/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.concurrent.FabricThreadManager;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractClientOperation;
import com.streamscape.sef.dispatcher.LocalFabricConnection;
import com.streamscape.sef.dispatcher.RuntimeExchange;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.Modifier;

public class DetachClientOperation
extends AbstractClientOperation {
    public static final String NAME = "detach client";

    public DetachClientOperation() {
        super(NAME, false);
        this.syntax.addModifier((AbstractModifier)new Modifier("KILL", false).setSyntaxHintSpace());
        this.syntax.setDescription("Detaches the specified external client (TLP, HTTP or XMPP).\nIt closes the network connection and removes the client context from the node.");
        this.syntax.addCompletionCommand("list clients at domain");
    }

    @Override
    String initSyntaxDescription() {
        return super.initSyntaxDescription() + "\n\nOptional parameters:\n\n   kill - Tries to kill (shutdown) the process of the detached client on the remote side.\n          This parameter is applicable for TLP clients only and do nothing for other client types.";
    }

    @Override
    String getExamples() {
        return super.getExamples() + this.getName() + " Client_SLANG.Client1_TestNode kill\n" + this.getName() + " Client_HTTP.Client1_TestNode";
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(statement.getParameter("ClientId").getValue(), statement.existsModifier("KILL"));
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        ComponentReference component = node.lookupComponent(definition.clientId);
        DetachClientOperation.checkClient(component != null);
        if (component.getModel() == ComponentModel.REMOTE_CLIENT) {
            RuntimeExchange.ClientExchangeConnection client = ((RuntimeContext)this.callable).exchange.getClient(component.getAddress());
            DetachClientOperation.checkClient(client != null);
            FabricThreadManager.getInstance().createThread("EXCH:Detach.Client", "Detaches the '" + String.valueOf(client) + "' client.", () -> {
                Utils.sleep(500L);
                ((RuntimeContext)this.callable).exchange.detachClient(client, definition.kill);
            }).start();
        } else if (DetachClientOperation.isExternalClient(component)) {
            LocalFabricConnection connection = ((RuntimeContext)this.callable).exchange.getExternalConnection(component);
            DetachClientOperation.checkClient(connection != null);
            connection.close();
        } else {
            throw new Exception("Only external client (TLP, HTTP or XMPP) can be detached.");
        }
        return new SLResponse();
    }

    private static boolean isExternalClient(ComponentReference component) {
        if (component.getModel() == ComponentModel.LOCAL_CLIENT) {
            String componentType = ModeratorUtils.extractComponentNameType(component.getName());
            return StringUtils.equalsNullSafe(componentType, "Client_HTTP") || StringUtils.equalsNullSafe(componentType, "Client_HTTPS") || StringUtils.equalsNullSafe(componentType, "Client_REST") || StringUtils.equalsNullSafe(componentType, "Client_XMPP");
        }
        return false;
    }

    private static void checkClient(boolean condition) throws Exception {
        if (!condition) {
            throw new Exception("Client not found.");
        }
    }

    static class Definition
    extends AbstractClientOperation.Definition {
        private boolean kill = false;

        Definition(String clientName, boolean kill) {
            super(DetachClientOperation.NAME, clientName);
            this.kill = kill;
        }
    }
}

