/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.ConfigurationProperty;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.mf.impl.AbstractServiceOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;

public class DescribeServiceOperation
extends AbstractServiceOperation {
    public static final String NAME = "describe service";

    public DescribeServiceOperation() {
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE SERVICE");
        this.syntax.setDescription("Returns basic information about service.");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition();
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        RowSet rowSet = new RowSet(new RowMetaData().addColumn("Name", String.class).addColumn("Value", String.class));
        rowSet.addToRowSet(new Object[]{"Service Name", ((ServiceContext)this.callable).getType() + "." + ((ServiceContext)this.callable).getName()});
        rowSet.addToRowSet(new Object[]{"Service State", ((ServiceContext)this.callable).getState()});
        String sessionDataspaceName = "SDS";
        ConfigurationProperty property = ((ServiceContext)this.callable).getServiceConfiguration().getAdvancedProperty("sessionDataspace");
        if (property != null && property.getValue() != null && String.valueOf(property.getValue()).trim().length() != 0) {
            sessionDataspaceName = String.valueOf(property.getValue()).trim();
        }
        rowSet.addToRowSet(new Object[]{"Default Dataspace", sessionDataspaceName});
        String version = ((ServiceContext)this.callable).getVersion();
        if (version == null) {
            version = com.streamscape.runtime.mf.operation.service.DescribeServiceOperation.getServiceVersion((ServiceContext)this.callable, ((ServiceContext)this.callable).getServiceConfiguration(), ((ServiceContext)this.callable).getPackageManifestManager().getManifestClassLoader());
        }
        rowSet.addToRowSet(new Object[]{"Version", version != null ? version : "N/A"});
        return new SLResponse(rowSet);
    }

    static class Definition
    extends AbstractSLStatement {
        Definition() {
            super(DescribeServiceOperation.NAME);
        }
    }
}

