/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.omf.java.SerialSchema;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.AtNodeOrAtDomainModifier;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractSerialOperation;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.LongParameter;

public class DescribeSerialSchemaOperation
extends AbstractSerialOperation {
    public static final String NAME = "describe serial schema";

    public DescribeSerialSchemaOperation() {
        super(true);
        this.createDSLSyntax(NAME);
        this.syntax.setAction("DESCRIBE SERIAL SCHEMA");
        this.syntax.addModifier((AbstractModifier)new CompoundModifier().addModifier((AbstractModifier)new Modifier("FOR CLASS").addParameter(new IdentifierParameter("ClassName"))).addModifier((AbstractModifier)new Modifier("VERSION").addParameter(new LongParameter("SerialVersion").setRange(0L, Long.MAX_VALUE))).setSyntaxHintSpace());
        this.syntax.addModifier(new AtNodeOrAtDomainModifier(false));
        this.syntax.setDescription("Describes a Serial Schema for the specified version of the class.");
        this.syntax.setSyntaxDescription("Parameters:\n\n   for class <ClassName>   - Specifies the class.\n   version <SerialVersion> - Specifies the serial version of the semantic type associated with the class.\n\nOptional parameters:\n\n   at node <NodeName> - Executes the command at the specified node.");
        this.syntax.setExamples("describe serial schema for class example.Example version 3\ndescribe serial schema for class example.Example version 5 at node Node1");
    }

    @Override
    public SLStatement convertDslToSl(DSLStatement statement) throws ParsingException {
        return new Definition(AtNodeOrAtDomainModifier.getValue(statement), statement.getParameter("ClassName").getValue(), Long.parseLong(statement.getParameter("SerialVersion").getValue()));
    }

    @Override
    public SLResponse invoke(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(((Definition)statement).nodeName, statement, session, timeout, false, false);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        Definition definition = (Definition)statement;
        SerialSchema schema = this.getManager().getSerialSchema(definition.className, definition.serialVersion);
        if (schema == null) {
            throw new Exception("Serial Schema not found.");
        }
        RowSet result = new RowSet(DescribeSerialSchemaOperation.createResultDescriptor());
        for (SerialSchema.Field field : schema.getFields()) {
            SemanticType type = ((RuntimeContext)this.callable).getSemanticTypeCache().lookupSemanticClass(field.getType());
            result.addToRowSet(new Object[]{field.getName(), field.getType(), type != null ? type.getTypeName() : "n/a", field.isPublic(), field.isInner()});
        }
        return new SLResponse(result);
    }

    private static RowMetaData createResultDescriptor() {
        RowMetaData result = new RowMetaData();
        DescribeSerialSchemaOperation.addColumn(result, "Field Name");
        DescribeSerialSchemaOperation.addColumn(result, "Field Class");
        DescribeSerialSchemaOperation.addColumn(result, "Field Type");
        DescribeSerialSchemaOperation.addColumn(result, "Public Field");
        DescribeSerialSchemaOperation.addColumn(result, "Inner Field");
        return result;
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;
        private String className;
        private long serialVersion;

        public Definition(String nodeName, String className, long serialVersion) {
            super(DescribeSerialSchemaOperation.NAME);
            this.nodeName = nodeName;
            this.className = className;
            this.serialVersion = serialVersion;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getClassName() {
            return this.className;
        }

        public long getSerialVersion() {
            return this.serialVersion;
        }
    }
}

