/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.operation.moderator.ListComponentsOperation;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractClientOperation;
import com.streamscape.sef.dispatcher.ListClientsOperation;
import com.streamscape.sef.dispatcher.RuntimeExchange;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.OperationTag;
import java.util.List;
import java.util.Set;

public class DescribeClientOperation
extends AbstractClientOperation {
    public static final String NAME = "describe client";

    public DescribeClientOperation() {
        super(NAME, false);
        this.syntax.addCompletionCommand("list clients at domain");
    }

    @Override
    public String getSyntax(MFSession session) {
        return DescribeClientOperation.isFromSlangTool(session) ? "describe client [<ClientId>]" : this.syntax.getSyntax();
    }

    @Override
    public String getDescription(MFSession session) {
        return DescribeClientOperation.isFromSlangTool(session) ? "describe client            - Shows information about the current session's client.\ndescribe client &lt;ClientId&gt; - Shows information about the specified external client." : "Shows information about the specified external client.";
    }

    @Override
    public String getExamples(MFSession session) {
        return (DescribeClientOperation.isFromSlangTool(session) ? "describe client\n" : "") + super.getExamples(session);
    }

    @Override
    public Set<String> getTags(MFSession session) {
        Set<String> result = super.getTags(session);
        if (DescribeClientOperation.isFromSlangTool(session)) {
            result.add(OperationTag.session.name());
        }
        return result;
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        AbstractClientOperation.Definition definition = (AbstractClientOperation.Definition)statement;
        ComponentReference component = node.lookupComponent(definition.clientId);
        if (!ListComponentsOperation.checkSysadmin((MFSession)session, component)) {
            component = null;
        }
        return component != null ? new SLResponse(this.createResult(definition, session, component)) : new SLResponse("Client not found.", false);
    }

    private RowSet createResult(AbstractClientOperation.Definition definition, MFSession session, ComponentReference component) throws Exception {
        RuntimeExchange.ClientInfo client = ((RuntimeContext)this.callable).exchange.getClientInfo(component);
        if (client == null) {
            throw new Exception("Client not found.");
        }
        RowSet result = new RowSet(DescribeClientOperation.createSimpleResultDescriptor());
        List<String> nameTokens = ModeratorUtils.splitComponentFullName(component.getName());
        DescribeClientOperation.addValues(result, "Node", nameTokens.get(0));
        DescribeClientOperation.addValues(result, "Type", nameTokens.get(1));
        DescribeClientOperation.addValues(result, "Id", nameTokens.get(2));
        DescribeClientOperation.addValues(result, "Protocol", client.protocol.name());
        DescribeClientOperation.addValues(result, "Acceptor", client.acceptor);
        DescribeClientOperation.addValues(result, "Client Host", ListClientsOperation.formatHost(client));
        DescribeClientOperation.addValues(result, new Object[]{"Event Scope", component.getEventScope()});
        DescribeClientOperation.addValues(result, "Owner", component.getSecurityContext() != null ? component.getSecurityContext().getOwnerName() : "");
        DescribeClientOperation.addValues(result, "Connected On", DescribeClientOperation.getCreationTime(component));
        if (client instanceof RuntimeExchange.HTTPClientInfo) {
            RuntimeExchange.HTTPClientInfo httpClient = (RuntimeExchange.HTTPClientInfo)client;
            DescribeClientOperation.addValues(result, "Active", httpClient.isActive);
            DescribeClientOperation.addValues(result, "Expiration Time", httpClient.expirationTime > 0L ? httpClient.expirationTime + " seconds" : "-1");
        }
        return result;
    }

    private static String formatHostName(String host) {
        return host != null ? host : "N/A";
    }

    private static String formatHostAddress(String ip) {
        return ip != null ? ip : "N/A";
    }
}

