/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.dispatcher.TriggerFunctionContextImpl;
import java.lang.reflect.Proxy;

public class DataspaceAccessorProviderForTaskList
implements TriggerFunctionContextImpl.DataspaceAccessorProvider {
    private final boolean noAutoCommit;
    private DataspaceAccessor accessor;

    public DataspaceAccessorProviderForTaskList(boolean noAutoCommit) {
        this.noAutoCommit = noAutoCommit;
    }

    @Override
    public DataspaceAccessor getDataspaceAccessor() throws FabricComponentAccessorException, FabricConnectionException {
        if (this.accessor == null) {
            this.accessor = RuntimeContext.getInstance().getSystemConnection().createDataspaceAccessor(null, DataspaceType.TSPACE, "SCH");
        }
        try {
            this.accessor.setAutoCommit(!this.noAutoCommit);
        }
        catch (DataspaceComponentException exception) {
            throw new FabricComponentAccessorException(6151, "Set 'autocommit' parameter failed.", exception);
        }
        return this.notCloseableProxy(this.accessor);
    }

    public void commit() throws DataspaceComponentException {
        if (this.accessor != null) {
            this.accessor.commit();
        }
    }

    public void rollback() throws DataspaceComponentException {
        if (this.accessor != null) {
            this.accessor.rollback();
        }
    }

    public void close() {
        if (this.accessor != null) {
            this.interrupt();
            this.accessor.close();
            this.accessor = null;
        }
    }

    private void interrupt() {
        try {
            this.accessor.invokeInterruptRequest("Interrupt!");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private DataspaceAccessor notCloseableProxy(DataspaceAccessor accessor) {
        return (DataspaceAccessor)Proxy.newProxyInstance(DataspaceAccessor.class.getClassLoader(), new Class[]{DataspaceAccessor.class}, (proxy, method, args) -> {
            if (method.getName().equals("close")) {
                return null;
            }
            return method.invoke((Object)accessor, args);
        });
    }
}

