/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.dispatcher.EventDispatcherException;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.dispatcher.AbstractSystemStore;
import com.streamscape.sef.dispatcher.ExchangeDataConstraint;
import com.streamscape.sef.dispatcher.ExchangeDateRangeConstraint;
import com.streamscape.sef.dispatcher.ExchangeDomainConstraint;
import com.streamscape.sef.dispatcher.ExchangeException;
import com.streamscape.sef.dispatcher.ExchangeNumericRangeConstraint;
import com.streamscape.sef.dispatcher.ExchangeRangeConstraint;
import com.streamscape.sef.dispatcher.RuntimeDataConstraintStore;
import java.sql.SQLException;
import java.util.ArrayList;

class DataConstraintPersistentStore
extends AbstractSystemStore {
    static final String DOMAINS_TABLE_NAME = "DOMAIN_CONSTRAINTS";
    static final String RANGES_TABLE_NAME = "RANGE_CONSTRAINTS";
    @Deprecated
    static final String NUMERIC_RANGES_TABLE_NAME = "NUMERIC_RANGE_CONSTRAINTS";
    @Deprecated
    static final String DATE_RANGES_TABLE_NAME = "DATE_RANGE_CONSTRAINTS";
    private RuntimeDataConstraintStore store;

    DataConstraintPersistentStore(RuntimeDataConstraintStore store) throws Exception {
        this.store = store;
        this.store.init(this);
    }

    @Override
    protected void initAccessor() throws Exception {
        this.initTable(DOMAINS_TABLE_NAME, ExchangeDomainConstraint.class.getSimpleName());
        this.initTable(RANGES_TABLE_NAME, ExchangeRangeConstraint.class.getSimpleName());
    }

    private void initTable(String tableName, String dataType) throws Exception {
        if (this.accessor.lookupCollection(tableName) == null) {
            this.checkWithException(this.accessor.invokeLanguageRequest("CREATE PERSISTENT TABLE " + tableName + "(NAME varchar(255) PRIMARY KEY, DATA " + dataType + ")"), "Creating table '" + tableName + "'");
        }
    }

    void load() throws ExchangeException {
        this.doLoadConstraints("Domain", DOMAINS_TABLE_NAME, constraint -> this.store.addDomain((ExchangeDomainConstraint)constraint));
        if (!this.loadRangesFromOldTables()) {
            this.doLoadConstraints("Range", RANGES_TABLE_NAME, constraint -> this.store.addRange((ExchangeRangeConstraint)constraint));
        }
    }

    private void doLoadConstraints(String model, String tableName, Adder adder) throws ExchangeException {
        Trace.logDebug(this, "Loading " + model + "s...");
        try {
            ArrayList<String> invalidConstraints = new ArrayList<String>();
            RowSet rowSet = this.getTableWithCheck(tableName);
            rowSet.beforeFirst();
            while (rowSet.next()) {
                try {
                    adder.add(this.getData(rowSet));
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                    String name = rowSet.getObject("NAME").toString();
                    invalidConstraints.add(name);
                    Trace.logError(this, "Initialization of " + model + " '" + name + "' failed. It will be removed.");
                }
            }
            for (String name : invalidConstraints) {
                this.removeConstraint(model, tableName, name);
            }
        }
        catch (SQLException exception) {
            throw new ExchangeException(6169, "Loading " + model + "s failed.", exception);
        }
        Trace.logInfo(this, model + "s loaded.");
    }

    void addConstraint(ExchangeDataConstraint constraint) throws ExchangeException {
        this.checkWithException(this.invokeStatement("INSERT INTO " + constraint.getTableName() + " VALUES('" + constraint.getName() + "', ?)", constraint), "Adding " + constraint.getModel() + " '" + constraint.getName() + "'");
    }

    void removeConstraint(ExchangeDataConstraint constraint) throws ExchangeException {
        this.removeConstraint(constraint.getModel(), constraint.getTableName(), constraint.getName());
    }

    private void removeConstraint(String model, String tableName, String name) throws ExchangeException {
        this.checkWithException(this.invokeStatement("DELETE FROM " + tableName + " WHERE NAME='" + name + "'"), "Removing " + model + " '" + name + "'");
    }

    void updateConstraint(ExchangeDataConstraint constraint) throws ExchangeException {
        this.checkWithException(this.invokeStatement("UPDATE " + constraint.getTableName() + " SET DATA=? WHERE NAME='" + constraint.getName() + "'", constraint), "Update " + constraint.getModel() + " '" + constraint.getName() + "'");
    }

    private Object getData(RowSet rowSet) throws SQLException {
        return rowSet.getObject("DATA");
    }

    @Override
    protected Class getExceptionClass() {
        return ExchangeException.class;
    }

    private boolean loadRangesFromOldTables() {
        boolean result = false;
        try {
            if (this.accessor.lookupCollection(NUMERIC_RANGES_TABLE_NAME) != null) {
                this.doLoadRangesFromOldTable("Numeric Range", NUMERIC_RANGES_TABLE_NAME, constraint -> this.store.addNumericRange((ExchangeNumericRangeConstraint)constraint));
                result = true;
            }
            if (this.accessor.lookupCollection(DATE_RANGES_TABLE_NAME) != null) {
                this.doLoadRangesFromOldTable("Date Range", DATE_RANGES_TABLE_NAME, constraint -> this.store.addDateRange((ExchangeDateRangeConstraint)constraint));
                result = true;
            }
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Loading Data Constraints from old format failed.");
        }
        return result;
    }

    private void doLoadRangesFromOldTable(String model, String tableName, Adder adder) throws ExchangeException {
        Trace.logDebug(this, "Loading " + model + "s from old format...");
        try {
            ArrayList invalidConstraints = new ArrayList();
            RowSet rowSet = this.getTableWithCheck(tableName);
            rowSet.beforeFirst();
            while (rowSet.next()) {
                try {
                    adder.add(this.getData(rowSet));
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, false);
                    String name = rowSet.getObject("NAME").toString();
                    Trace.logError(this, "Initialization of " + model + " '" + name + "' failed. It will be skipped.");
                }
            }
        }
        catch (SQLException exception) {
            throw new ExchangeException(6169, "Loading " + model + "s failed.", exception);
        }
        finally {
            try {
                this.accessor.dropCollection(tableName);
            }
            catch (DataspaceComponentException dataspaceComponentException) {}
        }
        Trace.logInfo(this, model + "s loaded from old format.");
    }

    private static interface Adder {
        public void add(Object var1) throws EventDispatcherException, ExchangeException;
    }
}

