/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.cli.ClientState;
import com.streamscape.sdo.enums.ExceptionStrategy;
import com.streamscape.sef.dispatcher.AbstractAsyncConsumerReference;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.AccessorSessionReferenceImpl;
import com.streamscape.sef.dispatcher.AsyncConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.DirectConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.EndpointReferenceImpl;
import com.streamscape.sef.dispatcher.FabricNode;
import com.streamscape.sef.dispatcher.InternalUtils;
import com.streamscape.sef.dispatcher.ReceiverReferenceImpl;
import com.streamscape.sef.dispatcher.ReplicationEntityReferenceImpl;
import com.streamscape.sef.dispatcher.ReplicationSourceReferenceImpl;
import com.streamscape.sef.dispatcher.ReplicationTargetReferenceImpl;
import com.streamscape.sef.dispatcher.RequestConsumerReferenceImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.AccessorReference;
import com.streamscape.sef.moderator.AccessorSessionReference;
import com.streamscape.sef.moderator.AsyncConsumerReference;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.ConsumerReference;
import com.streamscape.sef.moderator.DirectConsumerReference;
import com.streamscape.sef.moderator.EventConsumerReference;
import com.streamscape.sef.moderator.ExchangeRole;
import com.streamscape.sef.moderator.ModeratorAdvisoryType;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.moderator.ReceiverReference;
import com.streamscape.sef.moderator.ReplicationSourceReference;
import com.streamscape.sef.moderator.ReplicationTargetReference;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.sef.security.SecurityContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class ComponentReferenceImpl
extends EndpointReferenceImpl
implements ComponentReference {
    private String name;
    private String description;
    private ComponentModel model;
    private long timestamp;
    private String owner;
    private Set<String> boundEventIds;
    private ExceptionStrategy exceptionStrategy = ExceptionStrategy.ABORT;
    private Set<String> groups;
    private transient FabricNode node;
    private transient SecurityContext securityContext;
    private transient Map<FabricAddress, DirectConsumerReferenceImpl> directConsumers;
    private transient Map<FabricAddress, AsyncConsumerReferenceImpl> asyncConsumers;
    private transient Map<FabricAddress, RequestConsumerReferenceImpl> requestConsumers;
    private transient Map<FabricAddress, ReceiverReferenceImpl> receivers;
    private transient Map<String, ReplicationSourceReferenceImpl> replicationSources;
    private transient Map<String, ReplicationTargetReferenceImpl> replicationTargets;
    private transient Map<String, AccessorReference> accessors;
    private transient Map<FabricAddress, AccessorSessionReferenceImpl> accessorSessions;
    private transient boolean isLocal = false;

    ComponentReferenceImpl(String name, AbstractFabricComponent component, boolean initBoundEventIds) {
        super(ExchangeRole.COMPONENT, component.getFabricAddress(), component.getEventScope(), component.getFabricAddress());
        this.name = name;
        this.description = component.description;
        this.model = ComponentReferenceImpl.getComponentModel(component);
        this.timestamp = component.timestamp;
        if (initBoundEventIds) {
            this.boundEventIds = new HashSet<String>();
        }
        this.isLocal = ClientState.isActive() || this.model != ComponentModel.REMOTE_CLIENT;
    }

    void bind(FabricNode node) {
        this.node = node;
    }

    static ComponentModel getComponentModel(AbstractFabricComponent component) {
        switch (component.model) {
            case CTX_RUNTIME: {
                return ComponentModel.RUNTIME;
            }
            case CTX_CLIENT: {
                return ComponentModel.LOCAL_CLIENT;
            }
            case REMOTE_CLIENT: {
                return ComponentModel.REMOTE_CLIENT;
            }
            case CTX_SERVICE: {
                return ComponentModel.SERVICE;
            }
            case CTX_DATASPACE: {
                return ComponentModel.DATASPACE;
            }
            case CTX_FACTORY_CONNECTION: {
                return ComponentModel.FACTORY_CONNECTION;
            }
        }
        return ComponentModel.UNDEFINED;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public ComponentModel getModel() {
        return this.model;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public String getOwnerName() {
        return this.owner;
    }

    @Override
    public SecurityContext getSecurityContext() {
        if (this.securityContext == null && !this.isLocal) {
            return (SecurityContext)this.node.invokeModeratorRequest("getSecurityContext", this.componentAddress);
        }
        return this.doGetSecurityContext();
    }

    SecurityContext doGetSecurityContext() {
        return this.securityContext;
    }

    void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
        if (securityContext != null) {
            this.owner = securityContext.getOwnerName();
        }
    }

    @Override
    public boolean hasBoundEventIds() {
        return this.boundEventIds != null && !this.boundEventIds.isEmpty();
    }

    @Override
    public boolean isBoundEventId(String eventId) {
        return this.boundEventIds != null && this.boundEventIds.contains(eventId);
    }

    @Override
    public List<String> listBoundEventIds() {
        return this.boundEventIds != null ? new ArrayList<String>(this.boundEventIds) : new ArrayList();
    }

    void setBoundEventIds(Set<String> boundEventIds) {
        this.boundEventIds = boundEventIds;
    }

    @Override
    public ExceptionStrategy getExceptionStrategy() {
        return this.exceptionStrategy;
    }

    void setExceptionStrategy(ExceptionStrategy exceptionStrategy) {
        this.exceptionStrategy = exceptionStrategy;
    }

    void update(ModeratorAdvisoryType type, Object parameter) {
        switch (type) {
            case COMPONENT_CHANGED: {
                this.setExceptionStrategy((ExceptionStrategy)((Object)parameter));
                break;
            }
            case PRODUCER_BOUND: {
                this.boundEventIds.add((String)parameter);
                break;
            }
            case PRODUCER_UNBOUND: {
                this.boundEventIds.remove(parameter);
            }
        }
    }

    void addDirectConsumer(DirectConsumerReferenceImpl consumer) {
        this.initDirectConsumers();
        this.directConsumers.put(consumer.getAddress(), consumer);
    }

    Collection<DirectConsumerReferenceImpl> getDirectConsumers() {
        return this.directConsumers != null ? this.directConsumers.values() : null;
    }

    private synchronized void initDirectConsumers() {
        if (this.directConsumers == null) {
            this.directConsumers = new ConcurrentHashMap<FabricAddress, DirectConsumerReferenceImpl>();
        }
    }

    void addAsyncConsumer(AsyncConsumerReferenceImpl consumer) {
        this.initAsyncConsumers();
        this.asyncConsumers.put(consumer.getAddress(), consumer);
    }

    private synchronized void initAsyncConsumers() {
        if (this.asyncConsumers == null) {
            this.asyncConsumers = new ConcurrentHashMap<FabricAddress, AsyncConsumerReferenceImpl>();
        }
    }

    Collection<AsyncConsumerReferenceImpl> getAsyncConsumers() {
        return this.asyncConsumers != null ? this.asyncConsumers.values() : null;
    }

    void addRequestConsumer(RequestConsumerReferenceImpl consumer) {
        this.initRequestConsumers();
        this.requestConsumers.put(consumer.getAddress(), consumer);
    }

    private synchronized void initRequestConsumers() {
        if (this.requestConsumers == null) {
            this.requestConsumers = new ConcurrentHashMap<FabricAddress, RequestConsumerReferenceImpl>();
        }
    }

    Collection<RequestConsumerReferenceImpl> getRequestConsumers() {
        return this.requestConsumers != null ? this.requestConsumers.values() : null;
    }

    void addReceiver(ReceiverReferenceImpl receiver) {
        this.initReceivers();
        this.receivers.put(receiver.getAddress(), receiver);
    }

    private synchronized void initReceivers() {
        if (this.receivers == null) {
            this.receivers = new ConcurrentHashMap<FabricAddress, ReceiverReferenceImpl>();
        }
    }

    Collection<ReceiverReferenceImpl> getReceivers() {
        return this.receivers != null ? this.receivers.values() : null;
    }

    void addAccessor(AccessorReference accessor) {
        this.initAccessors();
        this.accessors.put(accessor.getAccessorName(), accessor);
    }

    private synchronized void initAccessors() {
        if (this.accessors == null) {
            this.accessors = new ConcurrentHashMap<String, AccessorReference>();
        }
    }

    void removeAccessor(AccessorReference accessor) {
        if (this.accessors != null) {
            this.accessors.remove(accessor.getAccessorName());
        }
    }

    Collection<AccessorReference> getAccessors() {
        return this.accessors != null ? this.accessors.values() : null;
    }

    void addAccessorSession(AccessorSessionReferenceImpl session) {
        this.initAccessorSessions();
        this.accessorSessions.put(session.getAddress(), session);
    }

    private synchronized void initAccessorSessions() {
        if (this.accessorSessions == null) {
            this.accessorSessions = new ConcurrentHashMap<FabricAddress, AccessorSessionReferenceImpl>();
        }
    }

    Collection<AccessorSessionReferenceImpl> getAccessorSessions() {
        return this.accessorSessions != null ? this.accessorSessions.values() : null;
    }

    void removeEndpoint(EndpointReferenceImpl endpoint) {
        if (endpoint instanceof AccessorSessionReferenceImpl) {
            this.doRemoveEndpoint(endpoint, this.accessorSessions);
        } else if (endpoint instanceof DirectConsumerReferenceImpl) {
            this.doRemoveEndpoint(endpoint, this.directConsumers);
        } else if (endpoint instanceof AsyncConsumerReferenceImpl) {
            this.doRemoveEndpoint(endpoint, this.asyncConsumers);
        } else if (endpoint instanceof RequestConsumerReferenceImpl) {
            this.doRemoveEndpoint(endpoint, this.requestConsumers);
        } else if (endpoint instanceof ReceiverReferenceImpl) {
            this.doRemoveEndpoint(endpoint, this.receivers);
        }
    }

    private void doRemoveEndpoint(EndpointReferenceImpl endpoint, Map<FabricAddress, ? extends EndpointReferenceImpl> endpoints) {
        if (endpoints != null) {
            endpoints.remove(endpoint.getAddress());
        }
    }

    void addReplicationSource(ReplicationSourceReferenceImpl replicationSource) {
        this.initReplicationSources();
        this.replicationSources.put(replicationSource.getName(), replicationSource);
    }

    private synchronized void initReplicationSources() {
        if (this.replicationSources == null) {
            this.replicationSources = new ConcurrentHashMap<String, ReplicationSourceReferenceImpl>();
        }
    }

    void addReplicationTarget(ReplicationTargetReferenceImpl replicationTarget) {
        this.initReplicationTargets();
        this.replicationTargets.put(replicationTarget.getName(), replicationTarget);
    }

    private synchronized void initReplicationTargets() {
        if (this.replicationTargets == null) {
            this.replicationTargets = new ConcurrentHashMap<String, ReplicationTargetReferenceImpl>();
        }
    }

    void removeReplicationEntity(ReplicationEntityReferenceImpl entity) {
        if (entity instanceof ReplicationSourceReferenceImpl) {
            this.doRemoveReplicationEntity(entity, this.replicationSources);
        } else if (entity instanceof ReplicationTargetReferenceImpl) {
            this.doRemoveReplicationEntity(entity, this.replicationTargets);
        }
    }

    private void doRemoveReplicationEntity(ReplicationEntityReferenceImpl entity, Map<String, ? extends ReplicationEntityReferenceImpl> entities) {
        if (entities != null) {
            entities.remove(entity.getName());
        }
    }

    @Override
    public List<ConsumerReference> getConsumers(EventScope eventScope) {
        ArrayList<ConsumerReference> result = new ArrayList<ConsumerReference>();
        InternalUtils.getEntities(eventScope, this.getDirectConsumers(), result);
        InternalUtils.getEntities(eventScope, this.getAsyncConsumers(), result);
        InternalUtils.getEntities(eventScope, this.getReceivers(), result);
        InternalUtils.getEntities(eventScope, this.getRequestConsumers(), result);
        return result;
    }

    @Override
    public List<EventConsumerReference> getEventConsumers(EventScope eventScope) {
        ArrayList<EventConsumerReference> result = new ArrayList<EventConsumerReference>();
        InternalUtils.getEntities(eventScope, this.getDirectConsumers(), result);
        InternalUtils.getEntities(eventScope, this.getAsyncConsumers(), result);
        InternalUtils.getEntities(eventScope, this.getReceivers(), result);
        return result;
    }

    @Override
    public List<DirectConsumerReference> getDirectConsumers(EventScope eventScope) {
        return InternalUtils.getEntities(eventScope, this.getDirectConsumers());
    }

    @Override
    public List<AsyncConsumerReference> getAsyncConsumers(EventScope eventScope) {
        return InternalUtils.getEntities(eventScope, this.getAsyncConsumers());
    }

    @Override
    public List<RequestConsumerReference> getRequestConsumers(EventScope eventScope) {
        return InternalUtils.getEntities(eventScope, this.getRequestConsumers());
    }

    @Override
    public List<ReceiverReference> getReceivers(EventScope eventScope) {
        return InternalUtils.getEntities(eventScope, this.getReceivers());
    }

    @Override
    public List<AccessorReference> getAccessors(EventScope eventScope) {
        eventScope = InternalUtils.checkEventScope(eventScope);
        if (this.isLocal) {
            return this.doGetAccessors(eventScope);
        }
        if (this.node.isLocalRuntime()) {
            return InternalUtils.convert((List)this.node.invokeModeratorRequest(this.getAddress(), "doGetAccessors", new Object[]{eventScope}));
        }
        return InternalUtils.convert((List)this.node.invokeModeratorRequest("getAccessors", new Object[]{this.componentAddress, eventScope}));
    }

    List<AccessorReference> doGetAccessors(EventScope eventScope) {
        return InternalUtils.getEntities(eventScope, this.getAccessors());
    }

    @Override
    public List<AccessorSessionReference> getAccessorSessions(EventScope eventScope) {
        eventScope = InternalUtils.checkEventScope(eventScope);
        if (this.node.isLocalRuntime()) {
            return this.doGetAccessorSessions(eventScope);
        }
        return InternalUtils.convert((List)this.node.invokeModeratorRequest("getAccessorSessions", new Object[]{this.componentAddress, eventScope}));
    }

    List<AccessorSessionReference> doGetAccessorSessions(EventScope eventScope) {
        return InternalUtils.getEntities(eventScope, this.getAccessorSessions());
    }

    @Override
    public List<ReplicationSourceReference> getReplicationSources() {
        return this.replicationSources != null ? new ArrayList<ReplicationSourceReferenceImpl>(this.replicationSources.values()) : new ArrayList();
    }

    @Override
    public List<ReplicationTargetReference> getReplicationTargets() {
        return this.replicationTargets != null ? new ArrayList<ReplicationTargetReferenceImpl>(this.replicationTargets.values()) : new ArrayList();
    }

    @Override
    public List<EventConsumerReference> getEventConsumers(String groupName) {
        return InternalUtils.getGroupConsumers(this.getEventConsumers(EventScope.INHERITED), groupName);
    }

    @Override
    public List<AsyncConsumerReference> getAsyncConsumers(String groupName) {
        return InternalUtils.getGroupConsumers(this.getAsyncConsumers(EventScope.INHERITED), groupName);
    }

    @Override
    public List<ReceiverReference> getReceivers(String groupName) {
        return InternalUtils.getGroupConsumers(this.getReceivers(EventScope.INHERITED), groupName);
    }

    @Override
    public ConsumerReference lookupConsumer(FabricAddress address) {
        EventConsumerReference result = this.lookupEventConsumer(address);
        return result != null ? result : this.lookupRequestConsumer(address);
    }

    @Override
    public ConsumerReference lookupConsumer(String name) {
        EventConsumerReference result = this.lookupEventConsumer(name);
        return result != null ? result : this.lookupRequestConsumer(name);
    }

    @Override
    public EventConsumerReference lookupEventConsumer(FabricAddress address) {
        EventConsumerReference result = this.lookupDirectConsumer(address);
        if (result == null && (result = this.lookupAsyncConsumer(address)) == null) {
            result = this.lookupReceiver(address);
        }
        return result;
    }

    @Override
    public EventConsumerReference lookupEventConsumer(String name) {
        EventConsumerReference result = this.lookupDirectConsumer(name);
        if (result == null && (result = this.lookupAsyncConsumer(name)) == null) {
            result = this.lookupReceiver(name);
        }
        return result;
    }

    @Override
    public DirectConsumerReference lookupDirectConsumer(FabricAddress address) {
        return this.directConsumers != null ? (DirectConsumerReference)this.directConsumers.get(address) : null;
    }

    @Override
    public DirectConsumerReference lookupDirectConsumer(String name) {
        return InternalUtils.getConsumerByLocalName(name, this.getDirectConsumers());
    }

    @Override
    public AsyncConsumerReference lookupAsyncConsumer(FabricAddress address) {
        return this.asyncConsumers != null ? (AsyncConsumerReference)this.asyncConsumers.get(address) : null;
    }

    @Override
    public AsyncConsumerReference lookupAsyncConsumer(String name) {
        return InternalUtils.getConsumerByLocalName(name, this.getAsyncConsumers());
    }

    @Override
    public RequestConsumerReference lookupRequestConsumer(FabricAddress address) {
        return this.requestConsumers != null ? (RequestConsumerReference)this.requestConsumers.get(address) : null;
    }

    @Override
    public RequestConsumerReference lookupRequestConsumer(String name) {
        return InternalUtils.getConsumerByLocalName(name, this.getRequestConsumers());
    }

    @Override
    public ReceiverReference lookupReceiver(FabricAddress address) {
        return this.receivers != null ? (ReceiverReference)this.receivers.get(address) : null;
    }

    @Override
    public ReceiverReference lookupReceiver(String name) {
        return InternalUtils.getConsumerByLocalName(name, this.getReceivers());
    }

    @Override
    public ReplicationSourceReference lookupReplicationSource(String name) {
        return this.replicationSources != null ? (ReplicationSourceReference)this.replicationSources.get(name) : null;
    }

    @Override
    public ReplicationTargetReference lookupReplicationTarget(String name) {
        return this.replicationTargets != null ? (ReplicationTargetReference)this.replicationTargets.get(name) : null;
    }

    @Override
    public AccessorReference lookupAccessor(String name) {
        if (this.isLocal) {
            return this.doLookupAccessor(name);
        }
        if (this.node.isLocalRuntime()) {
            return (AccessorReference)this.node.invokeModeratorRequest(this.getAddress(), "doLookupAccessor", name);
        }
        return (AccessorReference)this.node.invokeModeratorRequest("lookupAccessor", this.componentAddress, name);
    }

    AccessorReference doLookupAccessor(String name) {
        return this.accessors != null ? this.accessors.get(name) : null;
    }

    @Override
    public AccessorSessionReference lookupAccessorSession(FabricAddress address) {
        if (this.node.isLocalRuntime()) {
            return this.doLookupAccessorSession(address);
        }
        return (AccessorSessionReference)this.node.invokeModeratorRequest("lookupAccessorSession", this.componentAddress, address);
    }

    AccessorSessionReferenceImpl doLookupAccessorSession(FabricAddress address) {
        return this.accessorSessions != null ? this.accessorSessions.get(address) : null;
    }

    @Override
    public AccessorSessionReference lookupAccessorSession(String name) {
        return InternalUtils.getConsumerByLocalName(name, this.getAccessorSessions(EventScope.INHERITED));
    }

    @Override
    public List<String> listConsumers() {
        return InternalUtils.listEntities(this.getConsumers(EventScope.INHERITED));
    }

    @Override
    public List<String> listEventConsumers() {
        return InternalUtils.listEntities(this.getEventConsumers(EventScope.INHERITED));
    }

    @Override
    public List<String> listDirectConsumers() {
        return InternalUtils.listEntities(this.getDirectConsumers(EventScope.INHERITED));
    }

    @Override
    public List<String> listAsyncConsumers() {
        return InternalUtils.listEntities(this.getAsyncConsumers(EventScope.INHERITED));
    }

    @Override
    public List<String> listRequestConsumers() {
        return InternalUtils.listEntities(this.getRequestConsumers(EventScope.INHERITED));
    }

    @Override
    public List<String> listReceivers() {
        return InternalUtils.listEntities(this.getReceivers(EventScope.INHERITED));
    }

    @Override
    public List<String> listReplicationSources() {
        return InternalUtils.listEntities(this.getReplicationSources());
    }

    @Override
    public List<String> listReplicationTargets() {
        return InternalUtils.listEntities(this.getReplicationTargets());
    }

    @Override
    public List<String> listAccessors() {
        return InternalUtils.listEntities(this.getAccessors(EventScope.INHERITED));
    }

    @Override
    public List<String> listAccessorSessions() {
        return InternalUtils.listEntities(this.getAccessorSessions(EventScope.INHERITED));
    }

    @Override
    public boolean isGroupMember(String groupName) {
        return this.groups != null && this.groups.contains(groupName);
    }

    @Override
    public List<String> listGroups() {
        ArrayList<String> result = this.groups != null ? new ArrayList<String>(this.groups) : new ArrayList();
        Collections.sort(result);
        return result;
    }

    void addGroup(String groupName) {
        this.initGroups();
        this.groups.add(groupName);
    }

    private synchronized void initGroups() {
        if (this.groups == null) {
            this.groups = new HashSet<String>();
        }
    }

    void removeGroup(String groupName) {
        this.groups.remove(groupName);
    }

    void update(AbstractExchange exchange, String name, FabricAddress address) {
        super.update(address, address, exchange);
        this.name = name;
    }

    void updateConsumers(AbstractExchange.ReAddComponentData data, boolean rebind) {
        if (rebind) {
            EndpointReferenceImpl newConsumer;
            if (this.directConsumers != null && data.directConsumers != null) {
                Map<FabricAddress, DirectConsumerReferenceImpl> oldDirectConsumers = this.directConsumers;
                this.directConsumers = null;
                for (DirectConsumerReferenceImpl directConsumerReferenceImpl : oldDirectConsumers.values()) {
                    newConsumer = data.directConsumers.get(ModeratorUtils.extractConsumerName(directConsumerReferenceImpl.getName()));
                    if (newConsumer == null) continue;
                    newConsumer.bind(this.exchange);
                    directConsumerReferenceImpl.underlyingConsumer.setName(((DirectConsumerReferenceImpl)newConsumer).getName());
                    ((DirectConsumerReferenceImpl)newConsumer).bind(directConsumerReferenceImpl.underlyingConsumer);
                    this.addDirectConsumer((DirectConsumerReferenceImpl)newConsumer);
                }
                oldDirectConsumers.clear();
            }
            if (this.asyncConsumers != null && data.asyncConsumers != null) {
                Map<FabricAddress, AsyncConsumerReferenceImpl> oldAsyncConsumers = this.asyncConsumers;
                this.asyncConsumers = null;
                for (AsyncConsumerReferenceImpl asyncConsumerReferenceImpl : oldAsyncConsumers.values()) {
                    newConsumer = data.asyncConsumers.get(ModeratorUtils.extractConsumerName(asyncConsumerReferenceImpl.getName()));
                    if (newConsumer == null) continue;
                    newConsumer.bind(this.exchange);
                    asyncConsumerReferenceImpl.underlyingConsumer.setName(((AbstractAsyncConsumerReference)newConsumer).getName());
                    ((AbstractAsyncConsumerReference)newConsumer).bind(asyncConsumerReferenceImpl.underlyingConsumer);
                    this.addAsyncConsumer((AsyncConsumerReferenceImpl)newConsumer);
                }
                oldAsyncConsumers.clear();
            }
            if (this.requestConsumers != null && data.requestConsumers != null) {
                Map<FabricAddress, RequestConsumerReferenceImpl> oldRequestConsumers = this.requestConsumers;
                this.requestConsumers = null;
                for (RequestConsumerReferenceImpl requestConsumerReferenceImpl : oldRequestConsumers.values()) {
                    newConsumer = data.requestConsumers.get(ModeratorUtils.extractConsumerName(requestConsumerReferenceImpl.getName()));
                    if (newConsumer == null) continue;
                    newConsumer.bind(this.exchange);
                    requestConsumerReferenceImpl.underlyingConsumer.setName(((RequestConsumerReferenceImpl)newConsumer).getName());
                    ((RequestConsumerReferenceImpl)newConsumer).bind(requestConsumerReferenceImpl.underlyingConsumer);
                    this.addRequestConsumer((RequestConsumerReferenceImpl)newConsumer);
                }
                oldRequestConsumers.clear();
            }
            if (this.receivers != null && data.receivers != null) {
                Map<FabricAddress, ReceiverReferenceImpl> oldReceivers = this.receivers;
                this.receivers = null;
                for (ReceiverReferenceImpl receiverReferenceImpl : oldReceivers.values()) {
                    ReceiverReferenceImpl newReceiver = data.receivers.get(ModeratorUtils.extractConsumerName(receiverReferenceImpl.getName()));
                    if (newReceiver == null) continue;
                    newReceiver.bind(this.exchange);
                    newReceiver.underlyingConsumer.setName(newReceiver.getName());
                    newReceiver.bind(receiverReferenceImpl.underlyingConsumer);
                    this.addReceiver(newReceiver);
                }
                oldReceivers.clear();
            }
        } else {
            if (this.directConsumers != null && data.directConsumers != null) {
                this.directConsumers.clear();
                this.directConsumers = null;
                data.directConsumers.values().forEach(this::addDirectConsumer);
            }
            if (this.asyncConsumers != null && data.asyncConsumers != null) {
                this.asyncConsumers.clear();
                this.asyncConsumers = null;
                data.asyncConsumers.values().forEach(this::addAsyncConsumer);
            }
            if (this.requestConsumers != null && data.requestConsumers != null) {
                this.requestConsumers.clear();
                this.requestConsumers = null;
                data.requestConsumers.values().forEach(this::addRequestConsumer);
            }
            if (this.receivers != null && data.receivers != null) {
                this.receivers.clear();
                this.receivers = null;
                data.receivers.values().forEach(this::addReceiver);
            }
        }
    }

    @Override
    public String toString() {
        return "<" + String.valueOf((Object)this.getModel()) + "> " + super.toString();
    }
}

