/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.repository.object.ReferenceContext;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.obj.ObjectConfigurationException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.dispatcher.AbstractPackage;
import com.streamscape.sef.dispatcher.AbstractPackageDescriptor;
import com.streamscape.sef.dispatcher.AbstractPackageManifestManager;
import com.streamscape.sef.dispatcher.RuntimeLoaderRegistryImpl;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.pkg.ComponentPackageManifest;
import com.streamscape.sef.pkg.PackageManifestException;
import javax.naming.NamingException;

public class ComponentManifestManager
extends AbstractPackageManifestManager {
    protected RuntimeLoaderRegistryImpl runtimeRegistry;
    protected FabricComponent component;

    public ComponentManifestManager(RuntimeContext context, FabricComponent component) {
        super(context);
        this.runtimeRegistry = (RuntimeLoaderRegistryImpl)context.manifestManager.loaderRegistry;
        this.component = component;
        this.loaderRegistry = this.runtimeRegistry.addComponentRegistry(this.getComponentName());
        this.manifest = new ComponentPackageManifest();
        context.manifestManager.addComponentManifestManager(this);
    }

    @Override
    protected void completeDestroy() {
        this.context.manifestManager.removeComponentManifestManager(this);
    }

    public FabricComponent getComponent() {
        return this.component;
    }

    public String getComponentName() {
        return ModeratorUtils.makeComponentFullName(this.component);
    }

    @Override
    public void setPackageScope(String name, boolean global) throws NamingException, PackageManifestException {
        throw new PackageManifestException("Operation is not supported");
    }

    @Override
    public void validatePackage(String name) throws NamingException, PackageManifestException {
        throw new PackageManifestException("Operation is not supported");
    }

    @Override
    protected void processServicePackages() throws PackageManifestException {
    }

    @Override
    protected void processGlobalPackages() throws PackageManifestException {
    }

    @Override
    protected void doSaveManifest() throws PackageManifestException {
        try {
            SemanticObjectReferenceStore.beginXact(this.component);
            ReferenceContext ref = SemanticObjectReferenceStore.lookupReferenceContext("/sys/package/manifest/" + this.component.getType());
            if (ref == null) {
                ref = SemanticObjectReferenceStore.createSubcontextFromNamespace("/sys/package/manifest/" + this.component.getType());
                Trace.logDebug(this, "Component Package Manifest area not found. Recreation...");
            }
            SemanticObjectReferenceStore.setReferenceContext(ref);
            if (SemanticObjectReferenceStore.lookup(this.component.getName()) == null) {
                Trace.logDebug(this, "Creating Package Manifest" + this.forComponent() + "...");
                SemanticObjectReferenceStore.bind(this.component.getName(), this.manifest);
            } else {
                Trace.logDebug(this, "Updating Package Manifest" + this.forComponent() + "...");
                SemanticObjectReferenceStore.rebind(this.component.getName(), this.manifest);
            }
            SemanticObjectReferenceStore.commitXact();
        }
        catch (ObjectConfigurationException exception) {
            throw new PackageManifestException("Saving Component Package Manifest" + this.forComponent() + " failed.", exception);
        }
    }

    @Override
    protected void doLoadManifest() throws PackageManifestException {
        try {
            ReferenceContext ref = SemanticObjectReferenceStore.lookupReferenceContext("/sys/package/manifest/" + this.component.getType());
            if (ref != null) {
                SemanticObjectReferenceStore.beginXact(this.component);
                SemanticObjectReferenceStore.setReferenceContext(ref);
                ComponentPackageManifest manifest = (ComponentPackageManifest)SemanticObjectReferenceStore.lookup(this.component.getName());
                if (manifest != null) {
                    this.manifest = manifest;
                    Trace.logDebug(this, "Component Package Manifest" + this.forComponent() + " loaded.");
                }
                SemanticObjectReferenceStore.commitXact();
            } else {
                Trace.logDebug(this, "Component Package Manifest area not found. Loading Package Manifest skipped.");
            }
        }
        catch (ObjectConfigurationException exception) {
            throw new PackageManifestException("Loading Component Package Manifest" + this.forComponent() + " failed.", exception);
        }
    }

    @Override
    protected String getManifestType() {
        return "Component";
    }

    @Override
    protected String forComponent() {
        return " for '" + this.getComponentName() + "'";
    }

    @Override
    protected void checkGlobalPackage(AbstractPackageDescriptor descriptor, AbstractPackage pkg) throws PackageManifestException {
        if (descriptor.isGlobal() || pkg.isGlobal()) {
            throw new PackageManifestException("Only packages in Runtime Package Manifest can be global.");
        }
    }

    @Override
    protected void checkDependencies(Package pkg) throws PackageManifestException {
        try {
            for (String dependency : pkg.listDependencies()) {
                if (!this.context.getPackageManifestManager().existsPackage(dependency)) {
                    throw new PackageManifestException("Dependency package '" + dependency + "' not found.");
                }
                if (this.context.getPackageManifestManager().isPackageLoaded(dependency)) continue;
                throw new PackageManifestException("Dependency package '" + dependency + "' not loaded.");
            }
        }
        catch (NamingException exception) {
            throw new PackageManifestException(exception);
        }
    }
}

