/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class ComponentBoundEventIds {
    protected AbstractFabricComponent component;
    protected Map<String, Integer> boundEventIds = new ConcurrentHashMap<String, Integer>();

    ComponentBoundEventIds(AbstractFabricComponent component) {
        this.component = component;
    }

    synchronized void bindEventId(String eventId, boolean isSystem, boolean checkUniqueness) throws FabricEventDispatcherException {
        Integer counter;
        if (checkUniqueness) {
            this.component.dispatcher.checkEventIdUniqueness(eventId);
        }
        if ((counter = this.boundEventIds.get(eventId)) == null) {
            if (isSystem) {
                this.component.dispatcher.bindProducerForSystem(eventId);
            } else {
                this.component.dispatcher.bindProducerFor(eventId);
            }
            this.boundEventIds.put(eventId, 1);
        } else {
            counter = counter + 1;
            this.boundEventIds.put(eventId, counter);
        }
    }

    synchronized void unbindEventId(String eventId, boolean forced) {
        Integer counter = this.boundEventIds.get(eventId);
        if (counter != null) {
            if ((counter = Integer.valueOf(counter - 1)) <= 0 || forced) {
                this.component.dispatcher.unbindProducerFor(eventId);
                this.boundEventIds.remove(eventId);
            } else {
                this.boundEventIds.put(eventId, counter);
            }
        }
    }

    boolean isEventIdBound(String eventId) {
        return this.boundEventIds.containsKey(eventId);
    }
}

