/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sef.dispatcher.AbstractFabricContext;
import com.streamscape.sef.dispatcher.AbstractSemanticTypeFactory;
import com.streamscape.sef.utils.SemanticUtils;

class ClientSemanticTypeFactory
extends AbstractSemanticTypeFactory {
    ClientSemanticTypeFactory() {
    }

    @Override
    public synchronized void addSemanticType(SemanticType semanticType) throws SemanticTypeFactoryException {
        this.checkOnAdd(semanticType, false);
        try {
            ((AbstractFabricContext)ClientSemanticTypeFactory.context).omfManager.aliasManager.alias(semanticType);
        }
        catch (FactoryManagerException exception) {
            ClientSemanticTypeFactory.throwFactoryException(exception.getErrorCode(), exception.getErrorMessage());
        }
        Trace.logInfo(this, "Semantic type '" + semanticType.getTypeName() + "' added.");
    }

    @Override
    public synchronized void removeSemanticType(String typeName, boolean force) throws SemanticTypeFactoryException {
        this.checkOnRemove(typeName, force, false);
        try {
            ((AbstractFabricContext)ClientSemanticTypeFactory.context).omfManager.aliasManager.unalias(typeName);
        }
        catch (FactoryManagerException exception) {
            ClientSemanticTypeFactory.throwFactoryException(exception.getErrorCode(), exception.getErrorMessage());
        }
        Trace.logInfo(this, "Semantic type '" + typeName + "' removed.");
    }

    @Override
    public boolean hasDependencies(SemanticType type) {
        return !SemanticUtils.listDependentTypes(type, context).isEmpty() || !SemanticUtils.listDependentEventIds(type, context).isEmpty();
    }
}

