/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.AbstractSecurityManagerProxy;
import com.streamscape.sef.dispatcher.RemoteFabricConnection;
import com.streamscape.sef.dispatcher.SecurityManagerImpl;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.security.AccessControlList;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.Organization;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.util.List;

class ClientSecurityManagerProxy
extends AbstractSecurityManagerProxy {
    RemoteFabricConnection fabricConnection;

    public ClientSecurityManagerProxy(RemoteFabricConnection fabricConnection) {
        super(ClientSecurityManagerProxy.createAnonymousUser());
        this.fabricConnection = fabricConnection;
    }

    public ClientSecurityManagerProxy(User currentUser, RemoteFabricConnection fabricConnection) {
        super(currentUser, ClientSecurityManagerProxy.createAnonymousUser());
        this.fabricConnection = fabricConnection;
    }

    static User createAnonymousUser() {
        return SecurityManagerImpl.createAnonymousUser();
    }

    @Override
    public User createUser(String name, String password, String description, vCard vcard) throws SecurityManagerException {
        if (this.currentUser.isAnonymous()) {
            AbstractExchange.AnonymousRegistrationRequestData data = new AbstractExchange.AnonymousRegistrationRequestData(name, password, description, vcard);
            if (!this.fabricConnection.isOpened()) {
                return (User)this.raiseInstantInternalRequest(33, data);
            }
            return (User)this.raiseInternalRequest(33, data);
        }
        return (User)this.raiseOperation(this.createOperationData("createUser", new Class[]{String.class, String.class, String.class, vCard.class}, new Object[]{name, password, description, vcard}));
    }

    @Override
    public void dropUser(String name) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("dropUser", name));
    }

    @Override
    public void updateUser(User user) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("updateUser", user));
    }

    @Override
    public boolean existsUser(String name) throws SecurityManagerException {
        return (Boolean)this.raiseOperation(this.createOperationData("existsUser", name));
    }

    @Override
    public User lookupUser(String name) throws SecurityManagerException {
        return (User)this.raiseOperation(this.createOperationData("lookupUser", name));
    }

    @Override
    public List<User> getUsers() throws SecurityManagerException {
        return (List)this.raiseOperation(this.createOperationData("getUsers", new Object[0]));
    }

    @Override
    public List<String> listUsers() throws SecurityManagerException {
        return (List)this.raiseOperation(this.createOperationData("listUsers", new Object[0]));
    }

    @Override
    public void addUserPermission(String userName, AccessControlOperation operation) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("addUserPermission", new Object[]{userName, operation}));
    }

    @Override
    public void removeUserPermission(String userName, AccessControlOperation operation) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("removeUserPermission", new Object[]{userName, operation}));
    }

    @Override
    public void resetUserPermissions(String userName) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("resetUserPermissions", userName));
    }

    @Override
    public AccessControlList getUserPermissions(String userName) throws SecurityManagerException {
        return (AccessControlList)this.raiseOperation(this.createOperationData("getUserPermissions", userName));
    }

    @Override
    public void enableUser(String name) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("enableUser", name));
    }

    @Override
    public void disableUser(String name) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("disableUser", name));
    }

    @Override
    public vCard getVCard(String userName) throws SecurityManagerException {
        return (vCard)this.raiseOperation(this.createOperationData("getVCard", userName));
    }

    @Override
    public void setVCard(String userName, vCard vcard) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("setVCard", new Class[]{String.class, vCard.class}, new Object[]{userName, vcard}));
    }

    @Override
    public Group createGroup(String name, String description) throws SecurityManagerException {
        return (Group)this.raiseOperation(this.createOperationData("createGroup", name, description));
    }

    @Override
    public void dropGroup(String name) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("dropGroup", name));
    }

    @Override
    public void updateGroup(Group group) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("updateGroup", group));
    }

    @Override
    public boolean existsGroup(String name) throws SecurityManagerException {
        return (Boolean)this.raiseOperation(this.createOperationData("existsGroup", name));
    }

    @Override
    public Group lookupGroup(String name) throws SecurityManagerException {
        return (Group)this.raiseOperation(this.createOperationData("lookupGroup", name));
    }

    @Override
    public List<Group> getGroups() throws SecurityManagerException {
        return (List)this.raiseOperation(this.createOperationData("getGroups", new Object[0]));
    }

    @Override
    public List<String> listGroups() throws SecurityManagerException {
        return (List)this.raiseOperation(this.createOperationData("listGroups", new Object[0]));
    }

    @Override
    public void addGroupPermission(String groupName, AccessControlOperation operation) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("addGroupPermission", new Object[]{groupName, operation}));
    }

    @Override
    public void removeGroupPermission(String groupName, AccessControlOperation operation) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("removeGroupPermission", new Object[]{groupName, operation}));
    }

    @Override
    public AccessControlList getGroupPermissions(String groupName) throws SecurityManagerException {
        return (AccessControlList)this.raiseOperation(this.createOperationData("getGroupPermissions", groupName));
    }

    @Override
    public void addUserToGroup(String userName, String groupName) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("addUserToGroup", userName, groupName));
    }

    @Override
    public void removeUserFromGroup(String userName, String groupName) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("removeUserFromGroup", userName, groupName));
    }

    @Override
    public Organization createOrganization(String name, String description) throws SecurityManagerException {
        return (Organization)this.raiseOperation(this.createOperationData("createOrganization", name, description));
    }

    @Override
    public void dropOrganization(String name) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("dropOrganization", name));
    }

    @Override
    public void updateOrganization(Organization organization) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("updateOrganization", organization));
    }

    @Override
    public boolean existsOrganization(String name) throws SecurityManagerException {
        return (Boolean)this.raiseOperation(this.createOperationData("existsOrganization", name));
    }

    @Override
    public Organization lookupOrganization(String name) throws SecurityManagerException {
        return (Organization)this.raiseOperation(this.createOperationData("lookupOrganization", name));
    }

    @Override
    public List<Organization> getOrganizations() throws SecurityManagerException {
        return (List)this.raiseOperation(this.createOperationData("getOrganizations", new Object[0]));
    }

    @Override
    public List<String> listOrganizations() throws SecurityManagerException {
        return (List)this.raiseOperation(this.createOperationData("listOrganizations", new Object[0]));
    }

    @Override
    public void setOrganizationDomain(String organizationName, String domain) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("setOrganizationDomain", organizationName, domain));
    }

    @Override
    public void setUserOrganization(String userName, String organizationName) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("setUserOrganization", userName, organizationName));
    }

    @Override
    public void setGroupOrganization(String groupName, String organizationName) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("setGroupOrganization", groupName, organizationName));
    }

    @Override
    public String resetPassword(String userName) throws SecurityManagerException {
        return (String)this.raiseOperation(this.createOperationData("resetPassword", userName));
    }

    @Override
    public void changePassword(String userName, String oldPassword, String newPassword) throws SecurityManagerException {
        this.raiseOperation(this.createOperationData("changePassword", userName, oldPassword, newPassword));
    }

    @Override
    public List<ComponentReference> listBoundComponents(String ownerName, boolean inSysplex) throws SecurityManagerException {
        return (List)this.raiseOperation(this.createOperationData("listBoundComponents", new Class[]{String.class, Boolean.TYPE}, new Object[]{ownerName, inSysplex}));
    }

    void checkCurrentUser() throws SecurityManagerException {
        if (this.currentUser.isAnonymous()) {
            throw new SecurityManagerException(6092, "User 'anonymous' has insufficient rights for this operation.");
        }
    }

    Object raiseOperation(AbstractExchange.OperationData data) throws SecurityManagerException {
        this.checkCurrentUser();
        return this.raiseInternalRequest(32, data);
    }

    Object raiseInternalRequest(int eventId, Object data) throws SecurityManagerException {
        Object result;
        try {
            result = this.fabricConnection.raiseInternalRequest(eventId, data);
        }
        catch (Exception exception) {
            throw new SecurityManagerException(6011, "Raising of internal request [" + AbstractExchange.INTERNAL_EVENT_NAMES.get(eventId) + "] failed.", exception);
        }
        if (result instanceof SecurityManagerException) {
            throw (SecurityManagerException)result;
        }
        return result;
    }

    Object raiseInstantInternalRequest(int eventId, Object data) throws SecurityManagerException {
        Object result;
        try {
            result = this.fabricConnection.raiseInstantInternalRequest(eventId, data);
        }
        catch (Exception exception) {
            throw new SecurityManagerException(6011, "Raising of internal request [" + AbstractExchange.INTERNAL_EVENT_NAMES.get(eventId) + "] failed.", exception);
        }
        if (result instanceof SecurityManagerException) {
            throw (SecurityManagerException)result;
        }
        return result;
    }
}

