/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.cli.ClientLoaderRegistry;
import com.streamscape.lib.loader.ClassLoaderReference;
import com.streamscape.lib.utils.ArchiveException;
import com.streamscape.sef.dispatcher.ClientFabricClassLoader;
import com.streamscape.sef.dispatcher.LoaderRegistry;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.pkg.PackageManifestException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ClientLoaderRegistryImpl
extends LoaderRegistry
implements ClientLoaderRegistry {
    static final String CLIENT_CLASS_LOADER_NAME = "SYS$ClientClassLoader";
    FabricContext context;
    private Set<String> packages = new HashSet<String>();
    private ClientFabricClassLoader loader;

    ClientLoaderRegistryImpl(FabricContext context, ClassLoader loader) {
        super("Client.Context", loader, true);
        this.context = context;
        try {
            this.registerClientClassLoader();
        }
        catch (Exception exception) {
            throw new RuntimeException("Initialization of ClientLoaderRegistry failed.", exception);
        }
    }

    private void registerClientClassLoader() throws PackageManifestException {
        ClassLoader parentLoader = ClassLoaderReference.getRealClassLoader(this.systemClassLoader);
        try {
            this.loader = new ClientFabricClassLoader(CLIENT_CLASS_LOADER_NAME, parentLoader, "memjar", this.context);
            this.addClassLoader(CLIENT_CLASS_LOADER_NAME, this.loader, parentLoader, true);
            this.setSystemClassLoaderChain(this.loader);
        }
        catch (Exception exception) {
            throw new PackageManifestException("Registering of system class loader 'SYS$ClientClassLoader' failed.", exception);
        }
    }

    @Override
    public void addArchive(String archiveName, byte[] archiveContent, long timestamp) throws ArchiveException {
        this.loader.addArchive(archiveName, archiveContent, timestamp);
    }

    @Override
    public byte[] getArchive(String archiveName) {
        return this.loader.getArchive(archiveName);
    }

    @Override
    public boolean existsArchive(String archiveName) {
        return this.loader.existsArchive(archiveName);
    }

    @Override
    public List<String> listArchives() {
        return this.loader.listArchives();
    }

    @Override
    public List<String> listArchivesByClass(String className) throws ArchiveException {
        return this.loader.listArchivesByClass(className);
    }

    synchronized void addPackage(String packageName, Map<String, byte[]> archives) throws ArchiveException {
        this.loader.addArchives(archives);
        this.packages.add(packageName);
    }

    synchronized boolean existsPackage(String packageName) {
        return this.packages.contains(packageName);
    }

    Map<String, Long> getArchiveTimestamps() {
        return this.loader.getArchiveTimestamps();
    }
}

