/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.AbstractFabricGroup;
import com.streamscape.sef.dispatcher.AbstractFabricGroupManager;
import com.streamscape.sef.dispatcher.ClientExchange;
import com.streamscape.sef.dispatcher.ClientFabricGroup;
import com.streamscape.sef.group.FabricGroup;
import com.streamscape.sef.group.FabricGroupManagerException;
import com.streamscape.sef.moderator.ModeratorAdvisoryType;

class ClientFabricGroupManager
extends AbstractFabricGroupManager {
    private ClientExchange exchange;

    ClientFabricGroupManager(ClientExchange exchange) {
        this.exchange = exchange;
    }

    @Override
    public synchronized FabricGroup createGroup(String name, String description) throws FabricGroupManagerException {
        ClientFabricGroup group = new ClientFabricGroup(name, description, this.exchange);
        group.uid = (Short)this.raiseInternalRequest(44, group);
        this.addGroup(group);
        this.exchange.onSysplexUpdate(ModeratorAdvisoryType.GROUP_CREATED, name);
        return group;
    }

    @Override
    public synchronized void dropGroup(String name) throws FabricGroupManagerException {
        if (this.existsGroup(name)) {
            this.raiseInternalRequest(45, name);
            this.removeGroup(name);
            this.exchange.onSysplexUpdate(ModeratorAdvisoryType.GROUP_DROPPED, name);
        }
    }

    <TReplyData> TReplyData raiseInternalRequest(int eventId, Object data) throws FabricGroupManagerException {
        Object result;
        try {
            result = this.exchange.raiseInternalRequest(eventId, data);
        }
        catch (Exception exception) {
            if (exception.getCause() instanceof FabricGroupManagerException) {
                throw (FabricGroupManagerException)exception.getCause();
            }
            throw new FabricGroupManagerException(6011, "Raising of internal request [" + AbstractExchange.INTERNAL_EVENT_NAMES.get(eventId) + "] failed.", exception);
        }
        if (result instanceof FabricGroupManagerException) {
            throw (FabricGroupManagerException)result;
        }
        return result;
    }

    @Override
    void createGroup(AbstractFabricGroup other) {
        this.addGroup(new ClientFabricGroup(other, this.exchange));
    }
}

