/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.loader.FabricClassLoader;
import com.streamscape.lib.loader.net.AbstractURLHandler;
import com.streamscape.lib.loader.net.memory.MemoryJarURLHandler;
import com.streamscape.lib.utils.ArchiveException;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sef.dispatcher.LoaderRegistry;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.utils.SemanticUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;

public class ClientFabricClassLoader
extends FabricClassLoader {
    private String protocolName;
    private FabricContext context;
    private Map<String, byte[]> archives = new ConcurrentHashMap<String, byte[]>();
    private Map<String, String> archiveUrlNames = new ConcurrentHashMap<String, String>();
    private Map<String, Long> archiveTimestamps = new ConcurrentHashMap<String, Long>();
    private final Map<String, FabricClassLoader> loaders = new ConcurrentHashMap<String, FabricClassLoader>();
    private final Map<String, FabricClassLoader> cachedClasses = new ConcurrentHashMap<String, FabricClassLoader>();
    private final ReadWriteLock archivesLock = new ReentrantReadWriteLock();
    private final Set<Long> loadingInProgressMap = Collections.synchronizedSet(new HashSet());
    private boolean operationInProgress = false;
    private final Object operationMutex = new Object();

    protected ClientFabricClassLoader(String name, ClassLoader parent, String protocolName, FabricContext context) throws Exception {
        super(name, new URL[0], parent);
        this.protocolName = protocolName;
        this.context = context;
        AbstractURLHandler.initHandlers(Collections.singletonList(new MemoryJarURLHandler(protocolName, this.archives)));
    }

    public void addArchive(String archiveName, byte[] archiveContent, long timestamp) throws ArchiveException {
        this.doAddArchive(archiveName, archiveContent, timestamp);
    }

    public void addArchives(Map<String, byte[]> archives) throws ArchiveException {
        for (Map.Entry<String, byte[]> entry : archives.entrySet()) {
            this.doAddArchive(entry.getKey(), entry.getValue(), -1L);
        }
    }

    public byte[] getArchive(String archiveName) {
        String archiveUrlName = this.archiveUrlNames.get(archiveName);
        return archiveUrlName != null ? this.archives.get(archiveUrlName) : null;
    }

    public boolean existsArchive(String archiveName) {
        return this.archiveTimestamps.containsKey(archiveName);
    }

    public List<String> listArchives() {
        return new ArrayList<String>(this.archiveTimestamps.keySet());
    }

    public List<String> listArchivesByClass(String className) throws ArchiveException {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, byte[]> entry : this.archives.entrySet()) {
            if (!SemanticUtils.isArchiveContainsClass(entry.getValue(), className)) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    protected synchronized void doAddArchive(String archiveName, byte[] archiveContent, long timestamp) throws ArchiveException {
        try {
            String oldArchiveUrlName = this.archiveUrlNames.get(archiveName);
            if (oldArchiveUrlName != null) {
                this.removeArchive(archiveName);
                this.archives.remove(oldArchiveUrlName);
                this.archiveUrlNames.remove(archiveName);
            }
            this.archiveTimestamps.put(archiveName, timestamp);
            String archiveUrlName = this.getArchiveUrlName(archiveName);
            this.addArchive(archiveName, new URL(this.protocolName + "://localhost/" + archiveUrlName), archiveContent);
            this.archives.put(archiveUrlName, archiveContent);
            this.archiveUrlNames.put(archiveName, archiveUrlName);
            Trace.logInfo(this, "Archive '" + archiveName + "' added.");
        }
        catch (Exception exception) {
            throw new ArchiveException("Adding archive '" + archiveName + "' failed.", exception);
        }
    }

    protected synchronized Map<String, Long> getArchiveTimestamps() {
        return new HashMap<String, Long>(this.archiveTimestamps);
    }

    private String getArchiveUrlName(String archiveName) {
        return archiveName + ":" + System.currentTimeMillis();
    }

    private String extractArchiveName(String archiveUrlName) {
        return archiveUrlName.substring(0, archiveUrlName.indexOf(":"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addArchive(String archiveName, URL archiveUrl, byte[] archiveContent) throws Exception {
        this.archivesLock.writeLock().lock();
        try {
            if (this.loaders.containsKey(archiveName)) {
                throw new UtilitiesException("Archive '" + archiveName + "' already exists in class loader '" + this.getName() + "'.");
            }
            ChildClientClassLoader loader = new ChildClientClassLoader(archiveName, new URL[]{archiveUrl}, this, archiveContent);
            this.loaders.put(archiveName, loader);
        }
        finally {
            this.archivesLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeArchive(String jarName) throws Exception {
        FabricClassLoader loader = null;
        List<SemanticType> relatedTypes = null;
        this.archivesLock.writeLock().lock();
        try {
            loader = this.loaders.get(jarName);
            if (loader == null) {
                throw new UtilitiesException("Archive '" + jarName + "' does not exist in class loader '" + this.getName() + "'.");
            }
            if (this.context != null) {
                relatedTypes = SemanticUtils.getRelatedSemanticTypes(((ChildClientClassLoader)loader).archiveContent, this.context);
            }
            this.loaders.remove(jarName);
            Iterator<Map.Entry<String, FabricClassLoader>> iter = this.cachedClasses.entrySet().iterator();
            while (iter.hasNext()) {
                if (iter.next().getValue() != loader) continue;
                iter.remove();
            }
        }
        finally {
            this.archivesLock.writeLock().unlock();
        }
        if (this.context != null) {
            ((LoaderRegistry)this.context.getClassLoaderRegistry()).onRemoveFabricClassLoader(loader, relatedTypes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        this.archivesLock.readLock().lock();
        try {
            if (this.isLoadingAllowed()) {
                try {
                    Class result = this.doLoadClass(name, resolve);
                    if (result != null) {
                        Class clazz = result;
                        return clazz;
                    }
                }
                finally {
                    this.loadingInProgressMap.remove(Thread.currentThread().getId());
                }
            }
            Class<?> clazz = this.getParent().loadClass(name);
            return clazz;
        }
        finally {
            this.archivesLock.readLock().unlock();
        }
    }

    private synchronized boolean isLoadingAllowed() {
        if (!this.loaders.isEmpty() && !this.loadingInProgressMap.contains(Thread.currentThread().getId())) {
            this.loadingInProgressMap.add(Thread.currentThread().getId());
            return true;
        }
        return false;
    }

    private Class doLoadClass(String className, boolean resolve) {
        Class result = null;
        FabricClassLoader cachedLoader = this.cachedClasses.get(className);
        if (cachedLoader != null) {
            try {
                result = cachedLoader.loadClass(className, resolve);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (result == null) {
            for (FabricClassLoader loader : this.loaders.values()) {
                try {
                    result = loader.loadClass(className, resolve);
                    if (result == null) continue;
                    if (result.getClassLoader() == loader) {
                        this.cachedClasses.put(className, loader);
                    }
                    return result;
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        return result;
    }

    @Override
    public URL[] getURLs() {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (FabricClassLoader loader : this.loaders.values()) {
            urls.addAll(Arrays.asList(loader.getURLs()));
        }
        return urls.toArray(new URL[0]);
    }

    @Override
    public URL getResource(String name) {
        return this.get(name, (loader, s) -> loader.getResource(name));
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.get(name, (loader, s) -> loader.getResourceAsStream(name));
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        try {
            return this.get(name, (loader, s) -> {
                try {
                    return loader.getResources(name);
                }
                catch (IOException exception) {
                    throw new RuntimeException(exception);
                }
            });
        }
        catch (RuntimeException exception) {
            if (exception.getCause() instanceof IOException) {
                throw (IOException)exception.getCause();
            }
            throw exception;
        }
    }

    private <Result> Result get(String name, BiFunction<ClassLoader, String, Result> getter) {
        Result result = this.doGet(name, getter);
        return result != null ? result : getter.apply(this.getParent(), name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <Result> Result doGet(String name, BiFunction<ClassLoader, String, Result> getter) {
        Object object = this.operationMutex;
        synchronized (object) {
            if (this.operationInProgress) return null;
            if (this.loaders.isEmpty()) return null;
            this.operationInProgress = true;
            Result result = this.findInChildLoaders(name, getter);
            if (result == null) return null;
            Result Result2 = result;
            return Result2;
            finally {
                this.operationInProgress = false;
            }
        }
    }

    private <Result> Result findInChildLoaders(String name, BiFunction<ClassLoader, String, Result> getter) {
        return this.loaders.values().stream().map(loader -> getter.apply((ClassLoader)loader, name)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private static class ChildClientClassLoader
    extends FabricClassLoader {
        private byte[] archiveContent;

        ChildClientClassLoader(String name, URL[] urls, ClassLoader parent, byte[] archiveContent) throws Exception {
            super(name, urls, parent);
            this.archiveContent = archiveContent;
        }

        @Override
        protected Object getClassLoadingLock(String className) {
            return this.getParent();
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }
}

