/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.cli.ClientContext;
import com.streamscape.cli.ClientContextException;
import com.streamscape.lib.concurrent.worker.MonitorWorker;
import com.streamscape.lib.dispatcher.EventException;
import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.filter.Filter;
import com.streamscape.lib.utils.Pair;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sdo.enums.CacheThresholdAction;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.coherence.CoherenceAgentAdvisory;
import com.streamscape.sef.dispatcher.AbstractClientComponent;
import com.streamscape.sef.dispatcher.AbstractClientContext;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.AbstractFabricDataConstraint;
import com.streamscape.sef.dispatcher.AbstractFabricGroup;
import com.streamscape.sef.dispatcher.AbstractFabricGroupManager;
import com.streamscape.sef.dispatcher.AbstractSpecialSLSession;
import com.streamscape.sef.dispatcher.AsyncConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.ClientDataConstraintStore;
import com.streamscape.sef.dispatcher.ClientExchangeEventPublisher;
import com.streamscape.sef.dispatcher.ClientFabricGroup;
import com.streamscape.sef.dispatcher.ClientFabricGroupManager;
import com.streamscape.sef.dispatcher.ComponentReferenceImpl;
import com.streamscape.sef.dispatcher.DiagnosticSLSessionImpl;
import com.streamscape.sef.dispatcher.DirectConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.DomainConstraintReferenceImpl;
import com.streamscape.sef.dispatcher.EndpointReferenceImpl;
import com.streamscape.sef.dispatcher.EntityReferenceImpl;
import com.streamscape.sef.dispatcher.EventCacheReferenceImpl;
import com.streamscape.sef.dispatcher.EventFlowMapImpl;
import com.streamscape.sef.dispatcher.ExchangeConsumer;
import com.streamscape.sef.dispatcher.ExchangeDataConstraintStore;
import com.streamscape.sef.dispatcher.ExchangeEventDispatcher;
import com.streamscape.sef.dispatcher.ExchangeEventRequestConsumerImpl;
import com.streamscape.sef.dispatcher.ExchangeException;
import com.streamscape.sef.dispatcher.ExtendedEventDispatcher;
import com.streamscape.sef.dispatcher.FabricEventAsyncConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventDirectConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventReceiverImpl;
import com.streamscape.sef.dispatcher.FabricEventRequestConsumerImpl;
import com.streamscape.sef.dispatcher.FabricGroupLinkImpl;
import com.streamscape.sef.dispatcher.FabricNode;
import com.streamscape.sef.dispatcher.ModeratorImpl;
import com.streamscape.sef.dispatcher.NetworkExchangeConsumer;
import com.streamscape.sef.dispatcher.RangeConstraintReferenceImpl;
import com.streamscape.sef.dispatcher.ReceiverReferenceImpl;
import com.streamscape.sef.dispatcher.RemoteFabricConnection;
import com.streamscape.sef.dispatcher.ReplicationEntityReferenceImpl;
import com.streamscape.sef.dispatcher.RequestConsumerReferenceImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.group.FabricGroup;
import com.streamscape.sef.group.FabricGroupManagerException;
import com.streamscape.sef.moderator.EndpointReference;
import com.streamscape.sef.moderator.EntityReference;
import com.streamscape.sef.moderator.EventFlowMap;
import com.streamscape.sef.moderator.ExchangeRole;
import com.streamscape.sef.moderator.ModeratorAdvisoryType;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.tlp.Connection;
import com.streamscape.sef.network.tlp.DefaultConnectionStateHandler;
import com.streamscape.sef.network.tlp.PacketHandler;
import com.streamscape.sef.security.SecurityManagerException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;

class ClientExchange
extends AbstractExchange
implements ClientExchangeEventPublisher {
    transient AbstractClientContext context = ClientContext.getInstance();
    transient ExchangeConnection exchangeConnection;
    transient RemoteFabricConnection fabricConnection;
    transient DiagnosticSLSessionImpl diagnosticSession;
    transient NetworkEventDispatcher networkDispatcher;
    transient ClientFabricGroupManager groupManager;
    transient HeartbeatMonitor heartbeatMonitor;
    transient boolean anonymous;
    transient boolean forSlangTool = false;
    transient boolean forcedClosingInProgress = false;
    transient boolean shutdownIsNeeded = false;
    private static final int DIAGNOSTIC_PACKET_HEADER_SIZE = 5;

    ClientExchange() {
    }

    ClientExchange(RemoteFabricConnection fabricConnection) {
        this();
        this.fabricConnection = fabricConnection;
    }

    ClientExchange(DiagnosticSLSessionImpl diagnosticSession) {
        this();
        this.diagnosticSession = diagnosticSession;
    }

    @Override
    protected boolean init() throws Exception {
        super.init();
        this.networkDispatcher = new NetworkEventDispatcher();
        this.setAccessorMonitor(false);
        return false;
    }

    @Override
    void addInternalListeners() {
        this.addInternalEventListener(5, new NodeDisconnectEventListener());
        this.addInternalEventListener(1, new DetachFromSysplexEventListener());
        this.addInternalEventListener(6, new AddNodeEventListener());
        this.addInternalEventListener(7, new RemoveNodeEventListener());
        this.addInternalEventListener(8, new AddEndpointEventListener());
        this.addInternalEventListener(9, new RemoveEndpointEventListener());
        this.addInternalEventListener(10, new AddComponentEventListener());
        this.addInternalEventListener(11, new ChangeComponentEventListener());
        this.addInternalEventListener(12, new ChangeConsumerEventListener());
        this.addInternalEventListener(13, new ChangeEventCacheEventListener());
        this.addInternalEventListener(18, new AddDataConstraintEventListener());
        this.addInternalEventListener(19, new RemoveDataConstraintEventListener());
        this.addInternalEventListener(20, new ChangeDataConstraintEventListener());
        this.addInternalEventListener(24, new AddReplicationEntityEventListener());
        this.addInternalEventListener(25, new RemoveReplicationEntityEventListener());
        this.addInternalEventListener(26, new ChangeReplicationEntityEventListener());
        this.addInternalEventListener(35, new ClientStartAcceptorEventListener());
        this.addInternalEventListener(36, new ClientStopAcceptorEventListener());
        this.addInternalEventListener(29, new UpdateNodeAddressEventListener());
        this.addInternalEventListener(43, new CoherenceAgentAdvisoryEventListener());
        this.addInternalEventListener(44, new CreateGroupEventListener());
        this.addInternalEventListener(45, new DropGroupEventListener());
        this.addInternalEventListener(48, new UpdateGroupsEventListener());
        this.addInternalEventListener(46, new AddGroupMemberEventListener());
        this.addInternalEventListener(47, new RemoveGroupMemberEventListener());
        this.addInternalEventListener(54, new ModeratorOperationEventListener());
        this.addInternalRequestListener(54, new ModeratorOperationRequestListener());
        this.addInternalRequestListener(55, new ClientKillRequestListener());
        this.addInternalRequestListener(56, new CloseAccessorsRequestListener());
    }

    @Override
    protected boolean isRuntime() {
        return false;
    }

    Object raiseInstantInternalRequest(LinkAddress address, int eventId, Object data) throws Exception {
        return this.raiseInstantInternalRequest(address, this.connectionTimeout, eventId, data);
    }

    Object raiseInstantInternalRequest(LinkAddress address, long connectionTimeout, int eventId, Object data) throws Exception {
        this.exchangeConnection = (ExchangeConnection)this.establishConnection(address, connectionTimeout * 1000L);
        try {
            Object result = this.raiseInternalRequest(eventId, data);
            this.exchangeConnection.close(true);
            return result;
        }
        catch (FabricException exception) {
            this.exchangeConnection.close(true);
            throw exception;
        }
    }

    AbstractExchange.ClientConnectReplyData connect(LinkAddress address, long timeout, boolean anonymous, boolean forSlangTool, boolean reconnect) throws Exception {
        this.anonymous = anonymous;
        this.forSlangTool = forSlangTool;
        this.exchangeConnection = (ExchangeConnection)this.establishConnection(address, timeout);
        try {
            AbstractExchange.ClientConnectReplyData replyData = this.raiseClientConnectRequest(anonymous, forSlangTool);
            this.context.domain = replyData.domain;
            this.context.fabricUid = replyData.fabricUid;
            this.exchangeConnection.bind(replyData.component.getFabricAddress());
            this.fabricConnection.component.getContextId().acquire(replyData.component.getFabricAddress());
            this.fabricConnection.component.name = replyData.component.name;
            this.fabricConnection.component.timestamp = replyData.component.timestamp;
            if (!anonymous) {
                this.groupManager = new ClientFabricGroupManager(this);
                this.groupManager.synchronizeGroups(replyData.fabricGroups);
                this.node = replyData.fabricNodes.remove(0);
                this.node.init();
                if (replyData.reAddData != null) {
                    this.reAddComponent(this.fabricConnection.component, replyData.reAddData);
                    this.reAddConsumers(replyData.reAddData);
                }
                this.node.resolve(this);
                this.addConsumers(this.node);
                replyData.fabricNodes.forEach(this::addFabricNode);
                if (this.dispatcher == null) {
                    this.dispatcher = new ExchangeEventDispatcher(this);
                }
                this.dispatcher.start();
                this.synchronizeDataConstraints(replyData.domainConstraints, replyData.rangeConstraints);
                this.raiseClientConnectConfirm(reconnect);
                this.onSysplexUpdate(reconnect ? ModeratorAdvisoryType.CLIENT_RECONNECTED : ModeratorAdvisoryType.CLIENT_CONNECTED, this.fabricConnection.component.getFullName());
                this.logInfo("Connection to node " + this.getNodePrintName() + " established.");
            } else {
                this.raiseClientConnectConfirm(reconnect);
                this.logInfo("Anonymous connection established.");
            }
            this.initHeartbeatMonitor(false);
            return replyData;
        }
        catch (Exception exception) {
            this.exchangeConnection.close(true);
            throw exception;
        }
    }

    private void reAddConsumers(AbstractExchange.ReAddComponentData data) {
        this.reAddConsumers(data.directConsumers);
        this.reAddConsumers(data.asyncConsumers);
        this.reAddConsumers(data.requestConsumers);
        this.reAddConsumers(data.receivers);
    }

    private <T extends EndpointReferenceImpl> void reAddConsumers(Map<String, T> consumers) {
        if (consumers != null) {
            for (EndpointReferenceImpl consumer : consumers.values()) {
                this.node.addEndpoint(consumer);
            }
        }
    }

    void reAddComponent(AbstractFabricComponent component, AbstractExchange.ReAddComponentData data) {
        component.reference.update(this, data.reference.getName(), component.getFabricAddress());
        component.reference.updateConsumers(data, true);
        this.node.addComponent(component.reference);
        this.logInfo("Component '" + component.reference.getName() + "' added.");
    }

    void restoreConsumers() {
        this.dispatcher.restoreConsumers();
    }

    private void synchronizeDataConstraints(Map<String, DomainConstraintReferenceImpl> domainConstraints, Map<String, RangeConstraintReferenceImpl> rangeConstraints) {
        this.logDebug("Data Constraints synchronization...");
        this.globalDataConstraintStore.synchronizeInSysplex(domainConstraints, rangeConstraints);
        this.globalDomainConstraints = domainConstraints;
        this.globalRangeConstraints = rangeConstraints;
        this.logInfo("Data Constraints synchronized.");
    }

    private AbstractExchange.ClientConnectReplyData raiseClientConnectRequest(boolean anonymous, boolean forSlangTool) throws Exception {
        AbstractExchange.ClientConnectRequestData data = null;
        if (anonymous) {
            data = new AbstractExchange.ClientConnectRequestData(AbstractExchange.VersionData.fromRuntimeVersion(), this.context.domain, this.context.fabricUid, this.fabricConnection.component, forSlangTool);
        } else {
            String userName = null;
            String credentials = null;
            if (this.fabricConnection.securityToken != null) {
                credentials = this.fabricConnection.securityToken;
            } else if (this.fabricConnection.userName != null) {
                userName = this.fabricConnection.userName;
                credentials = this.exchangeConnection.createDigest(userName, this.fabricConnection.password);
            } else {
                throw new SecurityManagerException(6004, "Null user name specified.");
            }
            data = new AbstractExchange.ClientConnectRequestData(AbstractExchange.VersionData.fromRuntimeVersion(), this.context.domain, this.context.fabricUid, this.fabricConnection.component, ClientExchange.createReAddData(this.fabricConnection.component.reference), forSlangTool, userName, credentials);
        }
        return (AbstractExchange.ClientConnectReplyData)this.raiseLongInternalRequest(2, data);
    }

    private static AbstractExchange.ReAddComponentData createReAddData(ComponentReferenceImpl reference) {
        return reference != null ? new AbstractExchange.ReAddComponentData(reference, reference.getDirectConsumers(), reference.getAsyncConsumers(), reference.getRequestConsumers(), reference.getReceivers()) : null;
    }

    private void raiseClientConnectConfirm(boolean reconnect) throws Exception {
        this.raiseInternalRequest(4, reconnect);
    }

    protected void bind(boolean isReconnecting) throws ClientContextException {
        this.logDebug("Component '" + this.fabricConnection.component.getFullName() + "' binding...");
        this.moderator = new ModeratorImpl(this);
        if (!isReconnecting) {
            this.addComponent(this.fabricConnection.component, false);
        }
        this.context.bind(this.fabricConnection.component);
        this.logInfo("Component '" + this.fabricConnection.component.getFullName() + "' bound.");
    }

    @Override
    void doStart() {
        this.logDebug("Client Exchange stopping...");
        this.startAccessorMonitor();
        this.logInfo("Client Exchange stopped.");
    }

    @Override
    void doStop() {
        this.logDebug("Client Exchange stopping...");
        this.destroyAccessorMonitor();
        this.destroyHeartbeatMonitor();
        super.doStop();
        this.logInfo("Client Exchange stopped.");
    }

    void disconnect(boolean anonymous) throws FabricException {
        if (!anonymous) {
            this.logDebug("Disconnecting from node " + this.getNodePrintName() + "...");
        }
        this.raiseClientDisconnectRequest(this.fabricConnection.component);
        this.onSysplexUpdate(ModeratorAdvisoryType.CLIENT_DISCONNECTED, this.fabricConnection.component.getFullName());
        this.exchangeConnection.close(true);
        if (!anonymous) {
            this.dispatcher.stop();
            this.logInfo("Connection to node " + this.getNodePrintName() + " closed.");
        } else {
            this.logInfo("Anonymous connection closed.");
        }
    }

    void raiseClientDisconnectRequest(AbstractClientComponent component) {
        try {
            this.raiseInternalRequest(3, null);
        }
        catch (Exception exception) {
            this.logInternalRequestError(exception, 3);
        }
    }

    protected void unbind() {
        this.logDebug("Component '" + this.fabricConnection.component.getFullName() + "' unbinding...");
        this.context.unbind(this.fabricConnection.component);
        this.removeComponent(this.fabricConnection.component.getFabricAddress());
        this.moderator = null;
        this.logInfo("Component '" + this.fabricConnection.component.getFullName() + "' unbound.");
    }

    private void addFabricNode(FabricNode fabricNode) {
        fabricNode.resolve(this);
        this.addFabricNodeInstance(fabricNode);
        this.addConsumers(fabricNode);
    }

    private void addConsumers(FabricNode fabricNode) {
        for (DirectConsumerReferenceImpl directConsumerReferenceImpl : fabricNode.doGetDirectConsumers()) {
            this.addNetworkConsumer(directConsumerReferenceImpl, fabricNode.isLocal());
        }
        for (AsyncConsumerReferenceImpl asyncConsumerReferenceImpl : fabricNode.doGetAsyncConsumers()) {
            this.addNetworkConsumer(asyncConsumerReferenceImpl, fabricNode.isLocal());
        }
        for (ReceiverReferenceImpl receiverReferenceImpl : fabricNode.doGetReceivers()) {
            this.addNetworkConsumer(receiverReferenceImpl, fabricNode.isLocal());
        }
        for (EventCacheReferenceImpl eventCacheReferenceImpl : fabricNode.doGetEventCaches()) {
            this.addNetworkConsumer(eventCacheReferenceImpl, fabricNode.isLocal());
        }
    }

    private void addNetworkConsumer(NetworkExchangeConsumer consumer, boolean isOwnNode) {
        if (isOwnNode || consumer.getEventScope() != EventScope.OBSERVABLE) {
            ClientFabricGroup group;
            NetworkEventDispatcher dispatcher = this.networkDispatcher;
            if (consumer.getGroupName() != null && (group = (ClientFabricGroup)this.groupManager.lookupGroup(consumer.getGroupName())) != null) {
                dispatcher = group.getNetworkDispatcher();
            }
            dispatcher.addConsumer(consumer);
        }
    }

    void removeConsumers(FabricNode fabricNode) {
        fabricNode.doGetDirectConsumers().forEach(this::removeNetworkConsumer);
        fabricNode.doGetAsyncConsumers().forEach(this::removeNetworkConsumer);
        fabricNode.doGetReceivers().forEach(this::removeNetworkConsumer);
        fabricNode.doGetEventCaches().forEach(this::removeNetworkConsumer);
    }

    private void removeNetworkConsumer(NetworkExchangeConsumer consumer) {
        ClientFabricGroup group;
        NetworkEventDispatcher dispatcher = this.networkDispatcher;
        if (consumer.getGroupName() != null && (group = (ClientFabricGroup)this.groupManager.lookupGroup(consumer.getGroupName())) != null) {
            dispatcher = group.getNetworkDispatcher();
        }
        dispatcher.removeConsumer(consumer);
    }

    @Override
    public void raiseEvent(ImmutableEventDatagram event, FabricAddress componentAddress, EventScope eventScope) throws FabricException, FabricEventSourceException, FabricEventException {
        this.networkDispatcher.raiseEvent(event, eventScope);
    }

    @Override
    void deliverEvent(EventDatagram event, FabricAddress componentAddress, EventScope eventScope) throws FabricException, FabricEventSourceException, FabricEventException {
        this.networkDispatcher.raiseEvent(event, eventScope);
    }

    @Override
    ImmutableEventDatagram raiseRequest(RequestConsumerReferenceImpl consumer, ImmutableEventDatagram request, long timeout) throws FabricException, TimeoutException {
        return this.exchangeConnection.raiseRequest(consumer.getAddress(), request, timeout);
    }

    @Override
    void changeComponent(ComponentReferenceImpl reference, ModeratorAdvisoryType type, Object parameter) {
        this.doChangeComponent(reference, type, parameter, true);
    }

    @Override
    void notifyOnChangeComponent(AbstractExchange.ChangeComponentData data, ComponentReferenceImpl reference, boolean notifyNode) {
        try {
            if (notifyNode) {
                this.exchangeConnection.raiseInternalRequest(16, data);
            }
        }
        catch (Exception exception) {
            this.logInternalRequestError(exception, 16);
        }
        this.onSysplexUpdate(data.type, reference.getName(), data.type == ModeratorAdvisoryType.COMPONENT_CHANGED ? null : (String)data.parameter);
    }

    @Override
    void addDirectConsumer(FabricEventDirectConsumerImpl consumer, FabricAddress componentAddress, EventScope scope, boolean noLocal, boolean isSystem, FabricGroupLinkImpl groupLink) throws Exception {
        this.addConsumer(new DirectConsumerReferenceImpl(consumer, componentAddress, scope, null, noLocal, groupLink), consumer.underlyingConsumer, isSystem, groupLink);
    }

    @Override
    void addAsyncConsumer(FabricEventAsyncConsumerImpl consumer, FabricAddress componentAddress, EventScope scope, boolean noLocal, boolean isSystem, FabricGroupLinkImpl groupLink) throws Exception {
        this.addConsumer(new AsyncConsumerReferenceImpl(consumer, componentAddress, scope, null, noLocal, groupLink), consumer.underlyingConsumer, isSystem, groupLink);
    }

    @Override
    void addRequestConsumer(FabricEventRequestConsumerImpl consumer, FabricAddress componentAddress, EventScope scope, boolean forAccessor) throws Exception {
        this.addConsumer(new AbstractExchange.ClientRequestConsumer(consumer, componentAddress, scope, null), consumer.underlyingConsumer, false, null);
    }

    @Override
    void addReceiver(FabricEventReceiverImpl consumer, FabricAddress componentAddress, EventScope scope, boolean noLocal, boolean isSystem, FabricGroupLinkImpl groupLink) throws Exception {
        this.addConsumer(new ReceiverReferenceImpl(consumer, componentAddress, scope, null, noLocal, groupLink), consumer.underlyingConsumer, isSystem, groupLink);
    }

    @Override
    void addReplyConsumer(ExtendedEventDispatcher.ReplyConsumer consumer, FabricAddress componentAddress, EventScope eventScope) throws Exception {
        this.addConsumer(new DirectConsumerReferenceImpl(consumer.getUnderlyingConsumer(), componentAddress, eventScope, null, false), consumer, false, null);
    }

    private void addConsumer(EndpointReferenceImpl reference, NamedObject consumer, boolean isSystem, FabricGroupLinkImpl groupLink) throws Exception {
        reference.address = this.raiseAddEndpointRequest(reference);
        reference.bind(this);
        this.node.addEndpoint(reference);
        ((ClientExchangeEventPublisher)((Object)(groupLink != null ? (ClientFabricGroup)groupLink.group : this))).addToDispatcher(reference, consumer, isSystem);
        this.onSysplexUpdate(reference, AbstractExchange.UpdateType.ADD);
    }

    @Override
    public void addToDispatcher(EndpointReferenceImpl reference, NamedObject consumer, boolean isSystem) throws Exception {
        if (consumer instanceof ExtendedEventDispatcher.ReplyConsumer) {
            this.dispatcher.addReplyConsumer((ExtendedEventDispatcher.ReplyConsumer)consumer);
        } else if (consumer instanceof ExchangeEventRequestConsumerImpl) {
            this.dispatcher.addConsumer(consumer, isSystem);
        } else {
            this.dispatcher.addConsumer(consumer, isSystem ? null : this.requestCachedEvents(((ExchangeConsumer)((Object)reference)).getCompositeFilter(), reference.eventScope));
        }
        if (reference instanceof NetworkExchangeConsumer && !((NetworkExchangeConsumer)((Object)reference)).noLocal()) {
            this.networkDispatcher.addConsumer((NetworkExchangeConsumer)((Object)reference));
        }
    }

    @Override
    void removeDirectConsumer(FabricEventDirectConsumerImpl consumer, FabricGroupLinkImpl groupLink) {
        this.removeConsumer(consumer.reference, consumer.underlyingConsumer, groupLink);
    }

    @Override
    void removeAsyncConsumer(FabricEventAsyncConsumerImpl consumer, FabricGroupLinkImpl groupLink) {
        this.removeConsumer(consumer.reference, consumer.underlyingConsumer, groupLink);
    }

    @Override
    void removeRequestConsumer(FabricEventRequestConsumerImpl consumer) {
        this.removeConsumer(consumer.reference, consumer.underlyingConsumer, null);
    }

    @Override
    void removeReceiver(FabricEventReceiverImpl receiver, FabricGroupLinkImpl groupLink) {
        this.removeConsumer(receiver.reference, receiver.underlyingConsumer, groupLink);
    }

    @Override
    void removeReplyConsumer(ExtendedEventDispatcher.ReplyConsumer consumer) throws Exception {
        this.removeConsumer(consumer.getUnderlyingConsumer().reference, consumer, null);
    }

    private void removeConsumer(EndpointReferenceImpl reference, NamedObject consumer, FabricGroupLinkImpl groupLink) {
        if (reference == null) {
            this.dispatcher.dropConsumer(consumer);
        } else if (this.node.removeEndpoint(reference) != null) {
            ((ClientExchangeEventPublisher)((Object)(groupLink != null ? (ClientFabricGroup)groupLink.group : this))).removeFromDispatcher(reference, consumer);
            this.raiseRemoveEndpointRequest(reference);
            this.onSysplexUpdate(reference, AbstractExchange.UpdateType.REMOVE);
        }
    }

    @Override
    public void removeFromDispatcher(EndpointReferenceImpl reference, NamedObject consumer) {
        if (consumer instanceof ExtendedEventDispatcher.ReplyConsumer) {
            this.dispatcher.removeReplyConsumer((ExtendedEventDispatcher.ReplyConsumer)consumer);
        } else {
            this.dispatcher.dropConsumer(consumer);
        }
        if (reference instanceof NetworkExchangeConsumer && !((NetworkExchangeConsumer)((Object)reference)).noLocal()) {
            this.networkDispatcher.removeConsumer((NetworkExchangeConsumer)((Object)reference));
        }
    }

    @Override
    void addEventCache(Filter eventFilter, int maxSize, CacheThresholdAction thresholdAction, FabricAddress componentAddress) throws Exception {
        this.checkEventCacheUniqueness(eventFilter);
        EventCacheReferenceImpl reference = new EventCacheReferenceImpl(componentAddress, null, eventFilter, maxSize, thresholdAction);
        reference.address = this.raiseAddEndpointRequest(reference);
        reference.bind(this);
        this.node.addEventCache(reference);
        this.networkDispatcher.addConsumer(reference);
        this.onSysplexUpdate(reference, AbstractExchange.UpdateType.ADD);
    }

    @Override
    void removeEventCache(String eventFilter) {
        EventCacheReferenceImpl reference = this.removeEventCacheReference(eventFilter);
        if (reference != null) {
            this.raiseRemoveEndpointRequest(reference);
            this.onSysplexUpdate(reference, AbstractExchange.UpdateType.REMOVE);
        }
    }

    private List<ImmutableEventDatagram> requestCachedEvents(CompositeFilter filter, EventScope scope) throws Exception {
        return (List)this.exchangeConnection.raiseInternalRequest(28, new AbstractExchange.ClientGetCachedEventsRequestData(filter, scope));
    }

    private FabricAddress raiseAddEndpointRequest(EndpointReference endpoint) throws Exception {
        return (FabricAddress)this.exchangeConnection.raiseInternalRequest(14, endpoint);
    }

    private void raiseRemoveEndpointRequest(EndpointReference endpoint) {
        try {
            this.exchangeConnection.raiseInternalRequest(15, endpoint);
        }
        catch (Exception exception) {
            this.logInternalRequestError(exception, 15);
        }
    }

    @Override
    EndpointReferenceImpl changeConsumer(AbstractExchange.ChangeConsumerData data) {
        return this.doChangeConsumer(this.node, data, true);
    }

    @Override
    void notifyOnChangeConsumer(AbstractExchange.ChangeConsumerData data, boolean notifyNode) {
        try {
            if (notifyNode) {
                this.exchangeConnection.raiseInternalRequest(17, data);
            }
        }
        catch (Exception exception) {
            this.logInternalRequestError(exception, 17);
        }
        this.onSysplexUpdate(data.reference, AbstractExchange.UpdateType.CHANGE);
    }

    @Override
    protected ExchangeDataConstraintStore createDataConstraintStore() {
        return new ClientDataConstraintStore();
    }

    @Override
    EntityReferenceImpl addDataConstraint(AbstractExchange.DataConstraintReferenceCreator creator) throws Exception {
        return this.addDataConstraint(creator, true);
    }

    private EntityReferenceImpl addDataConstraint(AbstractExchange.DataConstraintReferenceCreator creator, boolean notifyNode) throws Exception {
        EntityReferenceImpl reference = creator.create();
        try {
            if (notifyNode) {
                this.exchangeConnection.raiseInternalRequest(21, reference);
            }
        }
        catch (Exception exception) {
            creator.drop();
            throw exception;
        }
        this.addDataConstraintReference(reference);
        this.onSysplexUpdate(reference, AbstractExchange.UpdateType.ADD);
        return reference;
    }

    @Override
    void removeDataConstraint(String name, ExchangeRole role) {
        EntityReferenceImpl reference = this.doRemoveDataConstraint(name, role);
        if (reference != null) {
            try {
                this.exchangeConnection.raiseInternalRequest(22, reference);
            }
            catch (Exception exception) {
                this.logInternalEventError(exception, 22);
            }
        }
    }

    private EntityReferenceImpl doRemoveDataConstraint(String name, ExchangeRole role) {
        EntityReferenceImpl reference = this.removeDataConstraintReference(name, role);
        if (reference != null) {
            this.removeDataConstraintFromStore(name, role);
            this.onSysplexUpdate(reference, AbstractExchange.UpdateType.REMOVE);
        }
        return reference;
    }

    @Override
    void changeDataConstraint(AbstractFabricDataConstraint.Updater updater, boolean notifyNode) throws Exception {
        boolean updated = this.updateDataConstraintInStore(updater);
        if (updated) {
            if (notifyNode) {
                this.exchangeConnection.raiseInternalRequest(23, updater);
            }
            this.onSysplexUpdate(updater.name, updater.exchangeRole, AbstractExchange.UpdateType.CHANGE);
        }
    }

    @Override
    void initConnectionFactory() {
        this.connectionFactory = new AbstractExchange.ExchangeConnectionFactory(this.workerPoolType, this.workerPoolSize);
        this.connectionFactory.addConnectionStateHandler((byte)2, new ExchangeConnectionStateHandler());
        this.connectionFactory.addConnectionStateHandler((byte)3, new DiagnosticConnectionStateHandler());
    }

    <TReplyData> TReplyData raiseInternalRequest(int eventId, Object data) throws Exception {
        return this.raiseInternalRequest(FabricAddress.NULL, eventId, data);
    }

    <TReplyData> TReplyData raiseFastInternalRequest(int eventId, Object data) throws Exception {
        return this.raiseFastInternalRequest(FabricAddress.NULL, eventId, data);
    }

    <TReplyData> TReplyData raiseLongInternalRequest(int eventId, Object data) throws Exception {
        return this.raiseLongInternalRequest(FabricAddress.NULL, eventId, data);
    }

    void raiseInternalEvent(int eventId, Object data) throws Exception {
        this.raiseInternalEvent(FabricAddress.NULL, eventId, data);
    }

    @Override
    protected AbstractExchange.AbstractExchangeConnection getConnection(FabricAddress nodeAddress) throws FabricException {
        return this.exchangeConnection;
    }

    @Override
    AbstractExchange.AbstractExchangeConnection establishConnection(LinkAddress address, long timeout) throws FabricException {
        return this.establishConnection(address, timeout, (byte)2);
    }

    @Override
    ExchangeConnection createConnection(Connection networkConnection) {
        return new ExchangeConnection(networkConnection);
    }

    @Override
    AbstractExchange.NetworkConsumersStore getNetworkDispatcher() {
        return this.networkDispatcher;
    }

    private FabricNode doGetFabricNode(FabricAddress address) {
        return this.isLocal(address) ? this.node : this.getFabricNode(address);
    }

    @Override
    AbstractFabricGroupManager getGroupManager() {
        return this.groupManager;
    }

    @Override
    AbstractFabricGroup addGroupMember(String groupName, ComponentReferenceImpl component, boolean notifyNodes) throws FabricGroupManagerException {
        AbstractFabricGroup result = this.doAddGroupMember(groupName, component, notifyNodes);
        try {
            this.exchangeConnection.raiseInternalRequest(46, new AbstractExchange.GroupMemberData(groupName, component.address));
        }
        catch (Exception exception) {
            this.logInternalRequestError(exception, 46);
        }
        return result;
    }

    @Override
    void removeGroupMember(String groupName, ComponentReferenceImpl component, boolean notifyNodes) throws FabricGroupManagerException {
        this.doRemoveGroupMember(groupName, component, notifyNodes);
        try {
            this.exchangeConnection.raiseInternalRequest(47, new AbstractExchange.GroupMemberData(groupName, component.address));
        }
        catch (Exception exception) {
            this.logInternalRequestError(exception, 47);
        }
    }

    @Override
    void notifyOnChangeGroupMember(int eventId, String groupName, ComponentReferenceImpl component, boolean notifyNodes, ModeratorAdvisoryType advisoryType) {
        this.onSysplexUpdate(advisoryType, groupName, component.getName());
    }

    AbstractSpecialSLSession.ConnectReplyData connect(LinkAddress address, long timeout, String componentName, String slSessionName, String userName, String password, boolean fromSlangTool) throws Exception {
        this.logDebug("Connecting to " + String.valueOf(address) + "...");
        this.exchangeConnection = (ExchangeConnection)this.establishConnection(address, timeout, (byte)3);
        try {
            AbstractSpecialSLSession.ConnectReplyData reply = (AbstractSpecialSLSession.ConnectReplyData)this.raiseDiagnosticRequest((byte)1, new AbstractSpecialSLSession.ConnectRequestData(componentName, slSessionName, userName, this.exchangeConnection.createDigest(userName, password), fromSlangTool));
            this.initHeartbeatMonitor(true);
            return reply;
        }
        catch (Exception exception) {
            this.exchangeConnection.close(true);
            throw exception;
        }
    }

    <TReplyData> TReplyData raiseDiagnosticRequest(byte type, Object data) throws Exception {
        return this.raiseDiagnosticRequest(type, data, this.replyTimeout);
    }

    <TReplyData> TReplyData raiseDiagnosticRequest(byte type, Object data, long timeout) throws Exception {
        return (TReplyData)((AbstractExchange.InternalEvent)this.raiseDiagnosticRequest((byte)type, new AbstractExchange.InternalEvent<Object>((int)0, data), (long)timeout)).data;
    }

    ImmutableEventDatagram raiseDiagnosticRequest(byte type, ImmutableEventDatagram request, long timeout) throws Exception {
        byte[] requestBytes = this.serialize(request);
        ByteBuffer packet = ByteBuffer.allocate(5 + requestBytes.length);
        packet.put(type).putInt(requestBytes.length).put(requestBytes);
        ImmutableEventDatagram reply = this.exchangeConnection.raiseRequest(packet.array(), timeout);
        if (reply instanceof FabricRequestException) {
            throw (Exception)((FabricRequestException)reply).getCause();
        }
        if (reply instanceof FabricEventSourceException) {
            Throwable cause = ((FabricEventSourceException)reply).getCause();
            if (cause instanceof FabricException) {
                throw (FabricException)cause;
            }
            if (cause instanceof SecurityManagerException) {
                throw (SecurityManagerException)cause;
            }
            throw new ExchangeException("Raising of diagnostic request [" + type + "] failed.", cause);
        }
        return reply;
    }

    private Object invokeModeratorOperation(AbstractExchange.OperationData data) throws ExchangeException {
        try {
            Method method = ComponentReferenceImpl.class.getDeclaredMethod(data.methodName, data.parameterTypes);
            return method.invoke((Object)this.fabricConnection.component.reference, data.parameters);
        }
        catch (Throwable exception) {
            throw new ExchangeException("Processing of internal request [" + (String)INTERNAL_EVENT_NAMES.get(54) + "] failed.", exception);
        }
    }

    @Override
    EventFlowMap getMergedEventFlowMap(boolean all) {
        try {
            return (EventFlowMap)this.raiseInternalRequest(54, new AbstractExchange.ModeratorOperationData(true, "getEventFlowMap", new Class[]{Boolean.TYPE}, all));
        }
        catch (Exception exception) {
            this.logInternalRequestError(exception, 54);
            return new EventFlowMapImpl(this.getDomain(), this.getNodeName());
        }
    }

    private void initHeartbeatMonitor(boolean forDiagnostic) {
        if (System.getProperty("streamscape.debug") == null) {
            try {
                this.destroyHeartbeatMonitor();
                this.heartbeatMonitor = new HeartbeatMonitor(forDiagnostic);
                this.heartbeatMonitor.start();
            }
            catch (FabricException fabricException) {
                // empty catch block
            }
        }
    }

    private void destroyHeartbeatMonitor() {
        if (this.heartbeatMonitor != null) {
            this.heartbeatMonitor.stop();
            this.heartbeatMonitor = null;
        }
    }

    @Override
    boolean isClustered() {
        return this.node != null && this.node.getClusterName() != null;
    }

    class NetworkEventDispatcher
    extends AbstractExchange.NetworkConsumersStore {
        NetworkEventDispatcher() {
        }

        void raiseEvent(ImmutableEventDatagram event, EventScope eventScope) throws FabricException, FabricEventSourceException, FabricEventException {
            Collection<NetworkExchangeConsumer> consumers = this.getConsumersWithCheckCluster(event, eventScope);
            if (consumers != null) {
                Pair<Integer, byte[]> packetData = this.packEvent(event);
                if (this.isAsync(consumers)) {
                    ByteBuffer packet = ClientExchange.this.exchangeConnection.networkConnection.createPacketForPublish((Integer)packetData.first);
                    this.pack(packet, (byte[])packetData.second, eventScope);
                    ClientExchange.this.exchangeConnection.networkConnection.publishDirect(packet);
                } else {
                    Pair<Long, ByteBuffer> packet = ClientExchange.this.exchangeConnection.networkConnection.createPacketForPublishRequest((Integer)packetData.first);
                    this.pack((ByteBuffer)packet.second, (byte[])packetData.second, eventScope);
                    ClientExchange.this.exchangeConnection.publishRequestDirect(packet);
                }
            }
        }

        private Pair<Integer, byte[]> packEvent(ImmutableEventDatagram event) throws FabricException {
            byte[] eventBytes = ClientExchange.this.serialize(event);
            return new Pair<Integer, byte[]>(this.getPacketSize(eventBytes), eventBytes);
        }

        private boolean isAsync(Collection<NetworkExchangeConsumer> consumers) {
            return consumers.stream().noneMatch(consumer -> consumer instanceof DirectConsumerReferenceImpl);
        }

        private void pack(ByteBuffer packet, byte[] eventBytes, EventScope eventScope) {
            this.putPacketHeader(packet);
            packet.putInt(eventBytes.length).put(eventBytes).putInt(eventScope.ordinal()).flip();
        }

        int getPacketSize(byte[] eventBytes) {
            return 5 + eventBytes.length + 4;
        }

        void putPacketHeader(ByteBuffer packet) {
            packet.put((byte)0);
        }
    }

    private class NodeDisconnectEventListener
    extends ClientInternalEventListenerWithAck<Void, ExchangeConnection> {
        private NodeDisconnectEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, Void data, ExchangeConnection connection) {
            connection.isDisconnected = true;
            ClientExchange.this.forcedClosingInProgress = true;
            if (ClientExchange.this.node != null) {
                ClientExchange.this.onSysplexUpdate(ModeratorAdvisoryType.NODE_DISCONNECTED, ClientExchange.this.node.getName());
            }
        }
    }

    private class DetachFromSysplexEventListener
    extends ClientInternalEventListenerWithAck<AbstractExchange.DetachFromSysplexData, ExchangeConnection> {
        private DetachFromSysplexEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.DetachFromSysplexData data, ExchangeConnection connection) throws Exception {
            if (data.isShuttingDown) {
                ClientExchange.this.forcedClosingInProgress = true;
            }
            for (FabricNode fabricNode : ClientExchange.this.getFabricNodes()) {
                ClientExchange.this.removeFabricNodeInstance(fabricNode);
                ClientExchange.this.removeConsumers(fabricNode);
                ClientExchange.this.onSysplexUpdate(AbstractExchange.getNodeDisconnectAdvisoryType(data.isNormal, data.joinInterrupted), fabricNode.getName());
            }
            ClientExchange.this.clearFabricNodes();
            ClientExchange.this.networkDispatcher.clear();
            ClientExchange.this.groupManager.clear();
            ClientExchange.this.onSysplexUpdate(data.isNormal ? ModeratorAdvisoryType.DETACHED_FROM_SYSPLEX : ModeratorAdvisoryType.DETACHED_FROM_SYSPLEX_FORCIBLY, null);
        }
    }

    private class AddNodeEventListener
    extends ClientInternalEventListenerWithAck<AbstractExchange.NodeChangeEventData, ExchangeConnection> {
        private AddNodeEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.NodeChangeEventData data, ExchangeConnection connection) throws FabricException {
            if (!ClientExchange.this.containsFabricNode(data.fabricNode.getFabricAddress())) {
                ClientExchange.this.addFabricNode(data.fabricNode);
                ClientExchange.this.onSysplexUpdate(data.advisoryType, data.fabricNode.getName());
            }
        }
    }

    private class RemoveNodeEventListener
    extends ClientInternalEventListenerWithAck<AbstractExchange.NodeChangeEventData, ExchangeConnection> {
        private RemoveNodeEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.NodeChangeEventData data, ExchangeConnection connection) throws FabricException {
            ClientExchange.this.removeFabricNodeInstance(data.fabricNode);
            ClientExchange.this.removeConsumers(data.fabricNode);
            ClientExchange.this.onSysplexUpdate(data.advisoryType, data.fabricNode.getName());
        }
    }

    private class AddEndpointEventListener
    extends ClientInternalEventListenerWithAck<EndpointReferenceImpl, ExchangeConnection> {
        private AddEndpointEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, EndpointReferenceImpl reference, ExchangeConnection connection) {
            FabricNode fabricNode = ClientExchange.this.doGetFabricNode(reference.componentAddress);
            if (fabricNode != null) {
                if (reference instanceof NetworkExchangeConsumer) {
                    ClientExchange.this.addNetworkConsumer((NetworkExchangeConsumer)((Object)reference), fabricNode.isLocal());
                }
                reference.bind(ClientExchange.this);
                fabricNode.addEndpoint(reference);
                ClientExchange.this.onSysplexUpdate(reference, AbstractExchange.UpdateType.ADD);
            }
        }
    }

    private class RemoveEndpointEventListener
    extends ClientInternalEventListenerWithAck<EndpointReferenceImpl, ExchangeConnection> {
        private RemoveEndpointEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, EndpointReferenceImpl reference, ExchangeConnection connection) {
            FabricNode fabricNode = ClientExchange.this.doGetFabricNode(reference.componentAddress);
            if (fabricNode != null) {
                if (reference instanceof NetworkExchangeConsumer) {
                    ClientExchange.this.removeNetworkConsumer((NetworkExchangeConsumer)((Object)reference));
                }
                fabricNode.removeEndpoint(reference);
                ClientExchange.this.onSysplexUpdate(reference, AbstractExchange.UpdateType.REMOVE);
            }
        }
    }

    private class AddComponentEventListener
    extends ClientInternalEventListenerWithAck<AbstractExchange.ReAddComponentData, ExchangeConnection> {
        private AddComponentEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.ReAddComponentData data, ExchangeConnection connection) throws Exception {
            FabricNode fabricNode = ClientExchange.this.doGetFabricNode(data.reference.getAddress());
            if (fabricNode != null) {
                data.reference.bind(ClientExchange.this);
                fabricNode.addEndpoint(data.reference);
                this.doAddConsumers(data.reference, data.directConsumers, fabricNode);
                this.doAddConsumers(data.reference, data.asyncConsumers, fabricNode);
                this.doAddConsumers(data.reference, data.requestConsumers, fabricNode);
                this.doAddConsumers(data.reference, data.receivers, fabricNode);
                ClientExchange.this.onSysplexUpdate(data.reference, AbstractExchange.UpdateType.ADD);
            }
        }

        private <T extends EndpointReferenceImpl> void doAddConsumers(ComponentReferenceImpl component, Map<String, T> consumers, FabricNode fabricNode) throws Exception {
            if (consumers != null) {
                for (EndpointReferenceImpl consumer : consumers.values()) {
                    if (consumer instanceof NetworkExchangeConsumer) {
                        ClientExchange.this.addNetworkConsumer((NetworkExchangeConsumer)((Object)consumer), fabricNode.isLocal());
                    }
                    consumer.bind(ClientExchange.this);
                    fabricNode.addEndpoint(consumer);
                }
            }
        }
    }

    private class ChangeComponentEventListener
    extends ClientInternalEventListenerWithAck<AbstractExchange.ChangeComponentData, ExchangeConnection> {
        private ChangeComponentEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.ChangeComponentData data, ExchangeConnection connection) throws Exception {
            FabricNode fabricNode = ClientExchange.this.doGetFabricNode(data.address);
            if (fabricNode != null) {
                ClientExchange.this.doChangeComponent(fabricNode.getComponent(data.address), data.type, data.parameter, false);
            }
        }
    }

    private class ChangeConsumerEventListener
    extends ClientInternalEventListenerWithAck<AbstractExchange.ChangeConsumerData, ExchangeConnection> {
        private ChangeConsumerEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.ChangeConsumerData data, ExchangeConnection connection) throws Exception {
            FabricNode fabricNode = ClientExchange.this.doGetFabricNode(data.reference.componentAddress);
            if (fabricNode != null) {
                EndpointReferenceImpl reference = ClientExchange.this.doChangeConsumer(fabricNode, data, false);
                if (data.deepChange && reference instanceof NetworkExchangeConsumer) {
                    ClientExchange.this.getNetworkDispatcher((NetworkExchangeConsumer)((Object)reference)).changeConsumer((NetworkExchangeConsumer)((Object)reference));
                }
            }
        }
    }

    private class ChangeEventCacheEventListener
    extends ClientInternalEventListenerWithAck<EventCacheReferenceImpl, ExchangeConnection> {
        private ChangeEventCacheEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, EventCacheReferenceImpl reference, ExchangeConnection connection) throws Exception {
            FabricNode fabricNode = ClientExchange.this.doGetFabricNode(reference.getAddress());
            if (fabricNode != null) {
                fabricNode.changeEventCache(reference);
                ClientExchange.this.onSysplexUpdate(reference, AbstractExchange.UpdateType.CHANGE);
            }
        }
    }

    private class AddDataConstraintEventListener
    extends ClientInternalEventListenerWithAck<EntityReferenceImpl, ExchangeConnection> {
        private AddDataConstraintEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, EntityReferenceImpl reference, ExchangeConnection connection) throws Exception {
            ClientExchange.this.addDataConstraint(ClientExchange.this.createDataConstraintReferenceCreator(reference), false);
        }
    }

    private class RemoveDataConstraintEventListener
    extends ClientInternalEventListenerWithAck<EntityReference, ExchangeConnection> {
        private RemoveDataConstraintEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, EntityReference reference, ExchangeConnection connection) {
            ClientExchange.this.doRemoveDataConstraint(reference.getName(), reference.getExchangeRole());
        }
    }

    private class ChangeDataConstraintEventListener
    extends ClientInternalEventListenerWithAck<AbstractFabricDataConstraint.Updater, ExchangeConnection> {
        private ChangeDataConstraintEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractFabricDataConstraint.Updater updater, ExchangeConnection connection) throws Exception {
            ClientExchange.this.changeDataConstraint(updater, false);
        }
    }

    private class AddReplicationEntityEventListener
    extends ClientInternalEventListenerWithAck<ReplicationEntityReferenceImpl, ExchangeConnection> {
        private AddReplicationEntityEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, ReplicationEntityReferenceImpl reference, ExchangeConnection connection) throws Exception {
            FabricNode fabricNode = ClientExchange.this.doGetFabricNode(reference.componentAddress);
            if (fabricNode != null) {
                fabricNode.addReplicationEntity(reference);
                ClientExchange.this.onSysplexUpdate(reference, AbstractExchange.UpdateType.ADD);
            }
        }
    }

    private class RemoveReplicationEntityEventListener
    extends ClientInternalEventListenerWithAck<ReplicationEntityReferenceImpl, ExchangeConnection> {
        private RemoveReplicationEntityEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, ReplicationEntityReferenceImpl reference, ExchangeConnection connection) throws Exception {
            FabricNode fabricNode = ClientExchange.this.doGetFabricNode(reference.componentAddress);
            if (fabricNode != null) {
                fabricNode.removeReplicationEntity(reference);
                ClientExchange.this.onSysplexUpdate(reference, AbstractExchange.UpdateType.REMOVE);
            }
        }
    }

    private class ChangeReplicationEntityEventListener
    extends ClientInternalEventListenerWithAck<ReplicationEntityReferenceImpl, ExchangeConnection> {
        private ChangeReplicationEntityEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, ReplicationEntityReferenceImpl reference, ExchangeConnection connection) throws Exception {
            FabricNode fabricNode = ClientExchange.this.doGetFabricNode(reference.componentAddress);
            if (fabricNode != null) {
                fabricNode.changeReplicationEntity(reference);
                ClientExchange.this.onSysplexUpdate(reference, AbstractExchange.UpdateType.CHANGE);
            }
        }
    }

    private class ClientStartAcceptorEventListener
    extends ClientInternalEventListenerWithAck<AbstractExchange.ChangeAcceptorData, AbstractExchange.AbstractExchangeConnection> {
        private ClientStartAcceptorEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.ChangeAcceptorData data, AbstractExchange.AbstractExchangeConnection connection) throws Exception {
            FabricNode fabricNode = ClientExchange.this.doGetFabricNode(data.nodeAddress);
            if (fabricNode != null) {
                fabricNode.addAcceptor(data.linkAddress);
                ClientExchange.this.onSysplexUpdate(ModeratorAdvisoryType.ACCESS_POINT_ADDED, fabricNode.getName(), data.linkAddress.toString());
            }
        }
    }

    private class ClientStopAcceptorEventListener
    extends ClientInternalEventListenerWithAck<AbstractExchange.ChangeAcceptorData, AbstractExchange.AbstractExchangeConnection> {
        private ClientStopAcceptorEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.ChangeAcceptorData data, AbstractExchange.AbstractExchangeConnection connection) throws Exception {
            FabricNode fabricNode = ClientExchange.this.doGetFabricNode(data.nodeAddress);
            if (fabricNode != null) {
                fabricNode.removeAcceptor(data.linkAddress);
                ClientExchange.this.onSysplexUpdate(ModeratorAdvisoryType.ACCESS_POINT_REMOVED, fabricNode.getName(), data.linkAddress.toString());
            }
        }
    }

    private class UpdateNodeAddressEventListener
    extends ClientInternalEventListenerWithAck<Pair<Byte, Short>, ExchangeConnection> {
        private UpdateNodeAddressEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, Pair<Byte, Short> data, ExchangeConnection connection) throws FabricException {
            ClientExchange.this.node.updateAddress((Byte)data.first, (Short)data.second);
        }
    }

    private class CoherenceAgentAdvisoryEventListener
    extends ClientInternalEventListenerWithAck<CoherenceAgentAdvisory, ExchangeConnection> {
        private CoherenceAgentAdvisoryEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, CoherenceAgentAdvisory advisory, ExchangeConnection connection) throws Exception {
            ClientExchange.this.onCoherenceUpdate(advisory);
        }
    }

    private class CreateGroupEventListener
    extends ClientInternalEventListenerWithAck<AbstractFabricGroup, ExchangeConnection> {
        private CreateGroupEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractFabricGroup group, ExchangeConnection connection) {
            ClientExchange.this.groupManager.createGroup(group);
            ClientExchange.this.onSysplexUpdate(ModeratorAdvisoryType.GROUP_CREATED, group.getName());
        }
    }

    private class DropGroupEventListener
    extends ClientInternalEventListenerWithAck<String, ExchangeConnection> {
        private DropGroupEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, String groupName, ExchangeConnection connection) {
            ClientExchange.this.groupManager.removeGroup(groupName);
            ClientExchange.this.onSysplexUpdate(ModeratorAdvisoryType.GROUP_DROPPED, groupName);
        }
    }

    private class UpdateGroupsEventListener
    extends ClientInternalEventListenerWithAck<List<FabricGroup>, ExchangeConnection> {
        private UpdateGroupsEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, List<FabricGroup> groups, ExchangeConnection connection) {
            ClientExchange.this.groupManager.synchronizeGroups(groups);
        }
    }

    private class AddGroupMemberEventListener
    extends ClientInternalEventListenerWithAck<AbstractExchange.GroupMemberData, ExchangeConnection> {
        private AddGroupMemberEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.GroupMemberData data, ExchangeConnection connection) throws Exception {
            ComponentReferenceImpl component = (ComponentReferenceImpl)ClientExchange.this.moderator.lookupComponent(data.memberAddress);
            if (component != null) {
                ClientExchange.this.doAddGroupMember(data.groupName, component, false);
            }
        }
    }

    private class RemoveGroupMemberEventListener
    extends ClientInternalEventListenerWithAck<AbstractExchange.GroupMemberData, ExchangeConnection> {
        private RemoveGroupMemberEventListener() {
            super(ClientExchange.this);
        }

        @Override
        void onEvent(FabricAddress sourceAddress, AbstractExchange.GroupMemberData data, ExchangeConnection connection) throws Exception {
            ComponentReferenceImpl component = (ComponentReferenceImpl)ClientExchange.this.moderator.lookupComponent(data.memberAddress);
            if (component != null) {
                ClientExchange.this.doRemoveGroupMember(data.groupName, component, false);
            }
        }
    }

    private class ModeratorOperationEventListener
    extends ClientInternalEventListenerWithAck<AbstractExchange.ModeratorOperationData, ExchangeConnection> {
        private ModeratorOperationEventListener() {
            super(ClientExchange.this);
        }

        @Override
        Object onEventWithAck(FabricAddress sourceAddress, AbstractExchange.ModeratorOperationData data, ExchangeConnection connection) throws Exception {
            return ClientExchange.this.invokeModeratorOperation(data);
        }
    }

    private class ModeratorOperationRequestListener
    extends AbstractExchange.InternalRequestListener<AbstractExchange.ModeratorOperationData, ExchangeConnection> {
        private ModeratorOperationRequestListener() {
            super(ClientExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, AbstractExchange.ModeratorOperationData data, ExchangeConnection connection) throws Exception {
            return ClientExchange.this.createInternalEvent(ClientExchange.this.invokeModeratorOperation(data));
        }
    }

    private class ClientKillRequestListener
    extends AbstractExchange.InternalRequestListener<Void, ExchangeConnection> {
        private ClientKillRequestListener() {
            super(ClientExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, Void data, ExchangeConnection connection) throws Exception {
            if (ClientExchange.this.forSlangTool) {
                ClientExchange.this.shutdownIsNeeded = true;
            }
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    private class CloseAccessorsRequestListener
    extends AbstractExchange.InternalRequestListener<List<String>, ExchangeConnection> {
        private CloseAccessorsRequestListener() {
            super(ClientExchange.this);
        }

        @Override
        AbstractExchange.InternalEvent onRequest(FabricAddress sourceAddress, List<String> accessors, ExchangeConnection connection) throws Exception {
            ClientExchange.this.closeLocalAccessors(ClientExchange.this.fabricConnection.component.reference, accessors);
            return AbstractExchange.EmptyEvent.defaultInstance;
        }
    }

    class ExchangeConnection
    extends AbstractExchange.AbstractExchangeConnection {
        ExchangeConnection(Connection connection) {
            super(connection);
        }

        @Override
        <TReplyData> AbstractExchange.InternalEvent<TReplyData> raiseInternalRequest(FabricAddress address, AbstractExchange.InternalEvent request, long timeout) throws Exception {
            return !ClientExchange.this.forcedClosingInProgress ? super.raiseInternalRequest(address, request, timeout) : null;
        }

        @Override
        void raiseInternalEvent(FabricAddress address, AbstractExchange.InternalEvent event) throws FabricException {
            if (!ClientExchange.this.forcedClosingInProgress) {
                super.raiseInternalEvent(address, event);
            }
        }

        void raiseHeartbeatRequest(byte[] packet) throws Exception {
            byte[] reply;
            if (!ClientExchange.this.forcedClosingInProgress && !Arrays.equals(reply = this.raiseRoutedRequest(packet, ClientExchange.this.fastReplyTimeout), AbstractExchange.EmptyEvent.binaryForm)) {
                ImmutableEventDatagram event = this.unpackEvent(reply);
                if (event instanceof FabricEventSourceException) {
                    Throwable cause = ((FabricEventSourceException)event).getCause();
                    if (cause instanceof FabricException) {
                        throw (FabricException)cause;
                    }
                    throw new ExchangeException("Unexpected exception.", cause);
                }
                throw new ExchangeException("Unexpected reply on heartbeat request.");
            }
        }

        @Override
        FabricAddress getSourceAddress() {
            return this.address != null ? this.address : FabricAddress.NULL;
        }

        @Override
        PacketHandler createPacketHandler() {
            return new ClientPacketHandler();
        }

        String createDigest(String userName, String password) throws Exception {
            return this.networkConnection.createDigest(userName, password);
        }

        class ClientPacketHandler
        implements PacketHandler {
            ClientPacketHandler() {
            }

            @Override
            public void onPacket(byte[] packet) {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(packet);
                    FabricAddress address = ExchangeConnection.this.unpackAddress(buffer);
                    if (address.isNull() || address.equals(ClientExchange.this.node.getFabricAddress())) {
                        byte type = buffer.get();
                        if (type == 7) {
                            ExchangeConnection.this.onLatencyRequest();
                        } else if (type == 8) {
                            ExchangeConnection.this.onLatencyReply();
                        } else {
                            ClientExchange.this.onInternalEvent(ExchangeConnection.this.unpackAddress(buffer), ExchangeConnection.this.unpackInternalEvent(buffer), ExchangeConnection.this);
                        }
                    } else if (ClientExchange.this.isLocal(address)) {
                        ClientExchange.this.raiseDirectEventLocal(address, ExchangeConnection.this.unpackEvent(buffer));
                    }
                }
                catch (Exception exception) {
                    ClientExchange.this.onError(exception, "Packet processing failed.");
                }
            }

            @Override
            public ByteBuffer onRequest(long requestId, byte[] packet, long timeout) throws FabricException {
                try {
                    ByteBuffer buffer = ByteBuffer.wrap(packet);
                    FabricAddress consumerAddress = ExchangeConnection.this.unpackAddress(buffer);
                    if (consumerAddress.isNull() || consumerAddress.equals(ClientExchange.this.node.getFabricAddress())) {
                        buffer.get();
                        return ExchangeConnection.this.packReply(requestId, ClientExchange.this.onInternalRequest(ExchangeConnection.this.unpackAddress(buffer), ExchangeConnection.this.unpackInternalEvent(buffer), ExchangeConnection.this));
                    }
                    return ExchangeConnection.this.packReply(requestId, ClientExchange.this.raiseRequestLocal(consumerAddress, ExchangeConnection.this.unpackEvent(buffer)));
                }
                catch (Throwable exception) {
                    ClientExchange.this.logException(exception, true);
                    return ExchangeConnection.this.packReply(requestId, new FabricEventSourceException(6043, "Processing of network request failed.", exception));
                }
            }

            @Override
            public void onPublication(byte[] packet) {
                try {
                    this.raiseEvent(packet);
                }
                catch (Exception exception) {
                    ClientExchange.this.onError(exception, "Packet processing failed.");
                }
            }

            @Override
            public byte[] onPublicationRequest(byte[] packet) throws FabricException {
                try {
                    this.raiseEvent(packet);
                }
                catch (EventException exception) {
                    return ExchangeConnection.this.pack((FabricEventException)exception.getCause());
                }
                catch (Throwable exception) {
                    if (!(exception instanceof ExchangeException) || !((ExchangeException)exception).isWrapper()) {
                        ClientExchange.this.logException(exception, true);
                    }
                    return ExchangeConnection.this.pack(new FabricEventSourceException(6043, "Network request processing failed.", exception));
                }
                return null;
            }

            private void raiseEvent(byte[] packet) throws Exception {
                ByteBuffer packetBuffer = ByteBuffer.wrap(packet);
                byte eventType = packetBuffer.get();
                ExchangeEventDispatcher localDispatcher = eventType == 0 ? ClientExchange.this.dispatcher : ClientExchange.this.groupManager.getGroup((short)packetBuffer.getShort()).dispatcher;
                ImmutableEventDatagram event = ExchangeConnection.this.unpackEvent(packetBuffer);
                FabricAddress sourceAddress = new FabricAddress(event.getEventSource());
                if (ClientExchange.this.isLocal(sourceAddress)) {
                    localDispatcher.raiseEvent(event, sourceAddress, null);
                } else {
                    localDispatcher.raiseNetworkEvent(event, sourceAddress);
                }
            }
        }
    }

    private class ExchangeConnectionStateHandler
    extends DefaultConnectionStateHandler {
        private ExchangeConnectionStateHandler() {
        }

        @Override
        public void onClose(Connection connection, boolean isNormal) {
            ClientExchange.this.exchangeConnection.cancelLatencyCalculation();
            if (!isNormal) {
                ClientExchange.this.forcedClosingInProgress = true;
                if (ClientExchange.this.node != null) {
                    ClientExchange.this.logInfo("Connection to node " + ClientExchange.this.getNodePrintName() + " forcibly closed.");
                    if (!ClientExchange.this.anonymous && !ClientExchange.this.exchangeConnection.isDisconnected) {
                        ClientExchange.this.onSysplexUpdate(ModeratorAdvisoryType.NODE_DISCONNECTED_FORCIBLY, ClientExchange.this.node.getName(), false);
                    }
                }
                ClientExchange.this.fabricConnection.forcedClose(ClientExchange.this.shutdownIsNeeded);
            }
            if (ClientExchange.this.shutdownIsNeeded) {
                System.err.println("Client is being forcibly shut down by the node...\n");
                System.exit(-1);
            }
        }
    }

    private class DiagnosticConnectionStateHandler
    extends DefaultConnectionStateHandler {
        private DiagnosticConnectionStateHandler() {
        }

        @Override
        public void onClose(Connection connection, boolean isNormal) {
            if (!isNormal) {
                ClientExchange.this.diagnosticSession.forcedClose();
            }
        }
    }

    private class HeartbeatMonitor
    extends MonitorWorker {
        private static final long MONITOR_TIMEOUT = 30000L;
        private static final int PACKET_SIZE = 7;
        private static final int PACKET_SIZE_SHORT = 1;
        private byte[] packet;
        private static final long MAX_HEARTBEAT_SEND_ATTEMPTS = 3L;

        protected HeartbeatMonitor(boolean shortPacket) throws FabricException {
            super("EXCH:HeartbeatMonitor", "Sends heartbeat messages to the node.", 30000L);
            this.packet = (shortPacket ? ByteBuffer.allocate(1) : ByteBuffer.allocate(7).put(FabricAddress.NULL.toBinary())).put((byte)10).array();
        }

        @Override
        protected void doExecute() throws FabricException, InterruptedException {
            try {
                this.raiseHeartbeatRequest();
            }
            catch (Exception exception) {
                if (exception instanceof TimeoutException) {
                    ClientExchange.this.logError("Sending heartbeat message failed. Cause: " + exception.getMessage());
                } else {
                    ClientExchange.this.logException(exception, true, "Sending heartbeat message failed.");
                }
                this.processError();
            }
        }

        private void processError() {
            int i = 0;
            while ((long)i < 3L) {
                try {
                    this.raiseHeartbeatRequest();
                    return;
                }
                catch (Exception exception) {
                    ++i;
                }
            }
            ClientExchange.this.logError("Heartbeat monitoring failed. Disconnecting...");
            ClientExchange.this.exchangeConnection.close(false);
        }

        private void raiseHeartbeatRequest() throws Exception {
            ClientExchange.this.exchangeConnection.raiseHeartbeatRequest(this.packet);
        }
    }

    abstract class ClientInternalEventListenerWithAck<TEventData, TConnection extends AbstractExchange.AbstractExchangeConnection>
    extends AbstractExchange.ConcurrentInternalEventListenerWithAck<TEventData, TConnection> {
        ClientInternalEventListenerWithAck(ClientExchange this$0) {
        }

        @Override
        int getAckEventId() {
            return 50;
        }
    }
}

