/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.sef.discovery.ClientDiscoveryModule;
import com.streamscape.sef.discovery.DiscoveryModuleFactory;
import java.util.Map;

class ClientDiscoveryModuleFactory
extends DiscoveryModuleFactory {
    ClientDiscoveryModuleFactory() {
        super(false);
    }

    @Override
    protected Class getDefaultModuleClass() {
        String moduleClass = System.getProperty("streamscape.discovery.module.class");
        if (moduleClass != null) {
            try {
                return ClassUtils.loadClass(moduleClass, context.getSystemClassLoaderChain());
            }
            catch (ClassNotFoundException exception) {
                Trace.logError(this, "Discovery module class '" + moduleClass + "' not found. Default module class will be used.");
            }
        }
        return ClientDiscoveryModule.class;
    }

    @Override
    protected Map<String, String> getDefaultModuleParameters() {
        Map<String, String> result = super.getDefaultModuleParameters();
        result.put("multicastEnabled", Boolean.toString(true));
        result.put("multicastWaitingTime", Long.toString(3L));
        return result;
    }
}

