/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.sef.dispatcher.AbstractClientContext;
import com.streamscape.sef.mf.admin.module.Module;
import com.streamscape.sef.security.AuthenticationModule;
import com.streamscape.sef.security.AuthenticationModuleFactory;
import com.streamscape.sef.security.FabricAuthenticationModule;

class ClientAuthenticationModuleFactory
extends AuthenticationModuleFactory {
    ClientAuthenticationModuleFactory() {
        super(false);
    }

    @Override
    protected Class getDefaultModuleClass() {
        String moduleClass = System.getProperty("streamscape.authentication.module.class");
        if (moduleClass != null) {
            try {
                return ClassUtils.loadClass(moduleClass, context.getSystemClassLoaderChain());
            }
            catch (ClassNotFoundException exception) {
                Trace.logError(this, "Authentication module class '" + moduleClass + "' not found. Default module class will be used.");
            }
        }
        return FabricAuthenticationModule.class;
    }

    @Override
    protected void onModuleActivation(Module module) {
        ((AbstractClientContext)ClientAuthenticationModuleFactory.context).authenticationModule = (AuthenticationModule)module;
    }
}

