/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cache.RuntimeCache;
import com.streamscape.repository.cache.TFCache;
import com.streamscape.repository.cache.TFCacheException;
import com.streamscape.repository.cli.RepositoryAccessorException;
import com.streamscape.repository.enums.CachedEntity;
import com.streamscape.repository.globals.GlobalVariableCollection;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sef.dispatcher.AbstractPackage;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.dispatcher.GlobalVariableFactoryImpl;
import com.streamscape.sef.dispatcher.RuntimeLoaderRegistryImpl;
import java.io.RandomAccessFile;
import java.net.URL;
import java.util.List;

public abstract class AbstractTFCache
extends AbstractRuntimeFactory
implements RuntimeCache {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSemanticTypes() throws Exception {
        try {
            this.beginXLocked(null, 1000L);
            for (SemanticType type : this.getTypes(true)) {
                try {
                    boolean needWarning = this.addSemanticType(type);
                    Trace.logDebug(this, "Semantic type [" + type.getTypeName() + "] registered.");
                    if (!needWarning) continue;
                    Trace.logInfo(TFCache.class, "WARNING: Semantic type [" + type.getTypeName() + "] invalidated.");
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                    Trace.logError(this, "Registering semantic type [" + type.getTypeName() + "] failed.");
                }
            }
        }
        finally {
            this.endXLocked();
        }
    }

    protected abstract boolean addSemanticType(SemanticType var1) throws Exception;

    protected abstract RandomAccessFile getCachedFileWithoutLocks(String var1, CachedEntity var2) throws TFCacheException;

    protected GlobalVariableCollection createGlobalVariables() {
        return GlobalVariableFactoryImpl.createSysGlobals();
    }

    protected List<SemanticType> addToExtClassLoader(String jarName, URL jarURL) throws Exception {
        return ((RuntimeLoaderRegistryImpl)AbstractTFCache.getContext().getPackageLoaderRegistry()).addToExtClassLoader(jarName, jarURL);
    }

    protected List<SemanticType> removeFromExtClassLoader(String jarName, boolean force) throws Exception {
        return ((RuntimeLoaderRegistryImpl)AbstractTFCache.getContext().getPackageLoaderRegistry()).removeFromExtClassLoader(jarName, force);
    }

    protected void addExtArchive(String jarName, byte[] jarContent) throws RepositoryException, RepositoryAccessorException {
        AbstractTFCache.getContext().addExtensionArchive(jarName, jarContent);
    }

    protected abstract long getIoTimeout();

    protected abstract void setIoTimeout(long var1) throws TFCacheException;

    protected void nextVersion(Package pkg) {
        ((AbstractPackage)pkg).nextVersion();
    }
}

