/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.omf.java.SerialSchema;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dataspace.DataspaceComponentException;
import com.streamscape.sef.dispatcher.AbstractJSerializer;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.dispatcher.InternalUtils;
import java.sql.SQLException;

public abstract class AbstractSystemStore
extends AbstractRuntimeFactory {
    protected DataspaceAccessor accessor;

    protected static DataspaceAccessor doCreateAccessor(String dataspaceName) throws Exception {
        return AbstractSystemStore.getContext().getSystemConnection().createDataspaceAccessor(DataspaceType.TSPACE, dataspaceName != null ? dataspaceName : "SDS");
    }

    protected AbstractSystemStore() throws Exception {
        this(null);
    }

    protected AbstractSystemStore(String dataspaceName) throws Exception {
        if (AbstractSystemStore.getContext().isDataspaceBound()) {
            this.accessor = AbstractSystemStore.doCreateAccessor(dataspaceName);
            this.initAccessor();
        }
    }

    protected void destroy() {
        if (this.accessor != null) {
            this.accessor.close();
            this.accessor = null;
        }
    }

    protected void initAccessor() throws Exception {
    }

    protected synchronized SLResponse invokeStatement(String statement) {
        if (this.accessor != null) {
            try {
                return new SLResponse(this.accessor.executeQuery(statement));
            }
            catch (DataspaceComponentException exception) {
                return new SLResponse(exception);
            }
        }
        return null;
    }

    protected synchronized SLResponse invokeStatement(String statement, Object ... parameters) {
        if (this.accessor != null) {
            try {
                return new SLResponse(this.accessor.executeQuery(statement, parameters));
            }
            catch (DataspaceComponentException exception) {
                return new SLResponse(exception);
            }
        }
        return null;
    }

    protected RowSet getTable(String tableName) {
        SLResponse response = this.invokeStatement("SELECT * FROM " + tableName);
        return AbstractSystemStore.isOK(response) ? response.getRowSet() : null;
    }

    protected <T extends Throwable> RowSet getTableWithCheck(String tableName) throws T {
        SLResponse response = this.invokeStatement("SELECT * FROM " + tableName);
        this.checkWithException(response, "Obtaining table '" + tableName + "'");
        return response.getRowSet();
    }

    protected synchronized void setTable(String tableName, RowSet table) throws SQLException {
        this.invokeStatement("DELETE FROM " + tableName);
        if (table != null) {
            table.beforeFirst();
            while (table.next()) {
                StringBuilder statement = new StringBuilder("INSERT INTO " + tableName + " VALUES(");
                for (int i = 0; i < table.getRowMetaData().getColumnCount(); ++i) {
                    statement.append(i > 0 ? ", '" : "'").append(table.getObject(i + 1)).append("'");
                }
                statement.append(")");
                this.invokeStatement(statement.toString());
            }
        }
    }

    protected <T extends Throwable> void checkTable(String tableName) throws T {
        SLResponse response = this.invokeStatement("SELECT TOP 1 * FROM " + tableName);
        this.checkWithException(response, "Check table '" + tableName + "'");
    }

    protected static boolean isOK(SLResponse response) {
        try {
            return response != null && response.isOK() && response.getRowSet() != null && response.getRowSet().first();
        }
        catch (Exception exception) {
            Trace.logException(AbstractSystemStore.class, exception, false);
            return false;
        }
    }

    protected <T extends Throwable> void checkWithException(SLResponse response, Class<T> exceptionClass, int errorCode, String operation) throws T {
        if (!(this.accessor == null || response != null && response.isOK())) {
            this.throwException(response, exceptionClass, errorCode, operation + " failed. ");
        }
    }

    protected <T extends Throwable> void checkWithException(SLResponse response, String operation) throws T {
        this.checkWithException(response, this.getExceptionClass(), this.getErrorCode(), operation);
    }

    protected <T extends Throwable> void throwException(SLResponse response, Class<T> exceptionClass, int errorCode, String errorMessage) throws T {
        if (response != null && response.getException() != null) {
            InternalUtils.throwException(exceptionClass, errorCode, errorMessage + (String)(response.getText() != null ? ". " + response.getText() : ""), response.getException());
        }
        if (response != null && response.getText() != null) {
            InternalUtils.throwException(exceptionClass, errorCode, errorMessage + response.getText());
        }
    }

    protected Class getExceptionClass() {
        return Exception.class;
    }

    protected int getErrorCode() {
        return 6000;
    }

    protected SemanticType lookupSemanticClass(Class objectClass) {
        return context.getJSerializer().lookupSemanticClassFull(objectClass);
    }

    protected void setSerialSupport(SemanticType type, Class objectClass, SerialSchema serialSchema) throws JSerializerException {
        AbstractSystemStore.setSerialSupport(type, ((AbstractJSerializer)context.getJSerializer()).generateSerialSupport(objectClass, serialSchema));
    }
}

