/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.dispatcher.AbstractClientContext;
import com.streamscape.sef.dispatcher.AbstractSLANGTool;
import com.streamscape.sef.dispatcher.AbstractSLSession;
import com.streamscape.sef.dispatcher.FabricNode;
import com.streamscape.sef.dispatcher.SLCompleteRequest;
import com.streamscape.sef.dispatcher.SLSessionMFSession;
import com.streamscape.sef.dispatcher.SLStatementWrapper;
import com.streamscape.sef.dispatcher.SLTextWrapper;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.security.User;
import com.streamscape.slex.UnsupportedRequestException;
import com.streamscape.slex.slang.SLMessageListener;
import com.streamscape.slex.slang.SLSessionException;
import com.streamscape.slex.slang.SpecialSLSession;
import java.util.UUID;

public abstract class AbstractSpecialSLSession
extends AbstractSLSession
implements SpecialSLSession {
    AbstractClientContext context;
    String componentName;
    protected String url;
    protected ConnectReplyData connectData;
    protected AbstractSLANGTool.NodeShutdownListener nodeShutdownListener;

    protected AbstractSpecialSLSession(AbstractClientContext context, long sessionId, String url, String userName, String password, long timeout, boolean fromSlangTool) throws SLSessionException {
        this.context = context;
        this.componentName = UUID.randomUUID().toString();
        this.sessionName = AbstractSpecialSLSession.getName(this.getPrefix(), sessionId);
        this.url = url;
        this.open(userName, password, timeout, fromSlangTool);
    }

    private void open(String userName, String password, long timeout, boolean fromSlangTool) throws SLSessionException {
        try {
            this.connectData = this.connect(timeout, userName, password, fromSlangTool);
            this.nodeName = this.connectData.nodeName;
            this.banner = this.connectData.banner;
            this.mfSession = new SpecialSLSessionMFSession(this.sessionName, this.componentName, this.connectData.user, fromSlangTool);
            this.isOpened = true;
            this.logInfo(this.getPrefix() + " session with node " + FabricNode.getPrintName(this.nodeName) + " established.");
        }
        catch (Exception exception) {
            throw new SLSessionException(7002, (Throwable)exception);
        }
        this.initCompleter();
    }

    protected abstract ConnectReplyData connect(long var1, String var3, String var4, boolean var5) throws Exception;

    @Override
    public synchronized void close() {
        this.doClose(false);
    }

    protected synchronized void forcedClose() {
        this.doClose(true);
        this.nodeShutdownListener.onNodeShutdown(false);
    }

    private void doClose(boolean forced) {
        if (this.isOpened) {
            this.context.removeSpecialSession(this);
            if (!forced) {
                this.closeConnection();
            }
            this.isOpened = false;
            this.logInfo(this.getPrefix() + " session with node " + FabricNode.getPrintName(this.nodeName) + " closed.");
        }
    }

    protected abstract void closeConnection();

    void setNodeShutdownListener(AbstractSLANGTool.NodeShutdownListener nodeShutdownListener) {
        this.nodeShutdownListener = nodeShutdownListener;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public String getUserName() {
        return this.connectData.user != null ? this.connectData.user.getName().toString() : null;
    }

    @Override
    public String getDomain() {
        return this.connectData.domain;
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    protected static String getName(String prefix, long id) {
        return prefix + "SLSession" + id;
    }

    protected static String getMFSessionName(String prefix, long id) {
        return prefix + "Session" + id;
    }

    protected abstract String getPrefix();

    protected LinkAddress getAddress() throws FabricException {
        return new LinkAddress(this.url);
    }

    @Override
    public SLResponse invokeRequest(SLStatement request, long timeout) throws SLSessionException {
        return this.invokeRequest(new SLStatementWrapper(request, timeout), timeout);
    }

    @Override
    public SLResponse invokeRequest(String request, long timeout) throws SLSessionException {
        return this.invokeRequest(new SLTextWrapper(request, timeout), timeout);
    }

    @Override
    public boolean interruptCommand(String command) throws SLSessionException {
        throw new SLSessionException(7012, "Interruption of this command is not allowed.");
    }

    @Override
    public SLResponse invokeCompleteRequest(String request, long timeout) throws SLSessionException {
        return this.invokeRequest(new SLCompleteRequest(request, timeout), timeout);
    }

    private SLResponse invokeRequest(CloneableDataObject wrapper, long timeout) throws SLSessionException {
        this.checkOpened();
        try {
            return this.doInvokeRequest(wrapper, timeout);
        }
        catch (Exception exception) {
            if (exception instanceof FabricRequestException && exception.getCause() != null) {
                return new SLResponse(exception.getCause());
            }
            return new SLResponse(exception);
        }
    }

    protected abstract SLResponse doInvokeRequest(CloneableDataObject var1, long var2) throws Exception;

    @Override
    SLResponse processResponse(SLResponse response) throws SLSessionException {
        if (response == null) {
            return new SLResponse(new UnsupportedRequestException());
        }
        if (!response.isOK() && response.getException() == null && response.getText() == null) {
            return new SLResponse("Operation failed.", false);
        }
        if (response.getException() != null) {
            if (!this.isOpened()) {
                throw new SLSessionException(7010, "Underlying session is closed.", response.getException());
            }
            if (response.getException() instanceof FabricEventSourceException) {
                if (((FabricEventSourceException)response.getException()).getErrorCode() == 6042) {
                    throw new SLSessionException(6042, response.getException().getMessage());
                }
                throw new SLSessionException(7010, "SLANG request failed.", response.getException());
            }
        }
        return response;
    }

    @Override
    public void setSLMessageListener(SLMessageListener listener) throws SLSessionException {
    }

    @Override
    public SLResponse[] invokeSessionCommand(String command, long timeout) throws SLSessionException {
        return new SLResponse[]{this.invokeRequest(command, timeout)};
    }

    protected abstract void logInfo(String var1);

    public static class ConnectReplyData
    extends CloneableDataObject {
        public User user;
        public String domain;
        public String nodeName;
        public String banner;

        public ConnectReplyData(User user, String domain, String nodeName, String banner) {
            this.user = user;
            this.domain = domain;
            this.nodeName = nodeName;
            this.banner = banner;
        }
    }

    private static class SpecialSLSessionMFSession
    extends SLSessionMFSession {
        private boolean fromSlangTool = false;

        SpecialSLSessionMFSession(String name, String componentName, User user, boolean fromSlangTool) {
            super(name, componentName, user);
            this.fromSlangTool = fromSlangTool;
        }

        @Override
        public boolean isFromSlangTool() {
            return this.fromSlangTool;
        }
    }

    public static class ConnectRequestData
    extends CloneableDataObject {
        public String componentName;
        public String slSessionName;
        public String userName;
        public String digest;
        public long pid;
        public boolean fromSlangTool;

        public ConnectRequestData(String componentName, String slSessionName, String userName, String digest, boolean fromSlangTool) {
            this(componentName, slSessionName, userName, digest, -1L, fromSlangTool);
        }

        public ConnectRequestData(String componentName, String slSessionName, String userName, String digest, long pid, boolean fromSlangTool) {
            this.componentName = componentName;
            this.slSessionName = slSessionName;
            this.userName = userName;
            this.digest = digest;
            this.pid = pid;
            this.fromSlangTool = fromSlangTool;
        }
    }
}

