/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.debug.AccessorDebug;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.utils.SDOUtils;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.FabricRequestListener;
import com.streamscape.sef.dispatcher.AbstractAccessorProxy;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.AccessorProxy;
import com.streamscape.sef.dispatcher.AccessorSessionReferenceImpl;
import com.streamscape.sef.dispatcher.FabricEventDispatcherImpl;
import com.streamscape.sef.dispatcher.RequestConsumerReferenceImpl;
import com.streamscape.sef.dispatcher.SessionRequest;
import com.streamscape.sef.dispatcher.SessionResponse;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.FabricModeratorAdvisory;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorAdvisoryType;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.sef.security.ComponentOwner;
import com.streamscape.slex.SLSessionData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public abstract class AbstractSessionManager
implements FabricRequestListener {
    protected RuntimeContext context;
    protected AbstractFabricComponent component;
    protected FabricEventDispatcherImpl dispatcher;
    protected LongNumberAllocatorSimple sessionNameAllocator = new LongNumberAllocatorSimple();
    protected Map<String, AccessorProxy> sessions = new ConcurrentHashMap<String, AccessorProxy>();
    protected Map<String, Set<String>> localClientSessions = new ConcurrentHashMap<String, Set<String>>();
    protected Map<String, Set<String>> remoteClientSessions = new ConcurrentHashMap<String, Set<String>>();
    protected Map<String, Set<String>> remoteNodeClients = new ConcurrentHashMap<String, Set<String>>();
    protected SessionsCleaner sessionsCleaner;
    private final Object mutex = new Object();
    protected static final String SESSION_MANAGER_CONSUMER_NAME = "sys$SessionManager";
    private static final String SESSIONS_CLEANER_CONSUMER_NAME = "SessionsCleaner";
    protected static final String ACTIVATOR_PREFIX = "Activator$";

    protected AbstractSessionManager(RuntimeContext context, AbstractFabricComponent component) {
        this.context = context;
        this.component = component;
        this.dispatcher = component.dispatcher;
    }

    protected void init() {
        try {
            this.dispatcher.createSystemRequestConsumer(SESSION_MANAGER_CONSUMER_NAME, this, EventScope.INHERITED, false);
        }
        catch (FabricEventDispatcherException exception) {
            Trace.logException(AbstractSessionManager.class, exception, true);
        }
    }

    protected void destroy() {
        this.dispatcher.dropSystemConsumer(SESSION_MANAGER_CONSUMER_NAME);
    }

    @Override
    public ImmutableEventDatagram onRequest(ImmutableEventDatagram event) throws FabricRequestException {
        SessionRequest request = this.getSessionRequest(event);
        this.logDeepDebug("SessionRequest received: " + String.valueOf(request) + ".");
        switch (request.getSessionState()) {
            case OPEN: {
                RequestConsumerReference result = this.openSession(request);
                SessionResponse response = SessionResponse.createOpenResponse(result, this.getHandlerEventIds());
                this.logDeepDebug("Returning SessionResponse: " + String.valueOf(response) + ".");
                return this.createResponseEvent(response);
            }
            case CLOSE: {
                this.closeSession(request);
                SessionResponse response = SessionResponse.createCloseResponse();
                this.logDeepDebug("Returning SessionResponse: " + String.valueOf(response) + ".");
                return this.createResponseEvent(response);
            }
        }
        throw new FabricRequestException(6038, "Session state '" + String.valueOf((Object)request.getSessionState()) + "' is invalid" + this.inComponent());
    }

    protected List<String> getHandlerEventIds() {
        return null;
    }

    protected SessionRequest getSessionRequest(ImmutableEventDatagram event) throws FabricRequestException {
        try {
            return (SessionRequest)((OpaqueEvent)event).getData();
        }
        catch (Exception exception) {
            throw new FabricRequestException(6038, "Obtaining session request failed" + this.inComponent(), exception);
        }
    }

    protected OpaqueEvent createResponseEvent(SessionResponse response) throws FabricRequestException {
        try {
            return SDOUtils.createOpaqueEvent("e.sys.SessionResponse", response);
        }
        catch (Exception exception) {
            throw new FabricRequestException(6038, "Creating session response failed" + this.inComponent(), exception);
        }
    }

    protected RequestConsumerReference openSession(SessionRequest request) throws FabricRequestException {
        ComponentReference client = this.findClient(request);
        String sessionName = this.getSessionName(request);
        try {
            return this.doOpenSession(request, client, sessionName);
        }
        catch (Exception exception) {
            if (exception instanceof FabricRequestException) {
                throw (FabricRequestException)exception;
            }
            Trace.logException(AbstractSessionManager.class, exception, true);
            this.logDeepDebug("localClientSessions: " + String.valueOf(this.localClientSessions) + ", remoteClientSessions: " + String.valueOf(this.remoteClientSessions) + "remoteNodeClients: " + String.valueOf(this.remoteNodeClients));
            return this.throwException("Opening session '" + sessionName + "' failed" + this.inComponent(), exception);
        }
    }

    private ComponentReference findClient(SessionRequest request) throws FabricRequestException {
        ComponentReference client = this.component.moderator.lookupComponent(request.getClientName());
        if (client == null) {
            this.throwException("Opening session failed" + this.inComponent() + " Cause: Client component not found.", null);
        }
        return client;
    }

    protected String getSessionName(SessionRequest request) {
        return "Session" + this.sessionNameAllocator.getNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RequestConsumerReference doOpenSession(SessionRequest request, ComponentReference client, String sessionName) throws Exception {
        this.logDeepDebug("Opening session: client: " + String.valueOf(client) + ", sessionName: " + sessionName + ".");
        AccessorProxy proxy = this.createAccessorProxy(sessionName, request.getClientName(), this.getOwner(request), request.isRouted(), request.isInstant(), request.getSLSessionName(), request.getSLSessionData());
        AbstractSessionManager abstractSessionManager = this;
        synchronized (abstractSessionManager) {
            AccessorSessionReferenceImpl result = this.doOpenSession(request, sessionName, proxy, this.isLocal(client) ? EventScope.OBSERVABLE : EventScope.INHERITED);
            if (!request.isInstant()) {
                this.addClientSession(client, sessionName);
            }
            this.logDebug("Session '" + sessionName + "' opened");
            return result;
        }
    }

    protected ComponentOwner getOwner(SessionRequest request) throws Exception {
        return this.context.isSecurityEnabled() ? this.context.securityManagerImpl.getComponentOwner(request.getOwnerName(), false) : null;
    }

    protected abstract AccessorProxy createAccessorProxy(String var1, String var2, ComponentOwner var3, boolean var4, boolean var5, String var6, SLSessionData var7) throws FabricRequestException;

    protected boolean isLocal(ComponentReference client) {
        return client.getAddress().getNodeAddress().equals(this.component.moderator.getFabricNode().getFabricAddress());
    }

    private AccessorSessionReferenceImpl throwException(String message, Throwable cause) throws FabricRequestException {
        throw new FabricRequestException(6038, message, cause);
    }

    private AccessorSessionReferenceImpl doOpenSession(SessionRequest request, String sessionName, AccessorProxy proxy, EventScope eventScope) throws Exception {
        AccessorSessionReferenceImpl result = (AccessorSessionReferenceImpl)this.createSessionConsumer(request, sessionName, proxy, eventScope);
        this.sessions.put(sessionName, proxy);
        return result;
    }

    protected RequestConsumerReference createSessionConsumer(SessionRequest request, String sessionName, AccessorProxy proxy, EventScope eventScope) throws Exception {
        RequestConsumerReferenceImpl result = this.dispatcher.doCreateRequestConsumer(sessionName, proxy, eventScope, true, true).getReference();
        ((AccessorSessionReferenceImpl)result).init(sessionName, request.getClientName(), AbstractSessionManager.getAccessorName(request), request.getSLSessionName() != null);
        ((AbstractAccessorProxy)proxy).setAccessorSession((AccessorSessionReferenceImpl)result);
        return result;
    }

    private static String getAccessorName(SessionRequest request) {
        return request.getAccessorName().startsWith(ACTIVATOR_PREFIX) ? request.getAccessorName().substring(ACTIVATOR_PREFIX.length()) : request.getAccessorName();
    }

    protected void addClientSession(ComponentReference client, String sessionName) {
        FabricNodeReference localNode = this.component.moderator.getFabricNode();
        if (client.getAddress().getNodeAddress().equals(localNode.getFabricAddress())) {
            if (client.getModel() == ComponentModel.REMOTE_CLIENT) {
                this.addRemoteClientSession(client.getName(), sessionName);
                this.addSessionsCleaner();
            } else {
                this.addLocalClientSession(client.getName(), sessionName);
            }
        } else {
            this.addRemoteClientSession(client.getName(), sessionName);
            this.addRemoteNodeClient(client.getName());
            this.addSessionsCleaner();
        }
    }

    private void addLocalClientSession(String clientName, String sessionName) {
        if (!this.localClientSessions.containsKey(clientName)) {
            this.localClientSessions.put(clientName, new HashSet());
        }
        this.localClientSessions.get(clientName).add(sessionName);
    }

    private void addRemoteClientSession(String clientName, String sessionName) {
        if (!this.remoteClientSessions.containsKey(clientName)) {
            this.remoteClientSessions.put(clientName, new HashSet());
        }
        this.remoteClientSessions.get(clientName).add(sessionName);
    }

    private void addRemoteNodeClient(String clientName) {
        String nodeName = ModeratorUtils.extractNodeName(clientName);
        if (!this.remoteNodeClients.containsKey(clientName)) {
            this.remoteNodeClients.put(nodeName, new HashSet());
        }
        this.remoteNodeClients.get(nodeName).add(clientName);
    }

    private void addSessionsCleaner() {
        try {
            if (this.sessionsCleaner == null) {
                this.sessionsCleaner = new SessionsCleaner();
                this.dispatcher.createHiddenEventConsumer(SESSIONS_CLEANER_CONSUMER_NAME, this.sessionsCleaner, "advisory.fabric.Moderator", "type = 'CLIENT_DISCONNECTED_FORCIBLY' OR type = 'COMPONENT_REMOVED' OR type = 'NODE_DISCONNECTED' OR type = 'NODE_DISCONNECTED_FORCIBLY'");
            }
        }
        catch (FabricEventDispatcherException exception) {
            Trace.logException(AbstractSessionManager.class, exception, true);
            Trace.logError(AbstractSessionManager.class, "Creating 'SessionsCleaner' consumer failed" + this.inComponent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeSession(SessionRequest request) {
        AccessorProxy session;
        AbstractSessionManager abstractSessionManager = this;
        synchronized (abstractSessionManager) {
            if (!request.isInstant()) {
                this.removeClientSession(request.getClientName(), request.getSessionName());
            }
            session = this.doRemoveSession(request.getSessionName());
        }
        this.doCloseSession(session);
    }

    private void removeClientSession(String clientName, String sessionName) {
        Set<String> sessions = this.localClientSessions.get(clientName);
        if (sessions != null) {
            this.doRemoveClientSession(clientName, sessionName, sessions, this.localClientSessions);
        } else {
            sessions = this.remoteClientSessions.get(clientName);
            if (sessions != null) {
                this.doRemoveClientSession(clientName, sessionName, sessions, this.remoteClientSessions);
                this.removeRemoteNodeClient(clientName);
                this.removeSessionsCleaner();
            }
        }
    }

    private void doRemoveClientSession(String clientName, String sessionName, Set<String> sessions, Map<String, Set<String>> clientSessions) {
        sessions.remove(sessionName);
        if (sessions.isEmpty()) {
            clientSessions.remove(clientName);
        }
    }

    private void removeRemoteNodeClient(String clientName) {
        String nodeName = ModeratorUtils.extractNodeName(clientName);
        Set<String> clients = this.remoteNodeClients.get(nodeName);
        if (clients != null) {
            clients.remove(clientName);
            if (clients.isEmpty()) {
                this.remoteNodeClients.remove(nodeName);
            }
        }
    }

    private void removeSessionsCleaner() {
        if (this.sessionsCleaner != null && this.remoteClientSessions.isEmpty()) {
            this.dispatcher.dropSystemConsumer(SESSIONS_CLEANER_CONSUMER_NAME);
            this.sessionsCleaner = null;
        }
    }

    private AccessorProxy doRemoveSession(String sessionName) {
        this.dropSessionConsumer(sessionName);
        return this.sessions.remove(sessionName);
    }

    protected void dropSessionConsumer(String sessionName) {
        try {
            this.dispatcher.dropConsumer(sessionName);
        }
        catch (FabricEventDispatcherException fabricEventDispatcherException) {
            // empty catch block
        }
    }

    private void doCloseSession(AccessorProxy session) {
        if (session != null) {
            session.close();
            this.logDebug("Session '" + session.getAccessorSession().getSessionName() + "' closed");
        }
    }

    protected String inComponent() {
        return " in component '" + this.component.getFullName() + "'.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAccessors(String owner) {
        List<String> accessors;
        AbstractSessionManager abstractSessionManager = this;
        synchronized (abstractSessionManager) {
            accessors = this.sessions.values().stream().filter(proxy -> proxy.getOwner().equalsIgnoreCase(owner)).map(proxy -> ModeratorUtils.makeConsumerFullName(proxy.getAccessorSession().getAccessorComponentName(), proxy.getAccessorSession().getAccessorName())).collect(Collectors.toList());
        }
        this.context.exchange.closeAccessors(accessors);
    }

    private void logDebug(String message) {
        if (!Trace.logDebug(AbstractSessionManager.class, message + this.inComponent())) {
            this.logDeepDebug(message + ".");
        }
    }

    private void logDeepDebug(String message) {
        Trace.logDebug(AccessorDebug.class, "SessionManager of " + this.component.getFullName() + ": " + message);
    }

    private class SessionsCleaner
    implements FabricEventListener {
        private SessionsCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onEvent(ImmutableEventDatagram event) {
            ArrayList sessionsToClose = new ArrayList();
            AbstractSessionManager abstractSessionManager = AbstractSessionManager.this;
            synchronized (abstractSessionManager) {
                Set<String> removedClients;
                FabricModeratorAdvisory advisory = (FabricModeratorAdvisory)event;
                if (advisory.getType() == ModeratorAdvisoryType.CLIENT_DISCONNECTED_FORCIBLY || advisory.getType() == ModeratorAdvisoryType.COMPONENT_REMOVED) {
                    Set<String> removedSessions = AbstractSessionManager.this.remoteClientSessions.remove(advisory.getEntity());
                    if (removedSessions != null) {
                        sessionsToClose.addAll(removedSessions.stream().map(AbstractSessionManager.this::doRemoveSession).collect(Collectors.toList()));
                    }
                    AbstractSessionManager.this.removeRemoteNodeClient(advisory.getEntity());
                } else if ((advisory.getType() == ModeratorAdvisoryType.NODE_DISCONNECTED || advisory.getType() == ModeratorAdvisoryType.NODE_DISCONNECTED_FORCIBLY) && (removedClients = AbstractSessionManager.this.remoteNodeClients.remove(advisory.getEntity())) != null) {
                    for (String removedClient : removedClients) {
                        Set<String> removedSessions = AbstractSessionManager.this.remoteClientSessions.remove(removedClient);
                        if (removedSessions == null) continue;
                        sessionsToClose.addAll(removedSessions.stream().map(AbstractSessionManager.this::doRemoveSession).collect(Collectors.toList()));
                    }
                }
                AbstractSessionManager.this.removeSessionsCleaner();
            }
            sessionsToClose.forEach(AbstractSessionManager.this::doCloseSession);
        }
    }
}

