/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.mf.admin.sco.ServiceConfigurationObject;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.service.ServiceContext;
import com.streamscape.sef.service.ServiceDescriptor;
import com.streamscape.sef.service.ServiceManager;
import com.streamscape.sef.service.ServiceName;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.BooleanParameter;
import com.streamscape.slex.lang.parameter.CompoundParameter;
import com.streamscape.slex.lang.parameter.EnumParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.NumericParameter;
import com.streamscape.slex.lang.parameter.SetParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.value.StatementSetValue;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.function.Predicate;

public abstract class AbstractServiceOperation
extends AbstractOperation<RuntimeContext> {
    protected AbstractServiceOperation() {
        super(false, false);
    }

    protected AbstractServiceOperation(boolean isDiagnostic) {
        super(false, isDiagnostic);
    }

    protected AbstractServiceOperation(boolean isAdministrative, boolean isDiagnostic) {
        super(isAdministrative, isDiagnostic);
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.service);
    }

    protected String getServiceTypeName(DSLStatement statement) {
        return statement.getParameter("ServiceType").getValue() + "." + statement.getParameter("ServiceName").getValue();
    }

    protected ManifestDefinition createManifestDefinition(String serviceTypeName) {
        return null;
    }

    protected ManifestDefinition parseManifestSyntax(DSLStatement statement, ManifestDefinition result) throws ParsingException {
        StatementSetValue servicesSet;
        if (result == null) {
            result = this.createManifestDefinition(this.getServiceTypeName(statement));
        }
        if (statement.getParameter("Autostart").isPresent()) {
            result.autostart = Boolean.parseBoolean(statement.getParameter("Autostart").getValue());
        }
        if (statement.getParameter("StartSequence").isPresent()) {
            result.sequence = Integer.parseInt(statement.getParameter("StartSequence").getValue());
        }
        result.principal = statement.getParameter("UserName").getValue();
        result.password = statement.getParameter("Password").getValue();
        if (statement.getParameter("LogLevel").isPresent()) {
            result.logLevel = Trace.Level.valueOf(statement.getParameter("LogLevel").getValue().toUpperCase());
        }
        if (statement.getParameter("LogBroadcast").isPresent()) {
            result.logBroadcast = Boolean.parseBoolean(statement.getParameter("LogBroadcast").getValue());
        }
        if ((servicesSet = statement.getSet("ServicesSet")).isPresent()) {
            for (int i = 0; i < servicesSet.size(); ++i) {
                result.addDependency(servicesSet.getElement(i).getParameter("ServiceType").getValue() + "." + servicesSet.getElement(i).getParameter("ServiceName").getValue());
            }
        }
        return result;
    }

    protected void checkServiceFullName(String serviceFullName) throws Exception {
        StringTokenizer tokenizer = new StringTokenizer(serviceFullName, ".");
        if (tokenizer.countTokens() != 2) {
            throw new Exception("Invalid service name specified.");
        }
    }

    protected String getNodeName(String serviceFullName) throws Exception {
        String result = ModeratorUtils.extractNodeName(serviceFullName);
        return result != null ? result : ((RuntimeContext)this.callable).getName();
    }

    protected String getServiceName(String fullServiceName) throws Exception {
        String serviceName = ModeratorUtils.extractComponentName(fullServiceName);
        ServiceName name = new ServiceName(serviceName);
        if (!((RuntimeContext)this.callable).getRepositoryAccessor().existsServiceConfiguration(name.getName(), name.getType())) {
            throw new Exception("Service not found.");
        }
        return serviceName;
    }

    protected ServiceConfigurationObject getSco(String serviceName) throws Exception {
        ServiceName name = new ServiceName(serviceName);
        return ((RuntimeContext)this.callable).getRepositoryAccessor().loadServiceConfiguration(name.getName(), name.getType());
    }

    protected ServiceContext getServiceContext(ServiceDescriptor serviceDescriptor) {
        return serviceDescriptor != null ? ((RuntimeContext)this.callable).serviceManager.getServiceContext(serviceDescriptor) : null;
    }

    protected String getServiceState(String serviceName) throws Exception {
        return AbstractServiceOperation.getServiceState(((RuntimeContext)this.callable).getServiceManager(), serviceName);
    }

    public static String getServiceState(ServiceManager manager, String serviceName) throws Exception {
        if (manager == null) {
            throw new IllegalStateException("Service Manager is not initialized.");
        }
        ComponentState state = manager.getServiceState(serviceName);
        if (state != null) {
            return state.name();
        }
        if (manager.isServiceRegistered(serviceName)) {
            return ComponentState.NOT_INITIALIZED.toString();
        }
        return "UNREGISTERED";
    }

    public static class ManifestDefinition
    extends Definition {
        public Boolean autostart;
        public Integer sequence;
        public String principal;
        public String password;
        public Trace.Level logLevel;
        public Boolean logBroadcast;
        public List<String> dependencies = new ArrayList<String>();

        public ManifestDefinition(String name, String serviceName) {
            super(name, serviceName);
        }

        public void setAutostart(boolean autostart) {
            this.autostart = autostart;
        }

        public boolean isAutostart() {
            return this.autostart != null && this.autostart != false;
        }

        public void setSequence(int sequence) {
            this.sequence = sequence;
        }

        public int getSequence() {
            return this.sequence == null ? -1 : this.sequence;
        }

        public void setPrincipal(String principal) {
            this.principal = principal;
        }

        public String getPrincipal() {
            return this.principal;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getPassword() {
            return this.password;
        }

        public Trace.Level getLogLevel() {
            return this.logLevel;
        }

        public void setLogLevel(Trace.Level logLevel) {
            this.logLevel = logLevel;
        }

        public boolean isLogBroadcast() {
            return this.logBroadcast != null && this.logBroadcast != false;
        }

        public void setLogBroadcast(boolean logBroadcast) {
            this.logBroadcast = logBroadcast;
        }

        public void addDependency(String serviceName) {
            this.dependencies.add(serviceName);
        }

        public List<String> getDependencies() {
            return this.dependencies;
        }
    }

    public static class Definition
    extends AbstractSLStatement {
        public String serviceName;

        public Definition(String name, String serviceName) {
            super(name);
            this.serviceName = serviceName;
        }

        public String getServiceName() {
            return this.serviceName;
        }
    }

    public static class ServiceDependsOnParameter
    extends Modifier {
        public ServiceDependsOnParameter(ServiceState state) {
            super("DEPENDS ON");
            this.setName("DEPENDSON");
            this.addParameter(new SetParameter("ServicesSet").addParameter(new ServiceTypeNameParameter(state)));
            this.setRequired(false);
        }
    }

    public static class ServiceLogBroadcastParameter
    extends Modifier {
        public ServiceLogBroadcastParameter() {
            super("LOG_BROADCAST");
            this.addParameter(new BooleanParameter("LogBroadcast"));
            this.setRequired(false);
        }
    }

    public static class ServiceLogLevelParameter
    extends Modifier {
        public ServiceLogLevelParameter() {
            super("LOG_LEVEL");
            this.addParameter(new EnumParameter("LogLevel").addPossibleValues("ERROR", "INFO", "DEBUG").setCaseSensitive(false));
            this.setRequired(false);
        }
    }

    public static class ServicePasswordParameter
    extends Modifier {
        public ServicePasswordParameter() {
            super("PASSWORD");
            this.addParameter(new StringParameter("Password", Character.valueOf('\''), Character.valueOf('\'')));
            this.setRequired(false);
        }
    }

    public static class ServicePrincipalParameter
    extends Modifier {
        public ServicePrincipalParameter() {
            super("PRINCIPAL");
            this.addParameter(new IdentifierParameter("UserName"));
            this.setRequired(false);
        }
    }

    public static class ServiceSequenceParameter
    extends Modifier {
        public ServiceSequenceParameter() {
            super("SEQUENCE");
            this.addParameter(new NumericParameter("StartSequence"));
            this.setRequired(false);
        }
    }

    public static class ServiceAutostartParameter
    extends Modifier {
        public ServiceAutostartParameter() {
            super("AUTOSTART");
            this.addParameter(new BooleanParameter("Autostart"));
            this.setRequired(false);
        }
    }

    public static class ServiceTypeNameParameter
    extends CompoundParameter {
        public ServiceTypeNameParameter() {
            this.setParametersDelimiter('.');
            this.addParameter((AbstractParameter)new IdentifierParameter("ServiceType").setName("ServiceType"));
            this.addParameter((AbstractParameter)new IdentifierParameter("ServiceName").setName("ServiceName"));
        }

        public ServiceTypeNameParameter(EnumSet<ServiceState> states) {
            this();
            this.setCompletionAdviser(new ServiceCompletionAdviser(states));
        }

        public ServiceTypeNameParameter(ServiceState state) {
            this();
            this.setCompletionAdviser(new ServiceCompletionAdviser(state));
        }
    }

    public static class ServiceCompletionAdviser
    implements CompletionAdviser<RuntimeContext> {
        private EnumSet<ServiceState> states;

        ServiceCompletionAdviser(ServiceState state) {
            this(EnumSet.of(state));
        }

        ServiceCompletionAdviser(EnumSet<ServiceState> states) {
            this.states = states;
        }

        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            TreeSet<String> result = new TreeSet<String>();
            Predicate<String> isPrototype = name -> name.equalsIgnoreCase("prototype");
            if (this.states.contains((Object)ServiceState.PROTOTYPES)) {
                result.addAll(this.getAll(callable, isPrototype));
            }
            if (this.states.contains((Object)ServiceState.ALL)) {
                result.addAll(this.getAll(callable, isPrototype.negate()));
            }
            if (this.states.contains((Object)ServiceState.REGISTERED)) {
                result.addAll(callable.getServiceManager().listRegisteredServices());
            }
            if (this.states.contains((Object)ServiceState.NOT_REGISTERED)) {
                List<String> all = new ServiceCompletionAdviser(ServiceState.ALL).getCompletions((String)null, processedScript, callable, session);
                all.removeAll(callable.getServiceManager().listRegisteredServices());
                result.addAll(all);
            }
            if (this.states.contains((Object)ServiceState.NOT_LOADED)) {
                List<String> registered = callable.getServiceManager().listRegisteredServices();
                registered.removeAll(callable.getServiceManager().listLoadedServices());
                result.addAll(registered);
            }
            if (this.states.contains((Object)ServiceState.LOADED)) {
                result.addAll(callable.getServiceManager().listLoadedServices());
            }
            if (this.states.contains((Object)ServiceState.NOT_RUNNING)) {
                callable.getServiceManager().listRegisteredServices().stream().filter(name -> !callable.getServiceManager().isServiceRunning((String)name)).forEach(result::add);
            }
            if (this.states.contains((Object)ServiceState.RUNNING)) {
                result.addAll(callable.getServiceManager().listRunningServices());
            }
            if (this.states.contains((Object)ServiceState.SUSPENDED)) {
                callable.getServiceManager().listRunningServices().stream().filter(name -> callable.getServiceManager().getServiceState((String)name) == ComponentState.SUSPENDED).forEach(result::add);
            }
            return new ArrayList<String>(result);
        }

        private List<String> getAll(RuntimeContext callable, Predicate<String> predicate) {
            ArrayList<String> result = new ArrayList<String>();
            RepositoryAccessor repositoryAccessor = callable.getRepositoryAccessor();
            try {
                repositoryAccessor.listServiceTypes().forEach(type -> {
                    try {
                        repositoryAccessor.listServicesByType((String)type).stream().filter(predicate).map(name -> type + "." + name).forEach(result::add);
                    }
                    catch (Exception exception) {
                        Trace.logException(AbstractServiceOperation.class, exception, true);
                    }
                });
            }
            catch (Exception exception) {
                Trace.logException(AbstractServiceOperation.class, exception, true);
            }
            return result;
        }

        @Override
        public boolean isCaseSensitive() {
            return true;
        }
    }

    public static enum ServiceState {
        PROTOTYPES,
        ALL,
        NOT_REGISTERED,
        REGISTERED,
        NOT_LOADED,
        LOADED,
        RUNNING,
        NOT_RUNNING,
        SUSPENDED;

    }
}

