/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.repository.types.AbstractSemanticFactory;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.ErrorMessages;
import com.streamscape.sdo.StructuredDataObject;
import com.streamscape.sdo.mf.admin.SemanticTypeFactory;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sef.dispatcher.AbstractFabricContextFactory;

abstract class AbstractSemanticTypeFactory
extends AbstractFabricContextFactory
implements SemanticTypeFactory {
    AbstractSemanticTypeFactory() {
    }

    @Override
    public void removeSemanticType(String typeName) throws SemanticTypeFactoryException {
        this.removeSemanticType(typeName, false);
    }

    @Override
    public boolean existsSemanticType(String typeName) {
        return context.getSemanticTypeCache().existsSemanticType(typeName);
    }

    @Override
    public boolean existsSemanticClass(Class typeClass) {
        return context.getSemanticTypeCache().existsSemanticClass(typeClass);
    }

    @Override
    public boolean existsSemanticClass(String className) {
        return context.getSemanticTypeCache().existsSemanticClass(className);
    }

    @Override
    public SemanticType createSemanticType(Class typeClass) {
        return AbstractSemanticTypeFactory.createSemanticType(typeClass, false);
    }

    @Override
    public SemanticType createSemanticType(String typeName, String className) {
        return AbstractSemanticTypeFactory.createSemanticType(typeName, className, false);
    }

    @Override
    public SemanticType createSemanticType(String typeName, Class typeClass) {
        return AbstractSemanticTypeFactory.createSemanticType(typeName, typeClass, false);
    }

    @Override
    public SemanticType createSemanticType(String typeName, StructuredDataObject object) {
        return AbstractSemanticTypeFactory.createSemanticType(typeName, object, false);
    }

    protected static void setValid(SemanticType semanticType, boolean isValid) {
        AbstractSemanticFactory.setValid(semanticType, isValid);
    }

    void checkOnAdd(SemanticType type, boolean force) throws SemanticTypeFactoryException {
        if (this.existsSemanticType(type.getTypeName())) {
            AbstractSemanticTypeFactory.throwTypeAlreadyExists(type.getTypeName());
        }
        if (this.existsSemanticClass(type.getClassName())) {
            AbstractSemanticTypeFactory.throwTypeAlreadyExists(context.getSemanticTypeCache().resolveSemanticClass(type.getClassName()), type.getClassName());
        }
        if (StringUtils.isEmpty(type.getAncestorType())) {
            AbstractSemanticTypeFactory.throwFactoryException(5005, "Ancestor is not set for semantic type [" + type.getTypeName() + "].");
        }
        if (!force) {
            try {
                ClassUtils.loadClass(type.getClassName(), context.getSystemClassLoaderChain());
            }
            catch (ClassNotFoundException exception) {
                AbstractSemanticTypeFactory.throwFactoryException(5016, "Semantic class '" + type.getClassName() + "' not found.");
            }
            catch (NoClassDefFoundError exception) {
                AbstractSemanticTypeFactory.throwFactoryException(5016, "Semantic class '" + type.getClassName() + "' not found.");
            }
        }
        AbstractSemanticTypeFactory.setVerified(type);
    }

    SemanticType checkOnRemove(String typeName, boolean force, boolean noCheck) throws SemanticTypeFactoryException {
        SemanticType type = context.getSemanticTypeCache().lookupSemanticType(typeName);
        if (type == null && force) {
            return null;
        }
        AbstractSemanticTypeFactory.checkTypeExistence(typeName, type);
        if (!noCheck) {
            if (type.isSystem()) {
                AbstractSemanticTypeFactory.throwFactoryException(5017, ErrorMessages.format("System semantic type [%1$s] cannot be removed.", typeName));
            }
            if (!force && this.hasDependencies(type)) {
                AbstractSemanticTypeFactory.throwFactoryException(5018, ErrorMessages.format("Semantic type [%1$s] has dependencies and cannot be removed.", typeName));
            }
        }
        return type;
    }
}

