/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.lib.dispatcher.DomainConstraint;
import com.streamscape.lib.dispatcher.RangeConstraint;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.dispatcher.AbstractRuntimeContext;
import com.streamscape.sef.dispatcher.DomainConstraintReferenceImpl;
import com.streamscape.sef.dispatcher.RangeConstraintReferenceImpl;
import com.streamscape.sef.moderator.DomainConstraintReference;
import com.streamscape.sef.moderator.RangeConstraintReference;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.BlockModifier;
import com.streamscape.slex.lang.modifier.ChoiceModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.AbstractParameter;
import com.streamscape.slex.lang.parameter.CompoundParameter;
import com.streamscape.slex.lang.parameter.ExpressionParameter;
import com.streamscape.slex.lang.parameter.IdentifierParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import com.streamscape.slex.lang.value.StatementBlockValue;
import com.streamscape.slex.lang.value.StatementValueList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractSelectorOperation
extends AbstractOperation<RuntimeContext> {
    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.selector);
        this.syntax.addTag(OperationTag.constraint);
    }

    protected void addMainModifiers(boolean withCompletionAdviser, boolean required) {
        ConstraintParameter domain = new ConstraintParameter("Domain", required);
        if (withCompletionAdviser) {
            domain.setCompletionAdviser(new AbstractDSLOperation.AbstractCompletionAdviser<RuntimeContext>(){

                @Override
                protected List<String> doGetCompletions(String processedScript, MFSession session) {
                    return ((RuntimeContext)AbstractSelectorOperation.this.callable).getModerator().listDomainConstraints().stream().sorted().collect(Collectors.toList());
                }
            });
        }
        this.syntax.addModifier((AbstractModifier)((Modifier)new Modifier().addParameter(domain)).setSyntaxHintSpace());
    }

    protected void addDescriptionModifier() {
        this.syntax.addModifier((AbstractModifier)new Modifier("DESCRIPTION", false).addParameter(new StringParameter("Description")));
    }

    protected void addLikeModifier() {
        this.syntax.addModifier(new CompoundModifier(false).addModifier(AbstractSelectorOperation.createLikeModifier(true)).addModifier(new CompoundModifier("AsFormat", false).addModifier(new Modifier("AS")).addModifier(new ChoiceModifier("Format").addPossibleValues("XML", "JSON"))));
    }

    protected BlockModifier createValuesModifier(String operation, boolean required, String indent) {
        return new BlockModifier(operation + "VALUES", StringUtils.toCapitalized(operation.trim().toLowerCase()) + "ValuesBlock", required).addModifier(this.wrapToRepeatable(this.createValueModifier(indent)));
    }

    protected CompoundModifier createValueModifier(String indent) {
        return new CompoundModifier().addParameter(new ExpressionParameter("Value")).addModifier(this.createPropertyTypeModifierExtended(AbstractDSLOperation.PropertyTypes.NO_BOOLEAN, true, indent, false));
    }

    protected static String getPatternDescription() {
        return "The pattern can contain wildcard characters <u>*</u> or <u>%</u>.\nThe pattern can be in one of the following formats:\n  <u>&lt;Name&gt;</u>                       - matches the specified plain name.\n  <u>&lt;Category&gt;.&lt;Name&gt;</u>            - matches the specified qualified name.\n  <u>*.*</u> or <u>%.%</u>                   - matches any name qualified or not.\n  <u>*</u> or <u>%</u>                       - matches any plain name without a category.\n  <u>&lt;Category&gt;.*</u> or <u>&lt;Category&gt;.%</u> - matches a qualified name that has any plain name\n                                 and the specified category.\n  <u>*.&lt;Name&gt;</u> or %.<u>&lt;Name&gt;</u>         - matches the specified plain name with any category.\n  <u>%</u> (but NOT <u>*</u>)                - can be placed inside a name or category and is processed\n                                 as a standard wildcard, replacing any number of characters.\nExamples:\n  <u>Dom%</u>      - matches any plain name starting with 'Dom'.\n  <u>%in%</u>      - matches any plain name containing 'in'.\n  <u>Cat%.%</u>    - matches a qualified name that has any plain name and a category starting with 'Cat'.\n  <u>Cat%.Dom%</u> - matches a qualified name that has a plain name starting with 'Dom'.\n              and a category starting with 'Cat'.\n  <u>%.Dom%</u>    - matches a qualified name that has any plain name and a category starting with 'Cat'.";
    }

    protected static String getDomainName(DSLStatement statement) {
        return AbstractSelectorOperation.getConstraintName(statement, "DomainCategory", "DomainName");
    }

    protected static String getRangeName(DSLStatement statement) {
        return AbstractSelectorOperation.getConstraintName(statement, "RangeCategory", "RangeName");
    }

    private static String getConstraintName(DSLStatement statement, String category, String name) {
        if (statement.existsParameter(category)) {
            return statement.getParameter(category).getValue() + "." + statement.getParameter(name).getValue();
        }
        if (statement.existsParameter(name)) {
            return statement.getParameter(name).getValue();
        }
        return null;
    }

    protected static String getDescription(DSLStatement statement) {
        return statement.existsParameter("Description") ? statement.getParameter("Description").getValue() : null;
    }

    protected void parseValues(DSLStatement statement, String blockName, List<AbstractDSLOperation.PropertyValue> result) throws ParsingException {
        if (statement.existsBlock(blockName)) {
            StatementBlockValue valuesBlock = statement.getBlock(blockName);
            for (int i = 0; i < valuesBlock.getLinesCount(); ++i) {
                StatementValueList line = valuesBlock.getLineByIndex(i);
                AbstractDSLOperation.PropertyValue value = new AbstractDSLOperation.PropertyValue(line.getParameter("Value").getValue());
                this.parseTypeAndFormat(line, value);
                result.add(value);
            }
        }
    }

    protected Set<Object> parseDomainValues(List<AbstractDSLOperation.PropertyValue> values) throws Exception {
        HashSet<Object> result = new HashSet<Object>();
        for (AbstractDSLOperation.PropertyValue value : values) {
            result.add(this.parseValue(value, false));
        }
        return result.isEmpty() ? null : result;
    }

    protected Object parseRangeValue(AbstractDSLOperation.PropertyValue value) throws Exception {
        return this.parseValue(value, false);
    }

    protected FabricConnection getConnection() {
        return ((AbstractRuntimeContext)this.callable).getSystemConnection();
    }

    protected DomainConstraint getUnderlyingDomain(DomainConstraintReference reference) {
        return ((DomainConstraintReferenceImpl)reference).getUnderlyingConstraint();
    }

    protected RangeConstraint getUnderlyingRange(RangeConstraintReference reference) {
        return ((RangeConstraintReferenceImpl)reference).getUnderlyingConstraint();
    }

    protected Stream<DomainConstraintReference> getSortedDomains(Stream<DomainConstraintReference> ranges) {
        return ranges.sorted().collect(Collectors.groupingBy(DomainConstraintReference::getType, TreeMap::new, Collectors.toList())).values().stream().flatMap(Collection::stream);
    }

    protected Stream<RangeConstraintReference> getSortedRanges(Stream<RangeConstraintReference> ranges) {
        return ranges.sorted().collect(Collectors.groupingBy(RangeConstraintReference::getType, TreeMap::new, Collectors.toList())).values().stream().flatMap(Collection::stream);
    }

    protected static class ConstraintParameter
    extends CompoundParameter {
        public ConstraintParameter(String model, boolean required) {
            this.setParametersDelimiter('.');
            this.addParameter((AbstractParameter)new IdentifierParameter(model + "Category").setRequired(false));
            this.addParameter(new IdentifierParameter(model + "Name"));
            this.addExclusionValues("LIKE");
            this.setRequired(required);
        }
    }

    protected static class AbstractDefinition
    extends AbstractSLStatement {
        private String entityName;
        private String description;

        protected AbstractDefinition(String operationName, String entityName) {
            super(operationName);
            this.entityName = entityName;
        }

        protected AbstractDefinition(String operationName, String entityName, String description) {
            this(operationName, entityName);
            this.description = description;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

