/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.lib.HashMappedList;
import com.streamscape.ds.lib.HsqlList;
import com.streamscape.ds.lib.OrderedHashSet;
import com.streamscape.ds.lib.OrderedIntHashSet;
import com.streamscape.ds.lib.Set;
import com.streamscape.ds.parser.ParserDQL;
import com.streamscape.ds.parser.expression.Expression;
import com.streamscape.ds.parser.expression.ExpressionColumn;
import com.streamscape.ds.parser.expression.QueryExpression;
import com.streamscape.ds.parser.expression.QuerySpecification;
import com.streamscape.ds.range.RangeVariable;
import com.streamscape.ds.result.ResultMetaData;
import com.streamscape.ds.schema.SchemaObject;
import com.streamscape.ds.schema.collection.Collection;
import com.streamscape.ds.schema.collection.SemagraphCollection;
import com.streamscape.ds.schema.column.ColumnSchema;
import com.streamscape.ds.schema.table.Table;
import com.streamscape.ds.schema.table.TableBase;
import com.streamscape.ds.schema.table.View;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.types.Type;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.dispatcher.ServiceContextImpl;
import com.streamscape.sef.dispatcher.ServiceManagerImpl;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.sef.service.ServiceDescriptor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AbstractSelectForSemagraphExpression
extends QueryExpression {
    protected int limit;
    protected List<Pair<List<Expression>, List<Expression>>> terms;
    protected int scoreOperation;
    protected Expression score;
    protected NameManager.ObjectName collectionName;

    public AbstractSelectForSemagraphExpression(ParserDQL.CompileContext context) {
        super(context);
    }

    protected ServiceAccessor createServiceAccessor(Session session) {
        return AbstractSelectForSemagraphExpression.createServiceAccessor(session, this.collectionName);
    }

    protected static ServiceAccessor createServiceAccessor(Session session, NameManager.ObjectName collectionName) {
        return AbstractSelectForSemagraphExpression.createServiceAccessor(session, collectionName.name, collectionName.schema.name);
    }

    protected static ServiceAccessor createServiceAccessor(Session session, String collectionName, String schemaName) {
        SchemaObject collection = session.dataspaceStore.schemaManager.getSchemaObject(collectionName, schemaName, 4);
        String serviceName = ((SemagraphCollection)collection).getServiceName();
        return AbstractSelectForSemagraphExpression.createServiceAccessor("TXSemagraph", serviceName);
    }

    protected static ServiceAccessor createServiceAccessor(String serviceType, String serviceName) {
        ServiceManagerImpl serviceManager = (ServiceManagerImpl)DataspaceManager.getContext().getServiceManager();
        ServiceDescriptor serviceDescriptor = serviceManager.getService(serviceType + "." + serviceName);
        if (serviceDescriptor == null) {
            throw new DataspaceException("Service " + serviceType + "." + serviceName + " doesn't exist.");
        }
        ServiceContextImpl serviceContext = serviceManager.getServiceContext(serviceDescriptor);
        if (serviceContext == null) {
            throw new DataspaceException("Service " + serviceType + "." + serviceName + " is not loaded.");
        }
        if (serviceContext.getState() != ComponentState.STARTED) {
            throw new DataspaceException("Service " + serviceType + "." + serviceName + " is not in " + serviceContext.getState().name() + " state.");
        }
        try {
            return serviceContext.createServiceAccessor(serviceType, serviceName);
        }
        catch (FabricComponentAccessorException exception) {
            throw new DataspaceException(Utils.formatExceptionWithUnrepeatedCauses(exception));
        }
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public int getLimit() {
        return this.limit;
    }

    public void addTerms(List<Expression> positiveTerms, List<Expression> negativeTerms) {
        if (this.terms == null) {
            this.terms = new ArrayList<Pair<List<Expression>, List<Expression>>>();
        }
        this.terms.add(new Pair<List<Expression>, List<Expression>>(positiveTerms, negativeTerms));
    }

    public List<Pair<List<Expression>, List<Expression>>> getTerms() {
        return this.terms;
    }

    public void setScoreOperation(int scoreOperation) {
        this.scoreOperation = scoreOperation;
    }

    public int getScoreOperation() {
        return this.scoreOperation;
    }

    public void setScore(Expression score) {
        this.score = score;
    }

    public Expression getScore() {
        return this.score;
    }

    protected static void checkResponse(SLResponse response) {
        if (response.isOK()) {
            return;
        }
        if (response.getException() != null) {
            throw new DataspaceException(com.streamscape.omf.java.Utils.formatExceptionWithUnrepeatedCauses(response.getException()));
        }
        if (response.getText() != null) {
            throw new DataspaceException(response.getText());
        }
        throw new DataspaceException("Failed to execute access service");
    }

    @Override
    public void resolve(Session session) {
        this.resolveReferencesLocal(session, RangeVariable.emptyArray);
    }

    @Override
    public void resolve(Session session, RangeVariable[] outerRanges, Type[] targetTypes) {
        this.resolveReferencesLocal(session, outerRanges);
        this.resolveTypes(session);
    }

    private void resolveReferencesLocal(Session session, RangeVariable[] outerRanges) {
        if (this.terms != null) {
            this.terms.stream().forEach(p -> {
                ((List)p.first).forEach(e -> {
                    this.unresolvedExpressions = e.resolveColumnReferences(session, outerRanges, this.unresolvedExpressions);
                });
                ((List)p.second).forEach(e -> {
                    this.unresolvedExpressions = e.resolveColumnReferences(session, outerRanges, this.unresolvedExpressions);
                });
            });
        }
        if (this.score != null) {
            this.unresolvedExpressions = this.score.resolveColumnReferences(session, outerRanges, this.unresolvedExpressions);
        }
        ExpressionColumn.checkColumnsResolved(this.unresolvedExpressions);
    }

    @Override
    public void resolveTypes(Session session) {
        if (this.terms != null) {
            this.terms.stream().forEach(p -> {
                ((List)p.first).forEach(e -> e.resolveTypes(session, null));
                ((List)p.second).forEach(e -> e.resolveTypes(session, null));
            });
        }
        if (this.score != null) {
            this.score.resolveTypes(session, null);
        }
    }

    @Override
    public void resolveReferences(Session session, RangeVariable[] outerRanges) {
        if (outerRanges == RangeVariable.emptyArray) {
            return;
        }
        this.resolveReferencesLocal(session, outerRanges);
    }

    @Override
    public OrderedHashSet getSubqueries() {
        return new OrderedHashSet();
    }

    @Override
    public boolean isSingleColumn() {
        return false;
    }

    @Override
    public ResultMetaData getMetaData() {
        return this.resultMetaData;
    }

    @Override
    public QuerySpecification getMainSelect() {
        return null;
    }

    @Override
    public Map<String, Object> describeJson(Session session) {
        return new LinkedHashMap<String, Object>();
    }

    @Override
    public String describe(Session session, int blanks) {
        return "n/a";
    }

    @Override
    public HsqlList getUnresolvedExpressions() {
        return this.unresolvedExpressions;
    }

    @Override
    public boolean areColumnsResolved() {
        return true;
    }

    String[] getColumnNames() {
        return this.resultMetaData.columnLabels;
    }

    @Override
    public Type[] getColumnTypes() {
        return this.resultMetaData.columnTypes;
    }

    @Override
    public int getColumnCount() {
        return this.resultMetaData.getColumnCount();
    }

    @Override
    public OrderedHashSet collectAllExpressions(OrderedHashSet set, OrderedIntHashSet typeSet, OrderedIntHashSet stopAtTypeSet) {
        OrderedHashSet[] sets = new OrderedHashSet[]{set};
        if (this.terms != null) {
            this.terms.stream().forEach(p -> {
                ((List)p.first).forEach(e -> {
                    sets[0] = e.collectAllExpressions(sets[0], typeSet, stopAtTypeSet);
                });
                ((List)p.second).forEach(e -> {
                    sets[0] = e.collectAllExpressions(sets[0], typeSet, stopAtTypeSet);
                });
            });
        }
        if (this.score != null) {
            set = this.score.collectAllExpressions(set, typeSet, stopAtTypeSet);
        }
        return set;
    }

    @Override
    public void collectObjectNames(Set set) {
        if (this.terms != null) {
            this.terms.stream().forEach(p -> {
                ((List)p.first).forEach(e -> e.collectObjectNames(set));
                ((List)p.second).forEach(e -> e.collectObjectNames(set));
            });
        }
        if (this.score != null) {
            this.score.collectObjectNames(set);
        }
    }

    @Override
    public HashMappedList getColumns() {
        HashMappedList columnList = new HashMappedList();
        for (int i = 0; i < this.resultMetaData.getColumnCount(); ++i) {
            ColumnSchema column = new ColumnSchema(NameManager.newSystemObjectName(this.resultMetaData.columnLabels[i], this.resultMetaData.columnTypes[i].typeCode), this.resultMetaData.columnTypes[i], true, false, null);
            columnList.add(column.getObjectName().name, column);
        }
        return columnList;
    }

    @Override
    public void setView(View view) {
    }

    @Override
    public void setTableColumnNames(HashMappedList list) {
    }

    @Override
    public void createTable(Session session) {
    }

    void createResultTable(Session session) {
    }

    @Override
    public void setColumnsDefined() {
    }

    @Override
    public void setReturningResult() {
    }

    void setReturningResultSet() {
    }

    @Override
    public NameManager.ObjectName[] getResultColumnNames() {
        HashMappedList columns = this.getColumns();
        return (NameManager.ObjectName[])columns.toKeysArray(new NameManager.ObjectName[columns.size()]);
    }

    @Override
    public TableBase getResultTable() {
        return null;
    }

    @Override
    public Table getBaseTable() {
        return null;
    }

    @Override
    public boolean isUpdatable() {
        return false;
    }

    @Override
    public boolean isInsertable() {
        return false;
    }

    @Override
    public int[] getBaseTableColumnMap() {
        return null;
    }

    @Override
    public Expression getCheckCondition() {
        return null;
    }

    @Override
    public boolean hasReference(RangeVariable range) {
        return false;
    }

    @Override
    public void getBaseTableNames(OrderedHashSet set) {
    }

    @Override
    public void getRangeVariables(OrderedHashSet set) {
    }

    boolean isEquivalent(QueryExpression other) {
        return false;
    }

    @Override
    public void replaceColumnReference(RangeVariable range, Expression[] list) {
        if (this.terms != null) {
            this.terms.stream().forEach(p -> {
                ((List)p.first).forEach(e -> e.replaceColumnReferences(range, list));
                ((List)p.second).forEach(e -> e.replaceColumnReferences(range, list));
            });
        }
    }

    @Override
    public void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        if (this.terms != null) {
            this.terms.stream().forEach(p -> {
                ((List)p.first).forEach(e -> e.replaceRangeVariables(ranges, newRanges));
                ((List)p.second).forEach(e -> e.replaceRangeVariables(ranges, newRanges));
            });
        }
        if (this.score != null) {
            this.score.replaceRangeVariables(ranges, newRanges);
        }
    }

    @Override
    public void setSelectIntoCollection(Collection collection) {
    }

    @Override
    public Collection getSelectIntoCollection() {
        return null;
    }

    @Override
    public QueryExpression getLeftQueryExpression() {
        return null;
    }

    @Override
    public QueryExpression getRightQueryExpression() {
        return null;
    }

    @Override
    public Collection findSelectIntoCollection() {
        return null;
    }

    public void setCollectionName(NameManager.ObjectName collectionName) {
        this.collectionName = collectionName;
    }

    public NameManager.ObjectName getCollectionName() {
        return this.collectionName;
    }

    protected String joinTerms(Session session) {
        return this.terms.stream().map(p -> {
            String positives = ((List)p.first).stream().map(e -> this.getStringValuesOf(session, (Expression)e)).collect(Collectors.joining("+"));
            Object negatives = ((List)p.second).stream().map(e -> this.getStringValuesOf(session, (Expression)e)).collect(Collectors.joining("-"));
            if (((String)negatives).length() > 0) {
                negatives = "-" + (String)negatives;
            }
            return positives + (String)negatives;
        }).collect(Collectors.joining(","));
    }

    private String getStringValuesOf(Session session, Expression e) {
        Object value = e.getValue(session);
        if (value == null) {
            return "null";
        }
        if (value.getClass().isArray()) {
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < Array.getLength(value); ++i) {
                result.add(String.valueOf(Array.get(value, i)));
            }
            return result.stream().collect(Collectors.joining(","));
        }
        return String.valueOf(value);
    }
}

