/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.lib.utils.Base64;
import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.vcard.PhoneUse;
import com.streamscape.sdo.vcard.Photo;
import com.streamscape.sdo.vcard.vCard;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.dispatcher.RuntimeSecurityManagerProxy;
import com.streamscape.sef.moderator.ComponentModel;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.security.AccessControlList;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.Organization;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.lang.OperationTag;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.slex.lang.modifier.AbstractModifier;
import com.streamscape.slex.lang.modifier.CompoundModifier;
import com.streamscape.slex.lang.modifier.Modifier;
import com.streamscape.slex.lang.parameter.LocalPathParameter;
import com.streamscape.slex.lang.parameter.StringParameter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class AbstractSecurityOperation
extends AbstractOperation<RuntimeContext> {
    protected static final List<AccessControlOperation> ALL_PERMISSIONS = new ArrayList<AccessControlOperation>();
    protected static final List<String> ALL_SLANG_PERMISSIONS = new ArrayList<String>();

    protected AbstractSecurityOperation(boolean isAdministrative) {
        super(isAdministrative, false);
    }

    protected AbstractSecurityOperation(boolean isAdministrative, boolean isDiagnostic) {
        super(isAdministrative, isDiagnostic);
    }

    @Override
    public boolean isVisible(MFSession session) {
        return ((RuntimeContext)this.callable).isSecurityEnabled() && super.isVisible(session);
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.security);
    }

    protected SecurityManager getSecurityManager(User user) {
        return new RuntimeSecurityManagerProxy(((RuntimeContext)this.callable).securityManagerImpl, user);
    }

    protected SecurityManager getSecurityManager(MFSession session) {
        return this.getSecurityManager((User)session.getOwner());
    }

    protected void addPermissions(AccessControlList acl, RowSet result) throws Exception {
        for (AccessControlOperation permission : ALL_PERMISSIONS) {
            if (permission == AccessControlOperation.ALLOW_ALL || permission == AccessControlOperation.CLIENT_ALLOW_ALL || permission == AccessControlOperation.DATASPACE_ALLOW_ALL || permission == AccessControlOperation.SERVICE_ALLOW_ALL) continue;
            result.addToRowSet(new Object[]{permission.toSlangName(), acl.isAllowed(permission)});
        }
    }

    protected boolean doUpdate(Updater updater) throws Exception {
        updater.execute();
        return true;
    }

    protected void updateUser(User currentUser, User user) throws SecurityManagerException {
        ((RuntimeSecurityManagerProxy)((RuntimeContext)this.callable).securityManager).doUpdateUser(currentUser, user);
    }

    protected void updateGroup(User currentUser, Group group) throws SecurityManagerException {
        ((RuntimeSecurityManagerProxy)((RuntimeContext)this.callable).securityManager).doUpdateGroup(currentUser, group);
    }

    protected void updateOrganization(User currentUser, Organization organization) throws SecurityManagerException {
        ((RuntimeSecurityManagerProxy)((RuntimeContext)this.callable).securityManager).doUpdateOrganization(currentUser, organization);
    }

    protected OptionalParameter getOptionalParameter(DSLStatement statement) {
        if (statement.existsModifier("ACL AT")) {
            return OptionalParameter.ACL;
        }
        if (statement.existsModifier("OWNERSHIP")) {
            return OptionalParameter.OWNERSHIP;
        }
        if (statement.existsModifier("PERMISSIONS")) {
            return OptionalParameter.PERMISSIONS;
        }
        if (statement.existsModifier("ATTRIBUTES")) {
            return OptionalParameter.ATTRIBUTES;
        }
        if (statement.existsModifier("ACCESS")) {
            return OptionalParameter.ACCESS;
        }
        return this.getOtherOptionalParameter(statement);
    }

    protected OptionalParameter getOtherOptionalParameter(DSLStatement statement) {
        return null;
    }

    protected void parseDataspaceName(AbstractDescribeGroupUserDefinition definition) throws ParsingException {
        if (definition.dataspace != null) {
            try {
                ModeratorUtils.splitComponentFullName(definition.dataspace, true);
                definition.nodeName = ModeratorUtils.extractNodeName(definition.dataspace);
                definition.dataspace = ModeratorUtils.extractComponentName(definition.dataspace);
            }
            catch (FabricException exception) {
                throw new ParsingException(exception.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SLResponse doInvokeAcl(String owner, String dataspace, long timeout) throws Exception {
        try (DataspaceAccessor accessor = this.getFabricConnection().createDataspaceAccessor(DataspaceType.valueOf(ModeratorUtils.extractComponentNameType(dataspace).toUpperCase()), ModeratorUtils.extractComponentNameName(dataspace));){
            SLResponse sLResponse = accessor.invokeLanguageRequest("describe user " + owner + " acl");
            return sLResponse;
        }
    }

    protected void addOwnership(String owner, RowSet result) throws Exception {
        ArrayList<ComponentReference> services = new ArrayList<ComponentReference>();
        ArrayList<ComponentReference> dataspaces = new ArrayList<ComponentReference>();
        ArrayList<ComponentReference> clients = new ArrayList<ComponentReference>();
        for (ComponentReference component : ((RuntimeContext)this.callable).getSecurityManager().listBoundComponents(owner, false)) {
            if (component.getModel() == ComponentModel.SERVICE) {
                services.add(component);
                continue;
            }
            if (component.getModel() == ComponentModel.DATASPACE) {
                dataspaces.add(component);
                continue;
            }
            if (component.getModel() == ComponentModel.RUNTIME || component.getModel() == ComponentModel.UNDEFINED) continue;
            clients.add(component);
        }
        this.doAddOwnership(owner, services, result);
        this.doAddOwnership(owner, dataspaces, result);
        this.doAddOwnership(owner, clients, result);
    }

    protected void doAddOwnership(String owner, List<ComponentReference> components, RowSet result) throws Exception {
        Collections.sort(components);
        for (ComponentReference component : components) {
            List<String> nameTokens = ModeratorUtils.splitComponentFullName(component.getName());
            result.addToRowSet(new Object[]{nameTokens.get(0), nameTokens.get(1), nameTokens.get(2), component.getModel().toString(), component.getEventScope(), owner});
        }
    }

    protected static Modifier createDescriptionModifier() {
        return (Modifier)new Modifier("DESCRIPTION", false).addParameter(new StringParameter("Description"));
    }

    protected static void addProfileSyntax(DSLStatementSyntax syntax, boolean withClear) {
        CompoundModifier values = new CompoundModifier("Values");
        if (withClear) {
            values.addModifier(new Modifier("CLEAR", false));
        }
        values.addModifier((AbstractModifier)new Modifier("FULL NAME", false).addParameter(new StringParameter("FullName")));
        values.addModifier((AbstractModifier)new Modifier("FAMILY NAME", false).addParameter(new StringParameter("FamilyName")));
        values.addModifier((AbstractModifier)new Modifier("GIVEN NAME", false).addParameter(new StringParameter("GivenName")));
        values.addModifier((AbstractModifier)new Modifier("MIDDLE NAME", false).addParameter(new StringParameter("MiddleName")));
        values.addModifier((AbstractModifier)new Modifier("NICKNAME", false).addParameter(new StringParameter("Nickname")));
        values.addModifier((AbstractModifier)new Modifier("URL", false).addParameter(new StringParameter("Url")));
        values.addModifier((AbstractModifier)new Modifier("BIRTHDAY", false).addParameter(new StringParameter("Birthday")));
        values.addModifier((AbstractModifier)new Modifier("ORGANIZATION NAME", false).addParameter(new StringParameter("OrgName")));
        values.addModifier((AbstractModifier)new Modifier("TITTLE", false).addParameter(new StringParameter("Title")));
        values.addModifier((AbstractModifier)new Modifier("ROLE", false).addParameter(new StringParameter("Role")));
        values.addModifier((AbstractModifier)new Modifier("HOME CELL", false).addParameter(new StringParameter("HomeCell")));
        values.addModifier((AbstractModifier)new Modifier("HOME VOICE", false).addParameter(new StringParameter("HomeVoice")));
        values.addModifier((AbstractModifier)new Modifier("HOME FAX", false).addParameter(new StringParameter("HomeFax")));
        values.addModifier((AbstractModifier)new Modifier("HOME MESSAGE", false).addParameter(new StringParameter("HomeMessage")));
        values.addModifier((AbstractModifier)new Modifier("HOME PAGER", false).addParameter(new StringParameter("HomePager")));
        values.addModifier((AbstractModifier)new Modifier("HOME ADDRESS", false).addParameter(new StringParameter("HomeAddress")));
        values.addModifier((AbstractModifier)new Modifier("HOME STREET", false).addParameter(new StringParameter("HomeStreet")));
        values.addModifier((AbstractModifier)new Modifier("HOME LOCALITY", false).addParameter(new StringParameter("HomeLocality")));
        values.addModifier((AbstractModifier)new Modifier("HOME REGION", false).addParameter(new StringParameter("HomeRegion")));
        values.addModifier((AbstractModifier)new Modifier("HOME POSTAL CODE", false).addParameter(new StringParameter("HomePostalCode")));
        values.addModifier((AbstractModifier)new Modifier("HOME COUNTRY", false).addParameter(new StringParameter("HomeCountry")));
        values.addModifier((AbstractModifier)new Modifier("WORK CELL", false).addParameter(new StringParameter("WorkCell")));
        values.addModifier((AbstractModifier)new Modifier("WORK VOICE", false).addParameter(new StringParameter("WorkVoice")));
        values.addModifier((AbstractModifier)new Modifier("WORK FAX", false).addParameter(new StringParameter("WorkFax")));
        values.addModifier((AbstractModifier)new Modifier("WORK MESSAGE", false).addParameter(new StringParameter("WorkMessage")));
        values.addModifier((AbstractModifier)new Modifier("WORK PAGER", false).addParameter(new StringParameter("WorkPager")));
        values.addModifier((AbstractModifier)new Modifier("WORK ADDRESS", false).addParameter(new StringParameter("WorkAddress")));
        values.addModifier((AbstractModifier)new Modifier("WORK STREET", false).addParameter(new StringParameter("WorkStreet")));
        values.addModifier((AbstractModifier)new Modifier("WORK LOCALITY", false).addParameter(new StringParameter("WorkLocality")));
        values.addModifier((AbstractModifier)new Modifier("WORK REGION", false).addParameter(new StringParameter("WorkRegion")));
        values.addModifier((AbstractModifier)new Modifier("WORK POSTAL CODE", false).addParameter(new StringParameter("WorkPostalCode")));
        values.addModifier((AbstractModifier)new Modifier("WORK COUNTRY", false).addParameter(new StringParameter("WorkCountry")));
        values.addModifier((AbstractModifier)new Modifier("HOME E-MAIL", false).addParameter(new StringParameter("HomeEmail")));
        values.addModifier((AbstractModifier)new Modifier("WORK E-MAIL", false).addParameter(new StringParameter("WorkEmail")));
        values.addModifier((AbstractModifier)new Modifier("JABBER ID", false).addParameter(new StringParameter("JabberID")));
        values.addModifier((AbstractModifier)new Modifier("DESCRIPTION", "ProfileDescr", false).addParameter(new StringParameter("ProfileDescription")));
        values.addModifier((AbstractModifier)new Modifier("AGE", false).addParameter(new StringParameter("Age")));
        values.addModifier((AbstractModifier)new Modifier("GENDER", false).addParameter(new StringParameter("Gender")));
        values.addModifier((AbstractModifier)new Modifier("MARITAL STATUS", false).addParameter(new StringParameter("MaritalStatus")));
        values.addModifier((AbstractModifier)new Modifier("LOCATION", false).addParameter(new StringParameter("Location")));
        values.addModifier((AbstractModifier)new Modifier("PHOTO", false).addParameter(new LocalPathParameter("PathToPhoto")));
        values.setCompactSyntax((withClear ? "[clear]\n" : "\n") + "   [family name '<FamilyName>']\n   [given name '<GivenName>']\n   [middle name '<MiddleName>']\n   [nickname '<Nickname>']\n   [url <Url>']\n   [birthday '<Birthday>']\n   [organization name '<OrgName>']\n   [tittle '<Title>']\n   [role '<Role>']\n   [home cell '<HomeCell>']\n   [home voice '<HomeVoice>']\n   [home fax '<HomeFax>']\n   [home message '<HomeMessage>']\n   [home pager '<HomePager>']\n   [home address '<HomeAddress>']\n   [home street '<HomeStreet>']\n   [home locality '<HomeLocality>']\n   [home region '<HomeRegion>']\n   [home postal code '<HomePostalCode>']\n   [home country '<HomeCountry>']\n   [work cell '<WorkCell>']\n   [work voice '<WorkVoice>']\n   [work fax '<WorkFax>']\n   [work message '<WorkMessage>']\n   [work pager '<WorkPager>']\n   [work address '<WorkAddress>']\n   [work street '<WorkStreet>']\n   [work locality '<WorkLocality>']\n   [work region '<WorkRegion>']\n   [work postal code '<WorkPostalCode>']\n   [work country '<WorkCountry>']\n   [home e-mail '<HomeEmail>']\n   [work e-mail '<WorkEmail>']\n   [jabber id '<JabberID>']\n   [description '<ProfileDescription>']\n   [age '<Age>']\n   [gender '<Gender>']\n   [marital status '<MaritalStatus>']\n   [location '<Location>']\n   [photo '<PathToPhoto>']");
        syntax.addModifier(new CompoundModifier("UserProfile", false).addModifier(new Modifier("PROFILE")).addModifier(values));
    }

    protected static boolean setProfile(vCard vcard, DSLStatement statement) throws Exception {
        boolean done = false;
        if (statement.existsParameter("FullName")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard::setFullName, statement.getParameter("FullName").getValue());
        }
        if (statement.existsParameter("FamilyName")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getName()::setFamilyName, statement.getParameter("FamilyName").getValue());
        }
        if (statement.existsParameter("GivenName")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getName()::setGivenName, statement.getParameter("GivenName").getValue());
        }
        if (statement.existsParameter("MiddleName")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getName()::setMiddleName, statement.getParameter("MiddleName").getValue());
        }
        if (statement.existsParameter("Nickname")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard::setNickName, statement.getParameter("Nickname").getValue());
        }
        if (statement.existsParameter("Url")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard::setURL, statement.getParameter("Url").getValue());
        }
        if (statement.existsParameter("Birthday")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard::setBirthday, statement.getParameter("Birthday").getValue());
        }
        if (statement.existsParameter("OrgName")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getOrganization()::setOrganizationName, statement.getParameter("OrgName").getValue());
        }
        if (statement.existsParameter("Title")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard::setTitle, statement.getParameter("Title").getValue());
        }
        if (statement.existsParameter("Role")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard::setRole, statement.getParameter("Role").getValue());
        }
        if (statement.existsParameter("HomeCell")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getHomePhone(PhoneUse.CELL)::setNumber, statement.getParameter("HomeCell").getValue());
        }
        if (statement.existsParameter("HomeVoice")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getHomePhone(PhoneUse.VOICE)::setNumber, statement.getParameter("HomeVoice").getValue());
        }
        if (statement.existsParameter("HomeFax")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getHomePhone(PhoneUse.FAX)::setNumber, statement.getParameter("HomeFax").getValue());
        }
        if (statement.existsParameter("HomeMessage")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getHomePhone(PhoneUse.MSG)::setNumber, statement.getParameter("HomeMessage").getValue());
        }
        if (statement.existsParameter("HomePager")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getHomePhone(PhoneUse.PAGER)::setNumber, statement.getParameter("HomePager").getValue());
        }
        if (statement.existsParameter("HomeAddress")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getHomeAddress()::setExtendedAddress, statement.getParameter("HomeAddress").getValue());
        }
        if (statement.existsParameter("HomeStreet")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getHomeAddress()::setStreet, statement.getParameter("HomeStreet").getValue());
        }
        if (statement.existsParameter("HomeLocality")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getHomeAddress()::setLocality, statement.getParameter("HomeLocality").getValue());
        }
        if (statement.existsParameter("HomeRegion")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getHomeAddress()::setRegion, statement.getParameter("HomeRegion").getValue());
        }
        if (statement.existsParameter("HomePostalCode")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getHomeAddress()::setPostalCode, statement.getParameter("HomePostalCode").getValue());
        }
        if (statement.existsParameter("HomeCountry")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getHomeAddress()::setCountry, statement.getParameter("HomeCountry").getValue());
        }
        if (statement.existsParameter("WorkCell")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getWorkPhone(PhoneUse.CELL)::setNumber, statement.getParameter("WorkCell").getValue());
        }
        if (statement.existsParameter("WorkVoice")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getWorkPhone(PhoneUse.VOICE)::setNumber, statement.getParameter("WorkVoice").getValue());
        }
        if (statement.existsParameter("WorkFax")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getWorkPhone(PhoneUse.FAX)::setNumber, statement.getParameter("WorkFax").getValue());
        }
        if (statement.existsParameter("WorkMessage")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getWorkPhone(PhoneUse.MSG)::setNumber, statement.getParameter("WorkMessage").getValue());
        }
        if (statement.existsParameter("WorkPager")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getWorkPhone(PhoneUse.PAGER)::setNumber, statement.getParameter("WorkPager").getValue());
        }
        if (statement.existsParameter("WorkAddress")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getWorkAddress()::setExtendedAddress, statement.getParameter("WorkAddress").getValue());
        }
        if (statement.existsParameter("WorkStreet")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getWorkAddress()::setStreet, statement.getParameter("WorkStreet").getValue());
        }
        if (statement.existsParameter("WorkLocality")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getWorkAddress()::setLocality, statement.getParameter("WorkLocality").getValue());
        }
        if (statement.existsParameter("WorkRegion")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getWorkAddress()::setRegion, statement.getParameter("WorkRegion").getValue());
        }
        if (statement.existsParameter("WorkPostalCode")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getWorkAddress()::setPostalCode, statement.getParameter("WorkPostalCode").getValue());
        }
        if (statement.existsParameter("WorkCountry")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard.getWorkAddress()::setCountry, statement.getParameter("WorkCountry").getValue());
        }
        if (statement.existsParameter("HomeEmail")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard::setHomeEMail, statement.getParameter("HomeEmail").getValue());
        }
        if (statement.existsParameter("WorkEmail")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard::setWorkEMail, statement.getParameter("WorkEmail").getValue());
        }
        if (statement.existsParameter("JabberID")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard::setJID, statement.getParameter("JabberID").getValue());
        }
        if (statement.existsParameter("ProfileDescription")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard::setDescription, statement.getParameter("ProfileDescription").getValue());
        }
        if (statement.existsParameter("Age")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard::setAge, statement.getParameter("Age").getValue());
        }
        if (statement.existsParameter("Gender")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard::setGender, statement.getParameter("Gender").getValue());
        }
        if (statement.existsParameter("MaritalStatus")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard::setMaritalStatus, statement.getParameter("MaritalStatus").getValue());
        }
        if (statement.existsParameter("Location")) {
            done = AbstractSecurityOperation.setProfileParameter(vcard::setLocation, statement.getParameter("Location").getValue());
        }
        if (statement.existsParameter("PathToPhoto")) {
            File photoFile = new File(statement.getParameter("PathToPhoto").getValue());
            done = AbstractSecurityOperation.setProfileParameter(vcard::setPhoto, new Photo("image/jpeg", Base64.encodeBytes(FileIOUtils.getFileContent(photoFile))));
        }
        return done;
    }

    private static <T> boolean setProfileParameter(Consumer<T> setter, T parameter) {
        setter.accept(parameter);
        return true;
    }

    static {
        ALL_PERMISSIONS.add(AccessControlOperation.ALLOW_ALL);
        ALL_PERMISSIONS.add(AccessControlOperation.SERVICE_ALLOW_ALL);
        ALL_PERMISSIONS.add(AccessControlOperation.SERVICE_CREATE);
        ALL_PERMISSIONS.add(AccessControlOperation.SERVICE_ADMIN);
        ALL_PERMISSIONS.add(AccessControlOperation.SERVICE_ACCESS);
        ALL_PERMISSIONS.add(AccessControlOperation.SERVICE_USE);
        ALL_PERMISSIONS.add(AccessControlOperation.DATASPACE_ALLOW_ALL);
        ALL_PERMISSIONS.add(AccessControlOperation.DATASPACE_CREATE);
        ALL_PERMISSIONS.add(AccessControlOperation.DATASPACE_ADMIN);
        ALL_PERMISSIONS.add(AccessControlOperation.DATASPACE_USE);
        ALL_PERMISSIONS.add(AccessControlOperation.CONNECTION_FACTORY_USE);
        ALL_PERMISSIONS.add(AccessControlOperation.CLIENT_ALLOW_ALL);
        ALL_PERMISSIONS.add(AccessControlOperation.CLIENT_ACCESS_SLANG);
        ALL_PERMISSIONS.add(AccessControlOperation.CLIENT_ACCESS_REPOSITORY);
        ALL_PERMISSIONS.add(AccessControlOperation.CLIENT_ACCESS_PRODUCER);
        ALL_PERMISSIONS.add(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        ALL_PERMISSIONS.add(AccessControlOperation.CLIENT_ACCESS_EVENT_CACHE);
        ALL_PERMISSIONS.add(AccessControlOperation.CLIENT_ACCESS_DATA_CONSTRAINT);
        ALL_PERMISSIONS.add(AccessControlOperation.CLIENT_ACCESS_FABRIC_GROUPS);
        ALL_SLANG_PERMISSIONS.addAll(ALL_PERMISSIONS.stream().map(AccessControlOperation::toSlangName).collect(Collectors.toList()));
    }

    protected static interface Updater {
        public void execute() throws Exception;
    }

    public static enum OptionalParameter {
        ACL,
        OWNERSHIP,
        PERMISSIONS,
        ATTRIBUTES,
        ACCESS,
        OTHER;

    }

    protected static abstract class AbstractDescribeGroupUserDefinition
    extends AbstractSLStatement {
        protected String owner;
        protected OptionalParameter parameter;
        protected String dataspace;
        protected String nodeName;

        protected AbstractDescribeGroupUserDefinition(String operationName, String owner, OptionalParameter parameter, String dataspace, String nodeName) {
            super(operationName);
            this.owner = owner;
            this.parameter = parameter;
            this.dataspace = dataspace;
            this.nodeName = nodeName;
        }

        public OptionalParameter getParameter() {
            return this.parameter;
        }

        public String getDataspace() {
            return this.dataspace;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }
    }

    protected static abstract class AbstractAlterCreateUserDefinition
    extends AbstractSLStatement {
        public String userName;
        public DSLStatement statement;

        protected AbstractAlterCreateUserDefinition(String operationName, DSLStatement statement, String syntax) throws ParsingException {
            super(operationName);
            List<String> modifiers;
            this.userName = statement.getParameter("Name").getValue();
            this.statement = statement;
            if (statement.existsModifier("PROFILE") && !(modifiers = statement.listModifiers()).isEmpty() && modifiers.get(modifiers.size() - 1).equalsIgnoreCase("PROFILE")) {
                throw new ParsingException(AbstractSecurityOperation.getSyntaxErrorMessage(syntax, "At least one parameter must be specified for modifier 'profile'.", null));
            }
        }
    }

    public class OrganizationsAdviser
    implements CompletionAdviser<RuntimeContext> {
        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            try {
                return AbstractSecurityOperation.this.getSecurityManager(session).listOrganizations();
            }
            catch (SecurityManagerException securityManagerException) {
                return Collections.emptyList();
            }
        }

        @Override
        public boolean isCaseSensitive() {
            return false;
        }
    }

    public class GroupsAdviser
    implements CompletionAdviser<RuntimeContext> {
        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            try {
                return AbstractSecurityOperation.this.getSecurityManager(session).listGroups();
            }
            catch (SecurityManagerException securityManagerException) {
                return Collections.emptyList();
            }
        }

        @Override
        public boolean isCaseSensitive() {
            return false;
        }
    }

    public class UsersAdviser
    implements CompletionAdviser<RuntimeContext> {
        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            try {
                return AbstractSecurityOperation.this.getSecurityManager(session).listUsers();
            }
            catch (SecurityManagerException securityManagerException) {
                return Collections.emptyList();
            }
        }

        @Override
        public boolean isCaseSensitive() {
            return false;
        }
    }
}

