/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.utils.TimeWindow;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.enums.ReplyMatchStrategy;
import com.streamscape.sdo.enums.RequestDistributionStrategy;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.operation.Operation;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.EventReceiver;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.AbstractFabricConnection;
import com.streamscape.sef.dispatcher.AbstractFabricConsumer;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.dispatcher.ExchangeException;
import com.streamscape.sef.dispatcher.SinkEventFlowImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.sef.scheduler.EventTaskTrigger;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.SchedulerAdvisory;
import com.streamscape.sef.scheduler.SchedulerEvent;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.scheduler.SchedulerState;
import com.streamscape.sef.scheduler.TaskList;
import com.streamscape.sef.security.ComponentOwner;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import java.util.List;
import java.util.Map;

public abstract class AbstractSchedulerImpl
extends AbstractRuntimeFactory {
    private transient AbstractFabricConnection connection;

    protected AbstractSchedulerImpl() {
    }

    protected abstract SchedulerState getState();

    protected void init() throws Exception {
        this.connection = AbstractSchedulerImpl.getContext().getSystemConnection();
        this.connection.bindProducerForSystem("event.Scheduler", EventFlowEntity.SCHEDULER);
    }

    protected abstract void open() throws Exception;

    protected void destroy() {
        try {
            this.connection.unbindProducerForSystem("event.Scheduler", EventFlowEntity.SCHEDULER);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
        }
    }

    protected void update() {
        AbstractSchedulerImpl.getContext().saveScheduler();
    }

    protected abstract void recover() throws Exception;

    protected abstract Scheduler getScheduler(String var1);

    protected Object invokeRequest(String nodeName, String methodName, Object ... parameters) throws SchedulerException {
        return this.invokeRequest(nodeName, methodName, (Class[])null, parameters);
    }

    protected Object invokeRequest(String nodeName, String methodName, Class[] parameterTypes, Object ... parameters) throws SchedulerException {
        Object reply;
        try {
            reply = AbstractSchedulerImpl.getContext().exchange.raiseInternalRequest(nodeName, 140, (Object)new AbstractExchange.OperationData(methodName, parameterTypes, parameters));
        }
        catch (Exception exception) {
            if (exception instanceof ExchangeException && ((ExchangeException)exception).getErrorCode() == 6018) {
                throw new SchedulerException(6018, exception.getMessage());
            }
            throw new SchedulerException(6011, "Invocation of operation '" + methodName + "' on node '" + nodeName + "' failed.", exception);
        }
        if (reply instanceof SchedulerException) {
            throw (SchedulerException)reply;
        }
        return reply;
    }

    protected <T> List<T> broadcastRequest(String methodName, Object ... parameters) throws SchedulerException {
        return this.broadcastRequest(methodName, (Class[])null, parameters);
    }

    protected <T> List<T> broadcastRequest(String methodName, Class[] parameterTypes, Object ... parameters) throws SchedulerException {
        return AbstractSchedulerImpl.getContext().exchange.broadcastSchedulerRequest(new AbstractExchange.OperationData(methodName, parameterTypes, parameters));
    }

    protected abstract Map<String, TimeWindow> getTimeWindowsMap();

    protected abstract void synchronizeTimeWindowsInSysplex(Map<String, TimeWindow> var1, boolean var2) throws SchedulerException;

    protected abstract void synchronizeTimeWindowsInNode(Map<String, TimeWindow> var1) throws SchedulerException;

    protected void addTimeWindow(TimeWindow window) throws SchedulerException {
        try {
            AbstractSchedulerImpl.getContext().exchange.addTimeWindow(this, window);
        }
        catch (Exception exception) {
            if (exception instanceof SchedulerException) {
                throw (SchedulerException)exception;
            }
            throw new SchedulerException(6011, "Unexpected exception.", exception);
        }
    }

    protected abstract void doAddTimeWindow(TimeWindow var1) throws SchedulerException;

    protected void removeTimeWindow(String name) throws SchedulerException {
        try {
            AbstractSchedulerImpl.getContext().exchange.removeTimeWindow(this, name);
        }
        catch (Exception exception) {
            if (exception instanceof SchedulerException) {
                throw (SchedulerException)exception;
            }
            throw new SchedulerException(6011, "Unexpected exception.", exception);
        }
    }

    protected abstract boolean doRemoveTimeWindow(String var1) throws SchedulerException;

    protected void setTimeWindow(TimeWindow window) throws SchedulerException {
        try {
            AbstractSchedulerImpl.getContext().exchange.changeTimeWindow(this, window);
        }
        catch (Exception exception) {
            if (exception instanceof SchedulerException) {
                throw (SchedulerException)exception;
            }
            throw new SchedulerException(6011, "Unexpected exception.", exception);
        }
    }

    protected abstract boolean doSetTimeWindow(TimeWindow var1) throws SchedulerException;

    protected AbstractFabricConnection getConnection() {
        return this.connection;
    }

    protected FabricComponent getComponent() {
        return this.connection.component;
    }

    protected EventConsumer createEventConsumer(String name, FabricEventListener listener, String eventId, String selector, EventScope eventScope) throws Exception {
        return this.connection.createSystemEventConsumer(name, listener, eventId, selector, eventScope, false);
    }

    protected EventConsumer createEventAsyncConsumer(String name, FabricEventListener listener, String eventId, String selector, EventScope eventScope) throws Exception {
        return this.connection.createSystemEventAsyncConsumer(name, listener, eventId, selector, eventScope, false);
    }

    protected void completeSinkEventFlow(EventConsumer consumer, EventTaskTrigger trigger) {
        SinkEventFlowImpl eventFlow = ((AbstractFabricConsumer)((Object)consumer)).eventFlow;
        if (eventFlow != null) {
            eventFlow.setEntity(EventFlowEntity.SCHEDULER_EVENT_TASK_TRIGGER);
            eventFlow.setEntityName(trigger.getName());
            eventFlow.addEntityParameter("job", AbstractSchedulerImpl.convertNull(trigger.getJobName()));
            eventFlow.addEntityParameter("list", AbstractSchedulerImpl.convertNull(trigger.getListName()));
            eventFlow.addEntityParameter("task", AbstractSchedulerImpl.convertNull(trigger.getTaskName()));
            eventFlow.addEntityParameter("node", AbstractSchedulerImpl.convertNull(trigger.getNodeName()));
            eventFlow.addEntityParameter("user", AbstractSchedulerImpl.convertNull(trigger.getUserName()));
        }
    }

    protected void raiseEvent(EventDatagram event, EventScope eventScope) throws Exception {
        this.connection.component.raiseSystemEvent(event, eventScope);
    }

    protected AcknowledgementEvent raiseRequest(SchedulerEvent event, EventScope eventScope, long timeout) throws Exception {
        return this.connection.component.raiseSystemRequest(event, eventScope, RequestDistributionStrategy.AUCTION, ReplyMatchStrategy.REPLY_TO, timeout);
    }

    protected void raiseAcknowledgement(AcknowledgementEvent event, EventScope eventScope) throws Exception {
        this.connection.raiseAcknowledgement(event, eventScope, -1L);
    }

    protected void raiseAdvisory(SchedulerAdvisory advisory, EventScope eventScope) {
        try {
            AbstractSchedulerImpl.getContext().exchange.raiseSystemAdvisory(advisory, eventScope, true);
        }
        catch (Throwable exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Raising Scheduler Advisory failed.");
        }
    }

    protected void raiseException(SchedulerException exception, EventScope eventScope) {
        try {
            AbstractSchedulerImpl.getContext().exchange.raiseSystemException(exception, eventScope);
        }
        catch (Throwable error) {
            Trace.logException(this, error, true);
            Trace.logError(this, "Raising Scheduler Exception failed.");
        }
    }

    protected EventReceiver createCompletionEventReceiver(TaskList taskList) throws SchedulerException {
        try {
            String nodeName = AbstractSchedulerImpl.getContext().getName();
            String listName = taskList.getName();
            return this.connection.createSystemEventReceiver("sys$Receiver_" + listName, "event.Scheduler.Completion", String.format("(%s = '' OR %s = '%s')", "nodeName", "nodeName", nodeName) + String.format(" AND %s = '%s'", "listName", listName), taskList.getEventScope(), false);
        }
        catch (Exception exception) {
            throw new SchedulerException(6151, (Throwable)exception);
        }
    }

    protected User getUser(String userName) throws SchedulerException {
        try {
            return AbstractRuntimeFactory.getContext().securityManagerImpl.doGetUser(userName);
        }
        catch (SecurityManagerException exception) {
            throw new SchedulerException(exception.getErrorCode(), exception.getErrorMessage());
        }
    }

    protected ComponentOwner getOwner(String ownerName) throws SchedulerException {
        try {
            return AbstractRuntimeFactory.getContext().securityManagerImpl.getComponentOwner(ownerName, false);
        }
        catch (SecurityManagerException exception) {
            throw new SchedulerException(exception.getErrorCode(), exception.getErrorMessage());
        }
    }

    protected boolean existsUser(String userName) {
        return AbstractSchedulerImpl.getContext().securityManagerImpl.existsUser(userName);
    }

    protected Operation<?> getDSLOperation(String command) throws SchedulerException {
        return AbstractSchedulerImpl.getContext().getLexiconProcessor().getOperation(command);
    }

    protected void checkSemanticType(String key, Object value) throws SchedulerException {
        if (!AbstractSchedulerImpl.getContext().getSemanticTypeCache().existsSemanticClass(value.getClass())) {
            throw new SchedulerException(6152, "Invalid value for key '" + key + "' (semantic type not found).");
        }
    }

    protected static void throwInsufficientRights(String errorMessage) throws SchedulerException {
        throw new SchedulerException(6092, errorMessage);
    }

    private static String convertNull(String value) {
        return value == null ? "*" : value;
    }
}

