/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.sdo.operation.HelpSLResponse;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PromptSLResponse;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dispatcher.GenericSLSession;
import com.streamscape.sef.dispatcher.SLSessionDSLProvider;
import com.streamscape.sef.dispatcher.SLSessionMFSession;
import com.streamscape.sef.dispatcher.SLSessionUseOperation;
import com.streamscape.slex.HelpOperation;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.HelpDSLOperation;
import com.streamscape.slex.lang.completion.DSLCompletion;
import com.streamscape.slex.slang.SLSessionException;
import com.streamscape.tools.console.autocompletion.AbstractCompleter;
import com.streamscape.tools.console.autocompletion.CompleterCondition;
import com.streamscape.tools.console.autocompletion.CompoundCompleter;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

abstract class AbstractSLSession
extends AbstractCompleter
implements GenericSLSession {
    static final long DEFAULT_REPLY_TIMEOUT = 30000L;
    String nodeName;
    String sessionName;
    String banner;
    boolean isOpened = false;
    transient SLSessionDSLProvider dslProvider = new SLSessionDSLProvider(this);
    transient CompoundCompleter completer = new CompoundCompleter();
    transient SLSessionMFSession mfSession;
    long sessionTimeout = 30000L;
    private static Pattern REDIRECTION_PATTERN = Pattern.compile("^(?i)(FUNCTION|ACTOR|TRIGGER) ([a-zA-Z0-9_]+)(\\(\\))?$");

    AbstractSLSession() {
    }

    @Override
    public String getName() {
        return this.sessionName;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public String getComponentType() {
        return this.mfSession != null && this.mfSession.context != null && !this.mfSession.isNodeContext() ? this.mfSession.context.componentType : null;
    }

    @Override
    public String getComponentName() {
        return this.mfSession != null && this.mfSession.context != null && !this.mfSession.isNodeContext() ? this.mfSession.context.componentName : null;
    }

    @Override
    public String getBanner() {
        return this.banner;
    }

    @Override
    public boolean isOpened() {
        return this.isOpened;
    }

    @Override
    public boolean isAvailable() {
        return this.mfSession != null && this.mfSession.isAvailable();
    }

    @Override
    public SLResponse slangRequest(String request, long timeout) throws SLSessionException {
        this.checkOpened();
        return this.doSlangRequest(request, timeout);
    }

    @Override
    public SLResponse slangRequest(SLStatement request, long timeout) throws SLSessionException {
        this.checkOpened();
        return this.doSlangRequest(request, timeout);
    }

    synchronized SLResponse doSlangRequest(SLStatement request, long timeout) throws SLSessionException {
        if (this.dslProvider.hasOperation(request.getName())) {
            this.mfSession.timeout = timeout;
            if (request instanceof HelpOperation.Definition) {
                return this.processResponse(this.invokeHelp((HelpOperation.Definition)request, timeout));
            }
            if (request instanceof SLSessionUseOperation.Definition) {
                return this.processResponse(this.invokeUse((SLSessionUseOperation.Definition)request));
            }
            return this.processResponse(this.dslProvider.invoke(request, this.mfSession, timeout));
        }
        return this.processResponse(this.invokeRequest(request, timeout));
    }

    @Override
    public SLResponse completeRequest(String request) throws SLSessionException {
        return this.completeRequest(request, 30000L);
    }

    @Override
    public SLResponse completeRequest(String request, long timeout) throws SLSessionException {
        this.checkOpened();
        return this.invokeCompleteRequest(request, timeout);
    }

    protected SLResponse invokeUse(SLSessionUseOperation.Definition definition) {
        return null;
    }

    SLResponse doSlangRequest(String request, long timeout) throws SLSessionException {
        try {
            SLStatement statement = this.dslProvider.parse(request, this.mfSession);
            if (statement != null) {
                return this.doSlangRequest(statement, timeout);
            }
            return this.processResponse(this.invokeRequest(request, timeout));
        }
        catch (ParsingException exception) {
            return this.processResponse(new SLResponse(exception));
        }
    }

    abstract SLResponse processResponse(SLResponse var1) throws SLSessionException;

    SLResponse invokeHelp(HelpOperation.Definition definition, long timeout) throws SLSessionException {
        if (definition.isList()) {
            if (!definition.isComplex()) {
                definition.setComplex();
                SLResponse response = this.invokeHelpWithoutParameters(definition, timeout);
                return response.isOK() ? ((HelpSLResponse)response).convertToUserResponse() : response;
            }
            return this.invokeHelpWithoutParameters(definition, timeout);
        }
        if (this.dslProvider.hasVisibleOperation(definition.getOperationName(), this.mfSession)) {
            return HelpDSLOperation.internalInvokeHelpForOperation(definition.getOperationName(), this.dslProvider.getVisibleOperation(definition.getOperationName(), (MFSession)this.mfSession), this.mfSession);
        }
        Set<String> operations = this.dslProvider.listVisibleOperations(null, definition.getOperationName());
        SLResponse redirectionResponse = this.invokeHelpRedirection(definition);
        if (redirectionResponse != null) {
            return redirectionResponse;
        }
        SLResponse response = this.invokeRequest(definition, timeout);
        if (response.isOK() && response.getText() != null || !response.isOK() && operations.isEmpty()) {
            return response;
        }
        if (!operations.isEmpty()) {
            if (response.isOK()) {
                ((HelpSLResponse)response).setSessionOperations(operations);
            } else {
                response = new HelpSLResponse(null, null, operations);
            }
        }
        if (!definition.isComplex()) {
            definition.setComplex();
            return ((HelpSLResponse)response).convertToUserResponse();
        }
        return response;
    }

    protected SLResponse invokeHelpRedirection(HelpOperation.Definition definition) throws SLSessionException {
        SLResponse response = null;
        Matcher matcher = REDIRECTION_PATTERN.matcher(definition.getOperationName());
        if (matcher.find()) {
            String entityName = matcher.group(1);
            if (entityName.toUpperCase().equals("TRIGGER")) {
                entityName = "EVENT TRIGGER";
            }
            String functionName = matcher.group(2);
            try {
                String option = entityName.toUpperCase().equals("FUNCTION") ? "HELP" : "DOC";
                return this.mfSession.context.accessor.invokeLanguageRequest("DESCRIBE " + entityName + " " + functionName + " " + option);
            }
            catch (FabricComponentAccessorException exception) {
                throw new SLSessionException(7010, "Underlying accessor closed.");
            }
        }
        return response;
    }

    SLResponse invokeHelpWithoutParameters(HelpOperation.Definition definition, long timeout) throws SLSessionException {
        SLResponse response = this.invokeRequest(definition, timeout);
        if (response.isOK() && definition.isAll()) {
            ((HelpSLResponse)response).setSessionOperations(this.dslProvider.listVisibleOperations(this.mfSession, null));
        }
        return response;
    }

    protected void checkOpened() throws SLSessionException {
        if (!this.isOpened) {
            throw new SLSessionException(7009, "Session is closed.");
        }
    }

    void initCompleter() {
        this.completer = new CompoundCompleter();
        this.completer.addCompleter(this.dslProvider);
        this.completer.addCompleter(new AbstractCompleter(){

            @Override
            public DSLCompletion completeDsl(String command, CompleterCondition condition) {
                try {
                    SLResponse response = AbstractSLSession.this.invokeCompleteRequest(command, 30000L);
                    return response != null && response.getObject() != null ? (DSLCompletion)response.getObject() : null;
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
    }

    @Override
    public DSLCompletion completeDsl(String command, CompleterCondition condition) {
        return this.completer.completeDsl(command, condition);
    }

    @Override
    public PromptSLResponse getPrompt() {
        return this.getPrompt(this.getNodeName());
    }

    @Override
    public PromptSLResponse getPrompt(String nodeName) {
        return new PromptSLResponse(this.getUserName(), nodeName);
    }

    @Override
    public PromptSLResponse getPrompt(String nodeName, String componentType, String componentName) {
        return new PromptSLResponse(this.getUserName(), nodeName, componentType, componentName);
    }

    @Override
    public boolean isNativeContext(MFSession session) {
        return true;
    }

    @Override
    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @Override
    public long getSessionTimeout() {
        return this.sessionTimeout;
    }
}

