/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.Version;
import com.streamscape.cli.ClientContext;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.tlp.FabricConnectionFactoryException;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.lib.CountUpDownLatch;
import com.streamscape.lib.concurrent.worker.SingleTaskWorker;
import com.streamscape.lib.utils.JVM;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.omf.json.utils.TextTokenizedJsonPrinter;
import com.streamscape.omf.json.utils.TokenizedJson;
import com.streamscape.omf.json.utils.TokenizedJsonPartPrinter;
import com.streamscape.omf.json.utils.TokenizedText;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cache.TFCacheException;
import com.streamscape.repository.types.Prototype;
import com.streamscape.runtime.mf.admin.glv.GlobalVariableFactoryException;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.operation.BroadcastSLResponse;
import com.streamscape.sdo.operation.HelpSLResponse;
import com.streamscape.sdo.operation.Operation;
import com.streamscape.sdo.operation.ParsingException;
import com.streamscape.sdo.operation.PromptSLResponse;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sdo.operation.SLMessageSequenceId;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sdo.rowset.Row;
import com.streamscape.sdo.rowset.RowMetaData;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sdo.rowset.RowSetPrinter;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.AbstractFabricConnectionFactory;
import com.streamscape.sef.dispatcher.AbstractSpecialSLSession;
import com.streamscape.sef.dispatcher.ClientExchange;
import com.streamscape.sef.dispatcher.DiagnosticSLSessionImpl;
import com.streamscape.sef.dispatcher.GenericSLSession;
import com.streamscape.sef.dispatcher.RemoteFabricConnection;
import com.streamscape.sef.dispatcher.SLSessionImpl;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.LinkProtocol;
import com.streamscape.sef.network.tlp.impl.InvalidConnectionTypeException;
import com.streamscape.sef.scheduler.SchedulerException;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.DSLProvider;
import com.streamscape.slex.UnsupportedRequestException;
import com.streamscape.slex.lang.DSLStatement;
import com.streamscape.slex.lang.DSLStatementSyntax;
import com.streamscape.slex.slang.SLMessageListener;
import com.streamscape.slex.slang.SLSessionException;
import com.streamscape.tools.console.Console;
import com.streamscape.tools.console.ConsoleConfiguration;
import com.streamscape.tools.console.NativeConsole;
import com.streamscape.tools.console.autocompletion.AutoCompletionConsole;
import com.streamscape.tools.console.terminal.Color;
import com.streamscape.tools.console.terminal.Keys;
import com.streamscape.tools.console.terminal.ReadInterruptedException;
import com.streamscape.tools.mnode.StartManagedNodeOperation;
import com.streamscape.tools.mnode.StopManagedNodeOperation;
import com.streamscape.tools.mnode.activator.ActivatorSLSessionImpl;
import com.streamscape.tools.parser.ParserPositionalException;
import com.streamscape.tools.slang.SLANGTool;
import com.streamscape.tools.slang.STPlotterRunner;
import com.streamscape.tools.slang.plot.PlotData;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import sun.misc.Signal;

public abstract class AbstractSLANGTool {
    protected ClientContext context;
    protected InternalFabricConnectionFactory connectionFactory = new InternalFabricConnectionFactory();
    protected InternalFabricConnection connection;
    protected boolean printOnConnecting = true;
    protected DSLProvider<SLANGTool> slangProvider;
    protected SLSessionImpl session;
    protected AbstractSpecialSLSession specialSession;
    protected InternalMFSession internalMFSession;
    protected Console console;
    protected String prompt = "slang> ";
    protected PromptSLResponse promptSLResponse;
    protected RowSetPrinter rowSetPrinter = new RowSetPrinter();
    protected NodeShutdownListenerImpl nodeShutdownListener = new NodeShutdownListenerImpl();
    protected long startTime;
    protected long endTime;
    protected volatile boolean isRunning;
    protected boolean isConnected;
    private final CommandInterrupter commandInterrupter = new CommandInterrupter();
    private InterruptReader interruptReader;
    protected static String url;
    protected static String userName;
    protected static String password;
    protected static String securityToken;
    protected static Long timeout;
    protected static SessionType sessionType;
    protected static boolean isReliable;
    protected static Boolean isSSL;
    protected static boolean noPrompt;
    protected static boolean noVersion;
    public static final long DEFAULT_REPLY_TIMEOUT = 30L;
    private static final String DEFAULT_PROMPT = "slang";
    private static final String PROMPT_SIGN = "> ";
    private static final String ROUTED_PROMPT_SIGN = ">> ";
    public static final String CONNECTION_TYPE = "Client_SLANG";
    public static final String CONNECTION_TYPE_ANONYMOUS = "Client_SLANG_Anonymous";
    private static final String COMMENT_CHARS = "//";
    private static final String OUTPUT_REDIRECT = ">>";
    private static final DSLStatementSyntax START_NODE_SYNTAX;
    private static final DSLStatementSyntax STOP_NODE_SYNTAX;
    public static SLMessageListener MESSAGE_LISTENER;
    private final Map<String, Long> receivedSlMessageIds = new HashMap<String, Long>();

    protected AbstractSLANGTool() {
        Runtime.getRuntime().addShutdownHook(new ShutdownHandler());
        Signal.handle(new Signal("INT"), name -> this.commandInterrupter.handleCtrlC());
    }

    protected abstract Console createConsole();

    public static void showVersion() {
        System.out.println("\n\tSLANG Tool: Release " + com.streamscape.tools.slang.Version.getMajorVersion() + "." + com.streamscape.tools.slang.Version.getMinorVersion() + " Build " + com.streamscape.tools.slang.Version.getBuild());
        System.out.println("\tCopyright (c) 2015-2025 StreamScape Technologies");
        System.out.println("\tAll rights reserved.\n");
        System.out.println("\tFabric Runtime " + Version.getVersion());
        System.out.println("\tLocal host: " + JVM.getPrimaryHostName(true) + " " + JVM.getOSVersion() + "\n");
        System.out.println("\t" + JVM.getJVMInfo());
        System.out.println("\t" + JVM.getJVMName());
        System.out.println("\t" + JVM.getJVMNVendorHome() + "\n");
    }

    protected void run() throws Exception {
        this.initDiscoveryProperties();
        if (!noVersion) {
            AbstractSLANGTool.showVersion();
        }
        this.context = ClientContext.getInstance();
        this.isRunning = true;
        this.internalMFSession = new InternalMFSession();
        if (this.console instanceof NativeConsole) {
            this.interruptReader = new InterruptReader();
            this.interruptReader.start();
        }
        if (url != null) {
            this.connect(url, securityToken != null ? new Pair<Object, String>(null, securityToken) : new Pair<String, String>(userName, password), timeout != null ? timeout : -1L, isReliable, isSSL, sessionType);
        }
        MESSAGE_LISTENER = new SLMessageListenerImpl();
        while (this.isRunning) {
            try {
                String command = this.readCommand();
                if (command == null) {
                    this.exit();
                }
                if (command.isEmpty() || command.trim().startsWith(COMMENT_CHARS) || this.processCommand(command)) continue;
                this.waitForInterrupt();
            }
            catch (ReadInterruptedException command) {
            }
            catch (NoSuchElementException exception) {
                this.isRunning = false;
            }
            catch (Throwable exception) {
                this.logException(exception);
                this.printError(AbstractSLANGTool.formatException(exception));
                this.onCommandFail();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForInterrupt() {
        try {
            this.commandInterrupter.waitingForInterrupt = true;
            while (this.isRunning && this.commandInterrupter.waitingForInterrupt) {
                Keys key = this.console.waitForCtrlKC(10L);
                if (key == Keys.CTRL_K) {
                    break;
                }
                if (key != Keys.CTRL_C) continue;
                this.commandInterrupter.handleCtrlC();
            }
        }
        finally {
            this.commandInterrupter.currentCommandLock.lock();
            try {
                this.commandInterrupter.waitingForInterrupt = false;
            }
            finally {
                this.commandInterrupter.currentCommandLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readCommand() throws ReadInterruptedException {
        try {
            this.commandInterrupter.readingCommand = true;
            String string = this.console.readCommand();
            return string;
        }
        finally {
            this.commandInterrupter.currentCommandLock.lock();
            try {
                this.commandInterrupter.readingCommand = false;
            }
            finally {
                this.commandInterrupter.currentCommandLock.unlock();
            }
        }
    }

    private void initDiscoveryProperties() {
        if (System.getProperty("streamscape.discovery.fabric.directory") == null) {
            System.setProperty("streamscape.discovery.fabric.directory", this.getDiscoveryFabricDirectory());
        }
        if (System.getProperty("streamscape.discovery.multicast.enabled") == null) {
            System.setProperty("streamscape.discovery.multicast.enabled", Boolean.toString(this.isDiscoveryMulticastEnabled()));
        }
        if (System.getProperty("streamscape.discovery.multicast.address") == null) {
            System.setProperty("streamscape.discovery.multicast.address", this.getDiscoveryMulticastAddress());
        }
        if (System.getProperty("streamscape.discovery.multicast.waiting.time") == null) {
            System.setProperty("streamscape.discovery.multicast.waiting.time", Long.toString(this.getDiscoveryMulticastWaitingTime()));
        }
    }

    protected void exit() {
        this.isRunning = false;
        this.disconnect();
        ConsoleConfiguration.instance().saveToFile();
        this.console.destroy();
        System.exit(0);
    }

    protected ConnectResult connect(String url, String userName, String password, long timeout, boolean reliable, Boolean ssl, SessionType sessionType) {
        return this.connect(url, new Pair<String, String>(userName, password), timeout, reliable, ssl, sessionType);
    }

    private ConnectResult connect(String url, Pair<String, String> credentials, long timeout, boolean reliable, Boolean ssl, SessionType sessionType) {
        AbstractSLANGTool.sessionType = sessionType;
        isSSL = ssl;
        this.disconnect();
        try {
            url = this.checkURL(url, ssl);
            if (credentials.first == null && credentials.second == null && this.isSecurityEnabled(sessionType, url, AbstractSLANGTool.getTimeout(timeout))) {
                this.readCredentials(credentials);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            this.printError(AbstractSLANGTool.formatException(exception));
            this.onCommandFail();
            return ConnectResult.NOK;
        }
        if (credentials.first == null && sessionType != SessionType.STANDARD) {
            this.printError("Security token cannot be used for " + StringUtils.toCapitalized(sessionType.name().toLowerCase()) + " session.");
            return ConnectResult.NOK;
        }
        ConnectResult result = sessionType != SessionType.STANDARD ? this.openSpecialSession(sessionType, url, credentials, timeout) : this.openConnection(url, credentials, timeout, reliable);
        boolean bl = this.isConnected = result == ConnectResult.OK;
        if (this.isConnected) {
            AbstractSLANGTool.url = url;
            if (this.connection != null) {
                try {
                    this.rowSetPrinter.timezone(this.connection.getNodeTimezone());
                }
                catch (FabricConnectionException exception) {
                    Trace.logException(this, exception, true);
                }
            }
        }
        return result;
    }

    private String checkURL(String url, Boolean ssl) throws Exception {
        if (ssl == null) {
            return url.contains("://") ? url : InternalFabricConnection.URL_PREFIX + url;
        }
        LinkProtocol protocol = AbstractSLANGTool.getProtocol(ssl);
        LinkProtocol urlProtocol = LinkAddress.extractProtocol(url);
        if (urlProtocol == null) {
            return protocol.getURLPrefix() + url;
        }
        if (protocol != urlProtocol) {
            throw new FabricException("Parameters mismatch (" + urlProtocol.getURLPrefix() + " in URL, but -ssl specified).");
        }
        return url;
    }

    private static LinkProtocol getProtocol(boolean ssl) {
        return ssl ? LinkProtocol.TLPS : LinkProtocol.TLP;
    }

    private void readCredentials(Pair<String, String> credentials) throws Exception {
        this.println("");
        credentials.first = this.console.readUser();
        if (!this.isAnonymous((String)credentials.first)) {
            credentials.second = this.console.readPassword();
        }
        this.println("");
    }

    private boolean isSecurityEnabled(SessionType sessionType, String url, long timeout) throws Exception {
        if (sessionType != SessionType.ACTIVATOR) {
            ClientExchange exchange = new ClientExchange();
            exchange.initCore();
            this.printOnConnecting(url);
            this.printOnConnecting = false;
            return (Boolean)exchange.raiseInstantInternalRequest(new LinkAddress(url), timeout, 31, null);
        }
        return true;
    }

    private boolean isAnonymous(String userName) {
        return userName != null && userName.equalsIgnoreCase("anonymous");
    }

    private ConnectResult openConnection(String url, Pair<String, String> credentials, long timeout, boolean reliable) {
        if (reliable) {
            if (this.connectionFactory.getReconnectAttempts() == 0) {
                int consoleReconnectAttempts = ConsoleConfiguration.instance().getReconnectAttempts();
                this.connectionFactory.setReconnectAttempts(consoleReconnectAttempts != 0 ? consoleReconnectAttempts : -1);
            }
        } else {
            this.connectionFactory.setReconnectAttempts(0);
        }
        try {
            this.connectionFactory.setURL(url);
            this.connection = this.connectionFactory.createConnection();
            if (credentials.first == null) {
                this.connection.setSecurityToken((String)credentials.second);
            } else {
                this.connection.setUserName((String)credentials.first);
                this.connection.setPassword((String)credentials.second);
            }
        }
        catch (Exception exception) {
            this.connection = null;
            Trace.logException(this, exception, true);
            if (exception instanceof FabricConnectionException && exception.getCause() != null) {
                this.printError(AbstractSLANGTool.formatException(exception.getCause()) + "\n");
            } else {
                this.printError(AbstractSLANGTool.formatException(exception));
            }
            this.onCommandFail();
            return ConnectResult.NOK;
        }
        try {
            try {
                this.connection.open(AbstractSLANGTool.getTimeout(timeout));
            }
            catch (Exception exception) {
                this.connection = null;
                throw exception;
            }
            try {
                this.createSession();
            }
            catch (Exception exception) {
                this.connection.close();
                this.connection = null;
                throw exception;
            }
            try {
                if (!this.connection.anonymous && this.session != null) {
                    this.session.setSLMessageListener(new SLMessageListenerImpl());
                }
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Session will not receive asynchronous messages.");
                this.printError(AbstractSLANGTool.formatException(exception));
                this.printError("Session will not receive asynchronous messages.\n");
            }
            this.completeOpening(this.getSession());
            return ConnectResult.OK;
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            if (exception.getCause() != null && exception.getCause() instanceof SecurityManagerException) {
                this.printError(exception.getCause().getMessage() + "\n");
                return ConnectResult.AUTH_FAILED;
            }
            this.printError("Connecting failed.\n       Cause: " + AbstractSLANGTool.formatException(this.checkInvalidConnectionType(exception, false)));
            this.onCommandFail();
            return ConnectResult.NOK;
        }
    }

    private Throwable checkInvalidConnectionType(Throwable exception, boolean special) {
        Throwable result = exception;
        while (exception != null) {
            if (exception instanceof InvalidConnectionTypeException) {
                return special ? new Exception("Incorrect attempt to establish connection to usual node using -a option.") : new Exception("Incorrect attempt to establish connection to Activator without using -a option.");
            }
            exception = exception.getCause();
        }
        return result;
    }

    private static long getTimeout(long timeout) {
        return timeout > 0L ? timeout : 10L;
    }

    private void createSession() throws Exception {
        if (!this.connection.anonymous) {
            this.session = (SLSessionImpl)this.connection.createSLSession();
            this.session.banner = this.connection.banner;
            this.session.setRoutedCloseListener(new RoutedSessionCloseListener());
            this.session.setReopenListener(new ReopenSessionListener());
        }
    }

    private ConnectResult openSpecialSession(SessionType sessionType, String url, Pair<String, String> credentials, long timeout) {
        try {
            this.specialSession = sessionType == SessionType.DIAGNOSTIC ? (AbstractSpecialSLSession)this.context.doCreateDiagnosticSession(url, (String)credentials.first, (String)credentials.second, timeout, true) : (AbstractSpecialSLSession)this.context.doCreateActivatorSession(url, (String)credentials.first, (String)credentials.second, timeout, true);
            this.specialSession.setSLMessageListener(new SLMessageListenerImpl());
            this.specialSession.setNodeShutdownListener(this.nodeShutdownListener);
            this.completeOpening(this.getSession());
            return ConnectResult.OK;
        }
        catch (SLSessionException exception) {
            Trace.logException(this, exception, true);
            if (exception.getCause() != null && exception.getCause() instanceof SecurityManagerException) {
                this.printError(exception.getCause().getMessage() + "\n");
                return ConnectResult.AUTH_FAILED;
            }
            this.printError(StringUtils.toCapitalized(sessionType.name().toLowerCase()) + " session establishing failed.\n       Cause: " + AbstractSLANGTool.formatException(this.checkInvalidConnectionType(exception, true)));
            return ConnectResult.NOK;
        }
    }

    private void completeOpening(GenericSLSession session) {
        if (this.console instanceof AutoCompletionConsole && session != null) {
            ((AutoCompletionConsole)this.console).addCompleter(session);
        }
        if (session != null) {
            this.setPrompt(session.getPrompt());
            if (!noPrompt) {
                this.println(session.getBanner());
            }
        } else {
            this.println("");
        }
    }

    protected void disconnect() {
        if (this.connection != null) {
            try {
                this.connection.close();
                this.println("\nConnection closed.\n");
            }
            catch (FabricConnectionException exception) {
                Trace.logException(this, exception, true);
                this.printError("Connection closing failed.       Cause: " + AbstractSLANGTool.formatException(exception));
            }
        } else if (this.specialSession != null) {
            this.specialSession.close();
            this.println("\n" + this.specialSession.getPrefix() + " session closed.\n");
        }
        this.doDisconnect();
        this.resetPrompt();
    }

    private void doDisconnect() {
        if (this.console instanceof AutoCompletionConsole) {
            ((AutoCompletionConsole)this.console).removeCompleter(this.getSession());
        }
        this.connection = null;
        this.session = null;
        this.specialSession = null;
        this.isConnected = false;
    }

    protected void reconnect(long timeout, boolean reliable, Boolean ssl, SessionType sessionType) {
        this.connect(url, null, null, timeout, reliable, ssl, sessionType);
    }

    protected boolean isAnonymous() {
        return this.connection != null && this.connection.anonymous;
    }

    protected boolean isSpecial() {
        return this.specialSession != null;
    }

    protected boolean isActivator() {
        return this.specialSession instanceof ActivatorSLSessionImpl;
    }

    protected boolean isDiagnostic() {
        return this.specialSession instanceof DiagnosticSLSessionImpl;
    }

    protected GenericSLSession getSession() {
        return this.specialSession != null ? this.specialSession : this.session;
    }

    protected String getUserName() {
        return this.specialSession != null ? this.specialSession.getUserName() : this.connection.component.getOwnerName();
    }

    protected void addURL(String url) throws Exception {
        if (!((String)url).contains("://")) {
            url = InternalFabricConnection.URL_PREFIX + (String)url;
        }
        this.connectionFactory.addURL((String)url);
        if (this.connection != null) {
            this.connection.addURL((String)url);
        }
    }

    protected void removeURL(String url) {
        this.connectionFactory.removeURL(url);
        if (this.connection != null) {
            this.connection.removeURL(url);
        }
    }

    protected void setReconnectAttempts(int reconnectAttempts) {
        ConsoleConfiguration.instance().setReconnectAttempts(reconnectAttempts);
        this.connectionFactory.setReconnectAttempts(reconnectAttempts);
        if (this.connection != null) {
            this.connection.setReconnectAttempts(reconnectAttempts);
        }
    }

    protected void setReconnectInterval(long reconnectInterval) throws Exception {
        ConsoleConfiguration.instance().setReconnectInterval(reconnectInterval);
        this.connectionFactory.setReconnectInterval(reconnectInterval);
        if (this.connection != null) {
            this.connection.setReconnectInterval(reconnectInterval);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processCommand(String command) throws Exception {
        this.startTime = System.currentTimeMillis();
        this.endTime = 0L;
        Map<String, Long> map = this.receivedSlMessageIds;
        synchronized (map) {
            this.receivedSlMessageIds.clear();
        }
        String redirectFileName = null;
        int index = command.indexOf(OUTPUT_REDIRECT);
        if (index > 0) {
            redirectFileName = command.substring(index + OUTPUT_REDIRECT.length() + 1).trim();
            command = command.substring(0, index);
        }
        PrintStream printStream = redirectFileName != null ? new PrintStream(redirectFileName) : this.console.getPrintStreamLess(ConsoleConfiguration.instance().getResponseColor());
        try {
            boolean result;
            SLResponse response = this.processCommandInMultiplyProviders(command);
            this.endTime = System.currentTimeMillis();
            this.waitForSLMessagesForResponse(response);
            if (response.isOK()) {
                if (this.isPrintCommand(command)) {
                    RowSet rowSet = response.getRowSet();
                    if (rowSet != null && rowSet.next() && rowSet.getMeta() != null && rowSet.getMeta().findColumn("Message") != -1) {
                        printStream.println(rowSet.getString("Message"));
                    }
                    boolean bl = true;
                    return bl;
                }
                if (command.toLowerCase().trim().startsWith("describe session")) {
                    response.getRowSet().addToRowSet(new Object[]{"Reply Timeout", this.getReplyTimeout() > 0L ? this.getReplyTimeout() / 1000L + " seconds" : "n/a"});
                }
            }
            if (result = this.processResponse(response, printStream)) {
                this.showStatsTime();
            }
            boolean bl = result;
            return bl;
        }
        finally {
            if (redirectFileName != null) {
                printStream.flush();
                printStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForSLMessagesForResponse(SLResponse response) {
        SLMessageSequenceId lastMessageSequenceId = response.getLastMessageSequenceId();
        if (lastMessageSequenceId == null || lastMessageSequenceId.getMessageSequenceId() <= 0L) {
            return;
        }
        long lastSentId = lastMessageSequenceId.getMessageSequenceId();
        Map<String, Long> map = this.receivedSlMessageIds;
        synchronized (map) {
            Long lastReceivedSlMessageId = this.receivedSlMessageIds.get(lastMessageSequenceId.getCallUniqueId());
            if (lastReceivedSlMessageId != null && lastReceivedSlMessageId == lastSentId) {
                return;
            }
            try {
                this.receivedSlMessageIds.wait(1000L);
            }
            catch (InterruptedException exception) {
                Thread.currentThread().interrupt();
                return;
            }
            lastReceivedSlMessageId = this.receivedSlMessageIds.get(lastMessageSequenceId.getCallUniqueId());
            if (lastReceivedSlMessageId != null && lastReceivedSlMessageId < lastSentId) {
                Trace.logError(this, "SL message not yet received for operation. Sent ID: {}, Received ID: {}", lastSentId, lastReceivedSlMessageId);
            }
        }
    }

    private boolean isPrintCommand(String command) {
        if (!(command = command.trim().toLowerCase()).startsWith("print")) {
            return false;
        }
        return (command = command.substring("print".length()).trim()).startsWith("(") && command.endsWith(")");
    }

    private SLResponse processCommandInMultiplyProviders(String command) throws SLSessionException {
        SLResponse response;
        ParsingException slangProviderException;
        block11: {
            slangProviderException = null;
            try {
                DSLStatement statement = this.slangProvider.parseDsl(command, this.internalMFSession);
                if (statement == null || this.isConnected && statement.getDefinition().toLowerCase().startsWith("describe frm")) break block11;
                SLResponse response2 = this.slangProvider.invoke(statement, this.internalMFSession);
                if (response2.getException() instanceof ParsingException) {
                    slangProviderException = (ParsingException)response2.getException();
                    break block11;
                }
                return response2;
            }
            catch (ParsingException exception) {
                if (exception.getOperation() != null) {
                    if (!this.isDuplicateOperation(exception.getOperation())) {
                        return new SLResponse(exception);
                    }
                }
                slangProviderException = exception;
            }
        }
        try {
            if (this.isConnected && this.session != null || this.specialSession != null) {
                response = this.invokeSessionRequest(command);
                if (slangProviderException != null && response.getException() instanceof UnsupportedRequestException) {
                    throw slangProviderException;
                }
            } else {
                if (slangProviderException != null) {
                    throw slangProviderException;
                }
                response = new SLResponse(new UnsupportedRequestException());
            }
        }
        catch (ParsingException exception) {
            response = new SLResponse(exception);
        }
        return response;
    }

    protected abstract boolean isDuplicateOperation(Operation var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SLResponse invokeSessionRequest(String request) throws SLSessionException {
        GenericSLSession session = this.getSession();
        if (session == null) {
            return new SLResponse();
        }
        try {
            this.commandInterrupter.currentCommandSession = session;
            this.commandInterrupter.currentCommand = request;
            this.commandInterrupter.currentCommandStartTime = System.currentTimeMillis();
            if (this.interruptReader != null) {
                this.interruptReader.startReader();
            }
            SLResponse sLResponse = session.slangRequest(request, this.getReplyOrSessionTimeout());
            return sLResponse;
        }
        finally {
            if (this.interruptReader != null) {
                this.interruptReader.stopReader();
            }
            this.commandInterrupter.currentCommandLock.lock();
            try {
                this.commandInterrupter.currentCommandSession = null;
                this.commandInterrupter.currentCommand = null;
                this.commandInterrupter.currentCommandStartTime = 0L;
            }
            finally {
                this.commandInterrupter.currentCommandLock.unlock();
            }
        }
    }

    protected SLResponse invokeSessionRequest(DSLStatement request) throws SLSessionException {
        return this.invokeSessionRequest(request.toString());
    }

    protected SLResponse invokeSessionRequest(SLStatement request) throws SLSessionException {
        return this.getSession() == null ? new SLResponse() : this.getSession().slangRequest(request, this.getReplyOrSessionTimeout());
    }

    protected long getReplyOrSessionTimeout() {
        if (this.getSessionTimeout() != 0L) {
            return this.getSessionTimeout();
        }
        return this.getReplyTimeout();
    }

    protected long getReplyTimeout(String request) {
        long timeout = this.getTimeoutFromCommand(START_NODE_SYNTAX, request);
        if (timeout != -2L) {
            return timeout;
        }
        timeout = this.getTimeoutFromCommand(STOP_NODE_SYNTAX, request);
        if (timeout != -2L) {
            return timeout;
        }
        return this.getReplyTimeout();
    }

    protected long getTimeoutFromCommand(DSLStatementSyntax syntax, String request) {
        try {
            DSLStatement statement = syntax.parse(request);
            if (statement.existsParameter("Timeout")) {
                return Long.parseLong(statement.getParameter("Timeout").getValue()) * 1000L + 10000L;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -2L;
    }

    protected boolean processResponse(SLResponse response, PrintStream printStream) {
        if (response instanceof IgnoredResponse) {
            return true;
        }
        if (response instanceof InterruptedResponse) {
            this.console.getPrintStream().println();
            return true;
        }
        if (response instanceof HelpSLResponse && ((HelpSLResponse)response).getDescription() != null) {
            return this.doProcessHelpResponse((HelpSLResponse)response, printStream);
        }
        if (response instanceof BroadcastSLResponse && ((BroadcastSLResponse)response).getValues() != null) {
            return this.doProcessBroadcastResponse((BroadcastSLResponse)response, printStream);
        }
        if (response.getObject() instanceof PlotData) {
            return this.doProcessPlotResponse(response, printStream);
        }
        if (response.getObject() instanceof TokenizedJson) {
            return this.doProcessTokenizedJsonResponse(response, printStream);
        }
        if (response.getObject() instanceof TokenizedText) {
            return this.doProcessTokenizedTextResponse(response, printStream);
        }
        return this.doProcessResponse(response, printStream);
    }

    protected boolean doProcessPlotResponse(SLResponse response, PrintStream printStream) {
        PlotData plotData = (PlotData)response.getObject();
        STPlotterRunner runner = new STPlotterRunner();
        try {
            runner.start();
            runner.write(plotData);
            String line = null;
            while ((line = runner.getStreamReader().readLine(120000L)) != null) {
                printStream.println(line);
            }
        }
        catch (Throwable exception) {
            exception.printStackTrace(this.console.getErrorPrintStream());
            runner.stop();
        }
        return true;
    }

    protected boolean doProcessTokenizedJsonResponse(SLResponse response, final PrintStream printStream) {
        TokenizedJson tokenizedJson = (TokenizedJson)response.getObject();
        if (printStream.getClass() == PrintStream.class) {
            tokenizedJson.print(TextTokenizedJsonPrinter.of(new TokenizedJsonPartPrinter(){

                @Override
                public void onPrintDelimiters(String s) {
                }

                @Override
                public void onPrintKey(String key, boolean excluded) {
                    if (!excluded) {
                        printStream.print(key + " ");
                    }
                }

                @Override
                public void onPrintValue(String value, String compoundValue, boolean excluded) {
                    if (!(excluded || value == null && compoundValue == null)) {
                        printStream.print((compoundValue != null ? compoundValue : value) + " ");
                    }
                }

                @Override
                public void onPrintValueTokens(List<String> tokens, TokenizedJson.TokenizedJsonKey key) {
                }
            }));
            printStream.flush();
            return true;
        }
        final TokenizedJson.DisplayType displayType = tokenizedJson.getDisplayType();
        if (displayType == TokenizedJson.DisplayType.PATHS_TABLE) {
            RowSet rowSet = new RowSet(new RowMetaData().addColumn("Path", String.class).addColumn("Document", String.class));
            tokenizedJson.visitLeafs((path, value) -> {
                try {
                    rowSet.addToRowSet(new Object[]{"/" + path, value});
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            });
            printStream.println();
            RowSetPrinter printer = new RowSetPrinter();
            printer.setPrintStream(printStream);
            printer.setColumnPrintStream("Path", this.console.getPrintStreamLess(new Color(6)));
            printer.print(rowSet);
            printStream.println();
        } else {
            tokenizedJson.print(TextTokenizedJsonPrinter.of(new TokenizedJsonPartPrinter(){

                @Override
                public void onPrintDelimiters(String s) {
                    PrintStream stream = AbstractSLANGTool.this.console.getPrintStreamLess(new Color(6));
                    stream.print(s);
                    stream.flush();
                }

                @Override
                public void onPrintKey(String key, boolean excluded) {
                    int color = 6;
                    if (displayType == TokenizedJson.DisplayType.JSON_WITH_STRIKETHROUGH && excluded) {
                        color = 2052;
                    }
                    PrintStream stream = AbstractSLANGTool.this.console.getPrintStreamLess(new Color(color));
                    stream.print(key);
                    stream.flush();
                }

                @Override
                public void onPrintValue(String value, String compoundValue, boolean excluded) {
                    int color = 9;
                    if (displayType == TokenizedJson.DisplayType.JSON_WITH_STRIKETHROUGH) {
                        if (excluded) {
                            color = 2052;
                        } else if (compoundValue != null) {
                            color = 15;
                        }
                        if (compoundValue != null) {
                            value = compoundValue;
                        }
                    }
                    PrintStream stream = AbstractSLANGTool.this.console.getPrintStreamLess(new Color(color));
                    stream.print(value);
                    stream.flush();
                }

                @Override
                public void onPrintValueTokens(List<String> tokens, TokenizedJson.TokenizedJsonKey key) {
                    if (displayType == TokenizedJson.DisplayType.JSON_WITH_TOKENS_AND_PATH) {
                        PrintStream redStream = AbstractSLANGTool.this.console.getPrintStreamLess(new Color(12));
                        redStream.print("  -->  ");
                        redStream.flush();
                        PrintStream whiteStream = AbstractSLANGTool.this.console.getPrintStreamLess(new Color(15));
                        whiteStream.print("[ " + String.join((CharSequence)", ", tokens) + " ]");
                        whiteStream.flush();
                        PrintStream yellowStream = AbstractSLANGTool.this.console.getPrintStreamLess(new Color(6));
                        yellowStream.print("  (/" + key.getPath() + ")");
                        yellowStream.flush();
                    }
                }
            }));
        }
        return true;
    }

    protected boolean doProcessTokenizedTextResponse(SLResponse response, PrintStream printStream) {
        TokenizedText tokenizedText = (TokenizedText)response.getObject();
        if (printStream.getClass() == PrintStream.class) {
            printStream.print(tokenizedText.getMergedTokens().stream().filter(t -> t.getRuleType() != TokenizedText.RuleType.STOPWORD_EXCLUDED && t.getRuleType() != TokenizedText.RuleType.POS_EXCLUDED).map(TokenizedText.Token::getFinalToken).collect(Collectors.joining(" ")));
            printStream.flush();
            return true;
        }
        printStream.println();
        printStream.flush();
        List<TokenizedText.Token> tokens = tokenizedText.getMergedTokens();
        int lastPosition = 0;
        for (TokenizedText.Token token : tokens) {
            if (lastPosition < token.getStart()) {
                PrintStream stream = this.console.getPrintStreamLess(new Color(2056));
                stream.print(tokenizedText.getText().substring(lastPosition, token.getStart()));
                stream.flush();
            }
            PrintStream stream = this.console.getPrintStreamLess(switch (token.getRuleType()) {
                case TokenizedText.RuleType.TOKEN -> new Color(2);
                case TokenizedText.RuleType.LEMMATIZED -> new Color(6);
                case TokenizedText.RuleType.SYNONYM_REPLACED -> new Color(6);
                case TokenizedText.RuleType.STOPWORD_EXCLUDED -> new Color(2052);
                case TokenizedText.RuleType.POS_EXCLUDED -> new Color(2049);
                default -> throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)token.getRuleType()));
            });
            stream.print(token.getFinalToken());
            stream.flush();
            lastPosition = token.getEnd() + 1;
        }
        if (lastPosition < tokenizedText.getText().length()) {
            PrintStream stream = this.console.getPrintStreamLess(new Color(2056));
            stream.print(tokenizedText.getText().substring(lastPosition));
            stream.flush();
        }
        printStream.println();
        printStream.println();
        printStream.flush();
        return true;
    }

    protected boolean doProcessResponse(SLResponse response, PrintStream printStream) {
        if (response.getMessages() != null && !response.getMessages().isEmpty()) {
            printStream.println();
            response.getMessages().forEach(printStream::println);
        }
        if (response.isOK()) {
            if (response instanceof PseudoSLResponse) {
                return false;
            }
            if (response.getText() == null && response.getRowSet() == null) {
                if (response.getObject() != null) {
                    printStream.println("\n" + String.valueOf(response.getObject()) + "\n");
                } else {
                    printStream.println("\nOK\n");
                }
            } else {
                if (response.getText() != null) {
                    if (response instanceof PromptSLResponse) {
                        this.setPrompt((PromptSLResponse)response);
                    } else {
                        printStream.println("\n" + response.getText() + "\n");
                    }
                }
                if (response.getRowSet() != null) {
                    RowSet rowSet = response.getRowSet();
                    try {
                        if (rowSet.getRowCount() == 1 && rowSet.getRowMetaData().getColumnCount() == 1 && rowSet.next()) {
                            if (rowSet.getObject(1) instanceof RowSet) {
                                rowSet = (RowSet)rowSet.getObject(1);
                            } else if (rowSet.getObject(1) instanceof Row) {
                                Row row = (Row)rowSet.getObject(1);
                                rowSet = new RowSet(row.getMetaData());
                                rowSet.addToRowSet(row);
                                rowSet.beforeFirst();
                            }
                        } else {
                            rowSet.beforeFirst();
                        }
                    }
                    catch (SQLException exception) {
                        this.logException(exception);
                    }
                    printStream.println();
                    this.rowSetPrinter.setPrintStream(printStream);
                    this.rowSetPrinter.print(rowSet);
                    printStream.println();
                    response.getRowSet().close();
                }
            }
        } else if (response instanceof HelpSLResponse) {
            printStream.println("\n" + response.getText() + "\n");
        } else if (response.getException() != null) {
            this.logException(response.getException());
            ParsingException parsingException = Utils.getCauseAssignable(response.getException(), ParsingException.class);
            if (parsingException != null) {
                this.printSyntaxError(AbstractSLANGTool.formatSLResponseExceptionMessage(response));
            } else {
                this.printError(AbstractSLANGTool.formatSLResponseExceptionMessage(response));
            }
            if (response instanceof PromptSLResponse) {
                this.setPrompt((PromptSLResponse)response);
            }
            this.onCommandFail();
        } else {
            this.printError(response.getText() + "\n");
            this.onCommandFail();
        }
        return true;
    }

    protected boolean doProcessBroadcastResponse(BroadcastSLResponse response, PrintStream printStream) {
        String prefix = response.getPrefix() != null ? response.getPrefix() + " " : "";
        response.getValues().forEach(pair -> {
            printStream.print("\n" + prefix + (String)pair.first + "... ");
            if (pair.second instanceof String) {
                printStream.println(pair.second);
            } else if (pair.second instanceof Throwable) {
                String indent = AbstractSLANGTool.getIndent(((String)pair.first).length() + 2);
                this.printBroadcastError(AbstractSLANGTool.formatBroadcastExceptionMessage(indent, (Throwable)pair.second));
            }
        });
        printStream.println();
        return true;
    }

    protected boolean doProcessHelpResponse(HelpSLResponse response, PrintStream printStream) {
        printStream.println("\n");
        this.console.printWithTags(printStream, response.getDescription());
        this.console.printWithTags(printStream, response.getOtherInfo());
        printStream.println("\n");
        return true;
    }

    private static String getIndent(int length) {
        char[] tmp = new char[length];
        Arrays.fill(tmp, ' ');
        return new String(tmp);
    }

    private void printOnConnecting(String url) {
        this.println("\nConnecting to '" + url + "'...");
    }

    private boolean consoleInterrupt() {
        this.commandInterrupter.currentCommandLock.lock();
        try {
            this.commandInterrupter.waitingForInterrupt = false;
        }
        finally {
            this.commandInterrupter.currentCommandLock.unlock();
        }
        return this.console.interrupt();
    }

    synchronized void processForcedDisconnect(boolean isReconnecting) {
        if (this.isConnected) {
            this.printError("\n", "Connection to " + (sessionType == SessionType.ACTIVATOR ? "Activator" : "Fabric node") + " was forcibly closed.\n");
            if (!isReconnecting) {
                this.doDisconnect();
            }
            this.resetPrompt();
        }
    }

    synchronized void processRoutedSessionClosing() {
        if (this.isConnected) {
            this.printError("\n", "Routed session was forcibly closed.\n");
            this.resetPrompt();
            new SessionRollbackWorker().start();
        }
    }

    protected abstract long getReplyTimeout();

    protected abstract void setReplyTimeout(long var1);

    protected abstract long getSessionTimeout();

    protected abstract boolean isBasicPrompt();

    protected abstract void setBasicPrompt(boolean var1);

    protected abstract String getDiscoveryFabricDirectory();

    protected abstract void setDiscoveryFabricDirectory(String var1);

    protected abstract boolean isDiscoveryMulticastEnabled();

    protected abstract void setDiscoveryMulticastEnabled(boolean var1);

    protected abstract String getDiscoveryMulticastAddress();

    protected abstract void setDiscoveryMulticastAddress(String var1);

    protected abstract long getDiscoveryMulticastWaitingTime();

    protected abstract void setDiscoveryMulticastWaitingTime(long var1);

    protected void fillSessionInfo(RowSet result) throws Exception {
        if (this.isConnected) {
            if (this.isSpecial()) {
                result.addToRowSet(new Object[]{"Node Name", this.specialSession.getNodeName()});
                result.addToRowSet(new Object[]{this.isActivator() ? "Activator" : "Diagnostic", true});
                result.addToRowSet(new Object[]{"Access Point", this.specialSession.getURL()});
            } else if (!this.connection.anonymous) {
                FabricNodeReference node = this.connection.getModerator().lookupFabricNode(this.session.getNodeName());
                result.addToRowSet(new Object[]{"Routed", this.session.isRouted()});
                result.addToRowSet(new Object[]{"Anonymous", false});
                result.addToRowSet(new Object[]{"Reliable", this.connection.getReconnectAttempts() != 0});
                if (this.session.hasActivatorSession()) {
                    result.addToRowSet(new Object[]{"Activator", true});
                } else {
                    result.addToRowSet(new Object[]{"Diagnostic", false});
                }
                result.addToRowSet(new Object[]{"Access Point", this.connection.getURL()});
            } else {
                result.addToRowSet(new Object[]{"Node Name", this.connection.nodeName});
                result.addToRowSet(new Object[]{"Anonymous", true});
                result.addToRowSet(new Object[]{"Diagnostic", false});
                result.addToRowSet(new Object[]{"Activator", false});
                result.addToRowSet(new Object[]{"Access Point", this.connection.getURL()});
            }
        }
        if (!this.isActivator() && !this.isDiagnostic()) {
            result.addToRowSet(new Object[]{"Available Access Points", this.connectionFactory.getURLs()});
            result.addToRowSet(new Object[]{"Reconnect Attempts", this.getReconnectAttempts()});
            result.addToRowSet(new Object[]{"Reconnect Interval", this.isConnected ? this.connection.getReconnectInterval() : this.connectionFactory.getReconnectInterval()});
        }
    }

    int getReconnectAttempts() {
        if (this.isConnected) {
            return this.connection.getReconnectAttempts();
        }
        if (this.connection != null && this.connection.isReconnecting()) {
            return this.connectionFactory.getReconnectAttempts();
        }
        return ConsoleConfiguration.instance().getReconnectAttempts();
    }

    protected void setPrompt(PromptSLResponse response) {
        if (response != null) {
            this.promptSLResponse = response;
            this.setPrompt(response.getPrompt(this.isBasicPrompt()));
        }
    }

    protected void setPrompt(String prompt) {
        this.doSetPrompt(prompt, this.session != null && this.session.isOpened() && this.session.isRouted());
    }

    protected void doSetPrompt(String prompt, boolean isRouted) {
        Object object = !prompt.isEmpty() ? prompt + (String)(this.isDiagnostic() ? "[" + this.specialSession.getPrefix() + "]" : "") + (isRouted ? ROUTED_PROMPT_SIGN : PROMPT_SIGN) : (this.prompt = "");
        if (this.console != null) {
            this.console.setPrompt(this.getPrompt());
        }
    }

    protected void resetPrompt() {
        this.setPrompt(DEFAULT_PROMPT);
    }

    protected void showStatsTime() {
        if (this.endTime == 0L) {
            this.endTime = System.currentTimeMillis();
        }
        if (ConsoleConfiguration.instance().isStatsTimeOn()) {
            this.println("Time: " + (this.endTime - this.startTime) + " (ms).\n");
        }
    }

    protected abstract String getPrompt();

    protected abstract void showPrompt();

    protected void print(String line) {
        this.console.getPrintStream().print(line);
    }

    protected void println(String line) {
        this.console.getPrintStream().println(line);
    }

    protected void printWarning(String message) {
        this.console.getWarningPrintStream().println(message);
    }

    protected void printError(String error) {
        this.printError("", error);
    }

    protected void printError(String prefix, String error) {
        if (error != null && error.startsWith("Syntax Error: ")) {
            this.console.getErrorPrintStream().println(prefix + "\n" + error.trim() + "\n");
        } else {
            this.console.getErrorPrintStream().println(prefix + "\n" + (error.trim().startsWith("ERROR: ") ? "" : "ERROR: ") + error.trim() + "\n");
        }
    }

    protected void printSyntaxError(String error) {
        this.console.printWithTags(this.console.getErrorPrintStream(), "\n" + (error.trim().startsWith("ERROR: ") ? "" : "ERROR: ") + error.trim() + "\n");
        this.console.getErrorPrintStream().println();
    }

    protected void printBroadcastError(String error) {
        this.console.getErrorPrintStream().println((error.trim().startsWith("ERROR: ") ? "" : "ERROR: ") + error.trim() + "\n");
    }

    protected abstract void logException(Throwable var1);

    protected abstract void onCommandFail();

    protected static String formatSLResponseExceptionMessage(SLResponse response) {
        return AbstractSLANGTool.formatSLResponseExceptionMessage(response, response.getException());
    }

    protected static String formatSLResponseExceptionMessage(SLResponse response, Throwable exception) {
        Object message = "No exception in response.";
        if (exception != null && (message = AbstractSLANGTool.doFormatExceptionMessage("", exception)) == null) {
            message = (String)(!(response instanceof PromptSLResponse) && response.getText() != null ? response.getText() + "\n       Cause: " : "") + AbstractSLANGTool.formatException(exception);
        }
        return message;
    }

    protected static String formatBroadcastExceptionMessage(String indent, Throwable exception) {
        String message = AbstractSLANGTool.doFormatExceptionMessage(indent, exception);
        if (message == null) {
            message = AbstractSLANGTool.formatException(indent, exception);
        }
        return message;
    }

    private static String doFormatExceptionMessage(String indent, Throwable exception) {
        Throwable cause = exception.getCause();
        if (cause instanceof UnsupportedRequestException || cause instanceof ParsingException) {
            return cause.getMessage();
        }
        if (exception instanceof UnsupportedRequestException || exception instanceof ParsingException) {
            return exception.getMessage();
        }
        if ((exception instanceof FabricRequestException || exception instanceof GlobalVariableFactoryException) && cause != null) {
            return AbstractSLANGTool.formatException(cause);
        }
        if (exception instanceof RepositoryException && cause instanceof TFCacheException) {
            return AbstractSLANGTool.formatException(cause);
        }
        if (exception instanceof DataspaceException && cause instanceof SchedulerException) {
            return AbstractSLANGTool.formatException(cause);
        }
        if (Utils.getCauseAssignable(exception, ParserPositionalException.class) != null) {
            Object message = "";
            ParserPositionalException positional = Utils.getCauseAssignable(exception, ParserPositionalException.class);
            message = (String)message + positional.getErrorMessage();
            if (positional.getLineNumber() > 0) {
                message = (String)message + "\n\n";
                message = (String)message + positional.getLineAndPositionMessage();
            }
            if (!(positional instanceof DataspaceException) && ((Throwable)((Object)positional)).getCause() != null && ((Throwable)((Object)positional)).getCause() != positional) {
                message = (String)message + " Cause: ";
                message = (String)message + AbstractSLANGTool.formatException(((Throwable)((Object)positional)).getCause());
            }
            if (exception instanceof SchedulerException) {
                message = AbstractSLANGTool.formatException(new Exception(exception.getMessage() + "\n\n" + (String)message));
            }
            return message;
        }
        return null;
    }

    protected static String formatException(Throwable exception) {
        return AbstractSLANGTool.formatException("", exception);
    }

    protected static String formatException(String indent, Throwable exception) {
        String message = Utils.formatExceptionWithUnrepeatedCauses(exception, "\n" + indent + "       ");
        if (message.trim().endsWith("Cause: " + new UnsupportedRequestException().getMessage())) {
            message = new UnsupportedRequestException().getMessage();
        }
        return message.trim();
    }

    protected void showInterruptMessageForSyncCommand() {
        this.println("");
        this.println("");
        this.println("Use Ctrl+K to interrupt command execution.\nUse Ctrl+C to terminate the SLANG application. All client operations will terminate on application exit.");
        this.println("");
    }

    protected void showInterruptMessageForASyncCommand() {
        this.println("");
        this.println("");
        this.println("Use Ctrl+K to send the current, blocking operation to background.\nUse Ctrl+C to terminate the SLANG application. All client operations will terminate on application exit.");
        this.println("");
    }

    protected Pair<Prototype, ImmutableEventDatagram> getPrototype(String eventId) throws DatagramFactoryException {
        return this.context.getClientDatagramPrototypeFactory().getPrototype(eventId);
    }

    public abstract void setConsoleCCSID(Charset var1) throws UnsupportedEncodingException;

    static {
        sessionType = SessionType.STANDARD;
        isReliable = false;
        isSSL = null;
        noPrompt = false;
        noVersion = false;
        START_NODE_SYNTAX = new StartManagedNodeOperation().getDSLSyntax();
        STOP_NODE_SYNTAX = new StopManagedNodeOperation().getDSLSyntax();
    }

    class InternalFabricConnectionFactory
    extends AbstractFabricConnectionFactory {
        InternalFabricConnectionFactory() {
            this.setType(AbstractSLANGTool.CONNECTION_TYPE);
            try {
                this.setReconnectAttempts(ConsoleConfiguration.instance().getReconnectAttempts());
                this.setReconnectInterval(ConsoleConfiguration.instance().getReconnectInterval());
            }
            catch (FabricConnectionFactoryException exception) {
                AbstractSLANGTool.this.logException(exception);
            }
        }

        @Override
        public InternalFabricConnection createConnection() throws FabricConnectionFactoryException {
            return (InternalFabricConnection)super.createConnection();
        }

        @Override
        protected InternalFabricConnection createConnectionInstance() {
            return new InternalFabricConnection(AbstractSLANGTool.CONNECTION_TYPE);
        }
    }

    class NodeShutdownListenerImpl
    implements NodeShutdownListener {
        NodeShutdownListenerImpl() {
        }

        @Override
        public void onNodeShutdown(boolean isReconnecting) {
            AbstractSLANGTool.this.processForcedDisconnect(isReconnecting);
            if (!AbstractSLANGTool.this.consoleInterrupt()) {
                AbstractSLANGTool.this.showPrompt();
            }
        }
    }

    class CommandInterrupter {
        private volatile boolean readingCommand = false;
        private volatile GenericSLSession currentCommandSession;
        private volatile boolean waitingForInterrupt = false;
        private volatile String currentCommand;
        private volatile long currentCommandStartTime;
        private final ReentrantLock currentCommandLock = new ReentrantLock();

        CommandInterrupter() {
        }

        protected void handleCtrlC() {
            if (this.waitingForInterrupt) {
                this.currentCommandLock.lock();
                try {
                    if (this.waitingForInterrupt) {
                        AbstractSLANGTool.this.showInterruptMessageForASyncCommand();
                    }
                }
                finally {
                    this.currentCommandLock.unlock();
                }
            }
            if (this.readingCommand) {
                this.currentCommandLock.lock();
                try {
                    if (this.readingCommand) {
                        AbstractSLANGTool.this.exit();
                        return;
                    }
                }
                finally {
                    this.currentCommandLock.unlock();
                }
            }
            if (this.currentCommandSession != null) {
                this.currentCommandLock.lock();
                try {
                    if (this.currentCommandSession != null) {
                        AbstractSLANGTool.this.showInterruptMessageForSyncCommand();
                    }
                }
                finally {
                    this.currentCommandLock.unlock();
                }
            }
        }

        public void interruptCommand() {
            if (this.currentCommandSession != null) {
                this.currentCommandLock.lock();
                try {
                    if (this.currentCommandSession != null) {
                        this.currentCommandSession.interruptCommand(this.currentCommand);
                    }
                }
                catch (Throwable exception) {
                    AbstractSLANGTool.this.printError(AbstractSLANGTool.formatException(exception));
                }
                finally {
                    this.currentCommandLock.unlock();
                }
            }
        }
    }

    class ShutdownHandler
    extends Thread {
        public ShutdownHandler() {
            super("FSYS:Shutdown.Handler:SLANGTool");
        }

        @Override
        public void run() {
            AbstractSLANGTool.this.isRunning = false;
            AbstractSLANGTool.this.disconnect();
            Utils.sleep(500L);
        }
    }

    private static class InternalMFSession
    extends AbstractMFSession {
        InternalMFSession() {
            super("Internal", "SLANGTool", null, false, null, null);
        }

        @Override
        public boolean isFromSlangTool() {
            return true;
        }
    }

    class InterruptReader
    extends SingleTaskWorker {
        private CountUpDownLatch stoppedLatch;
        private CountUpDownLatch readingLatch;
        private boolean isReading;
        private final Exchanger<Integer> startExchanger;

        protected InterruptReader() {
            super("FSYS:InterruptReader:SLANGTool", "Reads for interrupt user command in background.");
            this.isReading = false;
            this.startExchanger = new Exchanger();
            this.readingLatch = new CountUpDownLatch();
            this.readingLatch.setCount(1);
            this.stoppedLatch = new CountUpDownLatch();
            this.stoppedLatch.setCount(0);
        }

        @Override
        protected void doExecute() throws FabricException, InterruptedException {
            while (AbstractSLANGTool.this.isRunning) {
                try {
                    this.startExchanger.exchange(1, 100L, TimeUnit.MILLISECONDS);
                    this.stoppedLatch.setCount(1);
                    this.isReading = true;
                    this.readingLatch.countDown();
                    try {
                        while (this.isReading && AbstractSLANGTool.this.isRunning) {
                            Keys key = AbstractSLANGTool.this.console.waitForCtrlKC(10L);
                            if (key == Keys.CTRL_K) {
                                AbstractSLANGTool.this.commandInterrupter.interruptCommand();
                                continue;
                            }
                            if (key != Keys.CTRL_C) continue;
                            AbstractSLANGTool.this.commandInterrupter.handleCtrlC();
                        }
                    }
                    finally {
                        this.isReading = false;
                        this.readingLatch.setCount(1);
                        this.stoppedLatch.countDown();
                    }
                }
                catch (TimeoutException timeoutException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startReader() {
            InterruptReader interruptReader = this;
            synchronized (interruptReader) {
                if (!this.isReading) {
                    try {
                        while (!this.isReading && AbstractSLANGTool.this.isRunning) {
                            try {
                                this.startExchanger.exchange(0, 100L, TimeUnit.MILLISECONDS);
                                break;
                            }
                            catch (TimeoutException timeoutException) {
                            }
                        }
                        while (!this.isReading && AbstractSLANGTool.this.isRunning && !this.readingLatch.await(100L)) {
                        }
                    }
                    catch (InterruptedException exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopReader() {
            InterruptReader interruptReader = this;
            synchronized (interruptReader) {
                if (this.isReading) {
                    this.isReading = false;
                    AbstractSLANGTool.this.console.interrupt();
                    try {
                        while (AbstractSLANGTool.this.isRunning && !this.stoppedLatch.await(100L)) {
                        }
                    }
                    catch (InterruptedException exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    public static enum SessionType {
        STANDARD,
        DIAGNOSTIC,
        ACTIVATOR;

    }

    public static enum ConnectResult {
        OK,
        NOK,
        AUTH_FAILED;

    }

    class SLMessageListenerImpl
    implements SLMessageListener {
        SLMessageListenerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void onMessage(SLMessage message) {
            String text;
            SLMessageSequenceId messageSequenceId = message.getMessageSequenceId();
            if (messageSequenceId != null) {
                Map<String, Long> map = AbstractSLANGTool.this.receivedSlMessageIds;
                synchronized (map) {
                    AbstractSLANGTool.this.receivedSlMessageIds.put(messageSequenceId.getCallUniqueId(), messageSequenceId.getMessageSequenceId());
                    AbstractSLANGTool.this.receivedSlMessageIds.notify();
                }
            }
            if ((text = message.getText()) != null) {
                if (!text.isEmpty()) {
                    if (message.getType() == SLMessage.Type.INFO) {
                        AbstractSLANGTool.this.print(text);
                    } else if (message.getType() == SLMessage.Type.WARNING) {
                        AbstractSLANGTool.this.printWarning(text);
                    } else {
                        AbstractSLANGTool.this.printError(text);
                    }
                }
            } else if (message.getException() != null) {
                AbstractSLANGTool.this.logException(message.getException());
                AbstractSLANGTool.this.printError(AbstractSLANGTool.formatException(message.getException()));
            } else {
                AbstractSLANGTool.this.println("");
                AbstractSLANGTool.this.showStatsTime();
                if (!AbstractSLANGTool.this.consoleInterrupt()) {
                    AbstractSLANGTool.this.showPrompt();
                }
            }
        }
    }

    protected class InternalFabricConnection
    extends RemoteFabricConnection {
        public String banner;
        public String nodeName;
        public boolean anonymous;

        InternalFabricConnection(String type) {
            super(type, ClientContext.getInstance());
        }

        @Override
        public void setUserName(String userName) throws FabricConnectionException {
            super.setUserName(userName);
            if (userName != null && userName.equalsIgnoreCase("anonymous")) {
                this.anonymous = true;
            }
        }

        @Override
        public void open(long timeout) throws FabricConnectionException, SecurityManagerException {
            if (this.anonymous) {
                this.openAnonymous(timeout);
            } else {
                super.open(timeout);
            }
        }

        @Override
        public void close() throws FabricConnectionException {
            if (this.anonymous) {
                this.closeAnonymous();
            } else {
                super.close();
            }
        }

        @Override
        synchronized void forcedClose(boolean shutdown) {
            if (this.anonymous) {
                this.component.type = AbstractSLANGTool.CONNECTION_TYPE;
                this.exchange.stop();
                Trace.logInfo(this, "Fabric connection '" + this.component.getFullName() + "' forcibly closed.");
            } else {
                super.forcedClose(shutdown);
            }
            AbstractSLANGTool.this.nodeShutdownListener.onNodeShutdown(this.isReconnecting());
            if (this.isReconnecting()) {
                AbstractSLANGTool.this.println("Reconnecting will start in " + this.getReconnectInterval() + " seconds.\n");
                AbstractSLANGTool.this.isConnected = false;
            }
        }

        synchronized void openAnonymous(long timeout) throws FabricConnectionException, SecurityManagerException {
            this.setConnectionTimeout(timeout);
            if (!this.isOpened) {
                this.component.type = AbstractSLANGTool.CONNECTION_TYPE_ANONYMOUS;
                this.nodeName = this.doOpen(true);
                AbstractSLANGTool.this.setPrompt(new PromptSLResponse("anonymous", this.nodeName));
                this.isOpened = true;
            }
        }

        @Override
        AbstractExchange.ClientConnectReplyData connect(LinkAddress address, long timeout, boolean anonymous, boolean reconnect) throws Exception {
            AbstractExchange.ClientConnectReplyData replyData = this.exchange.connect(address, timeout, anonymous, true, reconnect);
            this.banner = replyData.banner;
            return replyData;
        }

        synchronized void closeAnonymous() throws FabricConnectionException {
            if (this.isOpened) {
                this.component.type = AbstractSLANGTool.CONNECTION_TYPE;
                this.stopExchange(true);
                this.isOpened = false;
            }
        }

        @Override
        void onConnecting(String url) {
            if (AbstractSLANGTool.this.printOnConnecting) {
                AbstractSLANGTool.this.printOnConnecting(url);
            }
            AbstractSLANGTool.this.printOnConnecting = true;
        }

        @Override
        void onConnectingFailure(Exception exception, String url) {
            super.onConnectingFailure(exception, url);
            AbstractSLANGTool.this.printError("\n", "Connecting failed.\n       Cause: " + AbstractSLANGTool.formatException(exception));
        }

        @Override
        void onReconnectingStart(int iAttempt) {
            super.onReconnectingStart(iAttempt);
            AbstractSLANGTool.this.println("\nReconnecting (attempt #" + iAttempt + ")...");
        }

        @Override
        void onReconnectingStop(boolean printLog) {
            super.onReconnectingStop(printLog);
            if (printLog) {
                AbstractSLANGTool.this.println("\nReconnecting stopped.");
            }
        }

        @Override
        void onReconnectingSuccess() {
            super.onReconnectingSuccess();
            AbstractSLANGTool.this.isConnected = true;
        }

        @Override
        void onReconnectingFailure(Exception exception) {
            super.onReconnectingFailure(exception);
            AbstractSLANGTool.this.printError("\n", "Reconnecting failed.\n       Cause: " + AbstractSLANGTool.formatException(exception));
        }
    }

    class RoutedSessionCloseListener
    implements SLSessionImpl.RoutedCloseListener {
        RoutedSessionCloseListener() {
        }

        @Override
        public void onClose() {
            AbstractSLANGTool.this.processRoutedSessionClosing();
        }
    }

    class ReopenSessionListener
    implements SLSessionImpl.ReopenListener {
        ReopenSessionListener() {
        }

        @Override
        public void onReopen(PromptSLResponse prompt, SLSessionImpl.ReopenSessionType type) {
            if (type == SLSessionImpl.ReopenSessionType.STANDARD) {
                AbstractSLANGTool.this.println(AbstractSLANGTool.this.session.getBanner());
            } else if (type == SLSessionImpl.ReopenSessionType.RESTORING_PARENT) {
                AbstractSLANGTool.this.println("\n\nCurrent context destroyed. Restoring parent context...\n");
            } else if (type == SLSessionImpl.ReopenSessionType.RESTORING_ACTIVATOR) {
                AbstractSLANGTool.this.println("\n\nRestoring Activator context...\n");
            }
            AbstractSLANGTool.this.setPrompt(prompt);
            AbstractSLANGTool.this.showPrompt();
        }
    }

    static interface NodeShutdownListener {
        public void onNodeShutdown(boolean var1);
    }

    public static class IgnoredResponse
    extends SLResponse {
    }

    public static class InterruptedResponse
    extends SLResponse {
    }

    class SessionRollbackWorker
    extends SingleTaskWorker {
        protected SessionRollbackWorker() {
            super("FSYS:SLANG:SessionRollback", "Performs a rollback of the opened SLANG session.");
        }

        @Override
        protected void doExecute() throws FabricException {
            Utils.sleep(500L);
            if (AbstractSLANGTool.this.session != null && AbstractSLANGTool.this.connection != null && AbstractSLANGTool.this.connection.isOpened()) {
                try {
                    AbstractSLANGTool.this.session.rollback();
                    AbstractSLANGTool.this.setPrompt(AbstractSLANGTool.this.session.getPrompt());
                    if (!AbstractSLANGTool.this.consoleInterrupt()) {
                        AbstractSLANGTool.this.showPrompt();
                    }
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                    AbstractSLANGTool.this.printError("Session rollback failed.");
                    AbstractSLANGTool.this.disconnect();
                }
            }
        }
    }
}

