/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.NameManager;
import com.streamscape.ds.mf.SLSessionDataDataspaceSessionWrapper;
import com.streamscape.ds.session.Session;
import com.streamscape.ds.trigger.event.SysFunctionUnit;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.security.ComponentOwner;
import com.streamscape.sef.security.User;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.SLSessionData;

public abstract class AbstractRuntimeServiceMFSession
extends AbstractMFSession {
    private transient Session dataspaceSDSSession;

    protected AbstractRuntimeServiceMFSession(String name, String componentName, ComponentOwner owner, boolean isRouted, boolean isInstant, RuntimeContext context, String slSessionName, String resourceName, String dataspaceName) {
        super(name, componentName, owner, isRouted, slSessionName, resourceName);
        if (!isInstant) {
            try {
                String[] dataspaceNames = NameManager.splitDataspaceName(dataspaceName);
                AbstractDataspace dataspace = (AbstractDataspace)context.getDataspaceManager().lookup(dataspaceNames[dataspaceNames.length - 1]);
                if (dataspace == null) {
                    throw new Exception("Access to Dataspace component '" + dataspaceName + "' failed.");
                }
                if (!(owner instanceof User)) {
                    throw new Exception("Group cannot be owner of Runtime/Service session.");
                }
                this.dataspaceSDSSession = dataspace.createSession((User)owner);
                this.dataspaceSDSSession.setComponentName(componentName);
                this.dataspaceSDSSession.setSDSRuntimeSession(true);
                this.dataspaceSDSSession.setSLResourceName(resourceName);
                this.dataspaceSDSSession.setSLSessionName(slSessionName);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Creation of internal " + dataspaceName + " Dataspace session failed.");
            }
        }
    }

    public Session getDataspaceSDSSession() {
        Session session;
        if (this.slSessionName != null && (session = SysFunctionUnit.AbstractGetQueryEntry.getDataspaceSessionForSysQuery(this.slSessionName)) != null) {
            return session;
        }
        return this.dataspaceSDSSession;
    }

    public void close() {
        if (this.dataspaceSDSSession != null) {
            this.dataspaceSDSSession.close();
        }
    }

    @Override
    public void setSLSessionData(SLSessionData slSessionData) {
        if (this.dataspaceSDSSession != null) {
            this.dataspaceSDSSession.setFetchSize(slSessionData.getFetchSize());
            this.dataspaceSDSSession.setTransferBufferSize(slSessionData.getTransferBufferSize());
            this.dataspaceSDSSession.setSLFileSessionContext(slSessionData.getSLFileSessionContext());
            super.setSLSessionData(new SLSessionDataDataspaceSessionWrapper(slSessionData, this.dataspaceSDSSession));
        } else {
            super.setSLSessionData(slSessionData);
        }
    }
}

