/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.ds.DataspaceLogger;
import com.streamscape.lib.loader.ClassLoaderRegistry;
import com.streamscape.lib.loader.LoadedPackagesProvider;
import com.streamscape.lib.utils.Pair;
import com.streamscape.lib.utils.UtilitiesException;
import com.streamscape.omf.serializer.SerializerUtils;
import com.streamscape.repository.RepositoryContext;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cache.MFContext;
import com.streamscape.repository.cache.TFCache;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.cli.RepositoryAccessorException;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.globals.GlobalVariableCollection;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.ContextId;
import com.streamscape.runtime.PeerState;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeContextException;
import com.streamscape.runtime.RuntimeMFSession;
import com.streamscape.runtime.deploy.CtxDeploymentDescriptor;
import com.streamscape.runtime.listeners.RuntimeAdvisoryListener;
import com.streamscape.runtime.mf.admin.glv.GlobalVariableFactoryException;
import com.streamscape.runtime.mf.admin.obj.SemanticObjectReferenceStore;
import com.streamscape.runtime.stats.StatsMonitor;
import com.streamscape.sdo.AbstractDatagramFactoryManager;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.advisory.RuntimeAdvisory;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.coherence.CoherenceAgent;
import com.streamscape.sef.container.Container;
import com.streamscape.sef.container.FabricContainer;
import com.streamscape.sef.dataspace.DataspaceManager;
import com.streamscape.sef.dataspace.Store;
import com.streamscape.sef.discovery.DiscoveryModuleConfiguration;
import com.streamscape.sef.dispatcher.AbstractCoherenceAgent;
import com.streamscape.sef.dispatcher.AbstractContainerFactory;
import com.streamscape.sef.dispatcher.AbstractDataspaceManager;
import com.streamscape.sef.dispatcher.AbstractFabricContext;
import com.streamscape.sef.dispatcher.AbstractLogEventSender;
import com.streamscape.sef.dispatcher.AbstractSchedulerImpl;
import com.streamscape.sef.dispatcher.AbstractSessionManager;
import com.streamscape.sef.dispatcher.ComponentReferenceImpl;
import com.streamscape.sef.dispatcher.DynamicComponentsManager;
import com.streamscape.sef.dispatcher.EventFlowImpl;
import com.streamscape.sef.dispatcher.FabricEventDispatcherImpl;
import com.streamscape.sef.dispatcher.GlobalVariableFactoryImpl;
import com.streamscape.sef.dispatcher.LocalFabricConnection;
import com.streamscape.sef.dispatcher.RepositoryArtifactChangeListenerImpl;
import com.streamscape.sef.dispatcher.RepositoryStateChangeListenerImpl;
import com.streamscape.sef.dispatcher.RuntimeAuthenticationModuleFactory;
import com.streamscape.sef.dispatcher.RuntimeDatagramPrototypeFactory;
import com.streamscape.sef.dispatcher.RuntimeDiscoveryModuleFactory;
import com.streamscape.sef.dispatcher.RuntimeExchange;
import com.streamscape.sef.dispatcher.RuntimeExchangeFactory;
import com.streamscape.sef.dispatcher.RuntimeRepositoryAccessorImpl;
import com.streamscape.sef.dispatcher.RuntimeSecurityManagerProxy;
import com.streamscape.sef.dispatcher.RuntimeSemanticTypeFactory;
import com.streamscape.sef.dispatcher.SSSecurityKeyStoreCache;
import com.streamscape.sef.dispatcher.SSSecurityKeyStoreDataspace;
import com.streamscape.sef.dispatcher.SecurityManagerImpl;
import com.streamscape.sef.dispatcher.ServiceManagerImpl;
import com.streamscape.sef.dispatcher.SysGlobals;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricExchange;
import com.streamscape.sef.group.FabricGroupManager;
import com.streamscape.sef.keys.SSSecurityKeyStore;
import com.streamscape.sef.mf.admin.ExchangeObjectFactory;
import com.streamscape.sef.mf.admin.module.ModuleException;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.http.acceptor.HTTPAcceptor;
import com.streamscape.sef.network.http.server.authentication.runtime.HTTPAuthenticationManagerCoreImpl;
import com.streamscape.sef.network.tlp.acceptor.TLPAcceptorFactory;
import com.streamscape.sef.pkg.PackageManifestManager;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.SchedulerFactory;
import com.streamscape.sef.scheduler.SchedulerImpl;
import com.streamscape.sef.scheduler.SchedulerState;
import com.streamscape.sef.security.AuthenticationType;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.slex.MFSession;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;

public abstract class AbstractRuntimeContext
extends AbstractFabricContext
implements SLCallable {
    protected static boolean initMode = false;
    protected static boolean maintainMode = false;
    protected static boolean noTlpMode = false;
    protected static boolean noJoinMode = false;
    protected static Logger defaultServiceLogger = null;
    protected static DataspaceLogger defaultDataspaceLogger = null;
    protected int initLevel = 0;
    protected Map<String, Object> initProperties = new ConcurrentHashMap<String, Object>();
    protected HashMap<String, Object> environment = new HashMap();
    protected String ctxDescriptorFilename;
    protected CtxDeploymentDescriptor ctxDescriptor;
    protected boolean isRepositoryBound = false;
    protected RepositoryContext repositoryContext;
    protected long repositoryToken;
    protected RuntimeRepositoryAccessorImpl repositoryAccessor;
    protected LoadedPackagesProviderImpl loadedPackagesProvider = new LoadedPackagesProviderImpl();
    protected SecurityManagerImpl securityManagerImpl;
    protected DataspaceManager dsManager;
    protected HTTPAuthenticationManagerCoreImpl httpAuthenticationManagerCore;
    protected AbstractContainerFactory containerFactory;
    protected Container container;
    protected RuntimeExchangeFactory exchangeFactory;
    protected RuntimeExchange exchange;
    protected long shutdownTimeout = 10L;
    protected AbstractCoherenceAgent coherenceAgent;
    protected ServiceManagerImpl serviceManager;
    protected AbstractSessionManager sessionManager;
    protected GlobalVariableFactoryImpl globalVariableFactory;
    protected RepositoryArtifactChangeListenerImpl ascListener = new RepositoryArtifactChangeListenerImpl();
    protected RepositoryStateChangeListenerImpl rscListener = new RepositoryStateChangeListenerImpl();
    protected StatsMonitor statsMonitor;
    protected SchedulerFactory schedulerFactory;
    protected AbstractSchedulerImpl schedulerImpl;
    protected Scheduler scheduler;
    protected LocalFabricConnection systemConnection;
    protected DynamicComponentsManager dynamicComponentsManager = new DynamicComponentsManager();
    protected static boolean adminMode = false;
    protected static String adminURL = "9999";
    protected HTTPAcceptor adminAcceptor;
    protected SSSecurityKeyStore ssSecurityKeyStore;

    protected AbstractRuntimeContext() {
    }

    @Override
    public String getFullName() {
        return ModeratorUtils.makeComponentFullName(this.name, this.type, this.name);
    }

    @Override
    public UUID getFabricUID() {
        return this.exchange != null ? this.exchange.fabricUid : null;
    }

    protected FabricContainer getContainer() {
        return this.container;
    }

    protected void saveContainer() {
        AbstractRuntimeContext.saveObject(this.containerFactory, this.container);
    }

    protected FabricExchange getExchange() {
        return this.exchange;
    }

    protected void saveExchange() {
        AbstractRuntimeContext.saveObject(this.exchangeFactory, this.exchange);
    }

    public Moderator getModerator() {
        return this.exchange.getModerator();
    }

    protected List<LinkAddress> getTLPAcceptors() {
        return this.exchange.getTLPAcceptors();
    }

    protected PeerState getPeerState() {
        return this.exchange.getPeerState();
    }

    protected String getUserName() {
        return (String)this.environment.get("streamscape.naming.security.principal");
    }

    protected String getPassword() {
        return SecurityManagerImpl.normalizePassword((String)this.environment.get("streamscape.naming.security.credentials"));
    }

    protected void setInitProperty(String name, Object value) {
        this.initProperties.put(name, value);
    }

    protected void clearInitProperties() {
        this.initProperties.clear();
    }

    protected void initSemanticTypeFactory() {
        this.semanticTypeFactory = new RuntimeSemanticTypeFactory();
    }

    @Override
    protected void initSystemSemanticTypes() {
        try {
            this.logInfo("Initializing System Semantic Types...");
            super.initSystemSemanticTypes();
            this.replaceSemanticTypes();
            this.logInfo("System Semantic Types initialized.");
        }
        catch (Throwable exception) {
            this.processInitException(exception, "System Semantic Types", -1012);
        }
    }

    protected void replaceSemanticTypes() throws Exception {
    }

    protected void replaceSemanticTypes(List<Pair<String, Class>> types) throws Exception {
        SerializerUtils serializerUtils = new SerializerUtils();
        for (Pair<String, Class> type : types) {
            serializerUtils.replaceSemanticType(this.omfManager.aliasManager, (String)type.first, (Class)type.second);
        }
    }

    protected void initPackageManifest() throws Exception {
        SemanticObjectReferenceStore.beginXact();
        if (SemanticObjectReferenceStore.lookupReferenceContext("/sys/package/manifest") == null) {
            SemanticObjectReferenceStore.createSubcontextFromNamespace("/sys/package/manifest");
        }
        SemanticObjectReferenceStore.commitXact();
        this.manifestManager.load();
    }

    protected void destroyPackageManifestManager() {
        try {
            if (this.manifestManager != null) {
                this.manifestManager.destroy();
                this.manifestManager = null;
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying Runtime Manifest Manager failed.");
        }
    }

    protected void initCustomSemanticTypes() throws Exception {
        this.logInfo("Initializing Custom Semantic Types...");
        this.getTFCache().addSemanticTypes();
        this.logInfo("Custom Semantic Types initialized.");
    }

    @Override
    protected void initSecurityManager() throws Exception {
        if (this.isSecurityEnabled.booleanValue()) {
            this.logInfo("Initializing Security Manager...");
            if (this.repositoryContext != null) {
                this.repositoryContext.beginXact(this, 0L);
                this.repositoryContext.sudo(this.repositoryToken);
                this.repositoryContext.commitXact();
            }
            this.doInitSecurityManager();
            if (this.repositoryContext != null) {
                this.repositoryContext.beginXact(this, 0L);
                this.repositoryContext.unsudo(this.repositoryToken);
                this.repositoryContext.setSecurityManager(this.securityManager);
                this.repositoryContext.commitXact();
            }
            this.logInfo("Security Manager initialized.");
        } else {
            this.logInfo("Security disabled.");
        }
    }

    protected void doInitSecurityManager() throws Exception {
        this.securityManagerImpl = new SecurityManagerImpl((RuntimeContext)this);
        String authenticationModule = (String)this.environment.get("streamscape.repository.authentication.module");
        if (authenticationModule == null || authenticationModule.length() == 0) {
            throw new FabricException("AUTHENTICATION_MODULE is undefined.");
        }
        this.authenticationModuleFactory = new RuntimeAuthenticationModuleFactory(this.securityManagerImpl);
        this.authenticationModuleFactory.init();
        this.authenticationModuleFactory.activateModule(authenticationModule);
        this.securityManagerImpl.init();
        this.securityManager = new RuntimeSecurityManagerProxy(this.securityManagerImpl, AuthenticationType.PASSWORD_PLAIN_TEXT, this.getUserName(), this.getPassword(), null, null, this);
    }

    @Override
    protected SecurityManager doGetSecurityManager() throws SecurityManagerException {
        return super.doGetSecurityManager();
    }

    protected void destroySecurityManager() {
        try {
            if (this.isSecurityEnabled != null && this.isSecurityEnabled.booleanValue() && this.authenticationModuleFactory != null) {
                this.authenticationModuleFactory.destroy();
                this.authenticationModuleFactory = null;
                this.securityManagerImpl = null;
                this.securityManager = null;
                this.logInfo("Security Manager destroyed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying Security Manager failed.");
        }
    }

    protected void completeSecurityManagerInitialization() throws Exception {
        if (this.isSecurityEnabled()) {
            this.securityManagerImpl.completeInitialization();
        }
    }

    @Override
    protected boolean isSecurityEnabled() {
        return this.isSecurityEnabled;
    }

    protected void initDatagramFactories() throws Exception {
        this.logInfo("Initializing Datagram Factories...");
        this.datagramPrototypeFactory = new RuntimeDatagramPrototypeFactory(this);
        this.datagramFactoryManager = this.createDatagramFactoryManager();
        this.addSystemAdvisoryPrototypes();
        this.addSystemEventPrototypes();
        this.addSystemExceptionPrototypes();
        this.addPredefinedEventPrototypes();
        this.logInfo("Datagram Factories initialized.");
    }

    @Override
    protected void addXMPPEventPrototype(String eventId) throws Exception {
        ((RuntimeDatagramPrototypeFactory)this.datagramPrototypeFactory).removePrototypeSpecial(this.getEventDatagramFactory(), eventId);
        super.addXMPPEventPrototype(eventId);
    }

    @Override
    protected void addApiKeyApplicationUpdateEventPrototype() throws Exception {
        ((RuntimeDatagramPrototypeFactory)this.datagramPrototypeFactory).removePrototypeSpecial(this.getEventDatagramFactory(), "event.SDS.API_KEY_APPLICATIONS.afterUpdate");
        super.addApiKeyApplicationUpdateEventPrototype();
    }

    @Override
    void removeOldEventPrototypes() throws Exception {
        this.removeOldEventPrototype("event.audit.default");
        this.removeOldEventPrototype("event.process.audit");
        this.removeOldEventPrototype("event.sql.audit");
        this.removeOldEventPrototype("event.user.audit");
        this.removeOldEventPrototype("event.audit.sql");
        this.removeOldEventPrototype("event.dropbox.notification");
        this.removeOldEventPrototype("event.file.StateChange");
        this.removeOldEventPrototype("event.http.Request");
        this.removeOldEventPrototype("event.LogMonitor.Configuration");
    }

    private void removeOldEventPrototype(String eventId) throws Exception {
        if (this.getRuntimeDatagramPrototypeFactory().existsPrototype(eventId)) {
            this.getRuntimeDatagramPrototypeFactory().removeOldEventPrototype(this.getEventDatagramFactory(), eventId);
        }
    }

    protected abstract AbstractDatagramFactoryManager createDatagramFactoryManager() throws Exception;

    protected RuntimeDatagramPrototypeFactory getRuntimeDatagramPrototypeFactory() {
        return (RuntimeDatagramPrototypeFactory)this.datagramPrototypeFactory;
    }

    protected void initDiscoveryModule() throws Exception {
        this.logInfo("Initializing Discovery Module...");
        String discoveryModuleName = (String)this.environment.get("streamscape.repository.discovery.protocol");
        if (discoveryModuleName == null || discoveryModuleName.length() == 0) {
            throw new RuntimeContextException("DISCOVERY_PROTOCOL is undefined.");
        }
        this.discoveryModuleFactory = new RuntimeDiscoveryModuleFactory();
        this.discoveryModuleFactory.init();
        this.setDiscoveryModuleParameters(discoveryModuleName);
        if (!maintainMode) {
            this.discoveryModuleFactory.activateModule(discoveryModuleName);
        }
        this.logInfo("Discovery Module initialized.");
    }

    @Override
    DiscoveryModuleConfiguration setDiscoveryModuleParameters(String moduleName) throws ModuleException {
        DiscoveryModuleConfiguration configuration = super.setDiscoveryModuleParameters(moduleName);
        this.setParameter(configuration, "streamscape.discovery.multicast.use.acceptors", "multicastAddress");
        return configuration;
    }

    protected void initExchange() throws Exception {
        this.logInfo("Initializing Fabric Exchange...");
        this.exchangeFactory = new RuntimeExchangeFactory();
        this.exchange = (RuntimeExchange)this.exchangeFactory.create();
        this.exchange.init(this.getName(), this.discoveryModule, this.getTLPAcceptorFactory());
        this.repositoryAccessor.setNode(this.exchange.getModerator().getFabricNode());
        this.contextId = new ContextId(this.exchange.getNodeAddress());
        this.reference = new ComponentReferenceImpl(ModeratorUtils.makeComponentFullName(this.name, this), this, false);
        this.bind(this.exchange, this.reference);
        this.logInfo("Fabric Exchange initialized.");
    }

    protected abstract TLPAcceptorFactory getTLPAcceptorFactory();

    protected void initRepositoryAccessor() {
        this.repositoryAccessor = new RuntimeRepositoryAccessorImpl(null, this.getUserName(), null, (RuntimeContext)this);
    }

    protected void startExchange() {
        this.exchange.start();
    }

    protected void destroyExchange() {
        try {
            if (this.exchange != null) {
                if (this.exchange.isInitialized) {
                    this.exchange.stop();
                    this.exchange.destroy();
                }
                this.exchange = null;
                this.exchangeFactory.destroy();
                this.logInfo("Fabric Exchange destroyed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying Fabric Exchange failed.");
        }
    }

    protected void detachFromSysplex() {
        if (this.exchange != null && this.exchange.isInitialized) {
            this.exchange.detach(this.shutdownTimeout);
        }
    }

    protected void initCoherenceAgent() throws Exception {
        if (((Boolean)this.environment.get("streamscape.coherence.auto.bind")).booleanValue()) {
            this.logInfo("Initializing Coherence Agent...");
            this.coherenceAgent = new CoherenceAgent();
            this.logInfo("Coherence Agent initialized.");
        }
    }

    protected void destroyCoherenceAgent() {
        try {
            if (this.coherenceAgent != null) {
                this.coherenceAgent.destroy();
                this.coherenceAgent = null;
                this.logInfo("Coherence Agent destroyed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying Coherence Agent failed.");
        }
    }

    protected boolean isCoherenceAgentBound() {
        return this.coherenceAgent != null;
    }

    protected void initSessionManager() {
        this.logInfo("Initializing Runtime Session Manager...");
        this.sessionManager = this.createSessionManager();
        this.sessionManager.init();
        this.logInfo("Runtime Session Manager initialized.");
    }

    protected void destroySessionManager() {
        try {
            if (this.sessionManager != null) {
                this.sessionManager.destroy();
                this.sessionManager = null;
                this.logInfo("Session Manager destroyed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying Session Manager failed.");
        }
    }

    protected abstract AbstractSessionManager createSessionManager();

    protected void initStartTime() {
        this.exchange.node.initStartTime();
    }

    protected void joinSysplex() throws Exception {
        this.exchange.joinSysplex(true, noJoinMode);
    }

    protected void bindToExchange(FabricComponent component) throws RuntimeContextException {
        this.logDebug("Fabric Exchange bind...");
        try {
            if (this.exchange != null) {
                this.exchange.bind(component);
            }
        }
        catch (Exception exception) {
            throw new RuntimeContextException("Fabric Exchange bind failed.", exception);
        }
    }

    protected void unbindFromExchange(FabricComponent component) {
        this.logDebug("Fabric Exchange unbind...");
        if (this.exchange != null) {
            this.exchange.unbind(component);
        }
    }

    protected void initStatsMonitor() throws Exception {
        this.logInfo("Initializing Stats Monitor...");
        this.statsMonitor = new StatsMonitor((RuntimeContext)this);
        this.statsMonitor.start();
        this.logInfo("Stats Monitor initialized.");
    }

    protected void destroyStatsMonitor() {
        try {
            if (this.statsMonitor != null) {
                this.statsMonitor.stop();
                this.statsMonitor = null;
                this.logInfo("Stats Monitor destroyed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying Stats Monitor failed.");
        }
    }

    protected void initSecurityKeyStore() {
        this.logInfo("Initializing Security Key Store...");
        this.ssSecurityKeyStore = new SSSecurityKeyStoreDataspace((RuntimeContext)this);
        ((SSSecurityKeyStoreDataspace)this.ssSecurityKeyStore).init();
        this.ssSecurityKeyStore = new SSSecurityKeyStoreCache(this.ssSecurityKeyStore);
        this.logInfo("Security Key Store initialized.");
    }

    protected void destroySecurityKeyStore() {
        try {
            if (this.ssSecurityKeyStore != null) {
                this.ssSecurityKeyStore.destroy();
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying Security Key Store failed.");
        }
    }

    protected void initRuntimeEventDispatcher() throws Exception {
        this.logInfo("Initializing Runtime Event Dispatcher...");
        this.dispatcher = new FabricEventDispatcherImpl(this, this.getDatagramPrototypeCache());
        this.dispatcher.setExchange(this.exchange);
        this.ascListener.setDispatcher(this.dispatcher);
        this.rscListener.setDispatcher(this.dispatcher);
        this.addSourceEventFlow("advisory.Runtime", EventFlowEntity.RUNTIME_ADVISORY, null, this.getEventScope(), true);
        this.logInfo("Runtime Event Dispatcher initialized.");
    }

    @Override
    void addEventFlow(EventFlowImpl flow) {
        if (flow != null) {
            this.exchange.eventFlowMap.addEventFlow(flow);
        }
    }

    @Override
    void removeEventFlow(EventFlowImpl flow) {
        if (flow != null) {
            this.exchange.eventFlowMap.removeEventFlow(flow);
        }
    }

    protected void destroyRuntimeEventDispatcher() {
        try {
            if (this.dispatcher != null) {
                this.dispatcher.destroy(0L);
                this.dispatcher = null;
                this.ascListener.destroy();
                this.rscListener.destroy();
                this.logInfo("Runtime Event Dispatcher destroyed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying Runtime Event Dispatcher failed.");
        }
    }

    protected void addAdvisoryListener(RuntimeAdvisoryListener listener) throws RuntimeContextException {
        if (listener == null) {
            throw new RuntimeContextException("Null listener specified.");
        }
        if (listener.getListenerName() == null) {
            throw new RuntimeContextException("Listener name is null.");
        }
        if (listener.getListenerName().length() == 0) {
            throw new RuntimeContextException("Listener name is empty.");
        }
        if (this.dispatcher != null) {
            try {
                this.dispatcher.createEventAsyncConsumer(listener.getListenerName(), new RuntimeAdvisoryListenerWrapper(listener), "advisory.Runtime", null, this.getEventScope(), false).start();
            }
            catch (FabricEventDispatcherException exception) {
                throw new RuntimeContextException("Adding Runtime Advisory listener failed.", exception);
            }
        }
    }

    protected void removeAdvisoryListener(String listenerName) throws RuntimeContextException {
        if (listenerName == null) {
            throw new RuntimeContextException("Null listener name specified.");
        }
        if (this.dispatcher != null) {
            try {
                this.dispatcher.dropConsumer(listenerName);
            }
            catch (FabricEventDispatcherException exception) {
                throw new RuntimeContextException(exception);
            }
        }
    }

    protected List<String> listAdvisoryListeners() {
        return this.dispatcher.listEventAsyncConsumers();
    }

    protected void raiseRuntimeAdvisory(RuntimeAdvisory event, EventScope eventScope) throws RuntimeException {
        if (this.dispatcher != null) {
            try {
                this.dispatcher.raiseSystemAdvisory(event, eventScope);
            }
            catch (Throwable exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    protected void initLogEventSender() {
        AbstractLogEventSender.init();
    }

    protected void destroyLogEventSender() {
        try {
            AbstractLogEventSender.destroy();
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying Log Event Sender failed.");
        }
    }

    protected boolean isDataspaceBound() {
        return this.dsManager != null;
    }

    protected void openDataspaceManager() {
        this.logInfo("Opening Dataspace Manager...");
        this.dsManager.open();
        this.logInfo("Dataspace Manager opened.");
    }

    protected Store getDataspaceStore() {
        return ((AbstractDataspaceManager)this.dsManager).getStore();
    }

    protected void initServiceManager() throws Exception {
        this.serviceManager = new ServiceManagerImpl((RuntimeContext)this, defaultServiceLogger);
        this.serviceManager.init();
        if (!maintainMode) {
            this.serviceManager.start();
        }
    }

    protected void destroyServiceManager() {
        try {
            if (this.serviceManager != null) {
                this.serviceManager.stop();
                this.serviceManager.destroy();
                this.serviceManager = null;
                this.logInfo("Service Manager destroyed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying Service Manager failed.");
        }
    }

    protected void initGlobalVariableFactory() throws Exception {
        this.globalVariableFactory = new GlobalVariableFactoryImpl(this.repositoryContext);
    }

    protected void mergeGlobalVariables(GlobalVariableCollection variables) throws GlobalVariableFactoryException {
        this.globalVariableFactory.mergeSysGlobals((SysGlobals)variables);
    }

    protected RepositoryContext getRepositoryContext() throws RuntimeException {
        if (!this.isRepositoryBound) {
            throw new RuntimeException("Repository Context not bound in the Runtime.");
        }
        return this.repositoryContext;
    }

    protected TFCache getTFCache() {
        return ((MFContext)this.repositoryContext).getTFCache();
    }

    protected RepositoryAccessor getRepositoryAccessor() throws RuntimeException {
        if (!this.isRepositoryBound) {
            throw new RuntimeException("Repository not bound in the Runtime.");
        }
        return this.repositoryAccessor;
    }

    @Override
    public ClassLoaderRegistry getClassLoaderRegistry() {
        return this.manifestManager.getClassLoaderRegistry();
    }

    protected void addExtensionArchive(String jarName, byte[] jarContent) throws RepositoryAccessorException, RepositoryException {
        this.getRepositoryAccessor().addExtensionArchive(jarName, jarContent);
    }

    protected List<FabricComponent> getBoundComponents() {
        return new ArrayList<FabricComponent>(this.boundComponents.values());
    }

    protected void initScheduler() throws Exception {
        this.logInfo("Initializing Scheduler...");
        this.schedulerFactory = new SchedulerFactory();
        this.schedulerImpl = (AbstractSchedulerImpl)this.schedulerFactory.create();
        this.schedulerImpl.init();
        this.scheduler = this.schedulerImpl.getScheduler(this.getUserName());
        this.logInfo("Scheduler initialized.");
    }

    protected void openScheduler() throws Exception {
        if (this.schedulerImpl.getState() != SchedulerState.SUSPENDED) {
            this.logInfo("Scheduler Recovery...");
            this.schedulerImpl.open();
            this.logInfo("Scheduler recovered.");
        }
    }

    protected void destroyScheduler() {
        try {
            if (this.schedulerImpl != null) {
                this.scheduler = null;
                this.schedulerImpl.destroy();
                this.schedulerImpl = null;
                this.schedulerFactory.destroy();
                this.logInfo("Scheduler destroyed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying Scheduler failed.");
        }
    }

    protected void saveScheduler() {
        AbstractRuntimeContext.saveObject(this.schedulerFactory, (SchedulerImpl)this.schedulerImpl);
    }

    protected void loadDataConstraints() throws Exception {
        this.logInfo("Loading Data Constraints...");
        this.exchange.loadDataConstraints();
        this.logInfo("Data Constraints loaded.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LocalFabricConnection getSystemConnection() {
        if (this.systemConnection == null) {
            AbstractRuntimeContext abstractRuntimeContext = this;
            synchronized (abstractRuntimeContext) {
                if (this.systemConnection == null) {
                    try {
                        this.systemConnection = (LocalFabricConnection)new FabricConnectionFactory().createConnection();
                        this.systemConnection.setSystemName("InternalConnection");
                        this.systemConnection.open();
                        this.systemConnection.bindProducerForSystem("e.sys.sl.Message");
                        this.systemConnection.bindProducerForSystem("e.sys.sl.FileMessage");
                        this.systemConnection.bindProducerForSystem("e.sys.sl.AudioMessage");
                    }
                    catch (Exception exception) {
                        this.logException(exception, true);
                    }
                }
            }
        }
        return this.systemConnection;
    }

    protected void destroySystemConnection() {
        try {
            if (this.systemConnection != null) {
                this.systemConnection.close();
                this.systemConnection = null;
                this.logInfo("System Connection destroyed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying System Connection failed.");
        }
    }

    protected FabricConnection getFabricConnection() {
        return this.getSystemConnection();
    }

    protected void onNodeConnect(FabricNodeReference node) {
    }

    protected void onNodeDisconnect(FabricNodeReference node, boolean normal) {
    }

    protected static <T> void saveObject(ExchangeObjectFactory<T> factory, T object) {
        if (factory != null && object != null) {
            factory.updateObject(object);
        }
    }

    protected FabricGroupManager getGroupManager() {
        return this.exchange.groupManager;
    }

    protected DynamicComponentsManager getDynamicComponentsManager() {
        return this.dynamicComponentsManager;
    }

    protected void initAdminAcceptor() throws Exception {
        this.logInfo("Initializing Admin HTTP Acceptor...");
        Object url = adminURL;
        if (!((String)url).startsWith("$hostname:")) {
            url = "$hostname:" + Integer.parseInt((String)url);
        }
        this.adminAcceptor = new HTTPAcceptor("Admin", true);
        this.adminAcceptor.setURL((String)url);
        this.adminAcceptor.init((RuntimeContext)this);
        this.adminAcceptor.start();
        this.logInfo("Admin HTTP Acceptor initialized.");
    }

    protected void destroyAdminAcceptor() {
        try {
            if (this.adminAcceptor != null) {
                this.adminAcceptor.stop();
                this.adminAcceptor.destroy();
                this.adminAcceptor = null;
                this.logInfo("Admin HTTP Acceptor destroyed.");
            }
        }
        catch (Throwable exception) {
            this.logException(exception, true, "Destroying Admin HTTP Acceptor failed.");
        }
    }

    protected HTTPAcceptor getAdminAcceptor() {
        return this.adminAcceptor;
    }

    protected abstract void processInitException(Throwable var1, String var2, String var3, int var4);

    protected TimeZone getHostTimezone() {
        return TimeZone.getDefault();
    }

    protected TimeZone getNodeTimezone() {
        return this.dsManager.getTimezone();
    }

    protected Charset getCCSID() {
        return this.dsManager.getCCSID();
    }

    @Override
    public boolean isNativeContext(MFSession session) {
        return session instanceof RuntimeMFSession || session.isDiagnostic();
    }

    protected List<String> listOrganizations() {
        return this.securityManagerImpl.listOrganizations();
    }

    @Override
    protected void logException(Throwable exception, boolean printStackTrace) {
        Trace.logException(RuntimeContext.class, exception, printStackTrace);
    }

    @Override
    protected void logError(String message) {
        Trace.logError(RuntimeContext.class, message);
    }

    @Override
    protected void logInfo(String message) {
        Trace.logInfo(RuntimeContext.class, message);
    }

    @Override
    protected void logDebug(String message) {
        Trace.logDebug(RuntimeContext.class, message);
    }

    private class LoadedPackagesProviderImpl
    implements LoadedPackagesProvider {
        private LoadedPackagesProviderImpl() {
        }

        @Override
        public boolean isPackageLoaded(Package pkg) throws UtilitiesException {
            return AbstractRuntimeContext.this.getPackageManifestManager().getLoaderRegistry().isPackageRegistered(pkg.getFullName(), false) || AbstractRuntimeContext.this.getPackageManifestManager().getLoaderRegistry().isPackageRegistered(pkg.getFullName(), true) || AbstractRuntimeContext.this.getBoundComponents().stream().map(FabricComponent::getPackageManifestManager).anyMatch(componentManifestManager -> componentManifestManager != null && (componentManifestManager.getLoaderRegistry().isPackageRegistered(pkg.getFullName(), false) || componentManifestManager.getLoaderRegistry().isPackageRegistered(pkg.getFullName(), true)));
        }

        @Override
        public boolean isPackageLoaded(PackageType type, String name) throws UtilitiesException {
            return this.isPackageLoaded(Package.create(type, name));
        }

        @Override
        public boolean isPackageRegistered(Package pkg) throws NamingException {
            if (AbstractRuntimeContext.this.getPackageManifestManager().existsPackage(pkg.getFullName())) {
                return true;
            }
            for (FabricComponent component : AbstractRuntimeContext.this.getBoundComponents()) {
                PackageManifestManager componentManifestManager = component.getPackageManifestManager();
                if (componentManifestManager == null || !componentManifestManager.existsPackage(pkg.getFullName())) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isPackageRegistered(PackageType type, String name) throws NamingException {
            return this.isPackageRegistered(Package.create(type, name));
        }
    }

    private static class RuntimeAdvisoryListenerWrapper
    implements FabricEventListener {
        private RuntimeAdvisoryListener listener;

        private RuntimeAdvisoryListenerWrapper(RuntimeAdvisoryListener listener) {
            this.listener = listener;
        }

        @Override
        public void onEvent(ImmutableEventDatagram event) {
            this.listener.onEvent((AdvisoryEventDatagram)event);
        }
    }
}

