/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.utils.FileIOUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.cli.RepositoryAccessorException;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.sef.dispatcher.AbstractFabricConnection;
import com.streamscape.sef.moderator.FabricNodeReference;
import java.io.File;
import java.io.InputStream;
import javax.naming.NamingException;

abstract class AbstractRepositoryAccessor
implements RepositoryAccessor {
    AbstractFabricConnection connection;
    String userName;
    FabricNodeReference node;
    boolean isOpened;

    AbstractRepositoryAccessor(AbstractFabricConnection connection, FabricNodeReference node) {
        this(connection, connection.getCurrentUserName(), node);
    }

    AbstractRepositoryAccessor(AbstractFabricConnection connection, String userName, FabricNodeReference node) {
        this.connection = connection;
        this.userName = userName;
        this.node = node;
        this.isOpened = true;
    }

    @Override
    public String getNodeName() {
        return this.node.getName();
    }

    @Override
    public boolean isOpened() {
        return this.isOpened;
    }

    void checkOpened() throws RepositoryAccessorException {
        if (!this.isOpened) {
            throw new RepositoryAccessorException(4053, "Accessor is closed.");
        }
    }

    synchronized void open() {
        if (!this.isOpened) {
            this.isOpened = true;
        }
    }

    synchronized void close() {
        if (this.isOpened) {
            this.isOpened = false;
        }
    }

    void setNode(FabricNodeReference node) {
        this.node = node;
    }

    static byte[] getContent(File contentFile) throws RepositoryException {
        try {
            return FileIOUtils.getFileContent(contentFile);
        }
        catch (Exception exception) {
            throw new RepositoryException(4002, (Throwable)exception);
        }
    }

    static byte[] getContent(InputStream stream, long sizeLimit) throws RepositoryException {
        try {
            return FileIOUtils.getStreamContent(stream, sizeLimit);
        }
        catch (Exception exception) {
            throw new RepositoryException(4002, (Throwable)exception);
        }
    }

    @Override
    public Package getPackage(String fullName) throws RepositoryAccessorException, NamingException, RepositoryException {
        Pair<PackageType, String> parsedName = Package.parseFullName(fullName);
        return this.getPackage((PackageType)((Object)parsedName.first), (String)parsedName.second);
    }

    @Override
    public void removePackage(String fullName, boolean withJars) throws RepositoryAccessorException, NamingException, RepositoryException {
        Pair<PackageType, String> parsedName = Package.parseFullName(fullName);
        this.removePackage((PackageType)((Object)parsedName.first), (String)parsedName.second, withJars);
    }

    @Override
    public boolean existsPackage(String fullName) throws RepositoryAccessorException, NamingException, RepositoryException {
        Pair<PackageType, String> parsedName = Package.parseFullName(fullName);
        return this.existsPackage((PackageType)((Object)parsedName.first), (String)parsedName.second);
    }

    @Override
    public void importPackage(String directory, String fullName) throws RepositoryAccessorException, NamingException, RepositoryException {
        Pair<PackageType, String> parsedName = Package.parseFullName(fullName);
        this.importPackage(directory, (PackageType)((Object)parsedName.first), (String)parsedName.second);
    }

    @Override
    public void exportPackage(String directory, String fullName) throws RepositoryAccessorException, NamingException, RepositoryException {
        Pair<PackageType, String> parsedName = Package.parseFullName(fullName);
        this.exportPackage(directory, (PackageType)((Object)parsedName.first), (String)parsedName.second);
    }
}

