/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.ds.AbstractDataspace;
import com.streamscape.ds.DataspaceException;
import com.streamscape.ds.DataspaceStoreManager;
import com.streamscape.ds.replication.ReplicaInfo;
import com.streamscape.ds.replication.ReplicaState;
import com.streamscape.ds.replication.ReplicationDataBatch;
import com.streamscape.ds.replication.ReplicationEntityName;
import com.streamscape.ds.replication.ReplicationErrorCode;
import com.streamscape.ds.replication.ReplicationException;
import com.streamscape.ds.replication.ReplicationManager;
import com.streamscape.ds.replication.ReplicationMetaSchema;
import com.streamscape.ds.replication.ReplicationRequest;
import com.streamscape.ds.replication.ReplicationResponse;
import com.streamscape.ds.replication.ReplicationSource;
import com.streamscape.ds.replication.ReplicationTarget;
import com.streamscape.ds.result.Result;
import com.streamscape.ds.session.Session;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.lib.utils.Utils;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.event.OpaqueEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricRequestListener;
import com.streamscape.sef.FabricUnboundEventException;
import com.streamscape.sef.dataspace.DataspaceComponent;
import com.streamscape.sef.dispatcher.AbstractFabricConnection;
import com.streamscape.sef.dispatcher.FabricEventSourceFactoryImpl;
import com.streamscape.sef.dispatcher.ReplicationSourceReferenceImpl;
import com.streamscape.sef.dispatcher.ReplicationTargetReferenceImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.FabricModeratorAdvisory;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.moderator.ModeratorAdvisoryType;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.moderator.ReplicationSourceReference;
import com.streamscape.sef.moderator.ReplicationTargetReference;
import com.streamscape.sef.moderator.RequestConsumerReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

public abstract class AbstractReplicationManager
implements FabricRequestListener {
    protected static final String REPLICATION_MANAGEMENT_EVENT_ID = "e.replication.management.request";
    protected static final String REPLICATION_MANAGER_REQUESTS_LISTENER = "sys$ReplicationManagerListener";
    protected static final String REPLICA_LISTENER = "sys$ReplicaListener";
    protected static final String MODERATOR_ADVISORY_LISTENER = "sys$ModeratorAdvisoryListener";
    protected AbstractDataspace dataspace;
    protected Session managerSession;
    protected final ReentrantLock managerSessionLook = new ReentrantLock();
    protected Set<ReplicationSource> sources = Collections.synchronizedSet(new HashSet());
    protected Set<ReplicationTarget> targets = Collections.synchronizedSet(new HashSet());
    protected LongNumberAllocatorSimple targetCounter = new LongNumberAllocatorSimple();

    protected AbstractReplicationManager(AbstractDataspace dataspace) {
        this.dataspace = dataspace;
    }

    protected void open(Session session) {
        try {
            this.managerSessionLook.lock();
            try {
                this.managerSession = this.dataspace.createSession();
            }
            finally {
                this.managerSessionLook.unlock();
            }
            this.dataspace.dispatcher.createSystemRequestConsumer(REPLICATION_MANAGER_REQUESTS_LISTENER, this, EventScope.INHERITED);
            this.dataspace.dispatcher.createHiddenEventAsyncConsumer(MODERATOR_ADVISORY_LISTENER, new FabricEventListener(){

                @Override
                public void onEvent(ImmutableEventDatagram event) throws FabricEventException {
                    AbstractReplicationManager.this.onUpdate((FabricModeratorAdvisory)event);
                }
            }, "advisory.fabric.Moderator", "type='NODE_CONNECTED' or type='REQUEST_CONSUMER_ADDED' or type='REQUEST_CONSUMER_REMOVED' or type = 'NODE_DISCONNECTED' or type = 'NODE_DISCONNECTED_FORCIBLY'").start();
        }
        catch (FabricEventDispatcherException error) {
            throw new DataspaceException(error, "Opening of ReplicationManager failed.", "00000", 458);
        }
    }

    protected void close(Session parentSession) {
        if (this.dataspace.dispatcher != null) {
            this.dataspace.dispatcher.dropSystemConsumer(MODERATOR_ADVISORY_LISTENER);
            this.dataspace.dispatcher.dropSystemConsumer(REPLICATION_MANAGER_REQUESTS_LISTENER);
        }
    }

    public void close2(Session parentSession) {
        Result result = parentSession.executeDirectStatement("update RDS.SOURCE_REPLICAS set STATE = 'INACTIVE' where  REPLICA_NODE = '" + this.dataspace.context.getName() + "' and REPLICA_DATASPACE_NAME = '" + this.dataspace.getName() + "'");
        if (result.isError()) {
            Trace.logError(this, "Unable to reset replicas state. " + (result.getException() != null ? Utils.formatExceptionWithUnrepeatedCauses(result.getException()) : ""));
        }
        this.managerSessionLook.lock();
        try {
            if (this.managerSession != null) {
                this.managerSession.close();
                this.managerSession = null;
            }
        }
        finally {
            this.managerSessionLook.unlock();
        }
    }

    private void onUpdate(FabricModeratorAdvisory advisory) {
        for (ReplicationTarget target : this.targets) {
            if (target.getState() == ReplicaState.INACTIVE || target.getState() == ReplicaState.FAILURE) {
                if (advisory.getType() == ModeratorAdvisoryType.NODE_CONNECTED) {
                    if (!target.getSourceEntityName().getNodeName().equals(advisory.getEntity())) continue;
                    target.attachToSourceMonitor();
                    continue;
                }
                if (advisory.getType() != ModeratorAdvisoryType.REQUEST_CONSUMER_ADDED || !advisory.getEntity().startsWith(target.getSourceEntityName().getNodeName() + "://" + target.getSourceEntityName().getDataspaceType() + "." + target.getSourceEntityName().getDataspaceName()) || !advisory.getEntity().endsWith(REPLICATION_MANAGER_REQUESTS_LISTENER)) continue;
                target.attachToSourceMonitor();
                continue;
            }
            if (target.getState() == ReplicaState.INACTIVE || target.getState() == ReplicaState.FAILURE || target.getState() == ReplicaState.STOPPED) continue;
            if (advisory.getType() == ModeratorAdvisoryType.NODE_DISCONNECTED || advisory.getType() == ModeratorAdvisoryType.NODE_DISCONNECTED_FORCIBLY) {
                if (!target.getSourceEntityName().getNodeName().equals(advisory.getEntity())) continue;
                target.sourceDisconnected("Source node disconnected.");
                continue;
            }
            if (advisory.getType() != ModeratorAdvisoryType.REQUEST_CONSUMER_REMOVED || !advisory.getEntity().startsWith(target.getSourceEntityName().getNodeName() + "://" + target.getSourceEntityName().getDataspaceType() + "." + target.getSourceEntityName().getDataspaceName()) || !advisory.getEntity().endsWith(REPLICATION_MANAGER_REQUESTS_LISTENER)) continue;
            target.sourceDisconnected("Source dataspace went down.");
        }
        if (advisory.getType() == ModeratorAdvisoryType.REQUEST_CONSUMER_REMOVED && advisory.getEntity().contains(REPLICA_LISTENER)) {
            consumerName = advisory.getEntity();
            int index = consumerName.indexOf("://");
            nodeName = consumerName.substring(0, index);
            consumerName = consumerName.substring(index + 3);
            index = consumerName.indexOf(".");
            dataspaceType = consumerName.substring(0, index);
            consumerName = consumerName.substring(index + 1);
            index = consumerName.indexOf(":");
            dataspaceName = consumerName.substring(0, index);
            consumerName = consumerName.substring(index + 1);
            String replicaName = consumerName.substring(REPLICA_LISTENER.length());
            for (ReplicationSource source : this.sources) {
                source.detachReplicaIfAttached(new ReplicationEntityName(nodeName, dataspaceType, dataspaceName, replicaName, null), null, false, advisory.getTimestamp().getTime());
            }
        } else if (advisory.getType() == ModeratorAdvisoryType.REQUEST_CONSUMER_REMOVED && advisory.getEntity().contains(REPLICATION_MANAGER_REQUESTS_LISTENER)) {
            consumerName = advisory.getEntity();
            int index = consumerName.indexOf("://");
            nodeName = consumerName.substring(0, index);
            consumerName = consumerName.substring(index + 3);
            index = consumerName.indexOf(".");
            dataspaceType = consumerName.substring(0, index);
            consumerName = consumerName.substring(index + 1);
            index = consumerName.indexOf(":");
            dataspaceName = consumerName.substring(0, index);
            consumerName = consumerName.substring(index + 1);
            for (ReplicationSource source : this.sources) {
                source.detachAllReplicasFromDataspace(nodeName, dataspaceType, dataspaceName, false, advisory.getTimestamp().getTime());
            }
        }
        if (advisory.getType() == ModeratorAdvisoryType.NODE_DISCONNECTED || advisory.getType() == ModeratorAdvisoryType.NODE_DISCONNECTED_FORCIBLY) {
            for (ReplicationSource source : this.sources) {
                source.detachAllReplicasFromDataspace(advisory.getEntity(), null, null, false, advisory.getTimestamp().getTime());
            }
        }
    }

    protected ReplicationResponse sendReplicationManagementRequest(ReplicationRequest request, ReplicationEntityName to, long timeout) throws ReplicationException {
        return AbstractReplicationManager.sendReplicationManagementRequest(this.dataspace, null, request, to, timeout);
    }

    protected static ReplicationResponse sendReplicationManagementRequest(AbstractDataspace dataspace, FabricConnection connection, ReplicationRequest request, ReplicationEntityName to, long timeout) throws ReplicationException {
        return AbstractReplicationManager.sendReplicationManagementRequestInternal(dataspace, connection, request, to, timeout, 2);
    }

    protected static ReplicationResponse sendReplicationManagementRequestInternal(AbstractDataspace dataspace, FabricConnection connection, ReplicationRequest request, ReplicationEntityName to, long timeout, int repeats) throws ReplicationException {
        --repeats;
        try {
            RequestConsumerReference consumer;
            Moderator moderator = connection != null ? connection.getModerator() : dataspace.getModerator();
            FabricNodeReference node = to.getNodeName() == null ? moderator.getFabricNode() : moderator.lookupFabricNode(to.getNodeName());
            String consumerName = ModeratorUtils.makeConsumerFullName(to.getDataspaceType(), to.getDataspaceName(), REPLICATION_MANAGER_REQUESTS_LISTENER);
            RequestConsumerReference requestConsumerReference = consumer = node != null ? node.lookupRequestConsumer(consumerName) : null;
            if (consumer != null) {
                ImmutableEventDatagram responseEvent;
                ReplicationManager replicationManager;
                DataspaceComponent toComponent;
                OpaqueEvent requestEvent = (OpaqueEvent)OpaqueDatagramFactory.getInstance().newEventInstance("OpaqueEvent");
                FabricEventSourceFactoryImpl.setEventId(requestEvent, REPLICATION_MANAGEMENT_EVENT_ID);
                requestEvent.setData(request);
                if (DataspaceStoreManager.getRuntimeContext().getName().equals(to.getNodeName()) && request.getSession() != null && dataspace != null && (toComponent = dataspace.getStore().lookup(to.getDataspaceName())) instanceof AbstractDataspace && (replicationManager = ((AbstractDataspace)toComponent).getReplicationManager()) != null) {
                    responseEvent = replicationManager.onRequest(requestEvent);
                } else {
                    request.setSession(null);
                    ImmutableEventDatagram immutableEventDatagram = responseEvent = connection != null ? ((AbstractFabricConnection)connection).raiseSystemRequest(consumer, requestEvent, timeout) : dataspace.dispatcher.raiseSystemRequest(consumer, requestEvent, timeout);
                }
                if (responseEvent == null) {
                    throw new ReplicationException(ReplicationErrorCode.PROCESSING_IN_REPLICATION_MANAGER_FAILED, "Unable to process replication manager request. Null response returned.");
                }
                return (ReplicationResponse)((OpaqueEvent)responseEvent).getData();
            }
            String error = "Replication manager for '" + String.valueOf(to) + "' is not reachable. " + (node == null ? "Node '" + to.getNodeName() + "' not reachable." : "Consumer '" + consumerName + "' in node '" + to.getNodeName() + "' not found.");
            if (repeats == 0) {
                throw new ReplicationException(ReplicationErrorCode.REPLICATION_MANAGER_NOT_REACHABLE, error);
            }
            AbstractReplicationManager.trace(ReplicationManager.class, dataspace, Trace.Level.DEBUG, error + " Retry request one more time.", new Object[0]);
            return AbstractReplicationManager.sendReplicationManagementRequestInternal(dataspace, connection, request, to, timeout, repeats);
        }
        catch (FabricEventSourceException | FabricUnboundEventException exception) {
            AbstractReplicationManager.trace(ReplicationManager.class, dataspace, Trace.Level.DEBUG, "Exception sending management request: {}", Utils.formatExceptionWithUnrepeatedCauses(exception));
            if (repeats == 0) {
                throw new ReplicationException(ReplicationErrorCode.REPLICATION_MANAGER_NOT_REACHABLE, "Replication manager for '" + String.valueOf(to) + "' is not reachable.", exception);
            }
            AbstractReplicationManager.trace(ReplicationManager.class, dataspace, Trace.Level.DEBUG, "Retry request one more time.", new Object[0]);
            return AbstractReplicationManager.sendReplicationManagementRequestInternal(dataspace, connection, request, to, timeout, repeats);
        }
        catch (Exception exception) {
            AbstractReplicationManager.trace(ReplicationManager.class, dataspace, Trace.Level.DEBUG, "Exception sending management request: {}", Utils.formatExceptionWithUnrepeatedCauses(exception));
            if (exception instanceof ReplicationException) {
                throw (ReplicationException)exception;
            }
            throw new ReplicationException(ReplicationErrorCode.PROCESSING_IN_REPLICATION_MANAGER_FAILED, "Unable to process replication management request.", exception);
        }
    }

    protected static ReplicationResponse sendReplicationManagementRequestGlobal(ReplicationRequest request, ReplicationEntityName to, long timeout) throws ReplicationException {
        return AbstractReplicationManager.sendReplicationManagementRequest(null, DataspaceStoreManager.getRuntimeContext().getFabricConnection(), request, to, timeout);
    }

    protected RequestConsumerReference lookupReplicaConsumer(String nodeName, String dataspaceType, String dataspaceName, String replicaName) {
        FabricNodeReference node = this.dataspace.getModerator().lookupFabricNode(nodeName);
        return node != null ? node.lookupRequestConsumer(ModeratorUtils.makeConsumerFullName(dataspaceType, dataspaceName, REPLICA_LISTENER + replicaName)) : null;
    }

    protected ReplicationResponse sendReplicationDataWithAck(ReplicationEntityName replicaEntityName, RequestConsumerReference consumer, ReplicationDataBatch batch, ReplicationEntityName from, long batchTimeout) throws ReplicationException {
        try {
            if (consumer != null) {
                ImmutableEventDatagram responseEvent;
                FabricRequestListener target;
                ReplicationManager replicationManager;
                DataspaceComponent toComponent;
                OpaqueEvent requestEvent = (OpaqueEvent)OpaqueDatagramFactory.getInstance().newEventInstance("OpaqueEvent");
                FabricEventSourceFactoryImpl.setEventId(requestEvent, AbstractReplicationManager.getReplicationEventId(from));
                requestEvent.setData(batch);
                if (DataspaceStoreManager.getRuntimeContext().getName().equals(replicaEntityName.getNodeName()) && batch.getSession() != null && (toComponent = this.dataspace.getStore().lookup(replicaEntityName.getDataspaceName())) instanceof AbstractDataspace && (replicationManager = ((AbstractDataspace)toComponent).getReplicationManager()) != null && (target = replicationManager.getTargetRequestListener(replicaEntityName)) != null) {
                    responseEvent = target.onRequest(requestEvent);
                } else {
                    batch.setSession(null);
                    responseEvent = this.dataspace.dispatcher.raiseSystemRequest(consumer, requestEvent, batchTimeout);
                }
                if (responseEvent == null) {
                    throw new ReplicationException(ReplicationErrorCode.REPLICATION_PROCESSING_ON_TARGET_FAILED, "Unable to process replication data on target. Null response returned.");
                }
                return (ReplicationResponse)((OpaqueEvent)responseEvent).getData();
            }
            throw new ReplicationException(ReplicationErrorCode.REPLICA_IS_DETACHED, "Specified replica '" + String.valueOf(replicaEntityName) + "' is not reachable.");
        }
        catch (FabricEventSourceException | FabricUnboundEventException exception) {
            this.trace(Trace.Level.DEBUG, "Exception sending replication data: ", new Object[]{this.dataspace.getDataspaceType(), this.dataspace.getName(), Utils.formatExceptionWithUnrepeatedCauses(exception)});
            throw new ReplicationException(ReplicationErrorCode.REPLICA_CONSUMER_NOT_FOUND, "Unable to send replication request to target.", exception);
        }
        catch (Exception exception) {
            this.trace(Trace.Level.DEBUG, "Exception sending replication data: ", new Object[]{this.dataspace.getDataspaceType(), this.dataspace.getName(), Utils.formatExceptionWithUnrepeatedCauses(exception)});
            throw new ReplicationException(ReplicationErrorCode.REPLICATION_PROCESSING_ON_TARGET_FAILED, "Unable to process replication data on target.", exception);
        }
    }

    protected FabricRequestListener getTargetRequestListener(ReplicationEntityName replicaEntityName) {
        for (ReplicationTarget target : this.targets) {
            if (!target.getTargetEntityName().equalsNoCollection(replicaEntityName)) continue;
            return target;
        }
        return null;
    }

    private static String getReplicationEventId(ReplicationEntityName name) {
        return "e.replication." + name.getNodeName() + "." + name.getDataspaceType() + "." + name.getDataspaceName() + "." + name.getSourceOrReplicaName();
    }

    protected void registerTarget(ReplicationTarget replicationTarget) {
        try {
            long targetIdentity = this.targetCounter.getNumber();
            String consumerName = REPLICA_LISTENER + replicationTarget.getName();
            this.dataspace.dispatcher.createSystemRequestConsumer(consumerName, replicationTarget, EventScope.INHERITED, false);
            replicationTarget.setIdentity(targetIdentity);
        }
        catch (FabricEventDispatcherException exception) {
            this.trace(Trace.Level.ERROR, "Failed register target {}.", replicationTarget);
            Trace.logException(this, exception, true);
            throw new DataspaceException(exception);
        }
    }

    protected void addTarget(ReplicationTarget target) {
        this.targets.add(target);
    }

    protected ReplicationTargetReference addTargetReference(ReplicationTarget target) {
        ReplicationTargetReferenceImpl reference = new ReplicationTargetReferenceImpl(target.getComponentAddress(), target.getTargetEntityName().getFullName(), target.getEventScope(), target.getSourceEntityName().getFullName(), target.isNew(), target.isWithMaterialization(), target.getState(), target.isSuspended(), target.getMetaSchema(), target.getTargetCollectionName());
        this.dataspace.context.exchange.addReplicationTarget(reference);
        return reference;
    }

    protected void removeTarget(ReplicationTarget target) {
        this.targets.remove(target);
        if (target.getReference() != null) {
            this.dataspace.context.exchange.removeReplicationTarget((ReplicationTargetReferenceImpl)target.getReference());
        }
    }

    protected void updateTargetState(ReplicationTarget target, ReplicaState state, boolean isSuspended, Boolean sync, ReplicationMetaSchema metaSchema) {
        ReplicationTargetReferenceImpl reference = (ReplicationTargetReferenceImpl)target.getReference();
        if (reference != null) {
            reference.state = state;
            reference.isSuspended = isSuspended;
            reference.sync = sync;
            reference.metaSchema = metaSchema;
            this.dataspace.context.exchange.changeReplicationTarget(reference);
        }
    }

    protected void addSource(ReplicationSource source) {
        this.sources.add(source);
    }

    protected ReplicationSourceReference addSourceReference(ReplicationSource source) {
        ReplicationSourceReferenceImpl reference = new ReplicationSourceReferenceImpl(source.getComponentAddress(), source.getReplicationEntityName().getFullName(), source.getEventScope(), source.isEnabled(), source.getReplicationSourceSettings().sync, source.getReplicationSourceSettings().rollbackOnFailure, source.getReplicationQueueSettings().batchSize, source.getReplicationQueueSettings().batchInterval, source.getCollection().getCollectionName(), this.executeInManagerOrRequestSession(null, session -> source.listReplicas((Session)session)));
        this.dataspace.context.exchange.addReplicationSource(reference);
        return reference;
    }

    protected void removeSource(ReplicationSource source) {
        this.sources.remove(source);
        if (source.getReference() != null) {
            this.dataspace.context.exchange.removeReplicationSource((ReplicationSourceReferenceImpl)source.getReference());
        }
    }

    protected void updateSourceReference(ReplicationSource source) {
        ReplicationSourceReferenceImpl reference = (ReplicationSourceReferenceImpl)source.getReference();
        if (reference != null) {
            reference.setEnabled(source.isEnabled());
            this.dataspace.context.exchange.changeReplicationSource(reference);
        }
    }

    protected void updateSourceReplicas(ReplicationSource source, List<ReplicaInfo> replicas) {
        ReplicationSourceReferenceImpl reference = (ReplicationSourceReferenceImpl)source.getReference();
        if (reference != null) {
            reference.setReplicas(replicas);
            this.dataspace.context.exchange.changeReplicationSource(reference);
        }
    }

    protected void unregisterTarget(ReplicationTarget replicationTarget) {
        if (this.dataspace.dispatcher != null) {
            this.dataspace.dispatcher.dropSystemConsumer(REPLICA_LISTENER + replicationTarget.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T executeInManagerOrRequestSession(Session requestSession, Function<Session, T> function) {
        if (requestSession != null) {
            return AbstractReplicationManager.executeWithPush(requestSession, function);
        }
        try {
            int timeout = 600;
            if (this.managerSessionLook.getQueueLength() >= 5) {
                timeout = 20;
            }
            if (!this.managerSessionLook.tryLock(timeout, TimeUnit.SECONDS)) {
                Trace.logException(this, new Exception("Failed to get lock on replication manager session for " + timeout + " seconds. Interrupt execution."), true);
                throw new DataspaceException("Failed to get lock on replication manager session for " + timeout + " seconds. Interrupt execution.");
            }
        }
        catch (InterruptedException exception) {
            Thread.interrupted();
            throw new DataspaceException("Failed to get lock on replication manager session. Thread is interrupted.");
        }
        try {
            T t;
            try {
                t = function.apply(this.managerSession);
                this.managerSession.commit(true);
            }
            catch (Throwable throwable) {
                this.managerSession.commit(true);
                throw throwable;
            }
            return t;
        }
        finally {
            this.managerSessionLook.unlock();
        }
    }

    public static <T> T executeWithPush(Session session, Function<Session, T> function) {
        if (!session.isInMidTransaction() && !session.executingReplication && session.sessionContext.depth == 0 && session.getCurrentStatementCounter() == 0) {
            return function.apply(session);
        }
        session.sessionContext.pushDynamicArguments(new Object[0]);
        try {
            T t = function.apply(session);
            return t;
        }
        finally {
            session.sessionContext.pop();
        }
    }

    protected void trace(Trace.Level level, String message, Object ... args) {
        AbstractReplicationManager.trace(this.getClass(), this.dataspace, level, message, args);
    }

    protected static void trace(Class<?> clazz, AbstractDataspace dataspace, Trace.Level level, String message, Object ... args) {
        if (Trace.isEnabled(clazz, level)) {
            Trace.log(clazz, level, "Replication manager [" + String.valueOf(dataspace != null ? dataspace.getDataspaceType() : "unknown") + "." + (dataspace != null ? dataspace.getName() : "unknown") + "] : " + message, args);
        }
    }
}

