/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.loader.ClassLoaderRegistry;
import com.streamscape.lib.loader.FabricClassLoader;
import com.streamscape.lib.loader.PackageLoaderRegistry;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.lib.utils.Pair;
import com.streamscape.repository.enums.PackageType;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.AbstractSemanticFactory;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sef.dispatcher.AbstractPackage;
import com.streamscape.sef.dispatcher.AbstractPackageDescriptor;
import com.streamscape.sef.dispatcher.ComponentManifestManager;
import com.streamscape.sef.dispatcher.InternalUtils;
import com.streamscape.sef.dispatcher.LoaderRegistry;
import com.streamscape.sef.dispatcher.RuntimeExchange;
import com.streamscape.sef.mf.admin.FabricContext;
import com.streamscape.sef.pkg.AbstractPackageManifest;
import com.streamscape.sef.pkg.PackageDescriptor;
import com.streamscape.sef.pkg.PackageManifestException;
import com.streamscape.sef.pkg.PackageManifestManager;
import com.streamscape.sef.utils.SemanticUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.naming.NamingException;

public abstract class AbstractPackageManifestManager
extends AbstractSemanticFactory
implements PackageManifestManager {
    protected RuntimeContext context;
    protected LoaderRegistry loaderRegistry;
    protected AbstractPackageManifest manifest;
    protected boolean initOrDestroyInProgress = false;

    public AbstractPackageManifestManager(RuntimeContext context) {
        this.context = context;
    }

    protected void addComponentManifestManager(ComponentManifestManager componentManifestManager) {
    }

    protected void removeComponentManifestManager(ComponentManifestManager componentManifestManager) {
    }

    @Override
    public List<String> listPackages() {
        return this.manifest.listPackages();
    }

    @Override
    public PackageDescriptor getPackage(String name) throws NamingException {
        return this.doCopy(this.getPackageFromManifest(name));
    }

    PackageDescriptor getPackageFromManifest(String fullName) throws NamingException {
        Pair<PackageType, String> parsedName = Package.parseFullName(fullName);
        return this.getPackageFromManifest((PackageType)((Object)parsedName.first), (String)parsedName.second);
    }

    PackageDescriptor getPackageFromManifest(PackageType type, String name) {
        return this.manifest.get(type, name);
    }

    PackageDescriptor getPackageFromManifestSafe(String fullName) {
        return this.manifest.get(fullName);
    }

    public int getPosition(PackageDescriptor descriptor) {
        return this.manifest.getPosition(descriptor);
    }

    @Override
    public int getPackagePosition(String name) throws NamingException {
        PackageDescriptor descriptor = this.getPackageFromManifest(name);
        return descriptor != null ? this.manifest.getPosition(descriptor) : -1;
    }

    @Override
    public int getPackagePosition(PackageDescriptor descriptor) {
        return this.manifest.getPosition(descriptor);
    }

    @Override
    public boolean existsPackage(String name) throws NamingException {
        Pair<PackageType, String> parsedName = Package.parseFullName(name);
        return this.existsPackage((PackageType)((Object)parsedName.first), (String)parsedName.second);
    }

    boolean existsPackage(PackageType type, String name) {
        return this.manifest.existsPackage(type, name);
    }

    @Override
    public void addPackage(PackageDescriptor descriptor) throws PackageManifestException {
        this.addPackageAt(this.manifest.size() + 1, descriptor);
    }

    @Override
    public void addPackageAt(int position, PackageDescriptor descriptor) throws PackageManifestException {
        this.doAddPackageAt(position, descriptor, false);
    }

    protected void doAddPackageAt(int position, PackageDescriptor descriptor, boolean notify) throws PackageManifestException {
        this.checkPackageType(descriptor);
        if (notify && this.context.isCoherenceAgentBound() && AbstractPackageManifestManager.isPackageGeneric(descriptor)) {
            try {
                this.context.exchange.addPackage(this, position, descriptor);
            }
            catch (Exception exception) {
                if (exception instanceof PackageManifestException) {
                    throw (PackageManifestException)exception;
                }
                throw new PackageManifestException("Unexpected exception.", exception);
            }
        } else {
            this.doAddPackageAtCore(position, descriptor, false);
        }
    }

    protected void checkPackageType(PackageDescriptor descriptor) throws PackageManifestException {
    }

    synchronized RuntimeExchange.PackageData doAddPackageAtCore(int position, PackageDescriptor descriptor, boolean needReply) throws PackageManifestException {
        if (this.manifest.existsPackage(descriptor.getPackageType(), descriptor.getPackageName())) {
            throw new PackageManifestException("Package '" + String.valueOf(descriptor) + "' already registered.");
        }
        this.checkNonChainedRoot(descriptor);
        Package pkg = this.getPackageData(descriptor, needReply);
        this.checkGlobalPackage(descriptor, pkg);
        if (needReply) {
            this.checkPackageOnAdd(descriptor, pkg);
        }
        this.manifest.addAt(position, descriptor);
        if (descriptor.isAutoload()) {
            this.doLoadPackageCore(descriptor, true);
        }
        this.doSaveManifest();
        Trace.logInfo(this, "Package '" + String.valueOf(descriptor) + "' added.");
        return needReply ? new RuntimeExchange.PackageData(descriptor, position, pkg, pkg.listJARs()) : null;
    }

    protected void checkGlobalPackage(AbstractPackageDescriptor descriptor, AbstractPackage pkg) throws PackageManifestException {
        if (descriptor.isGlobal() && !descriptor.isGeneric() || pkg.isGlobal() && !pkg.isGeneric()) {
            throw new PackageManifestException("Only SDO or Collection packages can be global.");
        }
    }

    protected void checkPackageOnAdd(AbstractPackageDescriptor descriptor, AbstractPackage pkg) throws PackageManifestException {
        boolean needUpdate = false;
        if (pkg.isAutoloadNotSet() || descriptor.isAutoload() != pkg.isAutoload()) {
            pkg.setAutoload(descriptor.isAutoload());
            needUpdate = true;
        }
        if (descriptor.isGeneric() && (pkg.isGlobalNotSet() || descriptor.isGlobal() != pkg.isGlobal())) {
            pkg.setGlobal(descriptor.isGlobal());
            needUpdate = true;
        }
        if (needUpdate) {
            this.updatePackageInRepository((Package)pkg);
        }
    }

    @Override
    public void updatePackage(PackageDescriptor descriptor, Package pkg) throws PackageManifestException {
        this.doUpdatePackageAt(null, descriptor, pkg, false);
    }

    @Override
    public void updatePackageAt(int position, PackageDescriptor descriptor, Package pkg) throws PackageManifestException {
        this.doUpdatePackageAt(position, descriptor, pkg, false);
    }

    public void doUpdatePackageAt(Integer position, PackageDescriptor descriptor, Package pkg, boolean notify) throws PackageManifestException {
        if (notify && this.context.isCoherenceAgentBound() && AbstractPackageManifestManager.isPackageGeneric(descriptor, pkg)) {
            try {
                this.context.exchange.updatePackage(this, position, descriptor, pkg);
            }
            catch (Exception exception) {
                if (exception instanceof PackageManifestException) {
                    throw (PackageManifestException)exception;
                }
                throw new PackageManifestException("Unexpected exception.", exception);
            }
        } else {
            this.doUpdatePackageAtCore(position, descriptor, pkg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    synchronized RuntimeExchange.UpdatePackageData doUpdatePackageAtCore(Integer position, PackageDescriptor newDescriptor, Package newPkg) throws PackageManifestException {
        if (newDescriptor == null && newPkg == null) {
            throw new PackageManifestException("Neither package descriptor nor object is specified.");
        }
        if (newDescriptor != null && newPkg != null && !newDescriptor.getFullName().equals(newPkg.getFullName())) {
            throw new PackageManifestException("Package descriptor and object do not match.");
        }
        PackageDescriptor descriptor = this.getPackageDescriptor(newDescriptor, newPkg);
        Package pkg = this.getPackageObject(newDescriptor, newPkg);
        RuntimeExchange.UpdatePackageData result = null;
        if (descriptor == null) {
            if (newDescriptor != null) throw new PackageManifestException("Package '" + newDescriptor.getFullName() + "' is not registered.");
            this.updatePackageInRepository(pkg, newPkg);
        } else {
            if (this.isPackageLoaded(descriptor)) {
                throw new PackageManifestException("Package '" + String.valueOf(descriptor) + "' is loaded and cannot be changed.");
            }
            if (newDescriptor != null && ((AbstractPackageDescriptor)descriptor).isGlobalNotMatch(newDescriptor) || newPkg != null && ((AbstractPackage)pkg).isGlobalNotMatch(newPkg)) {
                throw new PackageManifestException("Method 'updatePackage' cannot be used for changing 'global' parameter. Use 'PackageManifestManager::setPackageScope' instead.");
            }
            if (newDescriptor != null) {
                this.checkNonChainedRoot(newDescriptor);
                result = new RuntimeExchange.UpdatePackageData(this.updatePackageInManifest(descriptor, newDescriptor, position), null, position);
                if (newPkg != null) {
                    this.updatePackageInRepository(pkg, newPkg, descriptor.isAutoload(), result);
                } else if (pkg.isAutoload() != descriptor.isAutoload()) {
                    this.updatePackageInRepository(pkg, null, descriptor.isAutoload(), result);
                }
            } else {
                result = new RuntimeExchange.UpdatePackageData(null, null, -1);
                if (!((AbstractPackage)newPkg).isAutoloadNotSet() && newPkg.isAutoload() != descriptor.isAutoload()) {
                    descriptor.setAutoload(newPkg.isAutoload());
                    this.doSaveManifest();
                    result.descriptor = descriptor;
                }
                this.updatePackageInRepository(pkg, newPkg, descriptor.isAutoload(), result);
            }
        }
        Trace.logInfo(this, "Package '" + String.valueOf(descriptor) + "' updated.");
        return result;
    }

    void doUpdatePackage(RuntimeExchange.UpdatePackageData data) throws PackageManifestException {
        if (data.descriptor != null) {
            PackageDescriptor descriptor = this.doGetPackage(data.descriptor.getPackageType(), data.descriptor.getPackageName());
            this.updatePackageInManifest(descriptor, data.descriptor, data.position);
        }
        if (data.pkg != null) {
            this.updateJARsInRepository(data);
            this.updatePackageInRepository(data.pkg);
        }
    }

    private PackageDescriptor updatePackageInManifest(PackageDescriptor descriptor, PackageDescriptor newDescriptor, Integer position) throws PackageManifestException {
        boolean needUpdate = false;
        if (!descriptor.equals(newDescriptor)) {
            ((AbstractPackageDescriptor)descriptor).update(newDescriptor);
            needUpdate = true;
        }
        if (position != null && position > 0) {
            this.doUpdatePackageInManifest(descriptor, position);
            needUpdate = true;
        }
        if (needUpdate) {
            this.doSaveManifest();
            return descriptor;
        }
        return null;
    }

    private void doUpdatePackageInManifest(PackageDescriptor descriptor, Integer position) {
        this.manifest.remove(descriptor.getFullName());
        this.manifest.addAt(position, descriptor);
    }

    private void updateJARsInRepository(RuntimeExchange.UpdatePackageData data) throws PackageManifestException {
        if (data.jarDir != null) {
            try {
                this.context.repositoryAccessor.doRemoveArchives(data.jars);
                this.context.repositoryAccessor.doAddArchives(this.context.exchange.getJarDir(data.jarDir), data.jars);
            }
            catch (Exception exception) {
                throw new PackageManifestException("Updating archives for package " + data.pkg.getFullName() + " failed.", exception);
            }
        }
    }

    private PackageDescriptor getPackageDescriptor(PackageDescriptor descriptor, Package pkg) {
        if (descriptor != null) {
            return this.getPackageFromManifest(descriptor.getPackageType(), descriptor.getPackageName());
        }
        if (pkg != null) {
            return this.getPackageFromManifest(pkg.getType(), pkg.getName());
        }
        return null;
    }

    private Package getPackageObject(PackageDescriptor descriptor, Package pkg) throws PackageManifestException {
        try {
            return descriptor != null ? this.context.repositoryAccessor.getPackage(descriptor.getPackageType(), descriptor.getPackageName()) : this.context.repositoryAccessor.getPackage(pkg.getType(), pkg.getName());
        }
        catch (Exception exception) {
            if (descriptor != null) {
                descriptor.setValid(false);
            }
            throw new PackageManifestException("Obtaining package '" + String.valueOf(descriptor) + "' from repository failed.", exception);
        }
    }

    private void updatePackageInRepository(Package pkg, Package newPkg, boolean autoload, RuntimeExchange.UpdatePackageData data) throws PackageManifestException {
        boolean needUpdate = false;
        if (newPkg != null && !pkg.equalsFully(newPkg)) {
            newPkg.listJARs().stream().filter(jar -> !pkg.containsJAR((String)jar)).collect(Collectors.toList());
            ((AbstractPackage)pkg).update(newPkg);
            needUpdate = true;
        }
        if (((AbstractPackage)pkg).isAutoloadNotSet() || pkg.isAutoload() != autoload) {
            ((AbstractPackage)pkg).setAutoload(autoload);
            if (newPkg == null) {
                ((AbstractPackage)pkg).nextVersion();
            }
            needUpdate = true;
        }
        if (needUpdate) {
            data.pkg = pkg;
            this.updatePackageInRepository(pkg);
        }
    }

    private void updatePackageInRepository(Package pkg, Package newPkg) throws PackageManifestException {
        if (!pkg.equalsFully(newPkg)) {
            ((AbstractPackage)pkg).update(newPkg);
            this.updatePackageInRepository(pkg);
        }
    }

    private Package updatePackageInRepository(Package pkg) throws PackageManifestException {
        try {
            this.context.repositoryAccessor.updatePackageForced(pkg);
            return pkg;
        }
        catch (Exception exception) {
            throw new PackageManifestException(exception);
        }
    }

    @Override
    public void setPackageScope(String name, boolean global) throws NamingException, PackageManifestException {
        if (!this.isPackageGeneric(name)) {
            throw new PackageManifestException("Only SDO or Collection packages can change global state.");
        }
        try {
            this.context.exchange.setPackageScope(this, name, global);
        }
        catch (Exception exception) {
            if (exception instanceof PackageManifestException) {
                throw (PackageManifestException)exception;
            }
            throw new PackageManifestException("Unexpected exception.", exception);
        }
    }

    synchronized PackageDescriptor doSetPackageScopeCore(String name, boolean global) throws NamingException, PackageManifestException {
        PackageDescriptor descriptor = this.doGetPackage(name);
        if (descriptor.isGlobal() != global) {
            if (global && !this.isPackageLoaded(name)) {
                throw new PackageManifestException("Package '" + name + "' not loaded and cannot be made global.");
            }
            this.updatePackagePosition(descriptor, global);
            ((AbstractPackageDescriptor)descriptor).setGlobal(global);
            this.doSaveManifest();
            Trace.logInfo(this, "Scope of package '" + name + "' changed.");
            return descriptor;
        }
        return null;
    }

    private void updatePackagePosition(PackageDescriptor descriptor, boolean global) throws NamingException, PackageManifestException {
        int lastGlobalPackagePosition = this.getLastGlobalPackagePosition();
        int newPosition = global ? lastGlobalPackagePosition + 1 : lastGlobalPackagePosition;
        if (this.getPosition(descriptor) != newPosition) {
            this.doChangePackagePosition(descriptor, newPosition);
        }
    }

    private void doChangePackagePosition(PackageDescriptor descriptor, int newPosition) throws NamingException, PackageManifestException {
        boolean isLoaded = this.isPackageLoaded(descriptor.getFullName());
        if (isLoaded) {
            this.doUnloadPackageCore(descriptor.getFullName(), false);
        }
        this.doUpdatePackageInManifest(descriptor, newPosition);
        if (isLoaded) {
            this.doLoadPackageCore(descriptor.getFullName(), false);
        }
    }

    private int getLastGlobalPackagePosition() {
        int result = 0;
        for (PackageDescriptor descriptor : this.manifest.getPackages()) {
            if (!descriptor.isGlobal()) break;
            ++result;
        }
        return result;
    }

    @Override
    public void removePackage(String name) throws NamingException, PackageManifestException {
        this.doRemovePackage(name, false);
    }

    protected void doRemovePackage(String name, boolean notify) throws PackageManifestException, NamingException {
        if (notify && this.context.isCoherenceAgentBound() && this.isPackageGeneric(name)) {
            try {
                this.context.exchange.removePackage(this, name);
            }
            catch (Exception exception) {
                if (exception instanceof PackageManifestException) {
                    throw (PackageManifestException)exception;
                }
                throw new PackageManifestException("Unexpected exception.", exception);
            }
        } else {
            this.doRemovePackageCore(name);
        }
    }

    synchronized PackageDescriptor doRemovePackageCore(String name) throws PackageManifestException, NamingException {
        PackageDescriptor descriptor = this.doGetPackage(name);
        if (this.isPackageLoaded(name)) {
            throw new PackageManifestException("Package '" + name + "' is loaded and cannot be removed.");
        }
        this.manifest.remove(name);
        this.doSaveManifest();
        Trace.logInfo(this, "Package '" + name + "' removed.");
        return descriptor;
    }

    @Override
    public List<PackageDescriptor> getPackages() {
        return this.manifest.getPackages().stream().map(this::doCopy).collect(Collectors.toList());
    }

    @Override
    public ClassLoader getManifestClassLoader() {
        return this.loaderRegistry.getSystemClassLoaderChain();
    }

    @Override
    public PackageLoaderRegistry getLoaderRegistry() {
        return this.loaderRegistry;
    }

    ClassLoaderRegistry getClassLoaderRegistry() {
        return this.loaderRegistry;
    }

    @Override
    public void loadPackage(String name) throws NamingException, PackageManifestException {
        this.loadPackage(name, true);
    }

    @Override
    public void loadPackage(String name, boolean checkDependencies) throws NamingException, PackageManifestException {
        this.doLoadPackage(name, checkDependencies, false);
    }

    protected void doLoadPackage(String name, boolean checkDependencies, boolean notify) throws NamingException, PackageManifestException {
        if (notify && this.context.isCoherenceAgentBound() && this.isPackageGeneric(name)) {
            try {
                this.context.exchange.loadPackage(this, name, checkDependencies);
            }
            catch (Exception exception) {
                if (exception instanceof PackageManifestException) {
                    throw (PackageManifestException)exception;
                }
                throw new PackageManifestException("Unexpected exception.", exception);
            }
        } else {
            this.doLoadPackageCore(name, checkDependencies);
        }
    }

    synchronized RuntimeExchange.LoadPackageData doLoadPackageCore(String name, boolean checkDependencies) throws NamingException, PackageManifestException {
        return this.doLoadPackageCore(this.doGetPackage(name), checkDependencies);
    }

    synchronized RuntimeExchange.LoadPackageData doLoadPackageCore(PackageDescriptor descriptor, boolean checkDependencies) throws PackageManifestException {
        Trace.logDebug(this, "Loading package '" + String.valueOf(descriptor) + "'...");
        Package pkg = this.getPackageObject(descriptor, null);
        if (this.isPackageLoaded(descriptor)) {
            throw new PackageManifestException("Package '" + descriptor.getFullName() + "' already loaded.");
        }
        this.checkNonChainedRoot(descriptor);
        try {
            List<SemanticType> relatedTypes = this.doLoadPackage(descriptor, pkg, true);
            if (relatedTypes != null) {
                InternalUtils.checkRelatedEntities(this.context, relatedTypes, true, !checkDependencies);
            }
        }
        catch (Exception exception) {
            if (exception instanceof PackageManifestException) {
                throw (PackageManifestException)exception;
            }
            throw new PackageManifestException("Loading package '" + descriptor.getFullName() + "' failed.", exception);
        }
        Trace.logInfo(this, "Package '" + String.valueOf(descriptor) + "' loaded.");
        return new RuntimeExchange.LoadPackageData(descriptor, pkg, checkDependencies);
    }

    private List<SemanticType> doLoadPackage(PackageDescriptor descriptor, Package pkg, boolean checkDependencies) throws Exception {
        try {
            PackageDescriptor parentPackage;
            List<String> jars = pkg.listJARs();
            URL[] urls = new URL[jars.size()];
            for (int i = 0; i < jars.size(); ++i) {
                urls[i] = this.context.getRepositoryAccessor().getArchiveURL(jars.get(i));
            }
            int position = this.manifest.getPosition(descriptor);
            FabricClassLoader loader = position < this.manifest.size() && descriptor.useChainedLoader() ? (FabricClassLoader)this.loaderRegistry.registerChainedClassLoader(pkg, urls, (parentPackage = this.findParentLoadedPackage(position)) != null ? parentPackage.getFullName() : null, this.loadAsRoot(position)) : (FabricClassLoader)this.loaderRegistry.registerClassLoader(pkg, urls, descriptor.useChainedLoader(), descriptor.loadAsRoot());
            loader.setPackage(descriptor, pkg);
            List<SemanticType> result = null;
            if (!this.initOrDestroyInProgress && checkDependencies) {
                result = SemanticUtils.getRelatedSemanticTypes(Arrays.asList(urls), (FabricContext)this.context);
            }
            descriptor.setValid(true);
            return result;
        }
        catch (Exception exception) {
            descriptor.setValid(false);
            throw exception;
        }
    }

    Package getPackageData(PackageDescriptor descriptor, boolean needReply) throws PackageManifestException {
        Object jars = null;
        try {
            Package pkg = this.context.repositoryAccessor.getPackage(descriptor.getPackageType(), descriptor.getPackageName());
            if (needReply) {
                this.checkJARs(pkg);
            }
            return pkg;
        }
        catch (Exception exception) {
            descriptor.setValid(false);
            throw new PackageManifestException("Obtaining package '" + String.valueOf(descriptor) + "' from Repository failed.", exception);
        }
    }

    private void checkJARs(Package pkg) throws Exception {
        for (String jarName : pkg.listJARs()) {
            if (this.context.repositoryAccessor.existsArchive(jarName)) continue;
            throw new PackageManifestException("Archive '" + jarName + "' does not exist.");
        }
    }

    private PackageDescriptor findParentLoadedPackage(int position) {
        while (--position > 0) {
            PackageDescriptor result = this.manifest.get(position);
            if (!this.isPackageLoaded(result)) continue;
            return result;
        }
        return null;
    }

    private boolean loadAsRoot(int position) {
        while (++position <= this.manifest.size()) {
            if (!this.isPackageLoaded(this.manifest.get(position))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void unloadPackage(String name) throws NamingException, PackageManifestException {
        this.unloadPackage(name, true);
    }

    @Override
    public void unloadPackage(String name, boolean checkDependencies) throws NamingException, PackageManifestException {
        this.doUnloadPackage(name, checkDependencies, false);
    }

    protected void doUnloadPackage(String name, boolean checkDependencies, boolean notify) throws NamingException, PackageManifestException {
        if (notify && this.context.isCoherenceAgentBound() && this.isPackageSynchronizable(name)) {
            try {
                this.context.exchange.unloadPackage(this, name, checkDependencies);
            }
            catch (Exception exception) {
                if (exception instanceof PackageManifestException) {
                    throw (PackageManifestException)exception;
                }
                throw new PackageManifestException("Unexpected exception.", exception);
            }
        } else {
            this.doUnloadPackageCore(name, checkDependencies);
        }
    }

    synchronized PackageDescriptor doUnloadPackageCore(String name, boolean checkDependencies) throws NamingException, PackageManifestException {
        PackageDescriptor descriptor = this.doGetPackage(name);
        Trace.logDebug(this, "Unloading package '" + String.valueOf(descriptor) + "'...");
        try {
            Package pkg = this.context.getRepositoryAccessor().getPackage(descriptor.getPackageType(), descriptor.getPackageName());
            if (pkg == null) {
                throw new PackageManifestException("Package '" + name + "' not found in Repository.");
            }
            if (!this.isPackageLoaded(name)) {
                throw new PackageManifestException("Package '" + name + "' not loaded.");
            }
            List<SemanticType> relatedTypes = null;
            if (!this.initOrDestroyInProgress && checkDependencies) {
                relatedTypes = SemanticUtils.getRelatedSemanticTypes(pkg, this.context);
            }
            this.loaderRegistry.unregisterClassLoader(pkg.getFullName(), false, relatedTypes);
            if (!this.initOrDestroyInProgress) {
                this.checkDependentPackages(descriptor);
                if (checkDependencies) {
                    InternalUtils.checkRelatedEntities(this.context, relatedTypes, false, false);
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof PackageManifestException) {
                throw (PackageManifestException)exception;
            }
            throw new PackageManifestException("Unloading package '" + name + "' failed.", exception);
        }
        Trace.logInfo(this, "Package '" + String.valueOf(descriptor) + "' unloaded.");
        return descriptor;
    }

    protected void checkDependentPackages(PackageDescriptor descriptor) {
    }

    @Override
    public boolean isPackageLoaded(String name) {
        return this.loaderRegistry.isPackageRegistered(name);
    }

    public boolean isPackageLoaded(PackageDescriptor descriptor) {
        return this.isPackageLoaded(descriptor.getFullName());
    }

    @Override
    public List<String> listLoadedPackages() {
        return this.listPackages().stream().filter(this::isPackageLoaded).collect(Collectors.toList());
    }

    @Override
    public void validatePackage(String name) throws NamingException, PackageManifestException {
        PackageDescriptor descriptor = this.doGetPackage(name);
        if (!descriptor.isGeneric()) {
            throw new PackageManifestException("Package '" + name + "' is not SDO or Collection.");
        }
        this.doValidatePackage(name, true);
    }

    protected void doValidatePackage(String name, boolean notify) throws NamingException, PackageManifestException {
        if (notify && this.context.isCoherenceAgentBound() && this.isPackageSynchronizable(name)) {
            try {
                this.context.exchange.validatePackage(this, name);
            }
            catch (Exception exception) {
                if (exception instanceof PackageManifestException) {
                    throw (PackageManifestException)exception;
                }
                throw new PackageManifestException("Unexpected exception.", exception);
            }
        } else {
            this.doValidatePackageCore(name);
        }
    }

    synchronized void doValidatePackageCore(String name) throws NamingException, PackageManifestException {
        PackageDescriptor descriptor = this.doGetPackage(name);
        Trace.logDebug(this, "Validating package '" + String.valueOf(descriptor) + "'...");
        try {
            Package pkg = this.context.getRepositoryAccessor().getPackage(descriptor.getPackageType(), descriptor.getPackageName());
            if (pkg == null) {
                throw new PackageManifestException("Package '" + name + "' is not found in repository.");
            }
            if (!this.isPackageLoaded(name)) {
                throw new PackageManifestException("Package '" + name + "' is not loaded.");
            }
            List<SemanticType> relatedTypes = SemanticUtils.getRelatedSemanticTypes(pkg, this.context);
            InternalUtils.checkRelatedEntities(this.context, relatedTypes, true, false);
        }
        catch (Exception exception) {
            if (exception instanceof PackageManifestException) {
                throw (PackageManifestException)exception;
            }
            throw new PackageManifestException("Validating package '" + name + "' failed.", exception);
        }
        Trace.logInfo(this, "Package '" + String.valueOf(descriptor) + "' validated.");
    }

    @Override
    public PackageDescriptor getPackageByArchive(String archiveName) throws PackageManifestException {
        try {
            Package pkg = this.context.getRepositoryAccessor().getPackageByArchive(archiveName);
            return pkg != null ? this.getPackage(pkg.getFullName()) : null;
        }
        catch (Exception exception) {
            if (exception instanceof PackageManifestException) {
                throw (PackageManifestException)exception;
            }
            throw new PackageManifestException("Obtaining package by archive '" + archiveName + "' failed.", exception);
        }
    }

    @Override
    public PackageDescriptor getPackageBySemanticType(SemanticType type) {
        try {
            ClassLoader classLoader = ClassUtils.loadClass(type.getClassName(), this.context.getSystemClassLoaderChain()).getClassLoader();
            if (classLoader instanceof FabricClassLoader && ((FabricClassLoader)classLoader).getPackageDescriptor() != null) {
                return this.doCopy(((FabricClassLoader)classLoader).getPackageDescriptor());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private PackageDescriptor doCopy(PackageDescriptor descriptor) {
        return descriptor != null ? descriptor.clone() : null;
    }

    protected void clear() throws PackageManifestException, NamingException {
        for (PackageDescriptor descriptor : this.manifest.getPackages()) {
            this.unloadPackage(descriptor.getFullName());
            this.removePackage(descriptor.getFullName());
        }
        this.doSaveManifest();
    }

    protected void doInit() throws PackageManifestException {
        if (!this.initOrDestroyInProgress) {
            this.initOrDestroyInProgress = true;
            Trace.logDebug(this, "Initializing " + this.getManifestType() + " Package Manifest" + this.forComponent() + "...");
            this.processServicePackages();
            this.processGlobalPackages();
            ArrayList<String> invalidPackages = new ArrayList<String>();
            Pair<Object, Boolean> pkg = new Pair<Object, Boolean>(null, false);
            for (PackageDescriptor descriptor : this.manifest.getPackages()) {
                this.checkPackageOnInit(descriptor, pkg);
                if (pkg.first != null) {
                    this.checkDependencies((Package)pkg.first);
                    if (descriptor.isAutoload() && !this.isPackageLoaded(descriptor)) {
                        Trace.logDebug(this, "Loading package '" + descriptor.getPackageName() + "'...");
                        if (this.isNonChainedRoot(descriptor)) {
                            Trace.logError(this, "Package '" + descriptor.getFullName() + "' is not chained and can not be registered as root.");
                            continue;
                        }
                        try {
                            this.doLoadPackage(descriptor, (Package)pkg.first, true);
                            Trace.logInfo(this, "Package '" + String.valueOf(descriptor) + "' loaded.");
                        }
                        catch (Throwable exception) {
                            Trace.logException(this, exception, true);
                            Trace.logError(this, "Loading package '" + descriptor.getFullName() + "' failed.");
                        }
                        continue;
                    }
                    this.checkPackage(descriptor, (Package)pkg.first);
                    continue;
                }
                invalidPackages.add(descriptor.getFullName());
            }
            invalidPackages.forEach(pkgName -> {
                Trace.logInfo(this, "WARNING: Invalid package '" + pkgName + "' removed from Package Manifest.");
                this.manifest.remove((String)pkgName);
            });
            if (((Boolean)pkg.second).booleanValue()) {
                this.doSaveManifest();
            }
            Trace.logDebug(this, this.getManifestType() + " Package Manifest" + this.forComponent() + " initialized.");
            this.initOrDestroyInProgress = false;
        }
    }

    protected void processServicePackages() throws PackageManifestException {
        ArrayList<PackageDescriptor> servicePackages = new ArrayList<PackageDescriptor>();
        for (PackageDescriptor descriptor2 : this.manifest.getPackages()) {
            if (descriptor2.getPackageType() != PackageType.service) continue;
            Trace.logInfo(this, "WARNING: Package '" + String.valueOf(descriptor2) + "' cannot be registered in Runtime Package Manifest. Removing...");
            servicePackages.add(descriptor2);
        }
        if (!servicePackages.isEmpty()) {
            servicePackages.forEach(descriptor -> this.manifest.remove(descriptor.getFullName()));
            this.doSaveManifest();
        }
    }

    protected void processGlobalPackages() throws PackageManifestException {
        ArrayList<PackageDescriptor> globalPackages = new ArrayList<PackageDescriptor>();
        ArrayList<PackageDescriptor> localPackages = new ArrayList<PackageDescriptor>();
        boolean misplacedLocalPackages = false;
        for (PackageDescriptor descriptor : this.manifest.getPackages()) {
            if (descriptor.isGlobal()) {
                globalPackages.add(descriptor);
                if (localPackages.isEmpty()) continue;
                misplacedLocalPackages = true;
                continue;
            }
            localPackages.add(descriptor);
        }
        if (misplacedLocalPackages) {
            this.manifest.clear();
            globalPackages.forEach(this.manifest::add);
            localPackages.forEach(this.manifest::add);
            this.doSaveManifest();
        }
    }

    protected void checkDependencies(Package pkg) throws PackageManifestException {
    }

    void checkNonChainedRoot(PackageDescriptor descriptor) throws PackageManifestException {
        if (this.isNonChainedRoot(descriptor)) {
            descriptor.setValid(false);
            throw new PackageManifestException("Package '" + descriptor.getFullName() + "' is not chained and can not be loaded as root.");
        }
    }

    boolean isNonChainedRoot(PackageDescriptor descriptor) {
        return !descriptor.useChainedLoader() && descriptor.loadAsRoot();
    }

    protected void checkPackageOnInit(PackageDescriptor descriptor, Pair<AbstractPackage, Boolean> result) {
        try {
            result.first = this.context.getRepositoryAccessor().getPackage(descriptor.getPackageType(), descriptor.getPackageName());
            this.doCheckPackageOnInit(descriptor, result);
        }
        catch (Throwable exception) {
            result.first = null;
            result.second = true;
            Trace.logException(this, exception, true);
            Trace.logError(this, "Initialization of package '" + descriptor.getFullName() + "' failed. It will be removed from Package Manifest.");
        }
    }

    protected void doCheckPackageOnInit(AbstractPackageDescriptor descriptor, Pair<AbstractPackage, Boolean> result) throws Exception {
        boolean needUpdate = false;
        if (((Package)result.first).getType() == PackageType.service) {
            if (!descriptor.isAutoload()) {
                descriptor.setAutoload(true);
                result.second = true;
            }
            if (!((AbstractPackage)result.first).isAutoload()) {
                ((AbstractPackage)result.first).setAutoload(true);
                needUpdate = true;
            }
        }
        if (((AbstractPackage)result.first).isGlobalNotSet()) {
            if (descriptor.isGlobalNotSet()) {
                ((AbstractPackage)result.first).setGlobal();
            } else {
                ((AbstractPackage)result.first).setGlobal(descriptor.isGlobal());
            }
            needUpdate = true;
        }
        if (((AbstractPackage)result.first).isAutoloadNotSet()) {
            if (descriptor.isAutoloadNotSet()) {
                ((AbstractPackage)result.first).setAutoload(false);
            } else {
                ((AbstractPackage)result.first).setAutoload(descriptor.isAutoload());
            }
            needUpdate = true;
        }
        if (needUpdate) {
            this.updatePackageInRepository((Package)result.first);
        }
        if (descriptor.isGlobalNotSet() || descriptor.isGlobal() != ((AbstractPackage)result.first).isGlobal()) {
            descriptor.setGlobal(((AbstractPackage)result.first).isGlobal());
            result.second = true;
        }
        if (descriptor.isAutoloadNotSet() || descriptor.isAutoload() != ((AbstractPackage)result.first).isAutoload()) {
            descriptor.setAutoload(((AbstractPackage)result.first).isAutoload());
            result.second = true;
        }
    }

    private void checkPackage(AbstractPackageDescriptor descriptor, Package pkg) {
        try {
            if (!pkg.isValid()) {
                Trace.logError(this, "Package '" + pkg.getFullName() + "' is invalid.");
                descriptor.setValid(false);
            }
            descriptor.setValid(true);
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            descriptor.setValid(false);
        }
    }

    void load() throws Exception {
        Trace.logDebug(this, "Loading " + this.getManifestType() + " Package Manifest" + this.forComponent() + "...");
        this.doLoadManifest();
        this.doInit();
        Trace.logInfo(this, this.getManifestType() + " Package Manifest" + this.forComponent() + " loaded.");
    }

    void destroy() {
        if (!this.initOrDestroyInProgress) {
            this.initOrDestroyInProgress = true;
            Trace.logDebug(this, "Destroying " + this.getManifestType() + " Package Manifest" + this.forComponent() + "...");
            List<String> packages = this.listLoadedPackages();
            for (int i = packages.size() - 1; i >= 0; --i) {
                String pkgName = packages.get(i);
                try {
                    this.unloadPackage(pkgName);
                    continue;
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                    Trace.logError(this, "Unloading package '" + pkgName + "' failed.");
                }
            }
            this.completeDestroy();
            Trace.logInfo(this, this.getManifestType() + " Package Manifest" + this.forComponent() + " destroyed.");
            this.initOrDestroyInProgress = false;
        }
    }

    protected void completeDestroy() {
    }

    protected abstract void doSaveManifest() throws PackageManifestException;

    protected abstract void doLoadManifest() throws PackageManifestException;

    protected abstract String getManifestType();

    static boolean isPackageGeneric(PackageDescriptor descriptor) {
        return descriptor.isGeneric();
    }

    static boolean isPackageGeneric(PackageDescriptor descriptor, Package pkg) {
        return descriptor != null ? descriptor.isGeneric() : pkg.isGeneric();
    }

    boolean isPackageGeneric(String name) throws NamingException, PackageManifestException {
        return AbstractPackageManifestManager.isPackageGeneric(this.doGetPackage(name));
    }

    static boolean isPackageSynchronizable(PackageDescriptor descriptor) {
        return descriptor.isReplicable();
    }

    static boolean isPackageSynchronizable(PackageDescriptor descriptor, Package pkg) {
        return descriptor != null ? descriptor.isReplicable() : pkg.isReplicable();
    }

    boolean isPackageSynchronizable(String name) throws NamingException, PackageManifestException {
        return AbstractPackageManifestManager.isPackageSynchronizable(this.doGetPackage(name));
    }

    private synchronized PackageDescriptor doGetPackage(String fullName) throws NamingException, PackageManifestException {
        return this.checkPackageExistence(this.getPackageFromManifest(fullName), fullName);
    }

    private synchronized PackageDescriptor doGetPackage(PackageType type, String name) throws PackageManifestException {
        return this.checkPackageExistence(this.getPackageFromManifest(type, name), Package.getFullName(type, name));
    }

    private PackageDescriptor checkPackageExistence(PackageDescriptor descriptor, String fullName) throws PackageManifestException {
        if (descriptor == null) {
            throw new PackageManifestException("Package '" + fullName + "' is not registered.");
        }
        return descriptor;
    }

    protected String forComponent() {
        return "";
    }
}

