/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.repository.pkg.Package;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sdo.OpaqueDatagram;
import com.streamscape.sdo.event.OpaqueDatagramFactory;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.dispatcher.AbstractPackage;
import com.streamscape.sef.dispatcher.AbstractRuntimeContext;
import com.streamscape.sef.dispatcher.AbstractSLANGTool;
import com.streamscape.sef.dispatcher.LocalDSLOperation;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.evtrigger.function.types.Type;
import com.streamscape.sef.evtrigger.function.types.TypeFactory;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.FabricNodeRole;
import com.streamscape.sef.scheduler.Scheduler;
import com.streamscape.sef.scheduler.SchedulerState;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.slex.AbstractMFSession;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.completion.CompletionAdviser;
import com.streamscape.tools.mnode.ManagementNode;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class AbstractOperation<T extends AbstractRuntimeContext>
extends AbstractDSLOperation<T>
implements LocalDSLOperation {
    protected AbstractOperation() {
    }

    protected AbstractOperation(boolean isAdministrative, boolean isDiagnostic) {
        super(isAdministrative, isDiagnostic);
    }

    public boolean isSysadminVisible(MFSession session) {
        return super.isVisible(session) && this.isSysadminSession(session);
    }

    protected boolean isSysadminSession(MFSession session) {
        return session != null && ((AbstractRuntimeContext)this.callable).securityManagerImpl.isSysadmin((User)session.getOwner());
    }

    protected SLResponse invoke(String nodeName, SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invoke(nodeName, statement, session, timeout, false, false);
    }

    protected SLResponse invoke(String nodeName, SLStatement statement, MFSession session, long timeout, boolean broadcastAllowed, boolean mnodesOnly) throws Exception {
        return AbstractOperation.invoke((AbstractRuntimeContext)this.callable, this, nodeName, statement, session, timeout, broadcastAllowed, mnodesOnly);
    }

    public static <T extends AbstractRuntimeContext> SLResponse invoke(T callable, LocalDSLOperation operation, String nodeName, SLStatement statement, MFSession session, long timeout, boolean broadcastAllowed, boolean mnodesOnly) throws Exception {
        FabricNodeReference node;
        if (session.isInstant()) {
            return operation.invokeLocal(callable.getModerator().getFabricNode(), statement, (AbstractMFSession)session, timeout);
        }
        if (broadcastAllowed && nodeName != null && nodeName.equals("*")) {
            SLResponse result = operation.invokeLocal(callable.getModerator().getFabricNode(), statement, (AbstractMFSession)session, timeout);
            AbstractOperation.invokeBroadcast(callable, operation, statement, (AbstractMFSession)session, timeout, mnodesOnly, callable.getName(), result);
            return result;
        }
        FabricNodeReference fabricNodeReference = node = nodeName != null ? callable.getModerator().lookupFabricNode(nodeName) : callable.getModerator().getFabricNode();
        if (node == null) {
            return new SLResponse("Node not found.", false);
        }
        if (node.isLocal()) {
            return operation.invokeLocal(node, statement, (AbstractMFSession)session, timeout);
        }
        if (mnodesOnly && node.getRole() != FabricNodeRole.MANAGEMENT_NODE) {
            return new SLResponse(nodeName + " is not a Management Node.", false);
        }
        return AbstractOperation.invokeRemote(callable, node, statement, (AbstractMFSession)session, timeout);
    }

    protected SLResponse invokeLocal(SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        return this.invokeLocal(((AbstractRuntimeContext)this.callable).getModerator().getFabricNode(), statement, session, timeout);
    }

    @Override
    public SLResponse invokeLocal(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        return null;
    }

    protected SLResponse invokeRemote(FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        return ((AbstractRuntimeContext)this.callable).exchange.invokeSlangRequest(node.getName(), statement, session, timeout);
    }

    protected static <T extends AbstractRuntimeContext> SLResponse invokeRemote(T callable, FabricNodeReference node, SLStatement statement, AbstractMFSession session, long timeout) throws Exception {
        return callable.exchange.invokeSlangRequest(node.getName(), statement, session, timeout);
    }

    protected SLResponse invokeBroadcast(SLStatement statement, AbstractMFSession session, long timeout, boolean mnodesOnly, String localNode, SLResponse localResponse) throws Exception {
        Map<String, Object> responses = ((AbstractRuntimeContext)this.callable).exchange.broadcastSlangRequest(statement, session, timeout, mnodesOnly);
        return this.processBroadcastResponse(localNode, localResponse, responses);
    }

    protected static <T extends AbstractRuntimeContext> SLResponse invokeBroadcast(T callable, LocalDSLOperation operation, SLStatement statement, AbstractMFSession session, long timeout, boolean mnodesOnly, String localNode, SLResponse localResponse) throws Exception {
        Map<String, Object> responses = callable.exchange.broadcastSlangRequest(statement, session, timeout, mnodesOnly);
        return operation.processBroadcastResponse(localNode, localResponse, responses);
    }

    @Override
    protected void doRaiseSLMessage(SLMessage message) {
        AbstractOperation.raiseSLMessage(message);
    }

    public static void raiseSLMessage(SLMessage message) {
        if (RuntimeState.isActive() && RuntimeContext.isInitialized()) {
            if (message.getSLSessionName() != null) {
                try {
                    OpaqueDatagram event = OpaqueDatagramFactory.getInstance().createEvent("e.sys.sl.Message");
                    event.setData(message);
                    event.setEventKey(message.getComponentName() + ":" + message.getSLSessionName());
                    RuntimeContext.getInstance().getSystemConnection().raiseSystemEvent(event, EventScope.GLOBAL);
                }
                catch (Exception exception) {
                    Trace.logException(AbstractOperation.class, exception, true);
                    Trace.logError(AbstractOperation.class, "Raising of asynchronous SLMessage failed.");
                }
            }
        } else if (AbstractSLANGTool.MESSAGE_LISTENER != null) {
            AbstractSLANGTool.MESSAGE_LISTENER.onMessage(message);
        }
    }

    protected FabricConnection getFabricConnection() {
        return ((AbstractRuntimeContext)this.callable).getSystemConnection();
    }

    protected void getUserEventIds(List<String> completions) {
        for (String eventId : ((AbstractRuntimeContext)this.callable).getDatagramPrototypeCache().listEventIds()) {
            if (AbstractOperation.isReservedEvent(eventId) || AbstractOperation.isSystemEvent(eventId)) continue;
            completions.add("[" + eventId + "]");
        }
    }

    protected void addCompletionCommandInPreservedOrder(String command) {
        this.syntax.addCompletionCommand(command);
        this.setPreserveCompletionOrder();
    }

    protected String resolveTypeName(String typeName) {
        if (typeName != null) {
            Type<?> type = TypeFactory.getType(typeName);
            return type != null ? type.getName() : typeName;
        }
        return typeName;
    }

    protected static String getCreationTime(ComponentReference component) {
        return component.getTimestamp() != -1L ? DATE_TIME_FORMAT.format(component.getTimestamp()) : "n/a";
    }

    protected Scheduler getScheduler(User user) {
        return ((AbstractRuntimeContext)this.callable).schedulerImpl.getScheduler(user.getName().toString());
    }

    protected Scheduler getScheduler(MFSession session) {
        return this.getScheduler((User)session.getOwner());
    }

    protected static Scheduler getScheduler(AbstractRuntimeContext callable, User user) {
        return callable.schedulerImpl.getScheduler(user.getName().toString());
    }

    protected static Scheduler getScheduler(AbstractRuntimeContext callable, MFSession session) {
        return AbstractOperation.getScheduler(callable, (User)session.getOwner());
    }

    protected void checkSchedulerReady() throws Exception {
        SchedulerState state = ((AbstractRuntimeContext)this.callable).schedulerImpl.getState();
        if (state != SchedulerState.ACTIVE) {
            throw new Exception("Scheduler not active (in " + String.valueOf((Object)state) + " state).");
        }
    }

    protected void recoverScheduler() throws Exception {
        ((AbstractRuntimeContext)this.callable).schedulerImpl.recover();
    }

    protected Path getPathRelativeToWorkingDir(File file) {
        Path workingDir = new File(((AbstractRuntimeContext)this.callable).getStartupDir()).toPath();
        Path filePath = file.toPath();
        return filePath.startsWith(workingDir) ? workingDir.relativize(filePath) : filePath;
    }

    protected boolean isFullPathAllowed() {
        return AbstractOperation.isFullPathAllowed((AbstractRuntimeContext)this.callable);
    }

    public static boolean isFullPathAllowed(AbstractRuntimeContext callable) {
        return callable.getDataspaceStore().getProperties().isPropertyTrue("file.allow_full_path");
    }

    protected void checkFullPathAllowed(boolean condition) throws Exception {
        AbstractOperation.checkFullPathAllowed((AbstractRuntimeContext)this.callable, condition);
    }

    public static void checkFullPathAllowed(AbstractRuntimeContext callable, boolean condition) throws Exception {
        if (condition && !AbstractOperation.isFullPathAllowed(callable)) {
            throw new Exception("Absolute path not allowed. Check 'file.allow_full_path' dataspace property.");
        }
    }

    protected static void setGlobal(Package pkg, boolean global) {
        ((AbstractPackage)pkg).setGlobal(global);
    }

    protected static void setAutoload(Package pkg, boolean autoload) {
        ((AbstractPackage)pkg).setAutoload(autoload);
    }

    protected String getMnodeName(FabricNodeReference node) {
        ManagementNode mnode = this.getManagementNodeObject(node);
        return mnode != null ? mnode.getName() : null;
    }

    protected ManagementNode getManagementNodeObject(FabricNodeReference node) {
        try {
            if (node.getRole() == FabricNodeRole.TASK_NODE) {
                return (ManagementNode)((AbstractRuntimeContext)this.callable).getRepositoryAccessor().lookupObject("sys/mf", "ManagementNode");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    protected void authenticate(String userName, String password) throws SecurityManagerException {
        ((AbstractRuntimeContext)this.callable).securityManagerImpl.authenticate(userName, password);
    }

    public static class SemanticTypeCompletionAdviser
    implements CompletionAdviser<RuntimeContext> {
        @Override
        public List<String> getCompletions(String script, String processedScript, RuntimeContext callable, MFSession session) {
            return callable.getSemanticTypeCache().listSemanticTypes();
        }

        @Override
        public boolean isCaseSensitive() {
            return false;
        }
    }

    public static enum Scale {
        BYTES,
        KB,
        MB,
        GB;

        private static final long Byte = 1L;
        private static final long Kilobyte = 1024L;
        private static final long Megabyte = 0x100000L;
        private static final long Gigabyte = 0x40000000L;

        public String format(long value) {
            if (value >= 0L) {
                switch (this.ordinal()) {
                    case 0: {
                        return value + " bytes";
                    }
                    case 1: {
                        return String.format("%.0f KB", (double)value / 1024.0);
                    }
                    case 2: {
                        return String.format("%.2f MB", (double)value / 1048576.0);
                    }
                    case 3: {
                        return String.format("%.2f GB", (double)value / 1.073741824E9);
                    }
                }
                throw new RuntimeException("Invalid Scale!");
            }
            return "n/a";
        }
    }

    protected class EventIdCompletionAdviser
    extends AbstractDSLOperation.AbstractCompletionAdviser {
        @Override
        public List<String> doGetCompletions(String processedScript, MFSession session) {
            ArrayList<String> result = new ArrayList<String>();
            AbstractOperation.this.getUserEventIds(result);
            return result;
        }
    }
}

