/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.lib.utils.ClassUtils;
import com.streamscape.omf.FactoryManagerException;
import com.streamscape.omf.java.JSerializerFactory;
import com.streamscape.omf.java.SerialSchema;
import com.streamscape.omf.json.JSONSerializerFactory;
import com.streamscape.omf.mf.admin.ObjectMediationAliasManager;
import com.streamscape.omf.mf.admin.ObjectMediationFactoryManager;
import com.streamscape.omf.serializer.ClassLoaderProvider;
import com.streamscape.omf.serializer.SerializerFactory;
import com.streamscape.omf.xml.XSerializerFactory;
import com.streamscape.sdo.AnnotationManager;
import com.streamscape.sdo.rowset.RowSet;
import com.streamscape.sef.dispatcher.AbstractAliasManager;
import com.streamscape.sef.dispatcher.AbstractFabricContextFactory;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractOMFManager
extends AbstractFabricContextFactory
implements ObjectMediationFactoryManager,
ClassLoaderProvider {
    protected Map<String, SerializerFactory> factories = new ConcurrentHashMap<String, SerializerFactory>();
    protected ObjectMediationAliasManager aliasManager = new ObjectMediationAliasManager(this);
    protected AnnotationManager annotationManager = new AnnotationManager(context, this.aliasManager);

    protected AbstractOMFManager() {
        AbstractOMFManager.checkContext();
        this.logDebug("Initializing Object Mediation Factory Manager...");
        try {
            this.addSerializerFactory(XSerializerFactory.class);
            this.addSerializerFactory(JSerializerFactory.class);
            this.addSerializerFactory(JSONSerializerFactory.class);
        }
        catch (FactoryManagerException exception) {
            throw new RuntimeException(exception);
        }
        this.logInfo("Object Mediation Factory Manager initialized.");
    }

    @Override
    public ObjectMediationAliasManager newAliasManager() {
        return new ObjectMediationAliasManager(this);
    }

    ObjectMediationAliasManager getAliasManager() {
        return this.aliasManager;
    }

    @Override
    public AnnotationManager getAnnotationManager() {
        return this.annotationManager;
    }

    @Override
    public void addSerializerFactory(Class factoryClass) throws FactoryManagerException {
        SerializerFactory factory;
        this.logDebug("Adding Serializer Factory '" + factoryClass.getName() + "'...");
        if (SerializerFactory.class.isAssignableFrom(factoryClass)) {
            try {
                this.logDebug("Initializing Serializer Factory '" + factoryClass.getName() + "'...");
                Method init = ClassUtils.getMethod(factoryClass, "init", new Class[]{AbstractOMFManager.class, ObjectMediationAliasManager.class});
                init.setAccessible(true);
                ClassUtils.invokeMethod(factoryClass, init, new Object[]{this, this.aliasManager});
                factory = (SerializerFactory)ClassUtils.invokeMethod(factoryClass, factoryClass.getDeclaredMethod("getInstance", new Class[0]), null);
                this.logDebug("Serializer Factory '" + factory.getName() + "' initialized.");
            }
            catch (Exception exception) {
                throw new FactoryManagerException(3036, (Throwable)exception);
            }
            if (this.factories.containsKey(factory.getName())) {
                throw new FactoryManagerException(3037, "Serializer factory '" + factory.getName() + "' already exists.");
            }
        } else {
            throw new FactoryManagerException(3035, "Class '" + factoryClass.getName() + "' is not an instance of '" + SerializerFactory.class.getName() + "'.");
        }
        this.factories.put(factory.getName(), factory);
        this.logInfo("Serializer Factory '" + factoryClass.getName() + "' added.");
    }

    @Override
    public void removeSerializerFactory(String factoryName) throws FactoryManagerException {
        this.logDebug("Removing Serializer Factory '" + factoryName + "'...");
        if (!this.factories.containsKey(factoryName)) {
            throw new FactoryManagerException(3038, "Serializer factory '" + factoryName + "' does not exist.");
        }
        this.factories.remove(factoryName).destroy();
    }

    @Override
    public SerializerFactory lookupSerializerFactory(String factoryName) {
        return this.factories.get(factoryName);
    }

    void destroy() {
        ((AbstractAliasManager)this.aliasManager).clear();
        this.aliasManager = null;
    }

    protected void addSerialSchema(String className, long serialVersion, SerialSchema schema) {
    }

    protected SerialSchema getSerialSchema(String className, long serialVersion) {
        return null;
    }

    protected void clearSerialSchemas() {
    }

    protected void fillSerialSchemas(String className, RowSet result) throws Exception {
    }

    protected Map<String, Integer> getSerialSchemaCount() throws Exception {
        return null;
    }

    protected List<Long> getSerialSchemaVersions(String className) {
        return null;
    }

    @Override
    public ClassLoader getClassLoader() {
        return AbstractOMFManager.getContext().getSystemClassLoaderChain();
    }

    protected void logInfo(String message) {
        Trace.logInfo(this.getClass(), message);
    }

    protected void logDebug(String message) {
        Trace.logDebug(this.getClass(), message);
    }
}

