/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.lib.utils.Pair;
import com.streamscape.omf.java.JSerializerException;
import com.streamscape.omf.java.SerialSchema;
import com.streamscape.repository.types.SemanticType;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.operation.SLMessage;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.FabricRequestListener;
import com.streamscape.sef.container.Container;
import com.streamscape.sef.dispatcher.AbstractFabricConnection;
import com.streamscape.sef.dispatcher.AbstractJSerializer;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.dispatcher.AbstractSLANGTool;
import com.streamscape.sef.dispatcher.FabricEventRequestConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventSinkFactoryImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.slang.SLSession;
import com.streamscape.slex.slang.SLSessionException;
import com.streamscape.tools.mnode.ManagementNode;
import com.streamscape.tools.mnode.activator.ActivatorMFSession;
import java.util.List;
import java.util.Map;

public abstract class AbstractMNodeContainer
extends Container {
    private transient AbstractFabricConnection connection;

    @Override
    public void doInit() throws FabricException {
        super.doInit();
        try {
            this.openConnection();
        }
        catch (Exception exception) {
            throw new FabricException("Opening internal MNodeContainer connection failed.", exception);
        }
    }

    @Override
    protected void doDestroy() {
        try {
            this.closeConnection();
        }
        catch (FabricConnectionException exception) {
            Trace.logException(AbstractMNodeContainer.class, exception, true);
            Trace.logError(AbstractMNodeContainer.class, "Closing internal MNodeContainer connection failed.");
        }
        super.doDestroy();
    }

    void openConnection() throws Exception {
        this.connection = (AbstractFabricConnection)new FabricConnectionFactory().createConnection();
        this.connection.setSystemName(AbstractMNodeContainer.getConnectionName(AbstractMNodeContainer.getContext().getName()));
        this.connection.open();
    }

    static String getConnectionName(String nodeName) {
        return "sys$MNodeContainer_" + nodeName;
    }

    protected String getConnectionFullName(String nodeName) {
        return ModeratorUtils.makeComponentFullName(nodeName, this.connection.getType(), AbstractMNodeContainer.getConnectionName(nodeName));
    }

    void closeConnection() throws FabricConnectionException {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    protected FabricConnection getFabricConnection() {
        return this.connection;
    }

    protected ManagementNode getManagementNodeObject(String nodeName) throws Exception {
        return (ManagementNode)AbstractMNodeContainer.getContext().exchange.raiseInternalRequest(nodeName, 131, null);
    }

    protected SLSession createSLSession() throws FabricConnectionException, SLSessionException {
        return this.connection.createSystemSLSession();
    }

    protected SLSession createSLSession(String nodeName) throws FabricConnectionException, SLSessionException {
        return this.connection.createSystemSLSession(nodeName);
    }

    protected void raiseEvent(ImmutableEventDatagram event, EventScope eventScope) throws Exception {
        this.connection.raiseSystemEvent(event, eventScope);
    }

    protected FabricNodeReference getFabricNode(String name) {
        return AbstractMNodeContainer.getContext().exchange.getFabricNode(name);
    }

    protected List<FabricNodeReference> getMNodes() {
        return AbstractMNodeContainer.getContext().exchange.getMNodes();
    }

    protected RequestConsumerReference createRequestConsumer(String name, FabricRequestListener listener, EventScope eventScope) throws Exception {
        return ((FabricEventRequestConsumerImpl)this.connection.createSystemRequestConsumer(name, listener, eventScope)).getReference();
    }

    protected EventAsyncConsumer createAsyncConsumer(String name, FabricEventListener listener, String eventId, String selector) throws Exception {
        return this.connection.createSystemEventAsyncConsumer(name, listener, eventId, selector, EventScope.GLOBAL, true);
    }

    protected void dropSystemConsumer(String name) {
        try {
            this.connection.dropSystemConsumer(name);
        }
        catch (FabricConnectionException exception) {
            this.logException(exception);
        }
    }

    protected Object invokeRoutedContainerRequest(String nodeName, byte[] data, long timeout) throws Exception {
        return AbstractMNodeContainer.getContext().exchange.invokeRoutedContainerRequest(nodeName, data, timeout);
    }

    protected Map<String, Object> broadcastRoutedContainerRequest(byte[] data, long timeout) throws Exception {
        return AbstractMNodeContainer.getContext().exchange.broadcastRoutedContainerRequest(data, timeout, true);
    }

    protected SLResponse invokeSlangRequest(SLStatement statement, MFSession session, long timeout) throws Exception {
        return this.invokeSlangRequest(AbstractMNodeContainer.getContext().getName(), statement, session, timeout);
    }

    protected SLResponse invokeSlangRequest(String nodeName, SLStatement statement, MFSession session, long timeout) throws Exception {
        return nodeName.equals(AbstractMNodeContainer.getContext().getName()) ? AbstractMNodeContainer.getContext().exchange.invokeSlangRequest(statement, session, timeout) : AbstractMNodeContainer.getContext().exchange.invokeSlangRequest(nodeName, statement, session, timeout);
    }

    protected void raiseSLMessage(SLMessage message) throws Exception {
        AbstractOperation.raiseSLMessage(message);
    }

    protected void joinSysplex(ActivatorMFSession session) throws Exception {
        Pair<Boolean, Throwable> result = AbstractMNodeContainer.getContext().exchange.joinSysplex(true, false);
        if (result.second != null) {
            throw new FabricException("Joining the sysplex failed.\n       Cause: " + AbstractSLANGTool.formatException((Throwable)result.second));
        }
    }

    protected void resetEvent(ImmutableEventDatagram event) throws Exception {
        FabricEventSinkFactoryImpl.reset(event);
    }

    protected SemanticType lookupSemanticClass(Class objectClass) {
        return context.getJSerializer().lookupSemanticClass(objectClass);
    }

    protected void setSerialSupport(SemanticType type, Class objectClass, SerialSchema serialSchema) throws JSerializerException {
        AbstractMNodeContainer.setSerialSupport(type, ((AbstractJSerializer)context.getJSerializer()).generateSerialSupport(objectClass, serialSchema));
    }
}

