/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.lib.evqueue.EventQueue;
import com.streamscape.lib.evqueue.FlowControlMode;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sef.dispatcher.AbstractFabricConnection;
import com.streamscape.sef.dispatcher.AbstractRuntimeFactory;
import com.streamscape.sef.enums.EventScope;
import java.util.Date;

public abstract class AbstractLogEventSender
extends AbstractRuntimeFactory {
    protected static AbstractLogEventSender instance = null;
    protected String sourceType;
    protected String sourceName;
    protected AbstractFabricConnection connection;
    protected EventQueue<ImmutableEventDatagram> eventQueue;
    protected long eventQueueThreadId;
    protected boolean isInitialized = false;

    static void init() {
        if (instance != null) {
            instance.doInit();
        }
    }

    static void destroy() {
        if (instance != null) {
            instance.doDestroy();
        }
    }

    protected void doInit() {
        if (!this.isInitialized) {
            try {
                this.openConnection();
                this.bindEvents();
                this.initEventQueue();
                this.sourceType = AbstractLogEventSender.getContext().getNodeRole().name();
                this.sourceName = AbstractLogEventSender.getContext().getName();
                this.isInitialized = true;
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Initializing LogEventSender failed.");
            }
        }
    }

    protected void doDestroy() {
        if (this.isInitialized) {
            this.isInitialized = false;
            try {
                this.destroyEventQueue();
                this.closeConnection();
            }
            catch (Throwable exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Destroying LogEventSender failed.");
            }
        }
    }

    private void openConnection() throws Exception {
        this.connection = (AbstractFabricConnection)new FabricConnectionFactory().createConnection();
        this.connection.setSystemName("LogEventSender_" + AbstractLogEventSender.getContext().getName());
        this.connection.open();
    }

    private void closeConnection() throws Exception {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    private void bindEvents() throws Exception {
        this.connection.bindProducerForSystem("event.log.Trace");
    }

    private void initEventQueue() {
        this.eventQueue = new EventQueue<ImmutableEventDatagram>("FSYS:Trace.LogEventSender", event -> {
            if (this.isInitialized) {
                try {
                    this.connection.raiseSystemEvent((ImmutableEventDatagram)event, EventScope.GLOBAL);
                }
                catch (Throwable exception) {
                    Trace.logException(Trace.class, exception, true);
                }
            }
        });
        this.eventQueue.setFlowControlMode(FlowControlMode.DROP);
        this.eventQueue.start();
        this.eventQueueThreadId = this.eventQueue.getDeliveryThreadId();
    }

    private void destroyEventQueue() {
        if (this.eventQueue != null) {
            this.eventQueue.close();
            this.eventQueue.stop();
            this.eventQueue = null;
        }
    }

    protected void sendEvent(Date timestamp, String level, String className, String message) throws Exception {
        this.doSendEvent(true, this.sourceType, this.sourceName, timestamp, level, className, null, null, message);
    }

    protected void sendEvent(String sourceType, String sourceName, Date timestamp, String level, String component, String entity, String message) throws Exception {
        this.doSendEvent(false, sourceType, sourceName, timestamp, level, null, component, entity, message);
    }

    private synchronized void doSendEvent(boolean isTrace, String sourceType, String sourceName, Date timestamp, String level, String className, String component, String entity, String message) throws Exception {
        if (this.isInitialized && Thread.currentThread().getId() != this.eventQueueThreadId) {
            this.eventQueue.enqueue(this.createEvent(isTrace, sourceType, sourceName, timestamp, level, className, component, entity, message));
        }
    }

    private EventDatagram createEvent(boolean isTrace, String sourceType, String sourceName, Date timestamp, String level, String className, String component, String entity, String message) throws Exception {
        MapEvent result = (MapEvent)EventDatagramFactory.getInstance().createEvent("event.log.Trace");
        result.setEventStringProperty("sourceType", sourceType);
        result.setEventStringProperty("sourceName", sourceName);
        result.setEventLongProperty("logTimestamp", timestamp.getTime());
        result.setEventStringProperty("level", level);
        if (isTrace) {
            result.setEventStringProperty("component", className);
        } else {
            result.setEventStringProperty("node", this.sourceName);
            result.setEventStringProperty("component", component);
            if (entity != null) {
                result.setEventStringProperty("entity", entity);
            }
        }
        result.setEventStringProperty("message", message);
        return result;
    }

    protected void finalize() throws Throwable {
        this.doDestroy();
        super.finalize();
    }
}

