/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.cli.tlp.ClientId;
import com.streamscape.cli.tlp.FabricConnectionFactory;
import com.streamscape.lib.evqueue.EventQueue;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.enums.ReplyMatchStrategy;
import com.streamscape.sdo.enums.RequestDistributionStrategy;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.dispatcher.AbstractFabricConnection;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.tools.log.monitor.LogEventForwarderState;

public abstract class AbstractLogEventForwarder {
    protected AbstractFabricConnection connection;
    protected EventQueue<MapEvent> externalEventQueue;

    protected void openConnection(String url, int reconnectAttempts, long reconnectInterval, String user, String password, String domain, String nodeName) throws Exception {
        FabricConnectionFactory factory = new FabricConnectionFactory(url);
        factory.setReconnectAttempts(reconnectAttempts);
        factory.setReconnectInterval(reconnectInterval);
        this.connection = (AbstractFabricConnection)factory.createConnection(user, password);
        ClientId clientId = new ClientId();
        clientId.setName(user);
        clientId.setDomain(domain);
        clientId.setResource("LogMonitor");
        clientId.add("node", nodeName);
        this.connection.setSystemName(clientId.toString());
        this.connection.open();
        this.connection.bindProducerFor("event.LogMonitor.Configuration");
        this.connection.bindProducerForSystem("event.log.monitor.Stream");
    }

    protected void closeConnection() throws Exception {
        this.connection.close();
        this.connection = null;
    }

    protected AcknowledgementEvent raiseRequest(EventDatagram event) throws Exception {
        return this.connection.raiseRequest(event, EventScope.GLOBAL, RequestDistributionStrategy.AUCTION, ReplyMatchStrategy.REPLY_TO, 5000L);
    }

    protected void raiseAcknowledgement(AcknowledgementEvent ack) throws Exception {
        this.connection.raiseAcknowledgement(ack, EventScope.GLOBAL, -1L);
    }

    protected void createConfigurationConsumer(String name, FabricEventListener listener) throws Exception {
        this.connection.createSystemEventAsyncConsumer("Configurator", listener, "event.LogMonitor.Configuration", "name = '" + name + "'", EventScope.GLOBAL, true).start();
    }

    protected void dropConfigurationConsumer() throws Exception {
        if (this.connection.isOpened()) {
            this.connection.dropSystemConsumer("Configurator");
        }
    }

    protected void raiseLogEvent(MapEvent event, EventScope eventScope) throws Exception {
        this.connection.raiseSystemEvent(event, eventScope);
    }

    protected LogEventForwarderState getState() throws Exception {
        if (this.connection != null) {
            if (this.connection.isOpened()) {
                return LogEventForwarderState.CONNECTED;
            }
            if (this.connection.isReconnecting()) {
                return LogEventForwarderState.RECONNECTING;
            }
        }
        return LogEventForwarderState.DISCONNECTED;
    }

    protected abstract void initExternalEventQueue();

    protected void destroyExternalEventQueue() {
        if (this.externalEventQueue != null) {
            this.externalEventQueue.close();
            this.externalEventQueue.stop();
            this.externalEventQueue = null;
        }
    }
}

