/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.loader.ClassLoaderReference;
import com.streamscape.lib.loader.FabricClassLoader;
import com.streamscape.repository.pkg.Package;
import com.streamscape.repository.types.SemanticType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

abstract class AbstractLoaderRegistry {
    protected Map<String, ClassLoader> loaders = new HashMap<String, ClassLoader>();
    protected Map<String, Package> packages = new HashMap<String, Package>();
    protected ClassLoaderReference systemClassLoader;
    protected LinkedList<ClassLoader> loadersChain = new LinkedList();

    AbstractLoaderRegistry() {
    }

    protected void addLoaderToChain(FabricClassLoader loader, ClassLoader parentLoader) throws Exception {
        int index = this.loadersChain.indexOf(parentLoader);
        if (index != -1) {
            ListIterator<ClassLoader> iterator = this.loadersChain.listIterator(index);
            iterator.next();
            iterator.add(loader);
            this.updateRemainingChain(iterator, loader);
        } else {
            this.loadersChain.add(loader);
        }
    }

    protected void removeLoaderFromChain(ClassLoader loader) throws Exception {
        int index = this.loadersChain.indexOf(loader);
        if (index != -1) {
            ListIterator<ClassLoader> iterator = this.loadersChain.listIterator(index);
            iterator.next();
            iterator.remove();
            this.updateRemainingChain(iterator, loader.getParent());
        }
    }

    private void updateRemainingChain(ListIterator<ClassLoader> iterator, ClassLoader currentParent) throws Exception {
        while (iterator.hasNext()) {
            ClassLoader currentLoader = iterator.next();
            this.onRemoveFabricClassLoader((FabricClassLoader)currentLoader, null);
            FabricClassLoader updatedCurrentLoader = new FabricClassLoader((FabricClassLoader)currentLoader, currentParent);
            iterator.set(updatedCurrentLoader);
            this.loaders.put(updatedCurrentLoader.getName(), updatedCurrentLoader);
            if (currentLoader.equals(ClassLoaderReference.getRealClassLoader(this.systemClassLoader))) {
                this.setSystemClassLoaderChain(updatedCurrentLoader);
            }
            currentParent = updatedCurrentLoader;
        }
    }

    protected abstract void onRemoveFabricClassLoader(FabricClassLoader var1, List<SemanticType> var2) throws Exception;

    public abstract void setSystemClassLoaderChain(ClassLoader var1);
}

