/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.lib.concurrent.worker.SingleTaskWorker;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.sdo.operation.AbstractSLStatement;
import com.streamscape.sdo.operation.PseudoSLResponse;
import com.streamscape.sdo.operation.SLResponse;
import com.streamscape.sdo.operation.SLStatement;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.deploy.DeploymentAdvisory;
import com.streamscape.sef.deploy.DeploymentAdvisoryType;
import com.streamscape.sef.dispatcher.AbstractFabricConnection;
import com.streamscape.sef.dispatcher.AbstractOperation;
import com.streamscape.sef.dispatcher.AbstractRuntimeContext;
import com.streamscape.sef.dispatcher.SLOperationLogger;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.slex.MFSession;
import com.streamscape.slex.file.SLFileInputStream;
import com.streamscape.slex.file.SLFileInputStreamFactory;
import com.streamscape.slex.file.SLFileSessionContext;
import com.streamscape.slex.lang.AbstractDSLOperation;
import com.streamscape.slex.lang.OperationTag;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class AbstractFrmNodeOperation<T extends RuntimeContext>
extends AbstractOperation<T> {
    protected boolean isAsync = true;
    protected AbstractDSLOperation.ProgressMonitor progressMonitor;

    protected AbstractFrmNodeOperation() {
    }

    protected AbstractFrmNodeOperation(boolean isAdministrative) {
        super(isAdministrative, false);
    }

    @Override
    protected void createDSLSyntax(String name) {
        super.createDSLSyntax(name);
        this.syntax.addTag(OperationTag.frm);
    }

    @Override
    public SLResponse invoke(SLStatement statement, final MFSession session, final long timeout) throws Exception {
        final Definition definition = (Definition)statement;
        if (definition.isAsync()) {
            this.checkBeforeExecute(definition, session);
            final SLOperationLogger.SLOperationLoggerContext currentContext = SLOperationLogger.getCurrentContext();
            SingleTaskWorker executor = new SingleTaskWorker("FRM:AsyncOperation.Executor", "Executes FRM operation asynchronously."){

                @Override
                protected void doExecute() throws FabricException {
                    AbstractFrmNodeOperation.this.progressMonitor = new AbstractDSLOperation.ProgressMonitor(AbstractFrmNodeOperation.this, session);
                    try {
                        SLOperationLogger.setCurrentContext(currentContext);
                        AbstractFrmNodeOperation.this.progressMonitor.start();
                        SLResponse response = AbstractFrmNodeOperation.this.execute(definition, session, timeout);
                        if (!response.isOK()) {
                            AbstractFrmNodeOperation.this.stopProgressMonitor();
                            if (response.getText() != null) {
                                AbstractFrmNodeOperation.this.raiseSLMessageError(response.getText(), session);
                            } else if (response.getException() != null) {
                                AbstractFrmNodeOperation.this.raiseSLMessageError(response.getException(), session);
                            }
                        }
                    }
                    catch (Exception error) {
                        AbstractFrmNodeOperation.this.stopProgressMonitor();
                        AbstractFrmNodeOperation.this.raiseSLMessageError(error, session);
                    }
                    finally {
                        AbstractFrmNodeOperation.this.stopProgressMonitor();
                        AbstractFrmNodeOperation.this.raiseSLMessage(null, session);
                        SLOperationLogger.unsetCurrentSession(session);
                    }
                }
            };
            executor.start();
            return new PseudoSLResponse();
        }
        this.checkBeforeExecute(definition, session);
        return this.execute(definition, session, timeout);
    }

    protected void checkBeforeExecute(Definition statement, MFSession session) throws Exception {
    }

    protected SLResponse execute(Definition statement, MFSession session, long timeout) throws Exception {
        return new SLResponse();
    }

    protected void stopProgressMonitor() {
        if (this.progressMonitor != null) {
            this.progressMonitor.stop();
            this.progressMonitor = null;
        }
    }

    protected void sleepProgressMonitor() {
        if (this.progressMonitor != null) {
            this.progressMonitor.sleep();
        }
    }

    protected void wakeUpProgressMonitor() {
        if (this.progressMonitor != null) {
            this.progressMonitor.wakeUp();
        }
    }

    protected static <T extends AbstractRuntimeContext> void raiseDeploymentAdvisory(T callable, DeploymentAdvisoryType type, String nodeName, String mnodeName) throws FabricException {
        try {
            FabricConnection connection = callable.getFabricConnection();
            if (connection instanceof AbstractFabricConnection) {
                ((AbstractFabricConnection)connection).raiseSystemAdvisory(new DeploymentAdvisory(type, nodeName, mnodeName), EventScope.GLOBAL);
            }
        }
        catch (Exception exception) {
            throw new FabricException("Raising of asynchronous SLMessage failed.", exception);
        }
    }

    protected static String createFrmPath(String frmPath) {
        if (!((String)frmPath).toLowerCase().endsWith(".frm")) {
            frmPath = (String)frmPath + ".frm";
        }
        return frmPath;
    }

    protected InputStream openFrmInputStream(MFSession session, Definition definition) throws Exception {
        return this.openFrmInputStream(session, definition, session.getSLSessionData().getSLFileSessionContext());
    }

    protected InputStream openFrmInputStream(MFSession session, Definition definition, SLFileSessionContext context) throws Exception {
        String frmPath = AbstractFrmNodeOperation.createFrmPath(definition.getFrmPath());
        SLFileInputStream inputStream = (SLFileInputStream)new SLFileInputStreamFactory().create(context, session, frmPath);
        try {
            inputStream.open();
        }
        catch (IOException exception) {
            throw new Exception("Opening FRM file '" + frmPath + "' failed. Cause: " + exception.getMessage());
        }
        return new BufferedInputStream(inputStream, session.getSLSessionData().getTransferBufferSize());
    }

    public static class Definition
    extends AbstractSLStatement {
        private String nodeName;
        private String frmPath;
        private boolean isAsync = true;

        protected Definition(String operationName, String nodeName, String frmPath, boolean isAsync) {
            super(operationName);
            this.nodeName = nodeName;
            this.frmPath = frmPath;
            this.isAsync = isAsync;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getFrmPath() {
            return this.frmPath;
        }

        public boolean isAsync() {
            return this.isAsync;
        }
    }
}

