/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.ds.schema.server.ServerObject;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricUnboundEventException;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.FabricEventAsyncConsumerImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.factory.connection.FactoryConnectionService;
import com.streamscape.slex.DSLComponent;
import com.streamscape.slex.MFSession;

public abstract class AbstractFactoryConnectionService
implements FactoryConnectionService,
SLCallable {
    protected AbstractFabricComponent component;
    protected ServerObject serverObject;
    protected int fetchSize = 300;

    @Override
    public void init(FabricComponent component, ServerObject serverObject) throws Exception {
        this.component = (AbstractFabricComponent)component;
        this.serverObject = serverObject;
        this.onInit();
    }

    protected abstract void onInit() throws Exception;

    @Override
    public void onServerDrop(ServerObject serverObject) {
    }

    public FabricComponent getComponent() {
        return this.component;
    }

    public ServerObject getServerObject() {
        return this.serverObject;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void raiseSystemAdvisory(AdvisoryEventDatagram event) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.component.raiseSystemAdvisory(event);
    }

    public FabricEventAsyncConsumerImpl createSystemEventAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws FabricEventDispatcherException {
        return this.component.dispatcher.createSystemEventAsyncConsumer(consumerName, listener, eventFilter, eventSelector, eventScope, noLocal);
    }

    public void raiseEvent(ImmutableEventDatagram event, EventScope eventScope, long timeToLive) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.component.raiseEvent(event, eventScope, timeToLive);
    }

    public void bindProducerFor(String eventId) throws FabricEventDispatcherException {
        this.component.bindProducerFor(eventId);
    }

    public void unbindProducerFor(String eventId) {
        this.component.unbindProducerFor(eventId);
    }

    protected void logDebug(String message) {
        if (this.component instanceof Logger) {
            ((Logger)((Object)this.component)).logDebug(message);
        } else {
            Trace.logDebug(this, message);
        }
    }

    protected void logInfo(String message) {
        if (this.component instanceof Logger) {
            ((Logger)((Object)this.component)).logInfo(message);
        } else {
            Trace.logInfo(this, message);
        }
    }

    protected void logError(String message) {
        if (this.component instanceof Logger) {
            ((Logger)((Object)this.component)).logError(message);
        } else {
            Trace.logError(this, message);
        }
    }

    protected <T> DSLComponent<T> getDSLComponent(final T callable) {
        return new DSLComponent<T>(){

            @Override
            public String getType() {
                return AbstractFactoryConnectionService.this.component.getType();
            }

            @Override
            public T getCallable() {
                return callable;
            }
        };
    }

    @Override
    public boolean isNativeContext(MFSession session) {
        return true;
    }
}

