/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.lib.timer.AbstractFabricTimerTask;
import com.streamscape.lib.timer.FabricTimer;
import com.streamscape.lib.timer.FabricTimerException;
import com.streamscape.lib.timer.FabricTimerManager;
import com.streamscape.lib.timer.FabricTimerState;
import com.streamscape.sdo.event.EventDatagramFactory;
import com.streamscape.sdo.event.MapEvent;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.dispatcher.AbstractFabricComponent;
import com.streamscape.sef.dispatcher.AbstractFabricConnection;
import com.streamscape.sef.dispatcher.AbstractFabricContextFactory;
import com.streamscape.sef.moderator.EventFlowEntity;
import java.util.Map;

public abstract class AbstractFabricTimerFactory
extends AbstractFabricContextFactory {
    protected static FabricTimer createTimer(String group, String name, long interval, int repeatCount, FabricConnection connection) throws FabricTimerException, FabricEventDispatcherException {
        return AbstractFabricTimerFactory.doCreateTimer(group, name, interval, repeatCount, ((AbstractFabricConnection)connection).component);
    }

    protected static FabricTimer createTimer(String group, String name, long interval, int repeatCount, FabricComponent component) throws FabricTimerException, FabricEventDispatcherException {
        return AbstractFabricTimerFactory.doCreateTimer(group, name, interval, repeatCount, (AbstractFabricComponent)component);
    }

    private static FabricTimer doCreateTimer(String group, String name, long interval, int repeatCount, AbstractFabricComponent component) throws FabricTimerException, FabricEventDispatcherException {
        return FabricTimerManager.getInstance().createTimer(group, name, new Task(component), interval, repeatCount);
    }

    private static class Task
    extends AbstractFabricTimerTask {
        private AbstractFabricComponent component;

        private Task(AbstractFabricComponent component) throws FabricEventDispatcherException {
            this.component = component;
            component.bindProducerForSystem("event.Timer");
            component.addSourceEventFlow("event.Timer", EventFlowEntity.RUNTIME_TIMER, null, component.getEventScope(), true);
        }

        @Override
        public void onStart(FabricTimer timer) {
            this.raiseTimerEvent(timer, FabricTimerState.STARTED);
        }

        @Override
        public void execute(FabricTimer timer) {
            this.raiseTimerEvent(timer, FabricTimerState.EXPIRED);
        }

        @Override
        public void onStop(FabricTimer timer) {
            this.raiseTimerEvent(timer, FabricTimerState.STOPPED);
            this.component.unbindProducerForSystem("event.Timer");
            this.component.removeSourceEventFlow("event.Timer", EventFlowEntity.RUNTIME_TIMER, null);
        }

        @Override
        public void onSuspend(FabricTimer timer) {
            this.raiseTimerEvent(timer, FabricTimerState.SUSPENDED);
        }

        @Override
        public void onResume(FabricTimer timer) {
            this.raiseTimerEvent(timer, FabricTimerState.RESUMED);
        }

        @Override
        public void onReset(FabricTimer timer) {
            this.raiseTimerEvent(timer, FabricTimerState.RESET);
        }

        @Override
        public void onCancel(FabricTimer timer) {
            this.raiseTimerEvent(timer, FabricTimerState.CANCELLED);
        }

        private void raiseTimerEvent(FabricTimer timer, FabricTimerState state) {
            try {
                MapEvent event = (MapEvent)EventDatagramFactory.getInstance().createEvent("event.Timer");
                event.setEventStringProperty("timerGroup", timer.getGroup());
                event.setEventStringProperty("timerName", timer.getName());
                event.setEventStringProperty("timerState", state.name());
                for (Map.Entry<String, Object> entry : timer.getValues()) {
                    event.setObject(entry.getKey(), entry.getValue());
                }
                this.component.raiseSystemEvent(event);
            }
            catch (Exception exception) {
                Trace.logException(this, exception, true);
                Trace.logError(this, "Raising 'event.Timer' event failed.");
            }
        }
    }
}

