/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.sef.dispatcher.AbstractFabricGroup;
import com.streamscape.sef.group.FabricGroup;
import com.streamscape.sef.group.FabricGroupManager;
import com.streamscape.sef.group.FabricGroupManagerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

abstract class AbstractFabricGroupManager
implements FabricGroupManager {
    Map<String, AbstractFabricGroup> groups;
    Map<Short, AbstractFabricGroup> groupsByUid;

    AbstractFabricGroupManager() {
    }

    private synchronized void initGroups() {
        if (this.groups == null) {
            this.groups = new ConcurrentHashMap<String, AbstractFabricGroup>();
            this.groupsByUid = new ConcurrentHashMap<Short, AbstractFabricGroup>();
        }
    }

    void addGroup(AbstractFabricGroup group) {
        this.initGroups();
        this.groups.put(group.getName(), group);
        this.groupsByUid.put(group.uid, group);
        Trace.logInfo(this, "Group '" + group.getName() + "' added.");
    }

    AbstractFabricGroup removeGroup(String name) {
        AbstractFabricGroup removedGroup;
        AbstractFabricGroup abstractFabricGroup = removedGroup = this.groups != null ? this.groups.remove(name) : null;
        if (removedGroup != null) {
            this.groupsByUid.remove(removedGroup.uid);
            Trace.logInfo(this, "Group '" + name + "' removed.");
        }
        return removedGroup;
    }

    void checkGroupExistence(String name) throws FabricGroupManagerException {
        if (this.groups != null && this.groups.containsKey(name)) {
            throw new FabricGroupManagerException(6125, "Group '" + name + "' already exists.");
        }
    }

    @Override
    public FabricGroup lookupGroup(String name) {
        return this.groups != null ? (FabricGroup)this.groups.get(name) : null;
    }

    @Override
    public boolean existsGroup(String name) {
        return this.groups != null && this.groups.containsKey(name);
    }

    @Override
    public List<FabricGroup> getGroups() {
        return this.groups != null ? new ArrayList<AbstractFabricGroup>(this.groups.values()) : new ArrayList();
    }

    @Override
    public List<String> listGroups() {
        ArrayList<String> result = this.groups != null ? new ArrayList<String>(this.groups.keySet()) : new ArrayList();
        Collections.sort(result);
        return result;
    }

    synchronized boolean hasGroups() {
        return this.groups != null && !this.groups.isEmpty();
    }

    AbstractFabricGroup getGroup(short uid) throws FabricGroupManagerException {
        AbstractFabricGroup result = this.doGetGroup(uid);
        if (result == null) {
            throw new FabricGroupManagerException(6126, "Group #" + uid + " does not exist.");
        }
        return result;
    }

    AbstractFabricGroup doGetGroup(short uid) {
        return this.groupsByUid != null ? this.groupsByUid.get(uid) : null;
    }

    void synchronizeGroups(List<FabricGroup> nodeGroups) {
        for (FabricGroup nodeGroup : nodeGroups) {
            FabricGroup sysplexGroup = this.lookupGroup(nodeGroup.getName());
            if (sysplexGroup != null) {
                ((AbstractFabricGroup)sysplexGroup).update((AbstractFabricGroup)nodeGroup);
                continue;
            }
            this.createGroup((AbstractFabricGroup)nodeGroup);
        }
    }

    abstract void createGroup(AbstractFabricGroup var1);

    synchronized void clear() {
        if (this.groups != null) {
            for (AbstractFabricGroup group : this.groups.values()) {
                group.clear();
            }
        }
    }
}

