/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.dispatcher.EventException;
import com.streamscape.sdo.AbstractNamedObject;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.ExchangeEventDispatcher;
import com.streamscape.sef.dispatcher.ExchangeEventPublisher;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.group.FabricGroup;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.Moderator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

abstract class AbstractFabricGroup
extends AbstractNamedObject
implements FabricGroup,
ExchangeEventPublisher {
    String description;
    Set<String> members;
    short uid = (short)-1;
    transient Moderator moderator;
    transient EventDispatcher dispatcher;

    AbstractFabricGroup(String name, String description, short uid) {
        super(name);
        this.description = description;
        this.uid = uid;
    }

    AbstractFabricGroup(AbstractFabricGroup other) {
        this(other.name, other.description, other.uid);
        this.members = other.members;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean hasMember(String name) {
        return this.members != null && this.members.contains(name);
    }

    @Override
    public boolean hasMembers() {
        return this.members != null && !this.members.isEmpty();
    }

    @Override
    public List<ComponentReference> getMembers() {
        ArrayList<ComponentReference> result = new ArrayList<ComponentReference>();
        if (this.members != null) {
            for (String memberName : this.listMembers()) {
                ComponentReference component = this.moderator.lookupComponent(memberName);
                if (component == null) continue;
                result.add(component);
            }
        }
        return result;
    }

    @Override
    public synchronized List<String> listMembers() {
        ArrayList<String> result = this.members != null ? new ArrayList<String>(this.members) : new ArrayList();
        Collections.sort(result);
        return result;
    }

    void addMember(ComponentReference component) {
        this.addMember(component.getName());
    }

    synchronized void addMember(String memberName) {
        this.initMembers();
        this.initDispatchers();
        this.members.add(memberName);
    }

    synchronized void removeMember(String memberName) {
        if (this.members != null) {
            this.members.remove(memberName);
        }
    }

    synchronized void initMembers() {
        if (this.members == null) {
            this.members = new HashSet<String>();
        }
    }

    void update(AbstractFabricGroup other) {
        if (other.hasMembers()) {
            this.initMembers();
            this.members.addAll(other.members);
        }
    }

    abstract void initDispatchers();

    void initDispatcher(AbstractExchange exchange) {
        this.dispatcher = new EventDispatcher(exchange);
        this.dispatcher.start();
        this.moderator = exchange.moderator;
    }

    abstract AbstractExchange.NetworkConsumersStore getNetworkDispatcher();

    void destroy() {
        if (this.dispatcher != null) {
            this.dispatcher.stop();
            this.dispatcher = null;
        }
    }

    void clear() {
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof AbstractFabricGroup && super.equals(other) && this.description.equals(((AbstractFabricGroup)other).description) && this.uid == ((AbstractFabricGroup)other).uid;
    }

    static class EventDispatcher
    extends ExchangeEventDispatcher {
        private EventDispatcher(AbstractExchange exchange) {
            super(exchange);
        }

        @Override
        protected synchronized void deliverEvent(ImmutableEventDatagram event, FabricAddress componentAddress) throws EventException {
            super.deliverEvent(event, componentAddress);
        }
    }
}

