/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.EventReceiver;
import com.streamscape.sef.EventRequestConsumer;
import com.streamscape.sef.dispatcher.AbstractFabricConsumer;
import com.streamscape.sef.dispatcher.FabricEventAsyncConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventDirectConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventReceiverImpl;
import com.streamscape.sef.dispatcher.FabricEventRequestConsumerImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

abstract class AbstractFabricConsumerStorage {
    private Map<String, FabricEventDirectConsumerImpl> directConsumers;
    private Map<String, FabricEventAsyncConsumerImpl> asyncConsumers;
    private Map<String, FabricEventRequestConsumerImpl> requestConsumers;
    private Map<String, FabricEventReceiverImpl> receivers;

    AbstractFabricConsumerStorage() {
    }

    void addDirectConsumer(String name, FabricEventDirectConsumerImpl consumer) {
        this.directConsumers = this.initConsumers(this.directConsumers);
        this.directConsumers.put(name, consumer);
    }

    FabricEventDirectConsumerImpl removeDirectConsumer(String name) {
        return this.removeConsumer(this.directConsumers, name);
    }

    public EventConsumer getEventConsumer(String name) {
        return this.getConsumer(this.directConsumers, name, false);
    }

    EventConsumer getSystemEventConsumer(String name) {
        return this.getConsumer(this.directConsumers, name, true);
    }

    public List<String> listEventConsumers() {
        return this.listConsumers(this.directConsumers);
    }

    void addAsyncConsumer(String name, FabricEventAsyncConsumerImpl consumer) {
        this.asyncConsumers = this.initConsumers(this.asyncConsumers);
        this.asyncConsumers.put(name, consumer);
    }

    FabricEventAsyncConsumerImpl removeAsyncConsumer(String name) {
        return this.removeConsumer(this.asyncConsumers, name);
    }

    public EventAsyncConsumer getEventAsyncConsumer(String name) {
        return this.getConsumer(this.asyncConsumers, name, false);
    }

    EventAsyncConsumer getSystemEventAsyncConsumer(String name) {
        return this.getConsumer(this.asyncConsumers, name, true);
    }

    public List<String> listEventAsyncConsumers() {
        return this.listConsumers(this.asyncConsumers);
    }

    void addRequestConsumer(String name, FabricEventRequestConsumerImpl consumer) {
        this.requestConsumers = this.initConsumers(this.requestConsumers);
        this.requestConsumers.put(name, consumer);
    }

    FabricEventRequestConsumerImpl removeRequestConsumer(String name) {
        return this.removeConsumer(this.requestConsumers, name);
    }

    public EventRequestConsumer getRequestConsumer(String name) {
        return this.getConsumer(this.requestConsumers, name, false);
    }

    EventRequestConsumer getSystemRequestConsumer(String name) {
        return this.getConsumer(this.requestConsumers, name, true);
    }

    public List<String> listRequestConsumers() {
        return this.listConsumers(this.requestConsumers);
    }

    void addReceiver(String name, FabricEventReceiverImpl receiver) {
        this.receivers = this.initConsumers(this.receivers);
        this.receivers.put(name, receiver);
    }

    FabricEventReceiverImpl removeReceiver(String name) {
        return this.removeConsumer(this.receivers, name);
    }

    public EventReceiver getEventReceiver(String name) {
        return this.getConsumer(this.receivers, name, false);
    }

    EventReceiver getSystemEventReceiver(String name) {
        return this.getConsumer(this.receivers, name, true);
    }

    public List<String> listEventReceivers() {
        return this.listConsumers(this.receivers);
    }

    private synchronized <T extends AbstractFabricConsumer> Map<String, T> initConsumers(Map<String, T> consumers) {
        return consumers == null ? new ConcurrentHashMap() : consumers;
    }

    private <T extends AbstractFabricConsumer> T removeConsumer(Map<String, T> consumers, String name) {
        return (T)(consumers != null ? (AbstractFabricConsumer)consumers.remove(name) : null);
    }

    private <T extends AbstractFabricConsumer> T getConsumer(Map<String, T> consumers, String name, boolean isSystem) {
        return (T)(consumers != null && (isSystem || !name.startsWith("sys$")) ? (AbstractFabricConsumer)consumers.get(name) : null);
    }

    private <T extends AbstractFabricConsumer> List<String> listConsumers(Map<String, T> consumers) {
        return consumers != null ? new ArrayList<String>(consumers.keySet()) : new ArrayList();
    }

    boolean existsConsumer(String name) {
        return this.existsConsumer(name, this.directConsumers) || this.existsConsumer(name, this.asyncConsumers) || this.existsConsumer(name, this.requestConsumers) || this.existsConsumer(name, this.receivers);
    }

    private <T extends AbstractFabricConsumer> boolean existsConsumer(String name, Map<String, T> consumers) {
        return consumers != null && consumers.containsKey(name);
    }

    synchronized void destroyConsumers(long timeout) {
        if (this.directConsumers != null) {
            for (FabricEventDirectConsumerImpl fabricEventDirectConsumerImpl : this.directConsumers.values()) {
                this.dropConsumer(fabricEventDirectConsumerImpl);
            }
            this.directConsumers = this.clearConsumers(this.directConsumers);
        }
        if (this.requestConsumers != null) {
            for (FabricEventRequestConsumerImpl fabricEventRequestConsumerImpl : this.requestConsumers.values()) {
                this.dropConsumer(fabricEventRequestConsumerImpl);
            }
            this.requestConsumers = this.clearConsumers(this.requestConsumers);
        }
        if (this.receivers != null) {
            for (FabricEventReceiverImpl fabricEventReceiverImpl : this.receivers.values()) {
                this.dropReceiver(fabricEventReceiverImpl);
            }
            this.receivers = this.clearConsumers(this.receivers);
        }
        if (this.asyncConsumers != null) {
            for (FabricEventAsyncConsumerImpl fabricEventAsyncConsumerImpl : this.asyncConsumers.values()) {
                this.dropConsumer(fabricEventAsyncConsumerImpl, timeout);
            }
            this.asyncConsumers = this.clearConsumers(this.asyncConsumers);
        }
    }

    private <T extends AbstractFabricConsumer> Map<String, T> clearConsumers(Map<String, T> consumers) {
        consumers.clear();
        return null;
    }

    abstract void dropConsumer(FabricEventDirectConsumerImpl var1);

    abstract void dropConsumer(FabricEventAsyncConsumerImpl var1, long var2);

    abstract void dropReceiver(FabricEventReceiverImpl var1);

    void dropConsumer(FabricEventRequestConsumerImpl consumer) {
    }

    void logException(Exception exception) {
        Trace.logException(this, exception, true);
    }

    void logError(String message) {
        Trace.logError(this, message);
    }

    void logInfo(String message) {
        Trace.logInfo(this, message);
    }

    void logDebug(String message) {
        Trace.logDebug(this, message);
    }
}

