/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.lib.filter.CompositeFilter;
import com.streamscape.lib.selector.SelectorExpression;
import com.streamscape.lib.selector.SelectorFormatException;
import com.streamscape.lib.selector.parser.SelectorParser;
import com.streamscape.sdo.CloneableDataObject;
import com.streamscape.sdo.NamedObject;
import com.streamscape.sef.EventSelectorFormatException;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.EndpointReferenceImpl;
import com.streamscape.sef.dispatcher.FabricEventDispatcherImpl;
import com.streamscape.sef.dispatcher.FabricGroupLinkImpl;
import com.streamscape.sef.dispatcher.InternalUtils;
import com.streamscape.sef.dispatcher.SinkEventFlowImpl;
import com.streamscape.sef.enums.EventScope;

abstract class AbstractFabricConsumer
extends CloneableDataObject
implements NamedObject {
    transient String name;
    transient EventScope eventScope;
    transient boolean noLocal;
    transient FabricEventDispatcherImpl dispatcher;
    transient FabricGroupLinkImpl groupLink;
    transient EndpointReferenceImpl reference;
    transient SinkEventFlowImpl eventFlow;

    AbstractFabricConsumer(String name, EventScope eventScope, boolean noLocal, FabricEventDispatcherImpl dispatcher, FabricGroupLinkImpl groupLink) {
        this.name = name;
        this.eventScope = eventScope;
        this.noLocal = noLocal;
        this.dispatcher = dispatcher;
        this.groupLink = groupLink;
    }

    void bind(EndpointReferenceImpl reference) {
        this.reference = reference;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public EventScope getEventScope() {
        return this.eventScope;
    }

    public boolean noLocal() {
        return this.noLocal;
    }

    public String getGroupName() {
        return this.groupLink != null ? this.groupLink.getGroup().getName() : null;
    }

    CompositeFilter getCompositeFilter() {
        return null;
    }

    String getEventFilter() {
        return null;
    }

    String getEventSelector() {
        return null;
    }

    abstract String getMode();

    SelectorExpression createSelectorExpression1(String eventSelector) throws FabricEventDispatcherException {
        try {
            return this.doCreateSelectorExpression(eventSelector);
        }
        catch (SelectorFormatException exception) {
            throw new FabricEventDispatcherException(6058, exception.getMessage(), exception.getCause());
        }
    }

    SelectorExpression createSelectorExpression2(String eventSelector) throws EventSelectorFormatException {
        try {
            return this.doCreateSelectorExpression(eventSelector);
        }
        catch (SelectorFormatException exception) {
            throw InternalUtils.createProtectedObject(EventSelectorFormatException.class, new Class[]{String.class, Throwable.class}, exception.getMessage(), exception.getCause());
        }
    }

    SelectorExpression doCreateSelectorExpression(String selector) throws SelectorFormatException {
        return selector != null ? SelectorParser.parse(selector, this.dispatcher.getSelectorDataSource()) : null;
    }

    void onChange(boolean deepChange) {
        if (this.dispatcher.isExchangeReady() && this.reference != null) {
            this.dispatcher.getExchange().changeConsumer(new AbstractExchange.ChangeConsumerData(this.reference, deepChange));
        }
    }

    void setEventFlow(SinkEventFlowImpl eventFlow) {
        this.eventFlow = eventFlow;
    }
}

