/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.cli.ClientContext;
import com.streamscape.cli.ClientState;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.tlp.FabricConnectionFactoryException;
import com.streamscape.lib.numalloc.LongNumberAllocatorSimple;
import com.streamscape.lib.utils.StringUtils;
import com.streamscape.lib.utils.Utils;
import com.streamscape.runtime.RuntimeContext;
import com.streamscape.runtime.RuntimeState;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.dispatcher.AbstractFabricContextFactory;
import com.streamscape.sef.dispatcher.LocalFabricConnection;
import com.streamscape.sef.dispatcher.RemoteFabricConnection;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.network.LinkProtocol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractFabricConnectionFactory
extends AbstractFabricContextFactory {
    static final String TLP_TYPE = "Client_TLP";
    static final String TLPS_TYPE = "Client_TLPS";
    static final String TLP_DESCRIPTION = "TLP Connection";
    static final String TLPS_DESCRIPTION = "TLPS Connection";
    private String name;
    private String type = "Client_TLP";
    private String description = "TLP Connection";
    private EventScope eventScope = EventScope.GLOBAL;
    private List<String> urls = new ArrayList<String>();
    private int reconnectAttempts = -1;
    private long reconnectInterval = 30L;
    private String userName;
    private String password;
    private String securityToken;
    protected static final Map<String, LongNumberAllocatorSimple> CLIENT_NUMBER_ALLOCATORS = new HashMap<String, LongNumberAllocatorSimple>();

    protected AbstractFabricConnectionFactory() {
    }

    protected AbstractFabricConnectionFactory(String url) throws FabricConnectionFactoryException {
        this(StringUtils.split(url, '&'));
    }

    protected AbstractFabricConnectionFactory(List<String> urls) throws FabricConnectionFactoryException {
        for (String url : urls) {
            this.addURL(url);
        }
    }

    protected FabricConnection createConnection() throws FabricConnectionFactoryException {
        FabricConnection result = this.createConnectionInstance();
        this.initConnectionParameters(result);
        return result;
    }

    protected FabricConnection createConnectionInstance() {
        if (RuntimeState.isActive()) {
            return this.createLocalConnectionInstance();
        }
        if (ClientState.isActive()) {
            return this.createRemoteConnectionInstance();
        }
        if (this.urls.isEmpty() || this.urls.contains(FabricConnection.LOCAL_URL)) {
            return this.createLocalConnectionInstance();
        }
        return this.createRemoteConnectionInstance();
    }

    protected void initConnectionParameters(FabricConnection connection) throws FabricConnectionFactoryException {
        try {
            this.initBasicConnectionParameters(connection);
            if (this.urls.isEmpty()) {
                connection.addURL(FabricConnection.LOCAL_URL);
            } else {
                for (String url : this.urls) {
                    connection.addURL(url);
                }
            }
            if (connection instanceof LocalFabricConnection) {
                ((LocalFabricConnection)connection).setURL();
            } else if (connection instanceof RemoteFabricConnection) {
                connection.setReconnectAttempts(this.reconnectAttempts);
                connection.setReconnectInterval(this.reconnectInterval);
            }
        }
        catch (FabricConnectionException exception) {
            throw new FabricConnectionFactoryException(exception.getErrorCode(), exception.toString());
        }
    }

    protected void initBasicConnectionParameters(FabricConnection connection) throws FabricConnectionException {
        this.doInitBasicConnectionParameters(connection);
        connection.setSecurityToken(this.securityToken);
    }

    protected void doInitBasicConnectionParameters(FabricConnection connection) throws FabricConnectionException {
        connection.setDescription(this.description);
        connection.setEventScope(this.eventScope);
        connection.setUserName(this.userName);
        connection.setPassword(this.password);
    }

    private FabricConnection createLocalConnectionInstance() {
        return new LocalFabricConnection(this.type, this.getClientName(), AbstractFabricConnectionFactory.getRuntimeContext());
    }

    private FabricConnection createRemoteConnectionInstance() {
        return new RemoteFabricConnection(this.type, AbstractFabricConnectionFactory.getClientContext());
    }

    protected FabricConnection createConnection(String userName, String password) throws FabricConnectionFactoryException {
        try {
            FabricConnection result = this.createConnection();
            result.setUserName(userName);
            result.setPassword(password);
            return result;
        }
        catch (FabricConnectionException exception) {
            throw new FabricConnectionFactoryException(exception.getErrorCode(), exception.toString());
        }
    }

    protected String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected String getType() {
        return this.type;
    }

    protected void setType(String type) {
        this.type = type;
    }

    protected String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) throws FabricConnectionFactoryException {
        if (description.length() > 20) {
            throw new FabricConnectionFactoryException(1009, "Description length cannot be more than 20 symbols.");
        }
        this.description = description;
    }

    protected synchronized void addURL(String url) throws FabricConnectionFactoryException {
        LinkProtocol protocol = null;
        try {
            if (!url.equals(FabricConnection.LOCAL_URL)) {
                protocol = LinkAddress.checkFormat(url);
            }
        }
        catch (FabricException exception) {
            throw new FabricConnectionFactoryException(1005, exception.getMessage());
        }
        if (!this.urls.contains(url)) {
            if (!this.urls.isEmpty()) {
                if (url.equals(FabricConnection.LOCAL_URL)) {
                    if (!this.urls.contains(FabricConnection.LOCAL_URL)) {
                        throw new FabricConnectionFactoryException(1006, "Local URL cannot be added to list of non-local URLs.");
                    }
                } else {
                    if (this.urls.contains(FabricConnection.LOCAL_URL)) {
                        throw new FabricConnectionFactoryException(1006, "Non-local URL cannot be added to list of local URLs.");
                    }
                    try {
                        if (!Utils.equalsNullSafe((Object)protocol, (Object)LinkAddress.extractProtocol(this.urls.get(0)))) {
                            throw new FabricConnectionFactoryException(1006, "URL '" + url + "' has different protocol than other URLs.");
                        }
                    }
                    catch (FabricException exception) {
                        throw new FabricConnectionFactoryException(1005, exception.getMessage());
                    }
                }
            }
            this.doAddURL(url);
            if (protocol == LinkProtocol.TLPS) {
                this.type = TLPS_TYPE;
                this.description = TLPS_DESCRIPTION;
            }
        }
    }

    protected void doAddURL(String url) {
        this.urls.add(url);
    }

    protected synchronized void removeURL(String url) {
        this.urls.remove(url);
    }

    protected List<String> getURLs() {
        return new ArrayList<String>(this.urls);
    }

    protected void setURL(String url) {
        this.urls.clear();
        this.urls.add(url);
    }

    protected int getReconnectAttempts() {
        return this.reconnectAttempts;
    }

    protected void setReconnectAttempts(int reconnectAttempts) {
        this.reconnectAttempts = reconnectAttempts;
    }

    protected long getReconnectInterval() {
        return this.reconnectInterval;
    }

    protected void setReconnectInterval(long reconnectInterval) throws FabricConnectionFactoryException {
        if (reconnectInterval <= 0L) {
            throw new FabricConnectionFactoryException(1006, "Reconnect interval must be positive.");
        }
        this.reconnectInterval = reconnectInterval;
    }

    protected EventScope getEventScope() {
        return this.eventScope;
    }

    protected void setEventScope(EventScope eventScope) {
        this.eventScope = eventScope;
    }

    protected String getUserName() {
        return this.userName;
    }

    protected void setUserName(String userName) {
        this.userName = userName;
    }

    protected String getPassword() {
        return this.password;
    }

    protected void setPassword(String password) {
        this.password = password;
    }

    protected String getSecurityToken() {
        return this.securityToken;
    }

    protected void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    protected String getClientName() {
        return AbstractFabricConnectionFactory.getClientName(this.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getClientName(String type) {
        Map<String, LongNumberAllocatorSimple> map = CLIENT_NUMBER_ALLOCATORS;
        synchronized (map) {
            if (!CLIENT_NUMBER_ALLOCATORS.containsKey(type)) {
                CLIENT_NUMBER_ALLOCATORS.put(type, new LongNumberAllocatorSimple());
            }
            return AbstractFabricConnectionFactory.getClientName(CLIENT_NUMBER_ALLOCATORS.get(type).getNumber(), AbstractFabricConnectionFactory.getRuntimeContext().getName());
        }
    }

    static String getClientName(long clientNumber, String nodeName) {
        return "Client" + clientNumber + "_" + nodeName.replace('.', '_');
    }

    private static synchronized RuntimeContext getRuntimeContext() {
        if (context == null) {
            RuntimeContext.getInstance();
        }
        return (RuntimeContext)context;
    }

    private static synchronized ClientContext getClientContext() {
        if (context == null) {
            ClientContext.getInstance();
        }
        return (ClientContext)context;
    }
}

