/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.cli.tlp.ClientId;
import com.streamscape.cli.tlp.FabricConnection;
import com.streamscape.cli.tlp.FabricConnectionException;
import com.streamscape.cli.tlp.PingResult;
import com.streamscape.cli.tlp.PingState;
import com.streamscape.lib.utils.ArchiveException;
import com.streamscape.repository.RepositoryException;
import com.streamscape.repository.cli.RepositoryAccessor;
import com.streamscape.repository.types.AbstractSemanticFactory;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ExceptionEventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.AcknowledgeAction;
import com.streamscape.sdo.enums.CacheThresholdAction;
import com.streamscape.sdo.enums.ExceptionStrategy;
import com.streamscape.sdo.enums.ReplyMatchStrategy;
import com.streamscape.sdo.enums.RequestDistributionStrategy;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.mf.admin.DatagramFactoryException;
import com.streamscape.sdo.mf.admin.SemanticTypeFactoryException;
import com.streamscape.sdo.operation.SLAudioMessage;
import com.streamscape.sdo.operation.SLFileMessage;
import com.streamscape.sef.DomainConstraint;
import com.streamscape.sef.EventAsyncConsumer;
import com.streamscape.sef.EventCache;
import com.streamscape.sef.EventConsumer;
import com.streamscape.sef.EventReceiver;
import com.streamscape.sef.EventRequestConsumer;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventListener;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricException;
import com.streamscape.sef.FabricNamingException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.FabricRequestListener;
import com.streamscape.sef.FabricUnboundEventException;
import com.streamscape.sef.RangeConstraint;
import com.streamscape.sef.accessor.FabricComponentAccessor;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dispatcher.AbstractClientComponent;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.AbstractFabricConsumer;
import com.streamscape.sef.dispatcher.AbstractRepositoryAccessor;
import com.streamscape.sef.dispatcher.DataspaceAccessorImpl;
import com.streamscape.sef.dispatcher.FabricEventAsyncConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventDirectConsumerImpl;
import com.streamscape.sef.dispatcher.FabricEventReceiverImpl;
import com.streamscape.sef.dispatcher.FabricGroupLinkImpl;
import com.streamscape.sef.dispatcher.FactoryConnectionAccessorImpl;
import com.streamscape.sef.dispatcher.InternalUtils;
import com.streamscape.sef.dispatcher.SLAudioMessageListener;
import com.streamscape.sef.dispatcher.SLAudioMessageProcessor;
import com.streamscape.sef.dispatcher.SLFileMessageListener;
import com.streamscape.sef.dispatcher.SLFileMessageProcessor;
import com.streamscape.sef.dispatcher.SLSessionImpl;
import com.streamscape.sef.dispatcher.SecurityManagerImpl;
import com.streamscape.sef.dispatcher.ServiceAccessorImpl;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.group.FabricGroupLink;
import com.streamscape.sef.group.FabricGroupManager;
import com.streamscape.sef.group.FabricGroupManagerException;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.Moderator;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.sef.network.LinkAddress;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.AuthenticationType;
import com.streamscape.sef.security.DigestCalculator;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.slex.slang.SLSession;
import com.streamscape.slex.slang.SLSessionException;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import javax.naming.NamingException;

abstract class AbstractFabricConnection
extends AbstractSemanticFactory
implements FabricConnection {
    AbstractClientComponent component;
    ClientId clientId;
    List<String> urls = new ArrayList<String>();
    String userName;
    transient String password;
    transient String securityToken;
    transient AuthenticationType authenticationType = AuthenticationType.PASSWORD_PLAIN_TEXT;
    transient Map<String, String> authenticationParameters;
    transient DigestCalculator digestCalculator;
    transient String url;
    transient FabricEventListener exceptionListener;
    transient AbstractRepositoryAccessor localRepositoryAccessor;
    transient Map<String, AbstractRepositoryAccessor> remoteRepositoryAccessors;
    transient Map<String, SLSessionImpl> slSessions;
    transient SLFileMessageProcessor slFileMessageProcessor;
    transient SLAudioMessageProcessor slAudioMessageProcessor;
    transient Map<String, FabricGroupLinkImpl> groupLinks;
    transient TimeZone hostTimezone;
    transient TimeZone nodeTimezone;
    transient Charset ccsid;
    volatile transient boolean isOpened = false;
    static final int MAX_DESCRIPTION_LENGTH = 20;
    private final Object repositoryAccessorMutex = new Object();

    AbstractFabricConnection() {
    }

    void bind(AbstractClientComponent component) {
        this.component = component;
    }

    @Override
    public String getName() {
        return this.component.getName();
    }

    @Override
    public void setName(String name) throws FabricConnectionException {
        this.doSetName(name, false);
    }

    void setSystemName(String name) throws FabricConnectionException {
        this.doSetName(InternalUtils.getSystemName(name), true);
    }

    void doSetName(String name, boolean isSystem) throws FabricConnectionException {
        this.checkNotOpened();
        try {
            this.component.setName(name, isSystem);
        }
        catch (FabricNamingException exception) {
            throw new FabricConnectionException(1007, exception.getMessage());
        }
    }

    @Override
    public ClientId getClientId() {
        return this.clientId;
    }

    @Override
    public void setClientId(ClientId clientId) throws FabricConnectionException {
        this.setName(clientId.toString());
        this.clientId = clientId;
    }

    @Override
    public String getType() {
        return this.component.getType();
    }

    @Override
    public String getDescription() {
        return this.component.description;
    }

    @Override
    public void setDescription(String description) throws FabricConnectionException {
        this.checkNotOpened();
        AbstractFabricConnection.checkDescription(description);
        this.component.description = description;
    }

    static void checkDescription(String description) throws FabricConnectionException {
        if (description != null && description.length() > 20) {
            throw new FabricConnectionException(1009, "Description length cannot be more than 20 symbols.");
        }
    }

    @Override
    public synchronized void addURL(String url) throws FabricConnectionException {
        try {
            if (!url.equals(LOCAL_URL)) {
                LinkAddress.checkFormat(url);
            }
        }
        catch (FabricException exception) {
            throw new FabricConnectionException(1005, exception.getMessage());
        }
        if (!this.urls.contains(url)) {
            if (!this.urls.isEmpty()) {
                if (url.equals(LOCAL_URL)) {
                    if (!this.urls.contains(LOCAL_URL)) {
                        throw new FabricConnectionException(1006, "Local URL cannot be used for remote connection.");
                    }
                } else if (this.urls.contains(LOCAL_URL)) {
                    throw new FabricConnectionException(1006, "Non-local URL cannot be used for local connection.");
                }
            }
            this.urls.add(url);
        }
    }

    protected void doAddURL(String url) {
        this.urls.add(url);
    }

    @Override
    public synchronized void removeURL(String url) {
        this.urls.remove(url);
    }

    @Override
    public List<String> getURLs() {
        return new ArrayList<String>(this.urls);
    }

    protected void setURL() {
        if (!this.urls.isEmpty()) {
            this.url = this.urls.get(0);
        }
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public EventScope getEventScope() {
        return this.component.eventScope;
    }

    @Override
    public void setEventScope(EventScope eventScope) throws FabricConnectionException {
        this.checkNotOpened();
        this.component.eventScope = eventScope;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String userName) throws FabricConnectionException {
        this.checkNotOpened();
        this.userName = userName;
    }

    @Override
    public void setPassword(String password) throws FabricConnectionException {
        this.checkNotOpened();
        this.doSetPassword(password);
    }

    protected void doSetPassword(String password) {
        this.password = SecurityManagerImpl.normalizePassword(password);
    }

    @Override
    public void setSecurityToken(String token) throws FabricConnectionException {
        this.securityToken = SecurityManagerImpl.normalizePassword(token);
    }

    @Override
    public int getReconnectAttempts() throws FabricConnectionException {
        return (Integer)this.throwOperationNotSupported();
    }

    @Override
    public void setReconnectAttempts(int reconnectAttempts) throws FabricConnectionException {
        this.throwOperationNotSupported();
    }

    @Override
    public long getReconnectInterval() throws FabricConnectionException {
        return (Long)this.throwOperationNotSupported();
    }

    @Override
    public void setReconnectInterval(long reconnectInterval) throws FabricConnectionException {
        this.throwOperationNotSupported();
    }

    @Override
    public boolean isReconnecting() throws FabricConnectionException {
        return (Boolean)this.throwOperationNotSupported();
    }

    @Override
    public synchronized PingResult ping() {
        return this.getEventScope() != EventScope.LOCAL ? (this.isOpened ? new PingResult(PingState.AVAILABLE) : this.doPing()) : new PingResult(PingState.UNAVAILABLE);
    }

    protected abstract PingResult doPing();

    @Override
    public boolean isSecurityEnabled() throws FabricConnectionException {
        try {
            return this.getEventScope() != EventScope.LOCAL && this.component.isSecurityEnabled();
        }
        catch (Exception exception) {
            throw new FabricConnectionException(1014, (Throwable)exception);
        }
    }

    protected void setAuthenticationType(AuthenticationType authenticationType) throws FabricConnectionException {
        this.checkNotOpened();
        this.authenticationType = authenticationType;
    }

    protected void addAuthenticationParameter(String key, String value) throws FabricConnectionException {
        this.checkNotOpened();
        if (this.authenticationParameters == null) {
            this.authenticationParameters = new HashMap<String, String>();
        }
        this.authenticationParameters.put(key, value);
    }

    protected void setAuthenticationParameters(Map<String, String> parameters) throws FabricConnectionException {
        this.checkNotOpened();
        this.authenticationParameters = new HashMap<String, String>();
        this.authenticationParameters.putAll(parameters);
    }

    protected void removeAuthenticationParameter(String key) throws FabricConnectionException {
        this.checkNotOpened();
        if (this.authenticationParameters != null) {
            this.authenticationParameters.remove(key);
        }
    }

    protected String getAuthenticationParameter(String key) {
        return this.authenticationParameters != null ? this.authenticationParameters.get(key) : null;
    }

    public void setDigestCalculator(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
    }

    @Override
    public synchronized void open() throws FabricConnectionException, SecurityManagerException {
        if (!this.isOpened) {
            try {
                this.doOpen();
                this.isOpened = true;
            }
            catch (FabricConnectionException | SecurityManagerException exception) {
                if (this.component != null) {
                    this.component.unsetTimestamp();
                }
                throw exception;
            }
            this.createSLFileRequestConsumer();
            this.createSLAudioRequestConsumer();
            if (!Trace.isBroadcastEnabled(this.getClass().getName())) {
                Trace.logInfo(this, "Fabric connection '" + this.component.getFullName() + "' opened.");
            }
        }
    }

    @Override
    public void open(long timeout) throws FabricConnectionException, SecurityManagerException {
        this.throwOperationNotSupported();
    }

    protected abstract void doOpen() throws FabricConnectionException, SecurityManagerException;

    @Override
    public void close() throws FabricConnectionException {
        this.close(30000L);
    }

    @Override
    public void close(long timeout) throws FabricConnectionException {
        this.doClose(timeout);
    }

    @Override
    public void forceClose() throws FabricConnectionException {
        this.close(0L);
    }

    protected synchronized void doClose(long timeout) throws FabricConnectionException {
        if (this.isOpened) {
            try {
                this.closeSecurityManager();
                this.closeRepositoryAccessors(true);
                this.closeSLSessions();
                this.closeAccessors();
                this.closeGroupLinks();
                this.doCloseInternal(timeout);
                if (!Trace.isBroadcastEnabled(this.getClass().getName())) {
                    Trace.logInfo(this, "Fabric connection '" + this.component.getFullName() + "' closed.");
                }
            }
            finally {
                this.isOpened = false;
            }
        }
    }

    protected void closeSecurityManager() {
        this.component.closeSecurityManager();
    }

    void closeRepositoryAccessors(boolean clear) {
        if (this.localRepositoryAccessor != null) {
            this.localRepositoryAccessor.close();
            if (clear) {
                this.localRepositoryAccessor = null;
            }
        }
        if (this.remoteRepositoryAccessors != null) {
            new ArrayList<AbstractRepositoryAccessor>(this.remoteRepositoryAccessors.values()).forEach(AbstractRepositoryAccessor::close);
            if (clear) {
                this.remoteRepositoryAccessors.clear();
                this.remoteRepositoryAccessors = null;
            }
        }
    }

    protected void closeAccessors() {
        this.component.closeAccessors();
    }

    protected void forcedCloseAccessors(boolean clear) {
        this.component.forcedCloseAccessors(clear);
    }

    protected void closeSLSessions() {
        if (this.slSessions != null) {
            new ArrayList<SLSessionImpl>(this.slSessions.values()).forEach(SLSessionImpl::close);
            this.clearSLSessions();
            this.closeSLFileMessageProcessor();
            this.closeSLAudioMessageProcessor();
        }
    }

    protected void forcedCloseSLSessions(boolean clear) {
        if (this.slSessions != null) {
            new ArrayList<SLSessionImpl>(this.slSessions.values()).forEach(session -> session.forcedClose(clear));
            if (clear) {
                this.clearSLSessions();
            }
            this.closeSLFileMessageProcessor();
            this.closeSLAudioMessageProcessor();
        }
    }

    private void clearSLSessions() {
        if (this.slSessions != null) {
            this.slSessions.clear();
            this.slSessions = null;
        }
    }

    private void closeSLFileMessageProcessor() {
        if (this.slFileMessageProcessor != null) {
            this.slFileMessageProcessor.close();
        }
    }

    private void closeSLAudioMessageProcessor() {
        if (this.slAudioMessageProcessor != null) {
            this.slAudioMessageProcessor.close();
        }
    }

    protected abstract void doCloseInternal(long var1) throws FabricConnectionException;

    @Override
    public boolean isOpened() {
        return this.isOpened;
    }

    @Override
    public long getTimestamp() {
        return this.component != null ? this.component.getTimestamp() : -1L;
    }

    @Override
    public AuthenticationType getAuthenticationType() throws FabricConnectionException {
        this.checkOpened();
        return this.authenticationType;
    }

    @Override
    public ComponentReference getComponentReference() throws FabricConnectionException {
        this.checkOpened();
        return this.component.reference;
    }

    @Override
    public FabricAddress getFabricAddress() throws FabricConnectionException {
        this.checkOpened();
        return this.component.getFabricAddress();
    }

    @Override
    public Moderator getModerator() throws FabricConnectionException {
        this.checkOpened();
        return this.component.moderator;
    }

    @Override
    public SecurityManager getSecurityManager() throws FabricConnectionException, SecurityManagerException {
        try {
            return this.component.getSecurityManager();
        }
        catch (Exception exception) {
            if (exception instanceof FabricConnectionException) {
                throw (FabricConnectionException)exception;
            }
            if (exception instanceof SecurityManagerException) {
                throw (SecurityManagerException)exception;
            }
            throw new FabricConnectionException(1014, (Throwable)exception);
        }
    }

    @Override
    public RepositoryAccessor getRepositoryAccessor() throws FabricConnectionException {
        return this.getRepositoryAccessor(null);
    }

    @Override
    public RepositoryAccessor getRepositoryAccessor(String nodeName) throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_REPOSITORY);
        return this.getEventScope() != EventScope.LOCAL ? (nodeName == null ? this.getLocalRepositoryAccessor(this.component.moderator.getFabricNode()) : this.getRemoteRepositoryAccessor(nodeName)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RepositoryAccessor getLocalRepositoryAccessor(FabricNodeReference node) throws FabricConnectionException {
        Object object = this.repositoryAccessorMutex;
        synchronized (object) {
            if (this.localRepositoryAccessor == null) {
                this.localRepositoryAccessor = this.createLocalRepositoryAccessor();
            } else {
                this.localRepositoryAccessor.setNode(node);
            }
            return this.localRepositoryAccessor;
        }
    }

    protected abstract AbstractRepositoryAccessor createLocalRepositoryAccessor() throws FabricConnectionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RepositoryAccessor getRemoteRepositoryAccessor(String nodeName) throws FabricConnectionException {
        Object object = this.repositoryAccessorMutex;
        synchronized (object) {
            AbstractRepositoryAccessor result;
            FabricNodeReference node = this.component.moderator.lookupFabricNode(nodeName);
            if (node == null) {
                throw new FabricConnectionException(1013, "Node '" + nodeName + "' not found.");
            }
            if (node.isLocal()) {
                return this.getLocalRepositoryAccessor(node);
            }
            if (this.remoteRepositoryAccessors == null) {
                this.remoteRepositoryAccessors = new ConcurrentHashMap<String, AbstractRepositoryAccessor>();
            }
            if ((result = this.remoteRepositoryAccessors.get(nodeName)) == null) {
                result = this.createRemoteRepositoryAccessor(node);
                this.remoteRepositoryAccessors.put(nodeName, result);
            } else {
                result.setNode(node);
            }
            return result;
        }
    }

    protected abstract AbstractRepositoryAccessor createRemoteRepositoryAccessor(FabricNodeReference var1) throws FabricConnectionException;

    @Override
    public DataspaceAccessor createDataspaceAccessor(DataspaceType dataspaceType, String dataspaceName) throws FabricConnectionException, FabricComponentAccessorException {
        this.authorize(AccessControlOperation.DATASPACE_USE);
        return this.component.createDataspaceAccessor(dataspaceType, dataspaceName);
    }

    @Override
    public DataspaceAccessor createDataspaceAccessor(String nodeName, DataspaceType dataspaceType, String dataspaceName) throws FabricConnectionException, FabricComponentAccessorException {
        this.authorize(AccessControlOperation.DATASPACE_USE);
        return this.component.createDataspaceAccessor(nodeName, dataspaceType, dataspaceName);
    }

    DataspaceAccessorImpl createDataspaceAccessor(String nodeName, DataspaceType type, String name, boolean checkComponent, SLSessionImpl session) throws FabricConnectionException, FabricComponentAccessorException {
        this.authorize(AccessControlOperation.DATASPACE_USE);
        return this.component.createDataspaceAccessor(nodeName, type, name, checkComponent, session, null);
    }

    DataspaceAccessorImpl createDataspaceAccessor(FabricNodeReference node, ComponentReference accessedComponent, RequestConsumerReference sessionManager, SLSessionImpl session) throws FabricConnectionException, FabricComponentAccessorException {
        this.authorize(AccessControlOperation.DATASPACE_USE);
        return this.component.createDataspaceAccessor(node, accessedComponent, sessionManager, session);
    }

    @Override
    public ServiceAccessor createServiceAccessor(String serviceType, String serviceName) throws FabricConnectionException, FabricComponentAccessorException {
        this.authorize(AccessControlOperation.SERVICE_USE);
        return this.component.createServiceAccessor(serviceType, serviceName);
    }

    @Override
    public ServiceAccessor createServiceAccessor(String nodeName, String serviceType, String serviceName) throws FabricConnectionException, FabricComponentAccessorException {
        this.authorize(AccessControlOperation.SERVICE_USE);
        return this.component.createServiceAccessor(nodeName, serviceType, serviceName);
    }

    ServiceAccessorImpl createServiceAccessor(String nodeName, String type, String name, boolean checkComponent, SLSessionImpl session) throws FabricConnectionException, FabricComponentAccessorException {
        this.authorize(AccessControlOperation.SERVICE_USE);
        return this.component.createServiceAccessor(nodeName, type, name, checkComponent, session);
    }

    ServiceAccessorImpl createServiceAccessor(FabricNodeReference node, ComponentReference accessedComponent, RequestConsumerReference sessionManager, SLSessionImpl session) throws FabricConnectionException, FabricComponentAccessorException {
        this.authorize(AccessControlOperation.SERVICE_USE);
        return this.component.createServiceAccessor(node, accessedComponent, sessionManager, session);
    }

    FabricComponentAccessor createFactoryConnectionAccessor(String nodeName, String factoryType, String factoryName, SLSessionImpl session) throws FabricConnectionException, FabricComponentAccessorException {
        this.authorize(AccessControlOperation.CONNECTION_FACTORY_USE);
        this.doAuthorize(() -> factoryType.equals("DropBox") || this.component.getCurrentUser().isAdministrator());
        factoryName = this.createFactoryConnectionComponent(session.mfSession.isRouted() ? nodeName : null, factoryType, factoryName, session.mfSession.timeout);
        FactoryConnectionAccessorImpl accessor = this.component.createFactoryConnectionAccessor(nodeName, factoryType, factoryName, true, session);
        this.onFactoryConnectionComponentAccessorCreated(session.mfSession.isRouted() ? nodeName : null, accessor);
        return accessor;
    }

    protected abstract String createFactoryConnectionComponent(String var1, String var2, String var3, long var4) throws FabricConnectionException;

    protected abstract void onFactoryConnectionComponentAccessorCreated(String var1, FabricComponentAccessor var2) throws FabricConnectionException;

    protected void removeAccessor(FabricComponentAccessor accessor) {
        this.component.removeAccessor(accessor);
    }

    @Override
    public SLSession createSLSession() throws FabricConnectionException, SLSessionException {
        return this.createSLSession(null);
    }

    SLSession createSystemSLSession() throws FabricConnectionException, SLSessionException {
        return this.createSystemSLSession(null);
    }

    SLSession createSystemSLSession(String nodeName) throws FabricConnectionException, SLSessionException {
        return this.createSLSession(nodeName, true);
    }

    @Override
    public SLSession createSLSession(String nodeName) throws FabricConnectionException, SLSessionException {
        return this.createSLSession(nodeName, false);
    }

    SLSession createSLSession(String nodeName, boolean isSystem) throws FabricConnectionException, SLSessionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_SLANG);
        if (this.getEventScope() != EventScope.LOCAL) {
            this.initSLSessions();
            SLSessionImpl result = (SLSessionImpl)this.doCreateSLSession(nodeName, isSystem);
            this.slSessions.put(result.getName(), result);
            return result;
        }
        return null;
    }

    protected SLSession doCreateSLSession(String nodeName, boolean isSystem) throws SLSessionException {
        return new SLSessionImpl(this, nodeName, null, isSystem);
    }

    private synchronized void initSLSessions() {
        if (this.slSessions == null) {
            this.slSessions = new ConcurrentHashMap<String, SLSessionImpl>();
        }
    }

    protected void removeSLSession(SLSessionImpl session) {
        if (this.slSessions != null) {
            this.slSessions.remove(session.getName());
        }
    }

    protected SLSession getSLSession(String sessionName) throws FabricConnectionException {
        return this.slSessions != null ? (SLSession)this.slSessions.get(sessionName) : null;
    }

    @Override
    public void raiseAdvisory(AdvisoryEventDatagram event, EventScope eventScope) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.checkOpened();
        this.component.dispatcher.raiseAdvisory(event, eventScope);
    }

    protected void raiseSystemAdvisory(AdvisoryEventDatagram event, EventScope eventScope) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.checkOpened();
        this.component.dispatcher.raiseSystemAdvisory(event, eventScope);
    }

    @Override
    public void raiseEvent(ImmutableEventDatagram event, EventScope eventScope, long timeToLive) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.raiseEvent(event, eventScope, timeToLive, null);
    }

    void raiseEvent(ImmutableEventDatagram event, EventScope eventScope, long timeToLive, FabricGroupLinkImpl groupLink) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.checkOpened();
        this.component.dispatcher.raiseEvent(event, eventScope, timeToLive, groupLink);
    }

    protected void raiseSystemEvent(ImmutableEventDatagram event, EventScope eventScope) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.checkOpened();
        this.component.dispatcher.raiseSystemEvent(event, eventScope);
    }

    @Override
    public ImmutableEventDatagram raiseRequest(RequestConsumerReference consumer, ImmutableEventDatagram request, long timeout) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricRequestException {
        this.checkOpened();
        return this.component.dispatcher.raiseRequest(consumer, request, timeout);
    }

    protected ImmutableEventDatagram raiseSystemRequest(RequestConsumerReference consumer, ImmutableEventDatagram request, long timeout) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricRequestException {
        this.checkOpened();
        return this.component.dispatcher.raiseSystemRequest(consumer, request, timeout);
    }

    @Override
    public AcknowledgementEvent raiseRequest(EventDatagram request, EventScope eventScope, RequestDistributionStrategy distributionStrategy, ReplyMatchStrategy matchStrategy, long timeout) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.checkOpened();
        return this.component.dispatcher.raiseRequest(request, eventScope, distributionStrategy, matchStrategy, timeout);
    }

    @Override
    public void raiseException(ExceptionEventDatagram event, EventScope eventScope) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.checkOpened();
        this.component.dispatcher.raiseException(event, eventScope);
    }

    @Override
    public void raiseAcknowledgement(AcknowledgementEvent event, EventScope eventScope, long timeToLive) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.checkOpened();
        this.component.dispatcher.raiseAcknowledgement(event, eventScope, timeToLive);
    }

    @Override
    public void acknowledgeEvent(EventDatagram event, boolean withSourceData, AcknowledgeAction action, String recipientId, EventScope eventScope, long timeToLive) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.checkOpened();
        this.component.dispatcher.acknowledgeEvent(event, withSourceData, action, recipientId, eventScope, timeToLive);
    }

    @Override
    public void acknowledgeException(ExceptionEventDatagram event, AcknowledgeAction action, String recipientId, EventScope eventScope, long timeToLive) throws FabricConnectionException, FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.checkOpened();
        this.component.dispatcher.acknowledgeException(event, action, recipientId, eventScope, timeToLive);
    }

    @Override
    public EventConsumer createEventConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws FabricConnectionException, FabricEventDispatcherException {
        return this.createEventConsumer(consumerName, listener, eventFilter, eventSelector, eventScope, noLocal, null);
    }

    FabricEventDirectConsumerImpl createEventConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal, FabricGroupLinkImpl groupLink) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        FabricEventDirectConsumerImpl result = this.component.dispatcher.createEventConsumer(consumerName, listener, eventFilter, eventSelector, eventScope, noLocal, groupLink);
        this.onConsumerCreated(result, false);
        return result;
    }

    FabricEventDirectConsumerImpl createSystemEventConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws FabricConnectionException, FabricEventDispatcherException {
        this.checkOpened();
        FabricEventDirectConsumerImpl result = this.component.dispatcher.createSystemEventConsumer(consumerName, listener, eventFilter, eventSelector, eventScope, noLocal);
        this.onConsumerCreated(result, true);
        return result;
    }

    EventConsumer createHiddenEventConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector) throws FabricConnectionException, FabricEventDispatcherException {
        this.checkOpened();
        return this.component.dispatcher.createHiddenEventConsumer(consumerName, listener, eventFilter, eventSelector);
    }

    @Override
    public void dropEventConsumer(String consumerName) throws FabricConnectionException, FabricEventDispatcherException {
        this.dropEventConsumer(consumerName, null);
    }

    void dropEventConsumer(String consumerName, FabricGroupLinkImpl groupLink) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        this.component.dispatcher.dropEventConsumer(consumerName, groupLink);
    }

    @Override
    public EventAsyncConsumer createEventAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws FabricConnectionException, FabricEventDispatcherException {
        return this.createEventAsyncConsumer(consumerName, listener, eventFilter, eventSelector, eventScope, noLocal, null);
    }

    FabricEventAsyncConsumerImpl createEventAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal, FabricGroupLinkImpl groupLink) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        FabricEventAsyncConsumerImpl result = this.component.dispatcher.createEventAsyncConsumer(consumerName, listener, eventFilter, eventSelector, eventScope, noLocal, groupLink);
        this.onConsumerCreated(result, false);
        return result;
    }

    FabricEventAsyncConsumerImpl createSystemEventAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws FabricConnectionException, FabricEventDispatcherException {
        this.checkOpened();
        FabricEventAsyncConsumerImpl result = this.component.dispatcher.createSystemEventAsyncConsumer(consumerName, listener, eventFilter, eventSelector, eventScope, noLocal);
        this.onConsumerCreated(result, true);
        return result;
    }

    EventAsyncConsumer createHiddenEventAsyncConsumer(String consumerName, FabricEventListener listener, String eventFilter, String eventSelector) throws FabricConnectionException, FabricEventDispatcherException {
        this.checkOpened();
        return this.component.dispatcher.createHiddenEventAsyncConsumer(consumerName, listener, eventFilter, eventSelector);
    }

    @Override
    public void dropEventAsyncConsumer(String consumerName) throws FabricConnectionException, FabricEventDispatcherException {
        this.dropEventAsyncConsumer(consumerName, null);
    }

    void dropEventAsyncConsumer(String consumerName, FabricGroupLinkImpl groupLink) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        this.component.dispatcher.dropEventAsyncConsumer(consumerName, 30000L, groupLink);
    }

    @Override
    public EventRequestConsumer createRequestConsumer(String consumerName, FabricRequestListener listener, EventScope eventScope) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        return this.component.dispatcher.createRequestConsumer(consumerName, listener, eventScope);
    }

    EventRequestConsumer createSystemRequestConsumer(String consumerName, FabricRequestListener listener, EventScope eventScope) throws FabricConnectionException, FabricEventDispatcherException {
        this.checkOpened();
        return this.component.dispatcher.createSystemRequestConsumer(consumerName, listener, eventScope);
    }

    @Override
    public void dropRequestConsumer(String consumerName) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        this.component.dispatcher.dropRequestConsumer(consumerName);
    }

    @Override
    public void dropConsumer(String consumerName) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        this.component.dispatcher.dropConsumer(consumerName);
    }

    void dropSystemConsumer(String consumerName) throws FabricConnectionException {
        this.checkOpened();
        this.component.dispatcher.dropSystemConsumer(consumerName);
    }

    @Override
    public EventConsumer getEventConsumer(String consumerName) throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        return this.component.dispatcher.getEventConsumer(consumerName);
    }

    EventConsumer getSystemEventConsumer(String consumerName) throws FabricConnectionException {
        this.checkOpened();
        return this.component.dispatcher.getSystemEventConsumer(consumerName);
    }

    @Override
    public EventAsyncConsumer getEventAsyncConsumer(String consumerName) throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        return this.component.dispatcher.getEventAsyncConsumer(consumerName);
    }

    EventAsyncConsumer getSystemEventAsyncConsumer(String consumerName) throws FabricConnectionException {
        this.checkOpened();
        return this.component.dispatcher.getSystemEventAsyncConsumer(consumerName);
    }

    @Override
    public EventRequestConsumer getRequestConsumer(String consumerName) throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        return this.component.dispatcher.getRequestConsumer(consumerName);
    }

    EventRequestConsumer getSystemRequestConsumer(String consumerName) throws FabricConnectionException {
        this.checkOpened();
        return this.component.dispatcher.getSystemRequestConsumer(consumerName);
    }

    @Override
    public List<String> listEventConsumers() throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        return this.component.dispatcher.listEventConsumers();
    }

    @Override
    public List<String> listEventAsyncConsumers() throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        return this.component.dispatcher.listEventAsyncConsumers();
    }

    @Override
    public List<String> listRequestConsumers() throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        return this.component.dispatcher.listRequestConsumers();
    }

    @Override
    public EventReceiver createEventReceiver(String receiverName, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws FabricConnectionException, FabricEventDispatcherException {
        return this.createEventReceiver(receiverName, eventFilter, eventSelector, eventScope, noLocal, null);
    }

    public EventReceiver createEventReceiver(String receiverName, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal, FabricGroupLinkImpl groupLink) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        FabricEventReceiverImpl result = this.component.dispatcher.createEventReceiver(receiverName, eventFilter, eventSelector, eventScope, noLocal, groupLink);
        this.onConsumerCreated(result, false);
        return result;
    }

    EventReceiver createSystemEventReceiver(String receiverName, String eventFilter, String eventSelector, EventScope eventScope, boolean noLocal) throws FabricConnectionException, FabricEventDispatcherException {
        this.checkOpened();
        FabricEventReceiverImpl result = this.component.dispatcher.createSystemEventReceiver(receiverName, eventFilter, eventSelector, eventScope, noLocal);
        this.onConsumerCreated(result, true);
        return result;
    }

    @Override
    public void dropEventReceiver(String receiverName) throws FabricConnectionException, FabricEventDispatcherException {
        this.dropEventReceiver(receiverName, null);
    }

    void dropEventReceiver(String receiverName, FabricGroupLinkImpl groupLink) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        this.component.dispatcher.dropEventReceiver(receiverName, groupLink);
    }

    void dropSystemEventReceiver(String consumerName) throws FabricConnectionException {
        this.checkOpened();
        this.component.dispatcher.dropSystemEventReceiver(consumerName);
    }

    @Override
    public EventReceiver getEventReceiver(String receiverName) throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        return this.component.dispatcher.getEventReceiver(receiverName);
    }

    @Override
    public List<String> listEventReceivers() throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_CONSUMER);
        return this.component.dispatcher.listEventReceivers();
    }

    void onConsumerCreated(AbstractFabricConsumer consumer, boolean isSystem) {
    }

    @Override
    public void addEventCache(String eventFilter, int maxSize, CacheThresholdAction thresholdAction) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_EVENT_CACHE);
        this.checkEventScope(false);
        this.component.dispatcher.addEventCache(eventFilter, maxSize, thresholdAction);
    }

    @Override
    public void removeEventCache(String eventFilter) throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_EVENT_CACHE);
        this.checkEventScope(false);
        this.component.dispatcher.removeEventCache(eventFilter);
    }

    @Override
    public EventCache getEventCache(String eventFilter) throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_EVENT_CACHE);
        this.checkEventScope(false);
        return this.component.dispatcher.getEventCache(eventFilter);
    }

    @Override
    public void bindProducerFor(String eventId) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_PRODUCER);
        this.component.bindProducerFor(eventId);
        this.onProducerBound(eventId, EventFlowEntity.CLIENT_EVENT_PRODUCER, false);
    }

    protected void bindProducerForSystem(String eventId) throws FabricConnectionException, FabricEventDispatcherException {
        this.bindProducerForSystem(eventId, EventFlowEntity.CLIENT_EVENT_PRODUCER);
    }

    protected void bindProducerForSystem(String eventId, EventFlowEntity entity) throws FabricConnectionException, FabricEventDispatcherException {
        this.checkOpened();
        this.component.bindProducerForSystem(eventId);
        this.onProducerBound(eventId, entity, true);
    }

    void onProducerBound(String eventId, EventFlowEntity entity, boolean isSystem) {
    }

    @Override
    public void unbindProducerFor(String eventId) throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_PRODUCER);
        this.component.unbindProducerFor(eventId);
        this.onProducerUnbound(eventId, EventFlowEntity.CLIENT_EVENT_PRODUCER);
    }

    protected void unbindProducerForSystem(String eventId) throws FabricConnectionException {
        this.unbindProducerForSystem(eventId, EventFlowEntity.CLIENT_EVENT_PRODUCER);
    }

    protected void unbindProducerForSystem(String eventId, EventFlowEntity entity) throws FabricConnectionException {
        this.checkOpened();
        this.component.unbindProducerForSystem(eventId);
        this.onProducerUnbound(eventId, entity);
    }

    void onProducerUnbound(String eventId, EventFlowEntity entity) {
    }

    @Override
    public boolean hasBoundEventIds() throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_PRODUCER);
        return this.component.dispatcher.hasBoundEventIds();
    }

    @Override
    public boolean isBoundEventId(String eventId) throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_PRODUCER);
        return this.component.dispatcher.isBoundEventId(eventId);
    }

    @Override
    public List<String> listBoundEventIds() throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_PRODUCER);
        return this.component.dispatcher.listBoundEventIds();
    }

    @Override
    public ExceptionStrategy getExceptionStrategy() throws FabricConnectionException {
        this.checkOpened();
        return this.component.dispatcher.getExceptionStrategy();
    }

    @Override
    public void setExceptionStrategy(ExceptionStrategy exceptionStrategy) throws FabricConnectionException {
        this.checkOpened();
        this.component.dispatcher.setExceptionStrategy(exceptionStrategy);
    }

    @Override
    public DomainConstraint createDomainConstraint(String domainName, String description, Set<Object> values) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_DATA_CONSTRAINT);
        return this.component.dispatcher.createDomainConstraint(domainName, description, values);
    }

    @Override
    public void dropDomainConstraint(String domainName) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_DATA_CONSTRAINT);
        this.component.dispatcher.dropDomainConstraint(domainName);
    }

    @Override
    public DomainConstraint getDomainConstraint(String domainName) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_DATA_CONSTRAINT);
        return this.component.dispatcher.getDomainConstraint(domainName);
    }

    @Override
    public void setDomainConstraint(DomainConstraint domain) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_DATA_CONSTRAINT);
        this.component.dispatcher.setDomainConstraint(domain);
    }

    @Override
    public RangeConstraint createRangeConstraint(String rangeName, String description, Object minValue, Object maxValue) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_DATA_CONSTRAINT);
        return this.component.dispatcher.createRangeConstraint(rangeName, description, minValue, maxValue);
    }

    @Override
    public void dropRangeConstraint(String rangeName) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_DATA_CONSTRAINT);
        this.component.dispatcher.dropRangeConstraint(rangeName);
    }

    @Override
    public RangeConstraint getRangeConstraint(String rangeName) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_DATA_CONSTRAINT);
        return this.component.dispatcher.getRangeConstraint(rangeName);
    }

    @Override
    public void setRangeConstraint(RangeConstraint range) throws FabricConnectionException, FabricEventDispatcherException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_DATA_CONSTRAINT);
        this.component.dispatcher.setRangeConstraint(range);
    }

    @Override
    public FabricGroupManager getGroupManager() throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_FABRIC_GROUPS);
        this.checkEventScope(false);
        return this.doGetFabricGroupManager();
    }

    abstract FabricGroupManager doGetFabricGroupManager();

    @Override
    public synchronized FabricGroupLink joinGroup(String groupName) throws FabricConnectionException, FabricGroupManagerException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_FABRIC_GROUPS);
        this.checkEventScope(false);
        this.initGroupLinks();
        if (this.groupLinks.containsKey(groupName)) {
            throw new FabricConnectionException(6128, "Connection already joined group '" + groupName + "'.");
        }
        FabricGroupLinkImpl result = new FabricGroupLinkImpl(this, this.getExchange().addGroupMember(groupName, this.component.reference, true));
        this.groupLinks.put(groupName, result);
        return result;
    }

    private synchronized void initGroupLinks() {
        if (this.groupLinks == null) {
            this.groupLinks = new ConcurrentHashMap<String, FabricGroupLinkImpl>();
        }
    }

    @Override
    public synchronized void leaveGroup(String groupName) throws FabricConnectionException, FabricGroupManagerException {
        FabricGroupLinkImpl groupLink;
        this.authorize(AccessControlOperation.CLIENT_ACCESS_FABRIC_GROUPS);
        this.checkEventScope(false);
        FabricGroupLinkImpl fabricGroupLinkImpl = groupLink = this.groupLinks != null ? this.groupLinks.remove(groupName) : null;
        if (groupLink != null) {
            groupLink.destroy(30000L);
            this.getExchange().removeGroupMember(groupName, this.component.reference, true);
        }
    }

    @Override
    public FabricGroupLink getGroupLink(String groupName) throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_FABRIC_GROUPS);
        this.checkEventScope(false);
        return this.groupLinks != null ? (FabricGroupLink)this.groupLinks.get(groupName) : null;
    }

    @Override
    public List<String> listGroups() throws FabricConnectionException {
        this.authorize(AccessControlOperation.CLIENT_ACCESS_FABRIC_GROUPS);
        this.checkEventScope(false);
        return this.groupLinks != null ? new ArrayList<String>(this.groupLinks.keySet()) : new ArrayList();
    }

    void closeGroupLinks() {
        if (this.groupLinks != null) {
            for (FabricGroupLink fabricGroupLink : this.groupLinks.values()) {
                try {
                    fabricGroupLink.leaveGroup();
                }
                catch (Exception exception) {
                    Trace.logException(this, exception, true);
                    Trace.logError(this, "Closing group link failed.");
                }
            }
        }
    }

    @Override
    public synchronized void setExceptionListener(FabricEventListener listener) throws FabricConnectionException, FabricEventDispatcherException {
        this.checkOpened();
        if (listener != null) {
            if (this.exceptionListener != null) {
                this.dropSystemConsumer("ExceptionListener");
            }
            this.exceptionListener = listener;
            this.createSystemEventAsyncConsumer("ExceptionListener", this.exceptionListener, "exception.#", null, EventScope.INHERITED, false).start();
        } else if (this.exceptionListener != null) {
            this.exceptionListener = null;
            this.dropSystemConsumer("ExceptionListener");
        }
    }

    @Override
    public FabricEventListener getExceptionListener() {
        return this.exceptionListener;
    }

    @Override
    public void exportExtensionArchive(File jarFile) throws FabricConnectionException, RepositoryException {
        this.throwOperationNotSupported();
    }

    @Override
    public void importExtensionArchive(String jarName) throws FabricConnectionException, RepositoryException, ArchiveException {
        this.throwOperationNotSupported();
    }

    @Override
    public void importPackage(String packageName) throws FabricConnectionException, NamingException, RepositoryException, ArchiveException {
        this.throwOperationNotSupported();
    }

    @Override
    public void exportSemanticType(String typeName) throws FabricConnectionException, SemanticTypeFactoryException {
        this.throwOperationNotSupported();
    }

    @Override
    public void importSemanticType(String typeName) throws FabricConnectionException, SemanticTypeFactoryException, ArchiveException {
        this.throwOperationNotSupported();
    }

    @Override
    public void exportEventPrototype(String eventId) throws FabricConnectionException, DatagramFactoryException {
        this.throwOperationNotSupported();
    }

    @Override
    public void importEventPrototype(String eventId) throws FabricConnectionException, DatagramFactoryException, ArchiveException {
        this.throwOperationNotSupported();
    }

    protected void checkOpened() throws FabricConnectionException {
        if (!this.isOpened) {
            throw new FabricConnectionException(1011, "Connection '" + this.component.getFullName() + "' is not opened.");
        }
    }

    protected void checkNotOpened() throws FabricConnectionException {
        if (this.isOpened) {
            throw new FabricConnectionException(1010, "Connection '" + this.component.getFullName() + "' is opened.");
        }
    }

    protected void checkEventScope(boolean onlyLocal) throws FabricConnectionException {
        if (this.getEventScope() == EventScope.LOCAL || !onlyLocal && this.getEventScope() == EventScope.OBSERVABLE) {
            throw new FabricConnectionException(1012, "Operation is not available for connection with 'LOCAL'" + (onlyLocal ? "" : " or 'OBSERVABLE'") + " event scope.");
        }
    }

    protected <T> T throwOperationNotSupported() throws FabricConnectionException {
        throw new FabricConnectionException(1001, "Operation is not supported in Runtime Context.");
    }

    abstract AbstractExchange getExchange();

    User getCurrentUser() {
        return this.component.getCurrentUser();
    }

    String getCurrentUserName() {
        return this.component.getOwnerName();
    }

    Object raiseInternalRequest(FabricAddress nodeAddress, int eventId, Object data) throws Exception {
        return this.getExchange().raiseInternalRequest(nodeAddress, eventId, data);
    }

    void authorize(AccessControlOperation operation) throws FabricConnectionException {
        this.authorizeReal(operation);
    }

    void authorizeReal(AccessControlOperation operation) throws FabricConnectionException {
        this.checkOpened();
        this.doAuthorize(() -> this.component.authorize(operation));
    }

    private void doAuthorize(BooleanSupplier predicate) throws FabricConnectionException {
        if (!predicate.getAsBoolean()) {
            throw new FabricConnectionException(6092, "User '" + this.getCurrentUserName() + "' has insufficient rights for this operation.");
        }
    }

    void authorizeAnonymous(AccessControlOperation operation) throws FabricConnectionException {
        this.checkOpened();
        if (this.component.isAnonymous()) {
            throw new FabricConnectionException(6092, "User 'anonymous' has insufficient rights for this operation.");
        }
    }

    protected void createSLFileRequestConsumer() {
        String fileRequestConsumerName = SLFileMessage.getRequestConsumerName();
        try {
            EventRequestConsumer requestConsumer = this.getSystemRequestConsumer(fileRequestConsumerName);
            if (requestConsumer == null) {
                this.createSystemRequestConsumer(fileRequestConsumerName, this.createSLFileMessageListener(), EventScope.INHERITED);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Creation of file request consumer '" + fileRequestConsumerName + "' for fabric connection '" + this.getName() + "' failed.");
        }
    }

    protected FabricRequestListener createSLFileMessageListener() {
        this.slFileMessageProcessor = new SLFileMessageProcessor(!this.getName().equals(InternalUtils.getSystemName("InternalConnection")));
        return new SLFileMessageListener(this.slFileMessageProcessor);
    }

    protected void createSLAudioRequestConsumer() {
        String audioRequestConsumerName = SLAudioMessage.getRequestConsumerName();
        try {
            EventRequestConsumer requestConsumer = this.getSystemRequestConsumer(audioRequestConsumerName);
            if (requestConsumer == null) {
                this.createSystemRequestConsumer(audioRequestConsumerName, this.createSLAudioMessageListener(), EventScope.INHERITED);
            }
        }
        catch (Exception exception) {
            Trace.logException(this, exception, true);
            Trace.logError(this, "Creation of audio request consumer '" + audioRequestConsumerName + "' for fabric connection '" + this.getName() + "' failed.");
        }
    }

    protected FabricRequestListener createSLAudioMessageListener() {
        this.slAudioMessageProcessor = new SLAudioMessageProcessor(!this.getName().equals(InternalUtils.getSystemName("InternalConnection")));
        return new SLAudioMessageListener(this.slAudioMessageProcessor);
    }

    void checkResetGlobalCounterRights() throws FabricConnectionException {
        if (!this.getCurrentUser().isAdministrator()) {
            throw new FabricConnectionException(6092, "User '" + this.getUserName() + "' has insufficient rights to reset the global counter.");
        }
    }
}

