/*
 * Decompiled with CFR 0.152.
 */
package com.streamscape.sef.dispatcher;

import com.streamscape.Logger;
import com.streamscape.Trace;
import com.streamscape.cli.ds.DataspaceAccessor;
import com.streamscape.cli.ds.DataspaceType;
import com.streamscape.cli.service.ServiceAccessor;
import com.streamscape.runtime.ContextId;
import com.streamscape.sdo.AdvisoryEventDatagram;
import com.streamscape.sdo.EventDatagram;
import com.streamscape.sdo.ImmutableEventDatagram;
import com.streamscape.sdo.enums.ReplyMatchStrategy;
import com.streamscape.sdo.enums.RequestDistributionStrategy;
import com.streamscape.sdo.event.AcknowledgementEvent;
import com.streamscape.sdo.excp.FabricEventException;
import com.streamscape.sdo.mf.admin.DatagramPrototypeCache;
import com.streamscape.sdo.operation.SLCallable;
import com.streamscape.sef.FabricComponent;
import com.streamscape.sef.FabricEventDispatcherException;
import com.streamscape.sef.FabricEventSourceException;
import com.streamscape.sef.FabricNamingException;
import com.streamscape.sef.FabricRequestException;
import com.streamscape.sef.FabricUnboundEventException;
import com.streamscape.sef.accessor.FabricComponentAccessor;
import com.streamscape.sef.accessor.FabricComponentAccessorException;
import com.streamscape.sef.dispatcher.AbstractComponentAccessor;
import com.streamscape.sef.dispatcher.AbstractExchange;
import com.streamscape.sef.dispatcher.AbstractFabricConsumer;
import com.streamscape.sef.dispatcher.AbstractPackageManifestManager;
import com.streamscape.sef.dispatcher.AbstractSecurityManagerProxy;
import com.streamscape.sef.dispatcher.ComponentBoundEventIds;
import com.streamscape.sef.dispatcher.ComponentReferenceImpl;
import com.streamscape.sef.dispatcher.DataspaceAccessorImpl;
import com.streamscape.sef.dispatcher.EventFlowImpl;
import com.streamscape.sef.dispatcher.FabricEventDispatcherImpl;
import com.streamscape.sef.dispatcher.FactoryConnectionAccessorImpl;
import com.streamscape.sef.dispatcher.ModeratorImpl;
import com.streamscape.sef.dispatcher.RuntimeSecurityManagerProxy;
import com.streamscape.sef.dispatcher.SLSessionImpl;
import com.streamscape.sef.dispatcher.SecurityContextImpl;
import com.streamscape.sef.dispatcher.SecurityManagerImpl;
import com.streamscape.sef.dispatcher.ServiceAccessorImpl;
import com.streamscape.sef.dispatcher.SinkEventFlowImpl;
import com.streamscape.sef.dispatcher.SourceEventFlowImpl;
import com.streamscape.sef.enums.ComponentModel;
import com.streamscape.sef.enums.ComponentState;
import com.streamscape.sef.enums.EventScope;
import com.streamscape.sef.exchange.FabricAddress;
import com.streamscape.sef.moderator.ComponentReference;
import com.streamscape.sef.moderator.EventFlowEntity;
import com.streamscape.sef.moderator.FabricNodeReference;
import com.streamscape.sef.moderator.ModeratorUtils;
import com.streamscape.sef.moderator.RequestConsumerReference;
import com.streamscape.sef.pkg.PackageManifestManager;
import com.streamscape.sef.pool.AccessorsPool;
import com.streamscape.sef.scheduler.Metaset;
import com.streamscape.sef.security.AccessControlOperation;
import com.streamscape.sef.security.AuthenticationType;
import com.streamscape.sef.security.DigestCalculator;
import com.streamscape.sef.security.Group;
import com.streamscape.sef.security.SecurityContext;
import com.streamscape.sef.security.SecurityManager;
import com.streamscape.sef.security.SecurityManagerException;
import com.streamscape.sef.security.User;
import com.streamscape.slex.MFSession;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

abstract class AbstractFabricComponent
implements FabricComponent,
SLCallable {
    protected ContextId contextId = new ContextId();
    protected ComponentState state = ComponentState.DESTROYED;
    protected String name = null;
    protected String type = null;
    protected ComponentModel model = ComponentModel.CTX_UNBOUND;
    protected EventScope eventScope = EventScope.GLOBAL;
    protected String description = null;
    protected long timestamp = -1L;
    protected transient FabricEventDispatcherImpl dispatcher = null;
    protected transient ModeratorImpl moderator = null;
    protected transient ComponentReferenceImpl reference = null;
    protected transient ComponentBoundEventIds boundEventIds = new ComponentBoundEventIds(this);
    protected transient Map<String, AbstractComponentAccessor> accessors = null;
    protected transient Boolean isSecurityEnabled = null;
    protected transient AbstractSecurityManagerProxy securityManager = null;
    protected transient SecurityContextImpl securityContext = null;
    protected transient Logger logger = null;
    protected transient String logPrefix = "";
    protected transient AbstractPackageManifestManager manifestManager = null;
    protected transient AccessorsPool accessorsPool = null;

    AbstractFabricComponent() {
    }

    AbstractFabricComponent(String type, String name, ComponentModel model, ComponentState state) {
        this.type = type;
        this.name = name;
        this.model = model;
        this.state = state;
    }

    @Override
    public String getType() {
        return this.type;
    }

    void setType(String type) throws FabricNamingException {
        this.setType(type, false);
    }

    void setType(String type, boolean isSystem) throws FabricNamingException {
        AbstractFabricComponent.checkValue(type, isSystem, "type");
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    void setName(String name) throws FabricNamingException {
        this.setName(name, false);
    }

    void setName(String name, boolean isSystem) throws FabricNamingException {
        AbstractFabricComponent.checkValue(name, isSystem, "name");
        this.name = name;
    }

    static void checkValue(String value, boolean isSystem, String valueType) throws FabricNamingException {
        if (value == null || value.length() == 0) {
            throw new FabricNamingException("Component " + valueType + " cannot be null or empty string.");
        }
        if (value.indexOf(46) != -1) {
            throw new FabricNamingException("Component " + valueType + " cannot contain '.' symbol.");
        }
        if (!isSystem && value.startsWith("sys$")) {
            throw new FabricNamingException("Component " + valueType + " cannot start with reserved prefix 'sys$'.");
        }
    }

    public String getFullName() {
        return this.reference != null ? this.reference.getName() : ModeratorUtils.makeComponentFullName(this.type, this.name);
    }

    @Override
    public EventScope getEventScope() {
        return this.eventScope;
    }

    public void setEventScope(EventScope scope) {
        this.eventScope = scope;
    }

    @Override
    public ContextId getContextId() {
        return this.contextId;
    }

    @Override
    public FabricAddress getFabricAddress() {
        return this.eventScope != EventScope.LOCAL ? this.contextId.getFabricAddress() : null;
    }

    @Override
    public ComponentModel getComponentModel() {
        return this.model;
    }

    @Override
    public ComponentReference getComponentReference() {
        return this.reference;
    }

    @Override
    public PackageManifestManager getPackageManifestManager() {
        return this.manifestManager;
    }

    void setModel(ComponentModel model) {
        this.model = model;
    }

    public ComponentState getState() {
        return this.state;
    }

    void setState(ComponentState state) {
        this.state = state;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    long getTimestamp() {
        return this.timestamp;
    }

    void setTimestamp() {
        this.timestamp = System.currentTimeMillis();
    }

    void unsetTimestamp() {
        this.timestamp = -1L;
    }

    void initInternal(DatagramPrototypeCache prototypeCache) {
        this.dispatcher = new FabricEventDispatcherImpl(this, prototypeCache);
    }

    void bind(AbstractExchange exchange, ComponentReferenceImpl reference) {
        this.moderator = exchange.getModerator();
        this.reference = reference;
        if (this.securityContext != null) {
            this.securityContext.bind(this);
        }
        if (this.dispatcher != null) {
            this.dispatcher.setExchange(exchange, reference);
        }
    }

    protected abstract void initPackageManifestManager();

    void destroyInternal() {
        this.destroyInternal(30000L);
    }

    void destroyInternal(long timeout) {
        if (this.accessorsPool != null) {
            this.accessorsPool.destroy();
            this.accessorsPool = null;
        }
        if (this.dispatcher != null) {
            this.dispatcher.destroy(timeout);
            this.dispatcher = null;
        }
        this.unbindSecurityContext();
    }

    void unbindSecurityContext() {
        if (this.securityContext != null) {
            this.securityContext.unbind(this);
            this.securityContext = null;
        }
    }

    public AccessorsPool getAccessorsPool() {
        return this.accessorsPool;
    }

    DataspaceAccessor createDataspaceAccessor(DataspaceType dataspaceType, String dataspaceName) throws FabricComponentAccessorException {
        return this.createDataspaceAccessor(null, dataspaceType, dataspaceName);
    }

    DataspaceAccessor createDataspaceAccessor(DataspaceType dataspaceType, String dataspaceName, String username) throws FabricComponentAccessorException {
        return this.createDataspaceAccessor(null, dataspaceType, dataspaceName, username);
    }

    DataspaceAccessor createDataspaceAccessor(String nodeName, DataspaceType dataspaceType, String dataspaceName) throws FabricComponentAccessorException {
        return this.createDataspaceAccessor(nodeName, dataspaceType, dataspaceName, true, null, null);
    }

    DataspaceAccessor createDataspaceAccessor(String nodeName, DataspaceType dataspaceType, String dataspaceName, String username) throws FabricComponentAccessorException {
        return this.createDataspaceAccessor(nodeName, dataspaceType, dataspaceName, true, null, username);
    }

    DataspaceAccessorImpl createDataspaceAccessor(String nodeName, DataspaceType type, String name, boolean checkComponent, SLSessionImpl session, String username) throws FabricComponentAccessorException {
        if (this.eventScope != EventScope.LOCAL) {
            return this.doAddAccessor(new DataspaceAccessorImpl(this, nodeName, type.name(), name, checkComponent, session, username));
        }
        return null;
    }

    DataspaceAccessorImpl createDataspaceAccessor(FabricNodeReference node, ComponentReference accessedComponent, RequestConsumerReference sessionManager, SLSessionImpl session) throws FabricComponentAccessorException {
        if (this.eventScope != EventScope.LOCAL) {
            return this.doAddAccessor(new DataspaceAccessorImpl(this, node, accessedComponent, sessionManager, session));
        }
        return null;
    }

    ServiceAccessor createServiceAccessor(String serviceType, String serviceName) throws FabricComponentAccessorException {
        return this.createServiceAccessor(null, serviceType, serviceName);
    }

    ServiceAccessor createServiceAccessor(String nodeName, String serviceType, String serviceName) throws FabricComponentAccessorException {
        return this.createServiceAccessor(nodeName, serviceType, serviceName, true, null);
    }

    ServiceAccessorImpl createServiceAccessor(String nodeName, String type, String name, boolean checkComponent, SLSessionImpl session) throws FabricComponentAccessorException {
        if (this.eventScope != EventScope.LOCAL) {
            return this.doAddAccessor(new ServiceAccessorImpl(this, nodeName, type, name, checkComponent, session, false));
        }
        return null;
    }

    ServiceAccessorImpl createInstantServiceAccessor(String nodeName, String type, String name, SLSessionImpl session) throws FabricComponentAccessorException {
        return new ServiceAccessorImpl(this, nodeName, type, name, false, session, true);
    }

    ServiceAccessorImpl createServiceAccessor(FabricNodeReference node, ComponentReference accessedComponent, RequestConsumerReference sessionManager, SLSessionImpl session) throws FabricComponentAccessorException {
        if (this.eventScope != EventScope.LOCAL) {
            return this.doAddAccessor(new ServiceAccessorImpl(this, node, accessedComponent, sessionManager, session));
        }
        return null;
    }

    private <TAccessor extends AbstractComponentAccessor> TAccessor doAddAccessor(TAccessor accessor) {
        this.addAccessor(accessor);
        return accessor;
    }

    FactoryConnectionAccessorImpl createFactoryConnectionAccessor(String nodeName, String type, String name, boolean checkComponent, SLSessionImpl session) throws FabricComponentAccessorException {
        if (this.eventScope != EventScope.LOCAL) {
            FactoryConnectionAccessorImpl result = new FactoryConnectionAccessorImpl(this, nodeName, type, name, checkComponent, session);
            this.addAccessor(result);
            return result;
        }
        return null;
    }

    void removeAccessor(FabricComponentAccessor accessor) {
        this.removeAccessor(accessor.getAccessorName());
    }

    synchronized void addAccessor(AbstractComponentAccessor accessor) {
        if (this.accessors == null) {
            this.accessors = new ConcurrentHashMap<String, AbstractComponentAccessor>();
        }
        this.accessors.put(accessor.getAccessorName(), accessor);
        if (this.reference != null) {
            this.reference.addAccessor(accessor);
        }
    }

    synchronized void removeAccessor(String name) {
        AbstractComponentAccessor accessor;
        if (this.accessors != null && (accessor = this.accessors.remove(name)) != null && this.reference != null) {
            this.reference.removeAccessor(accessor);
        }
    }

    boolean existsAccessor(String name) {
        return this.accessors != null && this.accessors.containsKey(name);
    }

    void closeAccessors() {
        if (this.accessors != null) {
            new ArrayList<AbstractComponentAccessor>(this.accessors.values()).forEach(AbstractComponentAccessor::close);
            this.accessors.clear();
            this.accessors = null;
        }
    }

    void forcedCloseAccessors(boolean clear) {
        if (this.accessors != null) {
            new ArrayList<AbstractComponentAccessor>(this.accessors.values()).forEach(AbstractComponentAccessor::forcedClose);
            if (clear) {
                this.accessors.clear();
                this.accessors = null;
            }
        }
    }

    void reopenAccessors() {
        if (this.accessors != null) {
            for (AbstractComponentAccessor accessor : new ArrayList<AbstractComponentAccessor>(this.accessors.values())) {
                try {
                    accessor.reopen();
                }
                catch (FabricComponentAccessorException exception) {
                    Trace.logException(this, exception, false);
                    Trace.logError(this, "Reopening accessor '" + accessor.getName() + "' failed.");
                }
            }
        }
    }

    synchronized boolean isSecurityEnabled() throws Exception {
        if (this.isSecurityEnabled == null) {
            this.initIsSecurityEnabled();
        }
        return this.isSecurityEnabled;
    }

    void initIsSecurityEnabled() throws Exception {
    }

    SecurityManager getSecurityManager() throws Exception {
        if (this.eventScope != EventScope.LOCAL) {
            this.initSecurityManager();
            return this.doGetSecurityManager();
        }
        return null;
    }

    void initSecurityManager() throws Exception {
    }

    SecurityManager doGetSecurityManager() throws SecurityManagerException {
        if (this.securityManager == null) {
            throw new SecurityManagerException(6081, "Security is disabled.");
        }
        return this.securityManager;
    }

    void closeSecurityManager() {
        if (this.securityManager != null) {
            this.securityManager.close();
        }
    }

    @Override
    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    String authenticate(SecurityManagerImpl securityManagerImpl, AuthenticationType type, String userName, String credentials, Map<String, String> parameters, DigestCalculator calculator) throws Exception {
        if (this.isSecurityEnabled()) {
            if (this.securityManager == null) {
                this.securityManager = new RuntimeSecurityManagerProxy(securityManagerImpl, type, userName, credentials, parameters, calculator, this);
            } else {
                this.securityManager.setCurrentUser(securityManagerImpl.authenticate(type, userName, credentials, parameters, calculator, this));
            }
            return this.securityManager.getCurrentUserName();
        }
        return null;
    }

    void bindUser(SecurityManagerImpl securityManagerImpl, User user) {
        this.doAuthenticate(securityManagerImpl, user);
        this.securityContext.bind(this);
    }

    void rebindUser(SecurityManagerImpl securityManagerImpl, User user) {
        this.securityContext.unbind(this);
        this.bindUser(securityManagerImpl, user);
    }

    void doAuthenticate(SecurityManagerImpl securityManagerImpl, User user) {
        securityManagerImpl.bindSecurityContext(user, this);
        if (this.securityManager == null) {
            this.securityManager = new RuntimeSecurityManagerProxy(securityManagerImpl, user);
        } else {
            this.securityManager.setCurrentUser(user);
        }
    }

    void bindGroup(SecurityManagerImpl securityManagerImpl, Group group) {
        securityManagerImpl.bindSecurityContext(group, this);
        this.securityContext.bind(this);
    }

    User getCurrentUser() {
        return this.securityContext != null ? this.securityContext.getUser() : null;
    }

    String getOwnerName() {
        return this.securityContext != null ? this.securityContext.getOwnerName() : null;
    }

    boolean authorize(AccessControlOperation operation) {
        return this.securityContext == null || this.securityContext.authorize(operation);
    }

    boolean isAnonymous() {
        return this.securityContext != null && this.securityContext.isAnonymous();
    }

    void bindProducerFor(String eventId) throws FabricEventDispatcherException {
        this.boundEventIds.bindEventId(eventId, false, true);
    }

    void bindProducerFor(String eventId, boolean checkUniqueness) throws FabricEventDispatcherException {
        this.boundEventIds.bindEventId(eventId, false, checkUniqueness);
    }

    void bindProducerForSystem(String eventId) throws FabricEventDispatcherException {
        this.boundEventIds.bindEventId(eventId, true, false);
    }

    void unbindProducerFor(String eventId) {
        this.boundEventIds.unbindEventId(eventId, true);
    }

    void unbindProducerFor(String eventId, boolean forced) {
        this.boundEventIds.unbindEventId(eventId, forced);
    }

    void unbindProducerForSystem(String eventId) {
        this.boundEventIds.unbindEventId(eventId, false);
    }

    public boolean hasBoundEventIds() {
        return this.dispatcher.hasBoundEventIds();
    }

    boolean isBoundEventId(String eventId) {
        return this.dispatcher.isBoundEventId(eventId);
    }

    void raiseAdvisory(AdvisoryEventDatagram event) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.dispatcher.raiseAdvisory(event, EventScope.INHERITED);
    }

    void raiseSystemAdvisory(AdvisoryEventDatagram event) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.dispatcher.raiseSystemAdvisory(event, EventScope.INHERITED);
    }

    void raiseEvent(ImmutableEventDatagram event, long timeToLive) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.raiseEvent(event, EventScope.INHERITED, timeToLive);
    }

    void raiseEvent(ImmutableEventDatagram event, EventScope eventScope, long timeToLive) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.dispatcher.raiseEvent(event, eventScope, timeToLive, null);
    }

    void raiseSystemEvent(ImmutableEventDatagram event) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.raiseSystemEvent(event, EventScope.INHERITED);
    }

    void raiseSystemEvent(ImmutableEventDatagram event, EventScope eventScope) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        this.dispatcher.raiseSystemEvent(event, eventScope);
    }

    ImmutableEventDatagram raiseRequest(RequestConsumerReference consumer, ImmutableEventDatagram request, long timeout) throws FabricEventSourceException, FabricUnboundEventException, FabricRequestException {
        return this.dispatcher.raiseRequest(consumer, request, timeout);
    }

    AcknowledgementEvent raiseRequest(EventDatagram request, RequestDistributionStrategy distributionStrategy, ReplyMatchStrategy matchStrategy, long timeout) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        return this.dispatcher.raiseRequest(request, EventScope.INHERITED, distributionStrategy, matchStrategy, timeout);
    }

    AcknowledgementEvent raiseSystemRequest(EventDatagram request, RequestDistributionStrategy distributionStrategy, ReplyMatchStrategy matchStrategy, long timeout) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        return this.dispatcher.raiseSystemRequest(request, EventScope.INHERITED, distributionStrategy, matchStrategy, timeout);
    }

    AcknowledgementEvent raiseSystemRequest(EventDatagram request, EventScope eventScope, RequestDistributionStrategy distributionStrategy, ReplyMatchStrategy matchStrategy, long timeout) throws FabricEventSourceException, FabricUnboundEventException, FabricEventException {
        return this.dispatcher.raiseSystemRequest(request, eventScope, distributionStrategy, matchStrategy, timeout);
    }

    boolean isConnectionValid() {
        return true;
    }

    SourceEventFlowImpl addSourceEventFlow(String eventId, EventFlowEntity entity, String entityName, EventScope entityScope, boolean isSystem) {
        SourceEventFlowImpl result = this.makeSourceEventFlow(eventId, entity, entityName, entityScope, isSystem);
        this.addEventFlow(result);
        return result;
    }

    SinkEventFlowImpl addSinkEventFlow(EventFlowEntity entity, String entityName, AbstractFabricConsumer consumer, boolean isSystem) {
        SinkEventFlowImpl result = this.makeSinkEventFlow(entity, entityName, consumer.getEventScope(), consumer.getName(), consumer.getMode(), consumer.getEventFilter(), consumer.getEventSelector(), isSystem);
        return this.doAddSinkEventFlow(consumer, result);
    }

    SinkEventFlowImpl addSinkEventFlow(EventFlowEntity entity, String entityName, String eventFilter, AbstractFabricConsumer consumer, boolean isSystem) {
        SinkEventFlowImpl result = this.makeSinkEventFlow(entity, entityName, consumer.getEventScope(), consumer.getName(), consumer.getMode(), eventFilter, consumer.getEventSelector(), isSystem);
        return this.doAddSinkEventFlow(consumer, result);
    }

    SinkEventFlowImpl addSinkEventFlow(EventFlowEntity entity, String entityName, EventScope entityScope, String consumerName, String consumerMode, String eventFilter, String eventSelector, boolean isSystem) {
        SinkEventFlowImpl result = this.makeSinkEventFlow(entity, entityName, entityScope, consumerName, consumerMode, eventFilter, eventSelector, isSystem);
        this.addEventFlow(result);
        return result;
    }

    private SinkEventFlowImpl doAddSinkEventFlow(AbstractFabricConsumer consumer, SinkEventFlowImpl eventFlow) {
        consumer.setEventFlow(eventFlow);
        this.addEventFlow(eventFlow);
        return eventFlow;
    }

    void addEventFlow(EventFlowImpl flow) {
    }

    void onConsumerRemoved(AbstractFabricConsumer consumer) {
        if (consumer != null && consumer.eventFlow != null) {
            this.removeEventFlow(consumer.eventFlow);
        }
    }

    void removeSourceEventFlow(String eventId, EventFlowEntity entity, String entityName) {
        this.removeEventFlow(this.makeSourceEventFlow(eventId, entity, entityName, null, false));
    }

    void removeSinkEventFlow(EventFlowEntity entity, String entityName, String eventFilter) {
        this.removeEventFlow(this.makeSinkEventFlow(entity, entityName, null, null, null, eventFilter, null, false));
    }

    void removeEventFlow(EventFlowImpl flow) {
    }

    private SourceEventFlowImpl makeSourceEventFlow(String eventId, EventFlowEntity entity, String entityName, EventScope entityScope, boolean isSystem) {
        if (this.reference != null && this.moderator != null) {
            return new SourceEventFlowImpl(eventId, this.moderator.getFabricNode().getName(), this.type, this.name, this.reference.getModel(), this.getOwnerName(), entity, entityName, entityScope == null || entityScope == EventScope.INHERITED ? this.getEventScope() : entityScope, isSystem);
        }
        return null;
    }

    private SinkEventFlowImpl makeSinkEventFlow(EventFlowEntity entity, String entityName, EventScope entityScope, String consumerName, String consumerMode, String eventFilter, String eventSelector, boolean isSystem) {
        if (this.reference != null && this.moderator != null) {
            SinkEventFlowImpl flow = new SinkEventFlowImpl(eventFilter, this.moderator.getFabricNode().getName(), this.type, this.name, this.reference.getModel(), this.getOwnerName(), entity, entityName, entityScope, isSystem);
            flow.setConsumerName(consumerName);
            flow.setConsumerMode(consumerMode);
            flow.setEventFilter(eventFilter);
            flow.setEventSelector(eventSelector);
            return flow;
        }
        return null;
    }

    @Override
    public boolean isNativeContext(MFSession session) {
        return true;
    }

    protected Metaset getMetaset() {
        return null;
    }
}

